/*
 * Decompiled with CFR 0.152.
 */
package pnp.endicia;

import StampsSDK.AddOnTypeV4;
import StampsSDK.AddOnV4;
import StampsSDK.ContentTypeV2;
import StampsSDK.CustomsLine;
import StampsSDK.NonDeliveryOption;
import StampsSDK.PackageTypeV6;
import StampsSDK.PostageBalance;
import StampsSDK.RateV11;
import StampsSDK.ServiceType;
import com.envmgr.labelservice.AccountStatusRequest;
import com.envmgr.labelservice.AccountStatusResponse;
import com.envmgr.labelservice.ArrayOfCustomsItem;
import com.envmgr.labelservice.ArrayOfString;
import com.envmgr.labelservice.CertifiedIntermediary;
import com.envmgr.labelservice.ChangePassPhraseRequest;
import com.envmgr.labelservice.ChangePassPhraseRequestResponse;
import com.envmgr.labelservice.CustomsInfo;
import com.envmgr.labelservice.CustomsItem;
import com.envmgr.labelservice.EwsLabelService;
import com.envmgr.labelservice.EwsLabelServiceSoap;
import com.envmgr.labelservice.GetSCANParameters;
import com.envmgr.labelservice.ImageData;
import com.envmgr.labelservice.LabelRequest;
import com.envmgr.labelservice.LabelRequestResponse;
import com.envmgr.labelservice.LabelResponse;
import com.envmgr.labelservice.PostageRate;
import com.envmgr.labelservice.PostageRateRequest;
import com.envmgr.labelservice.PostageRateResponse;
import com.envmgr.labelservice.RecreditRequest;
import com.envmgr.labelservice.RecreditRequestResponse;
import com.envmgr.labelservice.RefundRequest;
import com.envmgr.labelservice.RefundResponse;
import com.envmgr.labelservice.RefundStatus;
import com.envmgr.labelservice.SCANRequest;
import com.envmgr.labelservice.SCANResponse;
import com.envmgr.labelservice.SpecialServices;
import java.math.BigDecimal;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.xml.ws.Holder;
import pnp.services.datatypes.PreparedIndicium;
import pnp.services.util.ErrorsUtil;

public class EndiciaConnectionManager {
    private static EndiciaConnectionManager _instance;
    private EwsLabelService service;
    private EwsLabelServiceSoap call;
    private CertifiedIntermediary certifiedIntermediary = new CertifiedIntermediary();
    private String requesterID = "lhup";
    private String partnerTxnID = "lhup";
    private String endiciaActualError;
    private boolean isLive = true;
    private String wsdlLive = "http://www.handsupsolutions.com/wsdl/EwsLabelService.asmx.wsdl";

    public static EndiciaConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new EndiciaConnectionManager();
        }
        return _instance;
    }

    public boolean isLive() {
        return this.isLive;
    }

    private void trustAll() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            };
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public String getEndiciaActualError() {
        return this.endiciaActualError;
    }

    public EndiciaConnectionManager() {
        this.trustAll();
        this.endiciaActualError = "";
        this.createServicePopup();
    }

    private boolean createServicePopup() {
        boolean success = this.createService();
        if (!success) {
            JOptionPane.showMessageDialog(null, "No response was received through Endicia, please try logging in again.");
            this.endiciaActualError = "Problem connecting to Endicia Label Server";
        }
        return success;
    }

    private boolean createService() {
        if (this.service == null || this.call == null) {
            try {
                String wsdlTest = this.wsdlLive;
                URL wsdlLocation = null;
                try {
                    wsdlLocation = this.isLive ? new URL(this.wsdlLive) : new URL(wsdlTest);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                    return false;
                }
                if (wsdlLocation == null) {
                    this.service = null;
                    JOptionPane.showMessageDialog(null, "Please reload Gamut or contact support.");
                } else {
                    this.service = new EwsLabelService(wsdlLocation);
                }
                this.call = this.service.getEwsLabelServiceSoap();
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
                return false;
            }
        }
        return true;
    }

    public static float round(String d, int decimalPlace) throws Exception {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    public float buyPostage(String amount) {
        if (this.createServicePopup()) {
            block11: {
                if (amount != null && !amount.trim().isEmpty()) {
                    try {
                        float floatAmount = EndiciaConnectionManager.round(amount, 2);
                        if (!(floatAmount >= 10.0f) || !(floatAmount <= 500.0f)) break block11;
                        RecreditRequest request = new RecreditRequest();
                        request.setCertifiedIntermediary(this.certifiedIntermediary);
                        request.setRequesterID(this.requesterID);
                        request.setRequestID(UUID.randomUUID().toString());
                        request.setRecreditAmount(String.valueOf(floatAmount));
                        RecreditRequestResponse response = null;
                        try {
                            response = this.call.buyPostage(request);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                        if (response == null) {
                            JOptionPane.showMessageDialog(null, "No response from Endicia");
                        } else if (response.getStatus() != 0) {
                            JOptionPane.showMessageDialog(null, "Error Message: " + response.getErrorMessage());
                        } else {
                            if (response.getCertifiedIntermediary() != null & response.getCertifiedIntermediary().getPostageBalance() != null) {
                                return response.getCertifiedIntermediary().getPostageBalance().floatValue();
                            }
                            JOptionPane.showMessageDialog(null, "Problem obtaining new balance. Please check your balance on Endicia before continuing.");
                            return -1.0f;
                        }
                        return -1.0f;
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                }
            }
            JOptionPane.showMessageDialog(null, "Postage requested must be a number between 10 and 500");
        }
        return -1.0f;
    }

    public boolean getRefund(String tracking) {
        boolean success = false;
        if (this.createServicePopup()) {
            if (tracking != null && !tracking.trim().isEmpty()) {
                RefundRequest request = new RefundRequest();
                request.setRequesterID(this.requesterID);
                request.setRequestID(UUID.randomUUID().toString());
                request.setCertifiedIntermediary(this.certifiedIntermediary);
                ArrayOfString refundLabel = new ArrayOfString();
                refundLabel.getPicNumber().add(tracking.trim());
                request.setPicNumbers(refundLabel);
                RefundResponse response = null;
                try {
                    response = this.call.getRefund(request);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
                if (response == null) {
                    JOptionPane.showMessageDialog(null, "No response from Endicia");
                } else if (response.getRefund() != null && !response.getRefund().isEmpty()) {
                    LabelResponse labelResponse = (LabelResponse)response.getRefund().get(0);
                    JOptionPane.showMessageDialog(null, "Tracking: " + labelResponse.getPicNumber() + "\n" + "Refund Status: " + labelResponse.getRefundStatus() + "\n" + "Refund Message: " + labelResponse.getRefundStatusMessage());
                    success = labelResponse.getRefundStatus().equals((Object)RefundStatus.APPROVED);
                } else {
                    JOptionPane.showMessageDialog(null, "Refund Failed\n Error Message: " + response.getErrorMessage());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Invalid Tracking Number");
            }
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changePassPhrase(String newPassPhrase, String accountID, String oldPassPhrase) {
        if (!this.createServicePopup()) return false;
        if (newPassPhrase != null && !newPassPhrase.isEmpty() && newPassPhrase.length() >= 5 && newPassPhrase.length() <= 64) {
            ChangePassPhraseRequest request = new ChangePassPhraseRequest();
            request.setRequesterID(this.requesterID);
            request.setRequestID(UUID.randomUUID().toString());
            this.certifiedIntermediary.setAccountID(accountID);
            this.certifiedIntermediary.setPassPhrase(oldPassPhrase);
            request.setCertifiedIntermediary(this.certifiedIntermediary);
            request.setNewPassPhrase(newPassPhrase);
            ChangePassPhraseRequestResponse response = null;
            try {
                response = this.call.changePassPhrase(request);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            if (response == null) {
                JOptionPane.showMessageDialog(null, "No response from Endicia");
                return false;
            }
            if (response.getStatus() != 0) {
                JOptionPane.showMessageDialog(null, "Error Message: " + response.getErrorMessage());
                return false;
            }
            JOptionPane.showMessageDialog(null, "Password succesffuly changed!");
            return true;
        }
        JOptionPane.showMessageDialog(null, "Password must be between 5 and 64 characters long.");
        return false;
    }

    private void showMessage(String message, boolean openDialog) {
        if (openDialog) {
            JOptionPane.showMessageDialog(null, message);
        }
    }

    public float getPostageBalance(String accountID, String passPhrase, boolean openDialog) {
        if (this.createServicePopup()) {
            AccountStatusRequest request = new AccountStatusRequest();
            request.setRequesterID(this.requesterID);
            request.setRequestID(UUID.randomUUID().toString());
            this.certifiedIntermediary.setAccountID(accountID);
            this.certifiedIntermediary.setPassPhrase(passPhrase);
            request.setCertifiedIntermediary(this.certifiedIntermediary);
            AccountStatusResponse response = null;
            try {
                response = this.call.getAccountStatus(request);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            if (response == null) {
                this.showMessage("No response from Endicia", openDialog);
            } else if (response.getStatus() != 0) {
                this.showMessage("Error Message: " + response.getErrorMessage(), openDialog);
            } else {
                if (response.getCertifiedIntermediary() != null && response.getCertifiedIntermediary().getPostageBalance() != null) {
                    return response.getCertifiedIntermediary().getPostageBalance().floatValue();
                }
                this.showMessage("Problem receiving postage. Please try again later.", openDialog);
            }
        }
        return -1.0f;
    }

    public String[] getSCAN(ArrayOfString labelsForScan) {
        if (this.createServicePopup()) {
            if (labelsForScan != null && !labelsForScan.getPicNumber().isEmpty()) {
                boolean valid = true;
                for (String label : labelsForScan.getPicNumber()) {
                    if (label != null && !label.trim().isEmpty()) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    SCANRequest request = new SCANRequest();
                    request.setPicNumbers(labelsForScan);
                    request.setRequesterID(this.requesterID);
                    request.setRequestID(UUID.randomUUID().toString());
                    request.setCertifiedIntermediary(this.certifiedIntermediary);
                    GetSCANParameters parameters = new GetSCANParameters();
                    parameters.setImageFormat("PNG");
                    request.setGetSCANRequestParameters(parameters);
                    SCANResponse response = null;
                    try {
                        response = this.call.getSCAN(request);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    if (response == null) {
                        JOptionPane.showMessageDialog(null, "No response from Endicia");
                    } else {
                        if (response.getSCANForm() != null && !response.getSCANForm().isEmpty()) {
                            return new String[]{response.getSCANForm(), response.getSubmissionID()};
                        }
                        JOptionPane.showMessageDialog(null, "Error Message: " + response.getErrorMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Some of the tracking numbers were empty. Please check your selection and try again.");
                }
            } else {
                JOptionPane.showMessageDialog(null, "Cannot create an empty scan form.");
            }
        }
        return null;
    }

    private boolean getPostageLabelRates(LabelRequest request, PreparedIndicium indicium) {
        boolean success = false;
        try {
            request.setMailpieceShape(this.findPackageType(((RateV11)indicium.getRate().value).getPackageType()));
            request.setMailClass(this.findServiceType(((RateV11)indicium.getRate().value).getServiceType()));
            request.setDateAdvance(Integer.valueOf(this.findDateDifference(((RateV11)indicium.getRate().value).getShipDate().toGregorianCalendar().getTime())));
            request.setWeightOz(((RateV11)indicium.getRate().value).getWeightOz().doubleValue());
            if (indicium.getTo() != null && indicium.getTo().getCountry().equalsIgnoreCase("US")) {
                SpecialServices services = new SpecialServices();
                if (((RateV11)indicium.getRate().value).getAddOns() != null && ((RateV11)indicium.getRate().value).getAddOns().getAddOnV4() != null) {
                    for (AddOnV4 addon : ((RateV11)indicium.getRate().value).getAddOns().getAddOnV4()) {
                        if (addon.getAddOnType() == null || !addon.getAddOnType().equals((Object)AddOnTypeV4.US_A_SC)) continue;
                        services.setSignatureConfirmation("ON");
                    }
                }
                if (services.getSignatureConfirmation() == null || services.getSignatureConfirmation().equalsIgnoreCase("OFF")) {
                    services.setDeliveryConfirmation("ON");
                }
                request.setServices(services);
            }
            success = true;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    private boolean getPostageLabelFrom(LabelRequest request, PreparedIndicium indicium) {
        boolean success = false;
        try {
            if (indicium.getFrom() != null) {
                request.setFromCity(indicium.getFrom().getCity());
                request.setFromCountry(indicium.getFrom().getCountry());
                request.setFromEMail("");
                request.setFromName(indicium.getFrom().getFullName());
                if (indicium.getFrom().getPhoneNumber() != null) {
                    request.setFromPhone(indicium.getFrom().getPhoneNumber().trim().replace("-", "").replace("(", "").replace(")", "").replace(" ", ""));
                } else {
                    request.setFromPhone("");
                }
                request.setFromPostalCode(indicium.getFrom().getZIPCode());
                request.setFromState(indicium.getFrom().getState());
                request.setReturnAddress1(indicium.getFrom().getAddress1());
                request.setReturnAddress2(indicium.getFrom().getAddress2());
                success = true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    private String convertCustomsType(ContentTypeV2 type) {
        String customsType = ContentsType.Merchandise.name();
        if (type != null) {
            if (type.equals((Object)ContentTypeV2.COMMERCIAL_SAMPLE)) {
                customsType = ContentsType.Sample.name();
            } else if (type.equals((Object)ContentTypeV2.DANGEROUS_GOODS)) {
                customsType = ContentsType.DangerousGoods.name();
            } else if (type.equals((Object)ContentTypeV2.DOCUMENT)) {
                customsType = ContentsType.Documents.name();
            } else if (type.equals((Object)ContentTypeV2.GIFT)) {
                customsType = ContentsType.Gift.name();
            } else if (type.equals((Object)ContentTypeV2.HUMANITARIAN_DONATION)) {
                customsType = ContentsType.HumanitarianDonation.name();
            } else if (type.equals((Object)ContentTypeV2.MERCHANDISE)) {
                customsType = ContentsType.Merchandise.name();
            } else if (type.equals((Object)ContentTypeV2.OTHER)) {
                customsType = ContentsType.Other.name();
            } else if (type.equals((Object)ContentTypeV2.RETURNED_GOODS)) {
                customsType = ContentsType.ReturnedGoods.name();
            }
        }
        return customsType;
    }

    private String convertNonDeliveryOption(NonDeliveryOption NDO) {
        String NDOType = NonDeliveryOptions.Return.name();
        if (NDO != null && NDO.equals((Object)NonDeliveryOption.ABANDON)) {
            NDOType = NonDeliveryOptions.Abandon.name();
        }
        return NDOType;
    }

    private boolean getPostageLabelCustoms(LabelRequest request, PreparedIndicium indicium) {
        boolean success = false;
        try {
            if (indicium.getCustoms() != null) {
                CustomsInfo ci = new CustomsInfo();
                ci.setContentsType(this.convertCustomsType(indicium.getCustoms().getContentType()));
                ci.setContentsExplanation(indicium.getCustoms().getOtherDescribe());
                ci.setNonDeliveryOption(this.convertNonDeliveryOption(indicium.getNonDeliveryOption()));
                ArrayOfCustomsItem aoci = new ArrayOfCustomsItem();
                for (CustomsLine customsLine : indicium.getCustoms().getCustomsLines().getCustomsLine()) {
                    CustomsItem customsItem = new CustomsItem();
                    customsItem.setCountryOfOrigin(customsLine.getCountryOfOrigin());
                    customsItem.setDescription(customsLine.getDescription());
                    customsItem.setHSTariffNumber(customsLine.getHSTariffNumber());
                    customsItem.setQuantity((int)customsLine.getQuantity());
                    customsItem.setValue(customsLine.getValue());
                    BigDecimal bullshitDecimal = new BigDecimal(Math.floor(customsLine.getWeightOz()));
                    customsItem.setWeight(bullshitDecimal);
                    aoci.getCustomsItem().add(customsItem);
                }
                ci.setCustomsItems(aoci);
                request.setCustomsInfo(ci);
                request.setCustomsCertify("TRUE");
                request.setCustomsSigner(indicium.getFrom().getFullName());
                if (indicium.getTo().getCountry().equalsIgnoreCase("US")) {
                    request.setLabelType("Domestic");
                } else {
                    request.setLabelType("International");
                }
                request.setLabelSubtype("Integrated");
                request.setIntegratedFormType("Form2976A");
                if (aoci.getCustomsItem().size() <= 5) {
                    if (request.getLabelType().equalsIgnoreCase("Domestic")) {
                        request.setIntegratedFormType("Form2976");
                    } else if (request.getMailClass().equals(MailClass.FirstClassMailInternational.name())) {
                        request.setIntegratedFormType("Form2976");
                    } else if (request.getMailClass().equals(MailClass.PriorityMailInternational.name())) {
                        if (request.getMailpieceShape().equalsIgnoreCase(PackageType.FlatRateEnvelope.name())) {
                            request.setIntegratedFormType("Form2976");
                        } else if (request.getMailpieceShape().equalsIgnoreCase(PackageType.FlatRateLegalEnvelope.name())) {
                            request.setIntegratedFormType("Form2976");
                        } else if (request.getMailpieceShape().equalsIgnoreCase(PackageType.FlatRatePaddedEnvelope.name())) {
                            request.setIntegratedFormType("Form2976");
                        } else if (request.getMailpieceShape().equalsIgnoreCase(PackageType.SmallFlatRateBox.name())) {
                            request.setIntegratedFormType("Form2976");
                        }
                    }
                }
                success = true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    private boolean getPostageLabelTo(LabelRequest request, PreparedIndicium indicium) {
        boolean success = false;
        try {
            if (indicium.getTo() != null) {
                request.setToAddress1(indicium.getTo().getAddress1());
                request.setToAddress2(indicium.getTo().getAddress2());
                request.setToAddress3(indicium.getTo().getAddress3());
                request.setToCity(indicium.getTo().getCity());
                request.setToCountryCode(indicium.getTo().getCountry());
                request.setToEMail(indicium.getRecipientEmail());
                request.setToName(indicium.getTo().getFullName());
                if (indicium.getTo().getPhoneNumber() != null) {
                    request.setToPhone(indicium.getTo().getPhoneNumber().trim().replace("-", "").replace("(", "").replace(")", "").replace(" ", ""));
                } else {
                    request.setToPhone("");
                }
                if (indicium.getTo().getCountry().equals("US")) {
                    request.setToPostalCode(indicium.getTo().getZIPCode());
                } else {
                    request.setToPostalCode(indicium.getTo().getPostalCode());
                }
                request.setToState(indicium.getTo().getState());
                success = true;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    private boolean getObscureDetails(LabelRequest request, PreparedIndicium indicium) {
        boolean success = false;
        try {
            if (request.getMailClass().equalsIgnoreCase(MailClass.ParcelSelect.name())) {
                request.setSortType("Presorted");
                request.setEntryFacility("Other");
            }
            success = true;
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            success = false;
        }
        return success;
    }

    public Holder<String> getPostageLabel(PreparedIndicium indicium, String includePostage) {
        Holder url;
        block15: {
            url = null;
            if (this.createServicePopup()) {
                if (indicium != null && indicium.getRate() != null && indicium.getRate().value != null) {
                    try {
                        LabelRequest request = new LabelRequest();
                        request.setAccountID(this.certifiedIntermediary.getAccountID());
                        request.setPassPhrase(this.certifiedIntermediary.getPassPhrase());
                        request.setRequesterID(this.requesterID);
                        request.setPartnerTransactionID(this.partnerTxnID);
                        request.setReferenceID("ENDICIA-" + UUID.randomUUID().toString());
                        request.setIncludePostage(includePostage);
                        request.setStealth("TRUE");
                        this.getPostageLabelRates(request, indicium);
                        this.getPostageLabelFrom(request, indicium);
                        this.getPostageLabelTo(request, indicium);
                        this.getPostageLabelCustoms(request, indicium);
                        this.getObscureDetails(request, indicium);
                        if (includePostage.equalsIgnoreCase("FALSE") && request.getMailClass().equalsIgnoreCase("PriorityMailInternational")) {
                            request.setPrintConsolidatorLabel("TRUE");
                            request.setMailClass("IPA");
                        }
                        LabelRequestResponse response = null;
                        try {
                            response = this.call.getPostageLabel(request);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                        if (response == null) {
                            this.endiciaActualError = "No response from Endicia";
                            break block15;
                        }
                        if (response.getStatus() != 0) {
                            this.endiciaActualError = "Error Message: " + response.getErrorMessage();
                            break block15;
                        }
                        indicium.getUrl().value = "";
                        if (response.getBase64LabelImage() != null && !response.getBase64LabelImage().isEmpty()) {
                            indicium.getUrl().value = "ENDICIA:" + response.getBase64LabelImage();
                        } else if (response.getLabel() != null && response.getLabel().getImage() != null && !response.getLabel().getImage().isEmpty()) {
                            for (ImageData data : response.getLabel().getImage()) {
                                indicium.getUrl().value = indicium.getUrl().value + "ENDICIA:" + data.getValue();
                            }
                        } else {
                            this.endiciaActualError = "No Image Data Returned. Cancel the label and try again.";
                        }
                        indicium.getTrackingNumber().value = response.getTrackingNumber();
                        indicium.getStampsTxID().value = response.getReferenceID();
                        ((PostageBalance)indicium.getPostageBalance().value).setAvailablePostage(response.getPostageBalance());
                        ((RateV11)indicium.getRate().value).setAmount(response.getFinalPostage());
                        url = indicium.getUrl();
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                        this.endiciaActualError = "Something went wrong... ";
                    }
                } else {
                    this.endiciaActualError = "Not enough information given to create label.";
                }
            }
        }
        return url;
    }

    public float calculatePostageRate(PreparedIndicium indicium) {
        if (this.createServicePopup()) {
            if (indicium != null && indicium.getRate() != null && indicium.getRate().value != null) {
                try {
                    PostageRateRequest request = new PostageRateRequest();
                    request.setCertifiedIntermediary(this.certifiedIntermediary);
                    request.setRequesterID(this.requesterID);
                    request.setMailpieceShape(this.findPackageType(((RateV11)indicium.getRate().value).getPackageType()));
                    request.setMailClass(this.findServiceType(((RateV11)indicium.getRate().value).getServiceType()));
                    request.setDateAdvance(Integer.valueOf(this.findDateDifference(((RateV11)indicium.getRate().value).getShipDate().toGregorianCalendar().getTime())));
                    request.setWeightOz(((RateV11)indicium.getRate().value).getWeightOz().doubleValue());
                    if (indicium.getTo() != null && indicium.getTo().getCountry().equalsIgnoreCase("US")) {
                        SpecialServices services = new SpecialServices();
                        if (((RateV11)indicium.getRate().value).getAddOns() != null && ((RateV11)indicium.getRate().value).getAddOns().getAddOnV4() != null) {
                            for (AddOnV4 addon : ((RateV11)indicium.getRate().value).getAddOns().getAddOnV4()) {
                                if (addon.getAddOnType() == null || !addon.getAddOnType().equals((Object)AddOnTypeV4.US_A_SC)) continue;
                                services.setSignatureConfirmation("ON");
                            }
                        }
                        if (services.getSignatureConfirmation() == null || services.getSignatureConfirmation().equalsIgnoreCase("OFF")) {
                            services.setDeliveryConfirmation("ON");
                        }
                        request.setServices(services);
                    }
                    if (indicium.getFrom() != null) {
                        request.setFromPostalCode(indicium.getFrom().getZIPCode());
                    }
                    if (indicium.getTo() != null) {
                        request.setToCountryCode(indicium.getTo().getCountry());
                        if (indicium.getTo().getCountry().equals("US")) {
                            request.setToPostalCode(indicium.getTo().getZIPCode());
                        } else {
                            request.setToPostalCode(indicium.getTo().getPostalCode());
                        }
                    }
                    PostageRateResponse response = null;
                    try {
                        response = this.call.calculatePostageRate(request);
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex);
                    }
                    if (response == null) {
                        this.endiciaActualError = "No response from Endicia";
                    } else if (response.getStatus() != 0) {
                        this.endiciaActualError = "Error Message: " + response.getErrorMessage();
                    } else {
                        if (response.getPostage() != null && response.getPostage().size() == 1) {
                            return ((PostageRate)response.getPostage().get(0)).getRate().floatValue();
                        }
                        this.endiciaActualError = "No Postage Returned.";
                    }
                    return -1.0f;
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
            this.endiciaActualError = "Not enough information retrieved to check rates.";
        }
        return -1.0f;
    }

    private String findPackageType(PackageTypeV6 packageType) {
        String mailPieceShape = PackageType.Parcel.name();
        if (packageType != null) {
            if (packageType.equals((Object)PackageTypeV6.FLAT_RATE_BOX)) {
                mailPieceShape = PackageType.MediumFlatRateBox.name();
            } else if (packageType.equals((Object)PackageTypeV6.FLAT_RATE_ENVELOPE)) {
                mailPieceShape = PackageType.FlatRateEnvelope.name();
            } else if (packageType.equals((Object)PackageTypeV6.FLAT_RATE_PADDED_ENVELOPE)) {
                mailPieceShape = PackageType.FlatRatePaddedEnvelope.name();
            } else if (packageType.equals((Object)PackageTypeV6.LARGE_ENVELOPE_OR_FLAT)) {
                mailPieceShape = PackageType.Flat.name();
            } else if (packageType.equals((Object)PackageTypeV6.LARGE_FLAT_RATE_BOX)) {
                mailPieceShape = PackageType.LargeFlatRateBox.name();
            } else if (packageType.equals((Object)PackageTypeV6.LARGE_PACKAGE)) {
                mailPieceShape = PackageType.LargeParcel.name();
            } else if (packageType.equals((Object)PackageTypeV6.LEGAL_FLAT_RATE_ENVELOPE)) {
                mailPieceShape = PackageType.FlatRateLegalEnvelope.name();
            } else if (packageType.equals((Object)PackageTypeV6.LETTER)) {
                mailPieceShape = PackageType.Letter.name();
            } else if (packageType.equals((Object)PackageTypeV6.OVERSIZED_PACKAGE)) {
                mailPieceShape = PackageType.IrregularParcel.name();
            } else if (packageType.equals((Object)PackageTypeV6.PACKAGE)) {
                mailPieceShape = PackageType.Parcel.name();
            } else if (packageType.equals((Object)PackageTypeV6.POSTCARD)) {
                mailPieceShape = PackageType.Card.name();
            } else if (packageType.equals((Object)PackageTypeV6.REGIONAL_RATE_BOX_A)) {
                mailPieceShape = PackageType.RegionalRateBoxA.name();
            } else if (packageType.equals((Object)PackageTypeV6.REGIONAL_RATE_BOX_B)) {
                mailPieceShape = PackageType.RegionalRateBoxB.name();
            } else if (packageType.equals((Object)PackageTypeV6.REGIONAL_RATE_BOX_C)) {
                mailPieceShape = PackageType.RegionalRateBoxC.name();
            } else if (packageType.equals((Object)PackageTypeV6.SMALL_FLAT_RATE_BOX)) {
                mailPieceShape = PackageType.SmallFlatRateBox.name();
            } else if (packageType.equals((Object)PackageTypeV6.THICK_ENVELOPE)) {
                mailPieceShape = PackageType.SmallFlatRateEnvelope.name();
            } else if (packageType.equals((Object)PackageTypeV6.UNKNOWN)) {
                mailPieceShape = PackageType.Parcel.name();
            }
        }
        return mailPieceShape;
    }

    private String findServiceType(ServiceType serviceType) {
        String mailClass = MailClass.First.name();
        if (serviceType != null) {
            if (serviceType.equals((Object)ServiceType.US_CM)) {
                mailClass = MailClass.CriticalMail.name();
            } else if (serviceType.equals((Object)ServiceType.US_EMI)) {
                mailClass = MailClass.ExpressMailInternational.name();
            } else if (serviceType.equals((Object)ServiceType.US_FC)) {
                mailClass = MailClass.First.name();
            } else if (serviceType.equals((Object)ServiceType.US_FCI)) {
                mailClass = MailClass.FirstClassMailInternational.name();
            } else if (serviceType.equals((Object)ServiceType.US_LM)) {
                mailClass = MailClass.LibraryMail.name();
            } else if (serviceType.equals((Object)ServiceType.US_MM)) {
                mailClass = MailClass.MediaMail.name();
            } else if (serviceType.equals((Object)ServiceType.US_PM)) {
                mailClass = MailClass.Priority.name();
            } else if (serviceType.equals((Object)ServiceType.US_PMI)) {
                mailClass = MailClass.PriorityMailInternational.name();
            } else if (serviceType.equals((Object)ServiceType.US_PS)) {
                mailClass = MailClass.ParcelSelect.name();
            } else if (serviceType.equals((Object)ServiceType.US_XM)) {
                mailClass = MailClass.Express.name();
            }
        }
        return mailClass;
    }

    private int findDateDifference(Date shipDate) {
        int dayDifference = 0;
        if (shipDate != null) {
            Date newShipDate = new Date(shipDate.getYear(), shipDate.getMonth(), shipDate.getDate());
            Date today = new Date();
            today = new Date(today.getYear(), today.getMonth(), today.getDate());
            while (!newShipDate.before(today) && !newShipDate.equals(today)) {
                newShipDate.setDate(newShipDate.getDate() - 1);
                if (++dayDifference <= 7) continue;
                dayDifference = 7;
                this.endiciaActualError = "Cannot post date shipments more than 7 days. Shipment date has been set to the max of 7.";
                break;
            }
        } else {
            this.endiciaActualError = "Shipment Date was not set; set date to today.";
        }
        return dayDifference;
    }

    public static enum PackageType {
        Card,
        Letter,
        Flat,
        Parcel,
        LargeParcel,
        IrregularParcel,
        FlatRateEnvelope,
        FlatRateLegalEnvelope,
        FlatRatePaddedEnvelope,
        FlatRateGiftCardEnvelope,
        FlatRateWindowEnvelope,
        FlatRateCardboardEnvelope,
        SmallFlatRateEnvelope,
        SmallFlatRateBox,
        MediumFlatRateBox,
        LargeFlatRateBox,
        DVDFlatRateBox,
        LargeVideoFlatRateBox,
        RegionalRateBoxA,
        RegionalRateBoxB,
        RegionalRateBoxC,
        LargeFlatRateBoardGameBox,
        HalfTrayBox,
        FullTrayBox,
        EMMTrayBox,
        FlatTubTrayBox;

    }

    public static enum Pricing {
        CommercialBase,
        CommercialPlus,
        Retail;

    }

    public static enum MailClass {
        Express,
        PriorityExpress,
        First,
        LibraryMail,
        MediaMail,
        StandardPost,
        ParcelSelect,
        Priority,
        CriticalMail,
        ExpressMailInternational,
        PriorityMailExpressInternational,
        FirstClassMailInternational,
        FirstClassPackageInternationalService,
        PriorityMailInternational;

    }

    public static enum NonDeliveryOptions {
        Abandon,
        Return;

    }

    public static enum ContentsType {
        Documents,
        Gift,
        Merchandise,
        Other,
        ReturnedGoods,
        Sample,
        HumanitarianDonation,
        DangerousGoods;

    }
}

