/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.common;

import com.ebay.common.handler.ServiceHandlerResolver;
import com.ebay.services.client.ClientConfig;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFactory {
    private static final Logger logger = Logger.getLogger(ClientFactory.class);

    public static <I, C> I getServiceClient(Class<I> serviceEndpointInterface, Class<C> serviceClient, ClientConfig clientConfig, String servcieTrackingName) {
        String targetNamespace = serviceClient.getAnnotation(WebServiceClient.class).targetNamespace();
        String serviceName = serviceClient.getAnnotation(WebServiceClient.class).name();
        QName serviceQName = new QName(targetNamespace, serviceName);
        String wsdlLocation = serviceClient.getAnnotation(WebServiceClient.class).wsdlLocation();
        URL wsdlUrl = serviceClient.getResource(wsdlLocation);
        if (wsdlUrl == null) {
            logger.error((Object)("Can not find wsdl on specified location: " + wsdlLocation));
            throw new RuntimeException("can not find wsdl on specified location: " + wsdlLocation);
        }
        logger.debug((Object)"begin to create service instance ... ");
        logger.debug((Object)("wsdl : " + wsdlUrl.toString()));
        logger.debug((Object)("service : " + serviceQName.toString()));
        Service service = Service.create((URL)wsdlUrl, (QName)serviceQName);
        ServiceHandlerResolver hr = new ServiceHandlerResolver();
        service.setHandlerResolver((HandlerResolver)hr);
        QName serviceEndpiontQName = null;
        String serviceEndpointName = ClientFactory.getServiceEndpointName(serviceClient);
        if (serviceEndpointName != null) {
            serviceEndpiontQName = new QName(targetNamespace, serviceEndpointName);
        }
        Object port = null;
        port = serviceEndpiontQName != null ? service.getPort(serviceEndpiontQName, serviceEndpointInterface) : service.getPort(serviceEndpointInterface);
        ClientFactory.initReqeustContext(port, clientConfig, servcieTrackingName);
        return (I)port;
    }

    private static <C> String getServiceEndpointName(Class<C> serviceClient) {
        Method method;
        Method[] methods = serviceClient.getDeclaredMethods();
        WebEndpoint webEndpoint = null;
        Method[] arr$ = methods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (webEndpoint = (method = arr$[i$]).getAnnotation(WebEndpoint.class)) == null; ++i$) {
        }
        if (webEndpoint == null) {
            logger.debug((Object)("unable to find service endpoint name in service client : " + serviceClient.getName()));
            return null;
        }
        String endpontName = webEndpoint.name();
        return endpontName;
    }

    private static void initReqeustContext(Object port, ClientConfig clientConfig, String serviceTrackingName) {
        String appId;
        String globalId;
        Map requestContext = ((BindingProvider)port).getRequestContext();
        requestContext.put("client_config", clientConfig);
        if (clientConfig.getEndPointAddress() != null) {
            requestContext.put("javax.xml.ws.service.endpoint.address", clientConfig.getEndPointAddress());
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        String serviceVersion = clientConfig.getServiceVersion();
        if (serviceVersion != null && serviceVersion.length() > 0) {
            httpHeaders.put("X-EBAY-SOA-SERVICE-VERSION", Collections.singletonList(serviceVersion));
        }
        if ((globalId = clientConfig.getGlobalId()) != null && globalId.length() > 0) {
            httpHeaders.put("X-EBAY-SOA-GLOBAL-ID", Collections.singletonList(globalId));
        }
        if ((appId = clientConfig.getApplicationId()) != null && appId.length() > 0) {
            httpHeaders.put("X-EBAY-SOA-SECURITY-APPNAME", Collections.singletonList(appId));
        }
        httpHeaders.put("X-EBAY-SOA-MESSAGE-PROTOCOL", Collections.singletonList("SOAP12"));
        String uaValue = "eBayServiceKit(Java)";
        if (serviceTrackingName != null) {
            uaValue = uaValue + "-" + serviceTrackingName;
        }
        httpHeaders.put("User-Agent", Collections.singletonList(uaValue));
        boolean isHttpCompressionEnabled = clientConfig.isHttpCompressionEnabled();
        if (isHttpCompressionEnabled) {
            httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        }
        requestContext.put("javax.xml.ws.http.request.headers", httpHeaders);
        int timeout = clientConfig.getHttpTimeout();
        if (timeout > 0) {
            requestContext.put("com.sun.xml.ws.connect.timeout", timeout);
            requestContext.put("com.sun.xml.ws.request.timeout", timeout);
        } else {
            if (requestContext.containsKey("com.sun.xml.ws.connect.timeout")) {
                requestContext.remove("com.sun.xml.ws.connect.timeout");
            }
            if (requestContext.containsKey("com.sun.xml.ws.request.timeout")) {
                requestContext.remove("com.sun.xml.ws.request.timeout");
            }
        }
    }
}

