/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.common.handler;

import com.ebay.services.client.ClientConfig;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = Logger.getLogger(JAXWSHandler.class);

    public boolean handleMessage(SOAPMessageContext smc) {
        ClientConfig clientConfig = (ClientConfig)smc.get((Object)"client_config");
        Boolean request = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (request.booleanValue()) {
            if (clientConfig.isSoapMessageLoggingEnabled()) {
                String xmlStr = this.getXmlString(smc.getMessage());
                xmlStr = "sending soap request message ...\r\n" + xmlStr;
                logger.info((Object)xmlStr);
            }
            String operationName = this.getOperationName(smc.getMessage());
            Map http_req_headers = (Map)smc.get((Object)"javax.xml.ws.http.request.headers");
            http_req_headers.put("X-EBAY-SOA-OPERATION-NAME", Collections.singletonList(operationName));
            if (clientConfig.isHttpHeaderLoggingEnabled()) {
                logger.info((Object)"---[HTTP Request Headers]---");
                if (http_req_headers != null) {
                    logger.info((Object)JAXWSHandler.outputMap(http_req_headers));
                } else {
                    logger.info((Object)"HTTP Request Headers is not available!");
                }
            }
        } else {
            if (clientConfig.isHttpHeaderLoggingEnabled()) {
                Map http_resp_headers = (Map)smc.get((Object)"javax.xml.ws.http.response.headers");
                logger.info((Object)"---[HTTP Response Headers]---");
                if (http_resp_headers != null) {
                    logger.info((Object)JAXWSHandler.outputMap(http_resp_headers));
                } else {
                    logger.info((Object)"HTTP Response Headers is not available!");
                }
            }
            if (clientConfig.isSoapMessageLoggingEnabled()) {
                String xmlStr = this.getXmlString(smc.getMessage());
                xmlStr = "receiving soap response message ...\r\n" + xmlStr;
                logger.info((Object)xmlStr);
            }
        }
        return true;
    }

    private String getXmlString(SOAPMessage message) {
        String xmlStr = null;
        try {
            Source payload = message.getSOAPPart().getContent();
            xmlStr = JAXWSHandler.sourceToSting(payload);
        }
        catch (Exception e) {
            logger.error((Object)"fail to get xml string from SOAP message", (Throwable)e);
        }
        return xmlStr;
    }

    private static String sourceToSting(Source payload) throws TransformerException {
        String result = null;
        StreamResult strResult = new StreamResult(new StringWriter());
        if (payload != null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(payload, strResult);
            result = strResult.getWriter().toString();
        }
        return result;
    }

    private String getOperationName(SOAPMessage message) {
        String opName = null;
        try {
            String requestName = message.getSOAPBody().getFirstChild().getLocalName();
            opName = requestName.replace("Request", "");
        }
        catch (SOAPException e) {
            logger.error((Object)"fail to get operation name in the SOAP message", (Throwable)e);
        }
        return opName;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        ClientConfig clientConfig = (ClientConfig)smc.get((Object)"client_config");
        if (clientConfig.isSoapMessageLoggingEnabled()) {
            String xmlStr = this.getXmlString(smc.getMessage());
            xmlStr = "receiving soap fault message ...\r\n" + xmlStr;
            logger.info((Object)xmlStr);
        }
        return true;
    }

    public void close(MessageContext mc) {
    }

    public Set<QName> getHeaders() {
        return null;
    }

    private static String outputMap(Map map) {
        StringBuffer output = new StringBuffer("");
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            output.append((key == null ? "null" : key.toString()) + " : " + (value == null ? "null" : value.toString()) + "\n");
        }
        return output.toString();
    }
}

