/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.orders._2013_09_01;

import com.amazonservices.mws.client.MwsConnection;
import com.amazonservices.mws.client.MwsException;
import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsRequestType;
import com.amazonservices.mws.client.MwsResponseHeaderMetadata;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrders;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersConfig;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersException;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderResponse;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersResponse;
import com.amazonservices.mws.orders._2013_09_01.model.MWSResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ResponseHeaderMetadata;

public class MarketplaceWebServiceOrdersClient
implements MarketplaceWebServiceOrders {
    private static final String libraryName = "MarketplaceWebServiceOrders";
    private static final String libraryVersion = "2014-09-30";
    protected String servicePath;
    protected final MwsConnection connection;

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, String applicationName, String applicationVersion, MarketplaceWebServiceOrdersConfig config) {
        this.connection = config.copyConnection();
        this.connection.setAwsAccessKeyId(accessKey);
        this.connection.setAwsSecretKeyId(secretKey);
        this.connection.setApplicationName(applicationName);
        this.connection.setApplicationVersion(applicationVersion);
        this.connection.setLibraryVersion(libraryVersion);
        this.servicePath = config.getServicePath();
    }

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, MarketplaceWebServiceOrdersConfig config) {
        this(accessKey, secretKey, libraryName, libraryVersion, config);
    }

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, String applicationName, String applicationVersion) {
        this(accessKey, secretKey, applicationName, applicationVersion, new MarketplaceWebServiceOrdersConfig());
    }

    public GetOrderResponse getOrder(GetOrderRequest request) {
        return (GetOrderResponse)this.connection.call((MwsRequestType)new RequestType("GetOrder", GetOrderResponse.class, this.servicePath), (MwsObject)request);
    }

    public GetServiceStatusResponse getServiceStatus(GetServiceStatusRequest request) {
        return (GetServiceStatusResponse)this.connection.call((MwsRequestType)new RequestType("GetServiceStatus", GetServiceStatusResponse.class, this.servicePath), (MwsObject)request);
    }

    public ListOrderItemsResponse listOrderItems(ListOrderItemsRequest request) {
        return (ListOrderItemsResponse)this.connection.call((MwsRequestType)new RequestType("ListOrderItems", ListOrderItemsResponse.class, this.servicePath), (MwsObject)request);
    }

    public ListOrderItemsByNextTokenResponse listOrderItemsByNextToken(ListOrderItemsByNextTokenRequest request) {
        return (ListOrderItemsByNextTokenResponse)this.connection.call((MwsRequestType)new RequestType("ListOrderItemsByNextToken", ListOrderItemsByNextTokenResponse.class, this.servicePath), (MwsObject)request);
    }

    public ListOrdersResponse listOrders(ListOrdersRequest request) {
        return (ListOrdersResponse)this.connection.call((MwsRequestType)new RequestType("ListOrders", ListOrdersResponse.class, this.servicePath), (MwsObject)request);
    }

    public ListOrdersByNextTokenResponse listOrdersByNextToken(ListOrdersByNextTokenRequest request) {
        return (ListOrdersByNextTokenResponse)this.connection.call((MwsRequestType)new RequestType("ListOrdersByNextToken", ListOrdersByNextTokenResponse.class, this.servicePath), (MwsObject)request);
    }

    public static String quoteAppName(String s) {
        return MwsUtl.escapeAppName((String)s);
    }

    public static String quoteAppVersion(String s) {
        return MwsUtl.escapeAppVersion((String)s);
    }

    public static String quoteAttributeName(String s) {
        return MwsUtl.escapeAttributeName((String)s);
    }

    public static String quoteAttributeValue(String s) {
        return MwsUtl.escapeAttributeValue((String)s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequestType
    implements MwsRequestType {
        private final String operationName;
        private final Class<? extends MWSResponse> responseClass;
        private final String servicePath;

        public RequestType(String operationName, Class<? extends MWSResponse> responseClass, String servicePath) {
            this.operationName = operationName;
            this.responseClass = responseClass;
            this.servicePath = servicePath;
        }

        public String getServicePath() {
            return this.servicePath;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public Class<? extends MwsObject> getResponseClass() {
            return this.responseClass;
        }

        public MwsException wrapException(Throwable cause) {
            return new MarketplaceWebServiceOrdersException(cause);
        }

        public void setRHMD(MwsObject response, MwsResponseHeaderMetadata rhmd) {
            ((MWSResponse)response).setResponseHeaderMetadata(new ResponseHeaderMetadata(rhmd));
        }
    }
}

