/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.orders._2013_09_01.mock;

import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsReader;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.client.MwsXmlReader;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrders;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersAsync;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersException;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderResponse;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ResponseHeaderMetadata;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceWebServiceOrdersMock
implements MarketplaceWebServiceOrders,
MarketplaceWebServiceOrdersAsync {
    private <T> Future<T> newFuture(final T response) {
        FutureTask t = new FutureTask(new Callable<T>(){

            @Override
            public T call() {
                return response;
            }
        });
        t.run();
        return t;
    }

    private <T extends MwsObject> T newResponse(Class<T> cls) {
        MwsObject mwsObject;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(cls.getSimpleName() + ".xml");
            MwsXmlReader reader = new MwsXmlReader(is);
            MwsObject obj = (MwsObject)cls.newInstance();
            obj.readFragmentFrom((MwsReader)reader);
            ResponseHeaderMetadata rhmd = new ResponseHeaderMetadata("mockRequestId", Arrays.asList("A", "B", "C"), "mockTimestamp", 0.0, 0.0, new Date());
            cls.getMethod("setResponseHeaderMetadata", ((Object)((Object)rhmd)).getClass()).invoke((Object)obj, new Object[]{rhmd});
            mwsObject = obj;
        }
        catch (Exception e) {
            try {
                throw MwsUtl.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                MwsUtl.close(is);
                throw throwable;
            }
        }
        MwsUtl.close((Closeable)is);
        return (T)mwsObject;
    }

    @Override
    public GetOrderResponse getOrder(GetOrderRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(GetOrderResponse.class);
    }

    @Override
    public Future<GetOrderResponse> getOrderAsync(GetOrderRequest request) {
        return this.newFuture(this.getOrder(request));
    }

    @Override
    public GetServiceStatusResponse getServiceStatus(GetServiceStatusRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(GetServiceStatusResponse.class);
    }

    @Override
    public Future<GetServiceStatusResponse> getServiceStatusAsync(GetServiceStatusRequest request) {
        return this.newFuture(this.getServiceStatus(request));
    }

    @Override
    public ListOrderItemsResponse listOrderItems(ListOrderItemsRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(ListOrderItemsResponse.class);
    }

    @Override
    public Future<ListOrderItemsResponse> listOrderItemsAsync(ListOrderItemsRequest request) {
        return this.newFuture(this.listOrderItems(request));
    }

    @Override
    public ListOrderItemsByNextTokenResponse listOrderItemsByNextToken(ListOrderItemsByNextTokenRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(ListOrderItemsByNextTokenResponse.class);
    }

    @Override
    public Future<ListOrderItemsByNextTokenResponse> listOrderItemsByNextTokenAsync(ListOrderItemsByNextTokenRequest request) {
        return this.newFuture(this.listOrderItemsByNextToken(request));
    }

    @Override
    public ListOrdersResponse listOrders(ListOrdersRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(ListOrdersResponse.class);
    }

    @Override
    public Future<ListOrdersResponse> listOrdersAsync(ListOrdersRequest request) {
        return this.newFuture(this.listOrders(request));
    }

    @Override
    public ListOrdersByNextTokenResponse listOrdersByNextToken(ListOrdersByNextTokenRequest request) throws MarketplaceWebServiceOrdersException {
        return this.newResponse(ListOrdersByNextTokenResponse.class);
    }

    @Override
    public Future<ListOrdersByNextTokenResponse> listOrdersByNextTokenAsync(ListOrdersByNextTokenRequest request) {
        return this.newFuture(this.listOrdersByNextToken(request));
    }
}

