/*
 * Decompiled with CFR 0.152.
 */
package pnp.comm.amazon;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.SubmitFeedRequest;
import com.amazonaws.mws.model.SubmitFeedResponse;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersAsyncClient;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersConfig;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersException;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersResponse;
import com.amazonservices.mws.orders._2013_09_01.model.OrderItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import pnp.comm.amazon.MWSEndpoint;
import pnp.comm.amazon.datatypes.AmazonEnvelope;
import pnp.comm.amazon.datatypes.Header;
import pnp.comm.amazon.datatypes.OrderFulfillment;
import pnp.services.datatypes.AmazonAccount;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.listener.AmazonAccountListener;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class AmazonConnectionManager
implements AmazonAccountListener {
    private static AmazonConnectionManager _instance;
    private static final String accessKey = "AKIAIELWTBJYQN5R2FFA";
    private static final String secretKey = "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";
    private static final String appName = "Gamut";
    private static final String appVersion = "01";
    private static AmazonAccount account;
    private static final String serviceURL;
    private static MarketplaceWebServiceOrdersAsyncClient client;
    private boolean updatePending = false;

    private AmazonConnectionManager() {
        ListenerManager.getInstance().subscribe((GenericListener)this);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.AMAZON_ACCOUNT_LISTENER);
    }

    public static AmazonConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new AmazonConnectionManager();
        }
        return _instance;
    }

    public void amazonAccountChange() {
        account = LookupServicesUtil.getDBServices().getAmazonAccountAccount();
        AmazonConnectionManager.getAsyncClient();
    }

    public boolean isUpdatePending() {
        return this.updatePending;
    }

    public void refreshTransactions(final String refreshTime) {
        if (!this.updatePending) {
            this.updatePending = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AmazonConnectionManager.this.refreshAmazonTransactions(refreshTime);
                        AmazonConnectionManager.this.updatePending = false;
                    }
                    catch (Exception ex) {
                        AmazonConnectionManager.this.updatePending = false;
                    }
                }
            }).start();
        }
    }

    private void refreshAmazonTransactions(String refreshTime) {
        OrderDetails orderDetail;
        int i;
        Float itemCost;
        List items;
        CompleteOrder order;
        ListOrderItemsByNextTokenRequest itemsRequest;
        CompleteOrder completeOrder;
        List orders;
        ListOrdersByNextTokenRequest orderRequestByToken;
        HashMap<String, CompleteOrder> newOrdersMap = new HashMap<String, CompleteOrder>();
        ArrayList<ListOrdersRequest> orderRequestList = new ArrayList<ListOrdersRequest>();
        ListOrdersRequest orderRequest = new ListOrdersRequest();
        orderRequest.setSellerId(account.getSellerID());
        orderRequest.setMWSAuthToken(account.getMwsAuthToken());
        long timeStamp = 0L;
        if (null != LookupServicesUtil.getDBServices()) {
            timeStamp = LookupServicesUtil.getDBServices().getAccountPreferences().getEbayLastUpdate();
        }
        timeStamp = timeStamp != 0L ? (refreshTime.contains("1 Day") ? System.currentTimeMillis() - 86400000L : (refreshTime.contains("2 Days") ? System.currentTimeMillis() - 172800000L : (refreshTime.contains("7 Days") ? System.currentTimeMillis() - 604800000L : (timeStamp -= 0x6DDD00L)))) : System.currentTimeMillis() - 432000000L;
        XMLGregorianCalendar createdAfter = AmazonConnectionManager.toXmlGregorianCalendar(timeStamp);
        orderRequest.setCreatedAfter(createdAfter);
        ArrayList<String> orderStatus = new ArrayList<String>();
        orderStatus.add("Unshipped");
        orderStatus.add("PartiallyShipped");
        orderRequest.setOrderStatus(orderStatus);
        ArrayList<String> marketplaceId = new ArrayList<String>();
        marketplaceId.add(account.getMarketPlaceID());
        orderRequest.setMarketplaceId(marketplaceId);
        Integer maxResultsPerPage = 100;
        orderRequest.setMaxResultsPerPage(maxResultsPerPage);
        orderRequestList.add(orderRequest);
        List<Object> orderList = AmazonConnectionManager.getOrderList(orderRequestList);
        ArrayList<ListOrderItemsRequest> requestItemsList = new ArrayList<ListOrderItemsRequest>();
        Iterator<Object> objectIter = orderList.iterator();
        ArrayList<ListOrdersByNextTokenRequest> requestOrdersByTokensList = new ArrayList<ListOrdersByNextTokenRequest>();
        while (objectIter.hasNext()) {
            ListOrdersResponse listOrdersResponse = (ListOrdersResponse)objectIter.next();
            if (listOrdersResponse.getListOrdersResult().isSetNextToken()) {
                orderRequestByToken = new ListOrdersByNextTokenRequest();
                orderRequestByToken.setSellerId(account.getSellerID());
                orderRequestByToken.setMWSAuthToken(account.getMwsAuthToken());
                orderRequestByToken.setNextToken(listOrdersResponse.getListOrdersResult().getNextToken());
                requestOrdersByTokensList.add(orderRequestByToken);
            }
            orders = listOrdersResponse.getListOrdersResult().getOrders();
            for (com.amazonservices.mws.orders._2013_09_01.model.Order amazonOrder : orders) {
                completeOrder = this.parseAmazonOrder(amazonOrder);
                newOrdersMap.put(amazonOrder.getAmazonOrderId(), completeOrder);
                ListOrderItemsRequest itemsRequest2 = new ListOrderItemsRequest();
                itemsRequest2.setSellerId(account.getSellerID());
                itemsRequest2.setMWSAuthToken(account.getMwsAuthToken());
                itemsRequest2.setAmazonOrderId(amazonOrder.getAmazonOrderId());
                requestItemsList.add(itemsRequest2);
            }
        }
        while (!requestOrdersByTokensList.isEmpty()) {
            orderList = AmazonConnectionManager.getOrderListByToken(requestOrdersByTokensList);
            requestOrdersByTokensList.clear();
            for (ListOrdersResponse listOrdersResponse : orderList) {
                if (listOrdersResponse.getListOrdersResult().isSetNextToken()) {
                    orderRequestByToken = new ListOrdersByNextTokenRequest();
                    orderRequestByToken.setSellerId(account.getSellerID());
                    orderRequestByToken.setMWSAuthToken(account.getMwsAuthToken());
                    orderRequestByToken.setNextToken(listOrdersResponse.getListOrdersResult().getNextToken());
                    requestOrdersByTokensList.add(orderRequestByToken);
                }
                orders = listOrdersResponse.getListOrdersResult().getOrders();
                for (com.amazonservices.mws.orders._2013_09_01.model.Order amazonOrder : orders) {
                    completeOrder = this.parseAmazonOrder(amazonOrder);
                    newOrdersMap.put(amazonOrder.getAmazonOrderId(), completeOrder);
                    ListOrderItemsRequest itemsRequest2 = new ListOrderItemsRequest();
                    itemsRequest2.setSellerId(account.getSellerID());
                    itemsRequest2.setMWSAuthToken(account.getMwsAuthToken());
                    itemsRequest2.setAmazonOrderId(amazonOrder.getAmazonOrderId());
                    requestItemsList.add(itemsRequest2);
                }
            }
        }
        ArrayList<ListOrderItemsByNextTokenRequest> arrayList = new ArrayList<ListOrderItemsByNextTokenRequest>();
        List<Object> itemList = AmazonConnectionManager.getItemList(requestItemsList);
        requestItemsList.clear();
        objectIter = itemList.iterator();
        while (objectIter.hasNext()) {
            try {
                ListOrderItemsResponse listOrderItemsResponse = (ListOrderItemsResponse)objectIter.next();
                if (listOrderItemsResponse.getListOrderItemsResult().isSetNextToken()) {
                    itemsRequest = new ListOrderItemsByNextTokenRequest();
                    itemsRequest.setSellerId(account.getSellerID());
                    itemsRequest.setMWSAuthToken(account.getMwsAuthToken());
                    itemsRequest.setNextToken(listOrderItemsResponse.getListOrderItemsResult().getNextToken());
                    arrayList.add(itemsRequest);
                }
                if (!newOrdersMap.containsKey(listOrderItemsResponse.getListOrderItemsResult().getAmazonOrderId())) continue;
                order = (CompleteOrder)newOrdersMap.get(listOrderItemsResponse.getListOrderItemsResult().getAmazonOrderId());
                items = listOrderItemsResponse.getListOrderItemsResult().getOrderItems();
                for (OrderItem amazonItem : items) {
                    itemCost = Float.valueOf(Float.valueOf(amazonItem.getItemPrice().getAmount()).floatValue() + Float.valueOf(amazonItem.getShippingPrice().getAmount()).floatValue());
                    for (i = 0; i < amazonItem.getQuantityOrdered(); ++i) {
                        orderDetail = new OrderDetails();
                        orderDetail.setAccountName(account.getAccountName());
                        orderDetail.setEbaySite("Amazon");
                        orderDetail.setItemID(amazonItem.getSellerSKU());
                        orderDetail.setOrderDescription(amazonItem.getTitle());
                        orderDetail.setSalesPrice(itemCost.floatValue() / (float)amazonItem.getQuantityOrdered());
                        if (order.getOrderDetails().isEmpty()) {
                            orderDetail.setTransactionID(listOrderItemsResponse.getListOrderItemsResult().getAmazonOrderId());
                        } else {
                            orderDetail.setTransactionID(listOrderItemsResponse.getListOrderItemsResult().getAmazonOrderId() + "-" + order.getOrderDetails().size());
                        }
                        orderDetail.setOrderNumber(amazonItem.getASIN());
                        if (null != amazonItem.getGiftMessageText() && !amazonItem.getGiftMessageText().isEmpty()) {
                            order.getOrder().setOrderComments(order.getOrder().getOrderComments() + "\n " + amazonItem.getASIN() + " : " + amazonItem.getGiftMessageText());
                        }
                        order.getOrderDetails().add(orderDetail);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        while (!arrayList.isEmpty()) {
            itemList = AmazonConnectionManager.getItemListByToken(arrayList);
            arrayList.clear();
            for (ListOrderItemsByNextTokenResponse listOrderItemsByNextTokenResponse : itemList) {
                if (listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().isSetNextToken()) {
                    itemsRequest = new ListOrderItemsByNextTokenRequest();
                    itemsRequest.setSellerId(account.getSellerID());
                    itemsRequest.setMWSAuthToken(account.getMwsAuthToken());
                    itemsRequest.setNextToken(listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getNextToken());
                    arrayList.add(itemsRequest);
                }
                if (!newOrdersMap.containsKey(listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getAmazonOrderId())) continue;
                order = (CompleteOrder)newOrdersMap.get(listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getAmazonOrderId());
                items = listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getOrderItems();
                for (OrderItem amazonItem : items) {
                    itemCost = Float.valueOf(Float.valueOf(amazonItem.getItemPrice().getAmount()).floatValue() + Float.valueOf(amazonItem.getShippingPrice().getAmount()).floatValue());
                    for (i = 0; i < amazonItem.getQuantityOrdered(); ++i) {
                        orderDetail = new OrderDetails();
                        orderDetail.setAccountName(account.getAccountName());
                        orderDetail.setEbaySite("Amazon");
                        orderDetail.setItemID(amazonItem.getSellerSKU());
                        orderDetail.setOrderDescription(amazonItem.getTitle());
                        orderDetail.setSalesPrice(itemCost.floatValue() / (float)amazonItem.getQuantityOrdered());
                        if (order.getOrderDetails().isEmpty()) {
                            orderDetail.setTransactionID(listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getAmazonOrderId());
                        } else {
                            orderDetail.setTransactionID(listOrderItemsByNextTokenResponse.getListOrderItemsByNextTokenResult().getAmazonOrderId() + "-" + order.getOrderDetails().size());
                        }
                        orderDetail.setOrderNumber(amazonItem.getASIN());
                        orderDetail.setEbayWeight(0.0f);
                        orderDetail.setItemCost(0.0f);
                        if (null != amazonItem.getGiftMessageText() && !amazonItem.getGiftMessageText().isEmpty()) {
                            order.getOrder().setOrderComments(order.getOrder().getOrderComments() + "\n " + amazonItem.getASIN() + " : " + amazonItem.getGiftMessageText());
                        }
                        order.getOrderDetails().add(orderDetail);
                    }
                }
            }
        }
        LookupServicesUtil.getDBServices().addAmazonOrders(newOrdersMap.values());
    }

    private static void sleepThread(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public static List<Object> getItemList(List<ListOrderItemsRequest> requestList) {
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (ListOrderItemsRequest request : requestList) {
            Future future = AmazonConnectionManager.getAsyncClient().listOrderItemsAsync(request);
            futureList.add(future);
            if (requestList.size() <= 20) continue;
            AmazonConnectionManager.sleepThread(2500L);
        }
        ArrayList<Object> responseList = new ArrayList<Object>();
        for (Future future : futureList) {
            Object xresponse;
            try {
                ListOrderItemsResponse response;
                xresponse = response = (ListOrderItemsResponse)future.get();
                responseList.add(xresponse);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof MarketplaceWebServiceOrdersException) {
                    MarketplaceWebServiceOrdersException ex = (MarketplaceWebServiceOrdersException)cause;
                    ErrorsUtil.getInstance().logError((Exception)ex);
                    continue;
                }
                xresponse = cause;
            }
            catch (Exception e) {
                ErrorsUtil.getInstance().logError(e);
            }
        }
        return responseList;
    }

    public static List<Object> getItemListByToken(List<ListOrderItemsByNextTokenRequest> requestList) {
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (ListOrderItemsByNextTokenRequest request : requestList) {
            Future future = AmazonConnectionManager.getAsyncClient().listOrderItemsByNextTokenAsync(request);
            futureList.add(future);
            if (requestList.size() <= 20) continue;
            AmazonConnectionManager.sleepThread(2500L);
        }
        ArrayList<Object> responseList = new ArrayList<Object>();
        for (Future future : futureList) {
            try {
                ListOrderItemsByNextTokenResponse response;
                ListOrderItemsByNextTokenResponse xresponse = response = (ListOrderItemsByNextTokenResponse)future.get();
                responseList.add(xresponse);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (!(cause instanceof MarketplaceWebServiceOrdersException)) continue;
                MarketplaceWebServiceOrdersException ex = (MarketplaceWebServiceOrdersException)cause;
                ErrorsUtil.getInstance().logError((Exception)ex);
            }
            catch (Exception e) {
                ErrorsUtil.getInstance().logError(e);
            }
        }
        return responseList;
    }

    public static List<Object> getOrderList(List<ListOrdersRequest> requestList) {
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (ListOrdersRequest request : requestList) {
            Future future = AmazonConnectionManager.getAsyncClient().listOrdersAsync(request);
            futureList.add(future);
            if (requestList.size() <= 5) continue;
            AmazonConnectionManager.sleepThread(60000L);
        }
        ArrayList<Object> responseList = new ArrayList<Object>();
        for (Future future : futureList) {
            try {
                ListOrdersResponse response;
                ListOrdersResponse xresponse = response = (ListOrdersResponse)future.get();
                responseList.add(xresponse);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (!(cause instanceof MarketplaceWebServiceOrdersException)) continue;
                MarketplaceWebServiceOrdersException ex = (MarketplaceWebServiceOrdersException)cause;
                ErrorsUtil.getInstance().logError((Exception)ex);
            }
            catch (Exception e) {
                ErrorsUtil.getInstance().logError(e);
            }
        }
        return responseList;
    }

    public static List<Object> getOrderListByToken(List<ListOrdersByNextTokenRequest> requestList) {
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (ListOrdersByNextTokenRequest request : requestList) {
            Future future = AmazonConnectionManager.getAsyncClient().listOrdersByNextTokenAsync(request);
            futureList.add(future);
            if (requestList.size() <= 5) continue;
            AmazonConnectionManager.sleepThread(60000L);
        }
        ArrayList<Object> responseList = new ArrayList<Object>();
        for (Future future : futureList) {
            try {
                ListOrdersByNextTokenResponse response;
                ListOrdersByNextTokenResponse xresponse = response = (ListOrdersByNextTokenResponse)future.get();
                responseList.add(xresponse);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (!(cause instanceof MarketplaceWebServiceOrdersException)) continue;
                MarketplaceWebServiceOrdersException ex = (MarketplaceWebServiceOrdersException)cause;
                ErrorsUtil.getInstance().logError((Exception)ex);
            }
            catch (Exception e) {
                ErrorsUtil.getInstance().logError(e);
            }
        }
        return responseList;
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(long date) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException ex) {
            System.out.println("Unable to convert date '%s' to an XMLGregorianCalendar object");
            return null;
        }
    }

    public static synchronized MarketplaceWebServiceOrdersAsyncClient getAsyncClient() {
        if (client == null) {
            MarketplaceWebServiceOrdersConfig config = new MarketplaceWebServiceOrdersConfig();
            config.setServiceURL(serviceURL);
            client = new MarketplaceWebServiceOrdersAsyncClient(accessKey, secretKey, appName, appVersion, config, null);
        }
        return client;
    }

    private CompleteOrder parseAmazonOrder(com.amazonservices.mws.orders._2013_09_01.model.Order amazonOrder) {
        CompleteOrder completeOrder = new CompleteOrder();
        Customer customer = new Customer();
        String address = "";
        String uid = UUID.randomUUID().toString();
        uid = uid.substring(uid.length() - 5);
        if (null != amazonOrder.getShippingAddress().getAddressLine1() && !amazonOrder.getShippingAddress().getAddressLine1().trim().isEmpty()) {
            address = address + amazonOrder.getShippingAddress().getAddressLine1().trim() + " ";
        }
        if (null != amazonOrder.getShippingAddress().getAddressLine2() && !amazonOrder.getShippingAddress().getAddressLine2().trim().isEmpty()) {
            address = address + amazonOrder.getShippingAddress().getAddressLine2().trim() + " ";
        }
        if (null != amazonOrder.getShippingAddress().getAddressLine3() && !amazonOrder.getShippingAddress().getAddressLine3().trim().isEmpty()) {
            address = address + amazonOrder.getShippingAddress().getAddressLine3().trim();
        }
        customer.setCustomerAddress(address.trim());
        customer.setCustomerCity(amazonOrder.getShippingAddress().getCity());
        customer.setCustomerCountry(amazonOrder.getShippingAddress().getCountryCode());
        customer.setCustomerEmail(amazonOrder.getBuyerEmail());
        customer.setCustomerName(amazonOrder.getShippingAddress().getName());
        customer.setCustomerState(amazonOrder.getShippingAddress().getStateOrRegion());
        customer.setCustomerUserName(uid + "-" + amazonOrder.getBuyerEmail());
        customer.setCustomerZipcode(amazonOrder.getShippingAddress().getPostalCode());
        Order order = new Order();
        order.setCustomer(customer);
        order.setCustomerUserName(amazonOrder.getBuyerEmail());
        order.setOrderComments("Amazon Order");
        order.setOrderDate(new Date(amazonOrder.getPurchaseDate().toGregorianCalendar().getTime().getTime()));
        order.setOrderTotal(Float.valueOf(amazonOrder.getOrderTotal().getAmount()).floatValue());
        order.setShippingCost(0.0f);
        if (customer.getCustomerCountry().toUpperCase().contains("US")) {
            if (amazonOrder.getShipmentServiceLevelCategory().toLowerCase().equals("standard")) {
                order.setShippingMethodName("USPSFirstClass");
            } else if (amazonOrder.getShipmentServiceLevelCategory().toLowerCase().equals("expedited")) {
                order.setShippingMethodName("USPSPriority");
            } else if (amazonOrder.getShipmentServiceLevelCategory().toLowerCase().contains("second") || amazonOrder.getShipmentServiceLevelCategory().toLowerCase().contains("2")) {
                order.setShippingMethodName("USPSExpressMail");
            } else {
                order.setShippingMethodName(amazonOrder.getShipServiceLevel());
            }
        } else if (amazonOrder.getShipmentServiceLevelCategory().toLowerCase().equals("standard")) {
            order.setShippingMethodName("USPSFirstClassMailInternational");
        } else {
            order.setShippingMethodName(amazonOrder.getShipServiceLevel());
        }
        order.setShippingPaid(0.0f);
        completeOrder.setOrder(order);
        return completeOrder;
    }

    public XMLGregorianCalendar getCurrentAmazonTime() {
        XMLGregorianCalendar currentTimeStamp = null;
        try {
            URL url = new URL("https://mws.amazonservices.com/");
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            boolean found = false;
            while (!found) {
                String responseString = rd.readLine();
                if (null != responseString && responseString.contains("timestamp")) {
                    String[] token = responseString.split("\"");
                    if (token.length != 3) continue;
                    currentTimeStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(token[1]);
                    found = true;
                    continue;
                }
                if (null != responseString) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentTimeStamp;
    }

    public boolean createTrackingUpdateFeed(Collection<CompleteOrder> orderList) {
        AmazonEnvelope envelope = new AmazonEnvelope();
        Header header = new Header();
        envelope.setMessageType("OrderFulfillment");
        header.setMerchantIdentifier(account.getSellerID());
        header.setDocumentVersion("1.01");
        envelope.setHeader(header);
        Iterator<CompleteOrder> orderIter = orderList.iterator();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        int messageID = 1;
        while (orderIter.hasNext()) {
            CompleteOrder order = orderIter.next();
            OrderDetails orderDetail = (OrderDetails)order.getOrderDetails().get(0);
            String amazonTransactionID = orderDetail.getTransactionID();
            String[] multiOrderCheck = amazonTransactionID.split("-");
            if (null != multiOrderCheck && multiOrderCheck.length == 4) {
                amazonTransactionID = multiOrderCheck[0] + "-" + multiOrderCheck[1] + "-" + multiOrderCheck[2];
            }
            if (orderMap.containsKey(amazonTransactionID)) continue;
            orderMap.put(amazonTransactionID, amazonTransactionID);
            OrderFulfillment trackingObject = new OrderFulfillment();
            trackingObject.setAmazonOrderID(orderDetail.getTransactionID());
            XMLGregorianCalendar currentTime = this.getCurrentAmazonTime();
            if (null == currentTime) {
                GregorianCalendar date = new GregorianCalendar();
                date.set(12, 7);
                date.set(13, 0);
                date.set(14, 0);
                currentTime = AmazonConnectionManager.toXmlGregorianCalendar(date.getTime().getTime());
            }
            trackingObject.setFulfillmentDate(currentTime);
            OrderFulfillment.FulfillmentData carrierInfo = new OrderFulfillment.FulfillmentData();
            carrierInfo.setCarrierCode(orderDetail.getCarrier());
            carrierInfo.setShipperTrackingNumber(orderDetail.getTrackingNumber());
            carrierInfo.setShippingMethod(order.getOrder().getShippingMethodName());
            trackingObject.setFulfillmentData(carrierInfo);
            AmazonEnvelope.Message message = new AmazonEnvelope.Message();
            message.setMessageID(BigInteger.valueOf(messageID++));
            message.setOrderFulfillment(trackingObject);
            message.setOperationType("Update");
            envelope.getMessage().add(message);
        }
        String file = AmazonConnectionManager.jaxbObjectToXML(envelope);
        System.out.println(envelope.toString());
        if (null != file) {
            try {
                SubmitFeedRequest request = new SubmitFeedRequest();
                request.setMerchant(account.getSellerID());
                request.setMWSAuthToken(account.getMwsAuthToken());
                request.setFeedType("_POST_ORDER_FULFILLMENT_DATA_");
                request.setFeedContent((InputStream)new FileInputStream(file));
                FileInputStream fis = new FileInputStream(file);
                request.setContentMD5(AmazonConnectionManager.computeContentMD5HeaderValue(fis));
                fis.close();
                ArrayList<SubmitFeedRequest> requests = new ArrayList<SubmitFeedRequest>();
                requests.add(request);
                MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
                config.setServiceURL("https://mws.amazonservices.com");
                config.setMaxAsyncThreads(30);
                MarketplaceWebServiceClient service = new MarketplaceWebServiceClient(accessKey, secretKey, appName, appVersion, config);
                AmazonConnectionManager.submitFeed((MarketplaceWebService)service, requests);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static String jaxbObjectToXML(AmazonEnvelope envelope) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AmazonEnvelope.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            String fileName = "AmazonXML-" + System.currentTimeMillis() + ".xml";
            m.marshal((Object)envelope, new File(fileName));
            return fileName;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void submitFeed(MarketplaceWebService service, List<SubmitFeedRequest> requests) {
        ArrayList<Future> responses = new ArrayList<Future>();
        for (SubmitFeedRequest request : requests) {
            responses.add(service.submitFeedAsync(request));
        }
        for (Future future : responses) {
            while (!future.isDone()) {
                Thread.yield();
            }
            try {
                SubmitFeedResponse response = (SubmitFeedResponse)future.get();
                SubmitFeedRequest originalRequest = requests.get(responses.indexOf(future));
                System.out.println("Response request id: " + response.getResponseMetadata().getRequestId());
                System.out.println(response.getResponseHeaderMetadata());
                System.out.println();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MarketplaceWebServiceException) {
                    MarketplaceWebServiceException exception = (MarketplaceWebServiceException)MarketplaceWebServiceException.class.cast(e.getCause());
                    System.out.println("Caught Exception: " + exception.getMessage());
                    System.out.println("Response Status Code: " + exception.getStatusCode());
                    System.out.println("Error Code: " + exception.getErrorCode());
                    System.out.println("Error Type: " + exception.getErrorType());
                    System.out.println("Request ID: " + exception.getRequestId());
                    System.out.print("XML: " + exception.getXML());
                    System.out.println("ResponseHeaderMetadata: " + exception.getResponseHeaderMetadata());
                    continue;
                }
                e.printStackTrace();
            }
        }
    }

    public static String computeContentMD5HeaderValue(FileInputStream fis) throws IOException, NoSuchAlgorithmException {
        DigestInputStream dis = new DigestInputStream(fis, MessageDigest.getInstance("MD5"));
        byte[] buffer = new byte[8192];
        while (dis.read(buffer) > 0) {
        }
        String md5Content = new String(Base64.encodeBase64((byte[])dis.getMessageDigest().digest()));
        fis.getChannel().position(0L);
        dis.close();
        return md5Content;
    }

    static {
        serviceURL = MWSEndpoint.NA_PROD.toString();
        client = null;
    }
}

