/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignField;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignSort;
import net.sf.dynamicreports.design.base.DRDesignVariable;
import net.sf.dynamicreports.design.base.expression.DRDesignComplexExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignJasperExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignParameterExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignPropertyExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignSimpleExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignSystemExpression;
import net.sf.dynamicreports.design.base.expression.DRDesignValueFormatter;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.design.definition.DRIDesignField;
import net.sf.dynamicreports.design.definition.DRIDesignSort;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignJasperExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignParameterExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignPropertyExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSimpleExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSystemExpression;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRISort;
import net.sf.dynamicreports.report.definition.DRISubtotal;
import net.sf.dynamicreports.report.definition.DRIVariable;
import net.sf.dynamicreports.report.definition.column.DRIBooleanColumn;
import net.sf.dynamicreports.report.definition.column.DRIValueColumn;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.expression.DRIComplexExpression;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIJasperExpression;
import net.sf.dynamicreports.report.definition.expression.DRIParameterExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import net.sf.dynamicreports.report.definition.expression.DRISimpleExpression;
import net.sf.dynamicreports.report.definition.expression.DRISystemExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.exception.DRException;

public abstract class AbstractExpressionTransform {
    protected DesignTransformAccessor accessor;
    private Map<String, DRIDesignField> fields;
    private Map<String, DRIDesignVariable> variables;
    private Map<String, DRIDesignSystemExpression> systemExpressions;
    private Map<String, DRIDesignJasperExpression> jasperExpressions;
    private Map<String, DRIDesignSimpleExpression> simpleExpressions;
    private Map<String, DRIDesignComplexExpression> complexExpressions;
    private Map<DRIExpression<?>, DRIDesignExpression> expressions;
    private List<DRIDesignSort> sorts;

    public AbstractExpressionTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.init();
    }

    private void init() {
        this.fields = new LinkedHashMap<String, DRIDesignField>();
        this.variables = new LinkedHashMap<String, DRIDesignVariable>();
        this.systemExpressions = new HashMap<String, DRIDesignSystemExpression>();
        this.jasperExpressions = new HashMap<String, DRIDesignJasperExpression>();
        this.simpleExpressions = new HashMap<String, DRIDesignSimpleExpression>();
        this.complexExpressions = new HashMap<String, DRIDesignComplexExpression>();
        this.expressions = new HashMap();
        this.sorts = new ArrayList<DRIDesignSort>();
    }

    public void transform() throws DRException {
        for (DRIField<?> dRIField : this.transformFields()) {
            this.transformExpression(dRIField);
        }
        for (DRIVariable dRIVariable : this.transformVariables()) {
            this.transformExpression(dRIVariable);
        }
        for (DRISort dRISort : this.transformSorts()) {
            this.transformSort(dRISort);
        }
    }

    public DRIDesignExpression transformExpression(DRIExpression<?> expression) throws DRException {
        return this.transformExpression(expression, null, null);
    }

    protected DRIDesignExpression transformExpression(DRIExpression<?> expression, String parameterName) throws DRException {
        return this.transformExpression(expression, null, parameterName);
    }

    protected DRIDesignExpression transformExpression(DRIExpression<?> expression, DRIValueFormatter<?, ?> valueFormatter, String parameterName) throws DRException {
        DRIDesignExpression express;
        if (expression == null) {
            return null;
        }
        if (valueFormatter != null) {
            return this.addExpression(new DRDesignValueFormatter(valueFormatter, this.transformExpression(expression)));
        }
        if (this.expressions.containsKey(expression)) {
            return this.expressions.get(expression);
        }
        if (expression instanceof DRISystemExpression) {
            express = new DRDesignSystemExpression((DRISystemExpression)expression);
        } else if (expression instanceof DRIJasperExpression) {
            express = new DRDesignJasperExpression((DRIJasperExpression)expression);
        } else if (expression instanceof DRISimpleExpression) {
            express = new DRDesignSimpleExpression((DRISimpleExpression)expression, parameterName);
        } else if (expression instanceof DRIComplexExpression) {
            express = this.transformComplexExpression((DRIComplexExpression)expression, parameterName);
        } else if (expression instanceof DRIField) {
            express = this.transformField((DRIField)expression);
        } else if (expression instanceof DRIVariable) {
            express = this.transformVariable((DRIVariable)expression);
        } else if (expression instanceof DRIValueColumn) {
            express = this.transformExpression(((DRITextField)((DRIValueColumn)expression).getComponent()).getValueExpression());
        } else if (expression instanceof DRIBooleanColumn) {
            express = this.transformExpression(((DRIBooleanField)((DRIBooleanColumn)expression).getComponent()).getValueExpression());
        } else if (expression instanceof DRISubtotal) {
            express = this.transformExpression(((DRISubtotal)expression).getValueField().getValueExpression());
        } else {
            throw new DRDesignReportException("Expression " + expression.getClass().getName() + " not supported");
        }
        express = this.addExpression(express);
        this.expressions.put(expression, express);
        return express;
    }

    private DRDesignField transformField(DRIField<?> field) {
        DRDesignField designField = new DRDesignField();
        designField.setName(field.getName());
        designField.setValueClass(field.getValueClass());
        designField.setDescription(this.accessor.getTemplateTransform().getFieldDescription(field));
        return designField;
    }

    private DRIDesignExpression transformComplexExpression(DRIComplexExpression<?> complexExpression, String parameterName) throws DRException {
        DRDesignComplexExpression designComplexExpression = new DRDesignComplexExpression(complexExpression, parameterName);
        for (DRIExpression<?> expression : complexExpression.getExpressions()) {
            designComplexExpression.addExpression(this.transformExpression(expression));
        }
        return designComplexExpression;
    }

    private DRIDesignExpression transformVariable(DRIVariable<?> variable) throws DRException {
        DRDesignVariable designVariable = new DRDesignVariable(variable.getName());
        designVariable.setValueExpression(this.transformExpression(variable.getValueExpression()));
        designVariable.setInitialValueExpression(this.transformExpression(variable.getInitialValueExpression()));
        designVariable.setCalculation(variable.getCalculation());
        designVariable.setResetType(this.getVariableResetType(variable));
        designVariable.setResetGroup(this.getVariableResetGroup(variable));
        return designVariable;
    }

    protected ResetType getVariableResetType(DRIVariable<?> variable) {
        return null;
    }

    protected DRDesignGroup getVariableResetGroup(DRIVariable<?> variable) throws DRException {
        return null;
    }

    private void transformSort(DRISort sort) throws DRException {
        DRIDesignExpression sortExpression;
        DRIDesignExpression expression = this.transformExpression(sort.getExpression());
        if (expression instanceof DRIDesignField || expression instanceof DRIDesignVariable) {
            sortExpression = expression;
        } else {
            DRVariable variable = new DRVariable(sort.getExpression(), Calculation.NOTHING);
            variable.setResetType(Evaluation.NONE);
            sortExpression = this.transformExpression(variable);
        }
        DRDesignSort designSort = new DRDesignSort();
        designSort.setExpression(sortExpression);
        designSort.setOrderType(sort.getOrderType());
        this.sorts.add(designSort);
    }

    protected DRIDesignPropertyExpression transformPropertyExpression(DRIPropertyExpression propertyExpression) throws DRException {
        DRDesignPropertyExpression designPropertyExpression = new DRDesignPropertyExpression();
        designPropertyExpression.setName(propertyExpression.getName());
        designPropertyExpression.setValueExpression(this.transformExpression(propertyExpression.getValueExpression()));
        return designPropertyExpression;
    }

    protected DRIDesignParameterExpression transformParameterExpression(DRIParameterExpression parameterExpression) throws DRException {
        DRDesignParameterExpression designParameterExpression = new DRDesignParameterExpression();
        designParameterExpression.setName(parameterExpression.getName());
        designParameterExpression.setValueExpression(this.transformExpression(parameterExpression.getValueExpression()));
        return designParameterExpression;
    }

    private DRIDesignExpression addExpression(DRIDesignExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof DRIDesignField) {
            return this.addField((DRIDesignField)expression);
        }
        if (expression instanceof DRIDesignVariable) {
            this.addVariable((DRDesignVariable)expression);
        } else if (expression instanceof DRIDesignSystemExpression) {
            this.addSystemExpression((DRIDesignSystemExpression)expression);
        } else if (expression instanceof DRIDesignJasperExpression) {
            this.addJasperExpression((DRIDesignJasperExpression)expression);
        } else if (expression instanceof DRIDesignSimpleExpression) {
            this.addSimpleExpression((DRIDesignSimpleExpression)expression);
        } else if (expression instanceof DRIDesignComplexExpression) {
            this.addComplexExpression((DRIDesignComplexExpression)expression);
        } else {
            throw new DRDesignReportException("Expression " + expression.getClass().getName() + " not supported");
        }
        return expression;
    }

    private void addVariable(DRDesignVariable variable) {
        if (this.variables.containsKey(variable.getName())) {
            if (!this.variables.get(variable.getName()).equals(variable)) {
                throw new DRDesignReportException("Duplicate declaration of variable \"" + variable.getName() + "\"");
            }
            return;
        }
        this.variables.put(variable.getName(), variable);
    }

    private DRIDesignField addField(DRIDesignField field) {
        if (this.fields.containsKey(field.getName())) {
            DRIDesignField fld = this.fields.get(field.getName());
            if (!fld.getValueClass().equals(field.getValueClass())) {
                throw new DRDesignReportException("Duplicate declaration of field \"" + field.getName() + "\"");
            }
            return fld;
        }
        this.fields.put(field.getName(), field);
        return field;
    }

    private void addSystemExpression(DRIDesignSystemExpression systemExpression) {
        if (this.systemExpressions.containsKey(systemExpression.getName())) {
            return;
        }
        this.systemExpressions.put(systemExpression.getName(), systemExpression);
    }

    private void addJasperExpression(DRIDesignJasperExpression jasperExpression) {
        if (this.jasperExpressions.containsKey(jasperExpression.getName())) {
            return;
        }
        this.jasperExpressions.put(jasperExpression.getName(), jasperExpression);
    }

    private void addSimpleExpression(DRIDesignSimpleExpression simpleExpression) {
        if (this.simpleExpressions.containsKey(simpleExpression.getName())) {
            if (!this.simpleExpressions.get(simpleExpression.getName()).equals(simpleExpression)) {
                throw new DRDesignReportException("Duplicate declaration of simple expression \"" + simpleExpression.getName() + "\"");
            }
            return;
        }
        this.simpleExpressions.put(simpleExpression.getName(), simpleExpression);
    }

    private void addComplexExpression(DRIDesignComplexExpression complexExpression) {
        if (this.complexExpressions.containsKey(complexExpression.getName())) {
            if (!this.complexExpressions.get(complexExpression.getName()).equals(complexExpression)) {
                throw new DRDesignReportException("Duplicate declaration of complex expression \"" + complexExpression.getName() + "\"");
            }
            return;
        }
        this.complexExpressions.put(complexExpression.getName(), complexExpression);
    }

    public Collection<DRIDesignField> getFields() {
        return this.fields.values();
    }

    public Collection<DRIDesignVariable> getVariables() {
        return this.variables.values();
    }

    public Collection<DRIDesignSystemExpression> getSystemExpressions() {
        return this.systemExpressions.values();
    }

    public Collection<DRIDesignJasperExpression> getJasperExpressions() {
        return this.jasperExpressions.values();
    }

    public Collection<DRIDesignSimpleExpression> getSimpleExpressions() {
        return this.simpleExpressions.values();
    }

    public Collection<DRIDesignComplexExpression> getComplexExpressions() {
        return this.complexExpressions.values();
    }

    public Collection<DRIDesignSort> getSorts() {
        return this.sorts;
    }

    protected abstract List<? extends DRIField<?>> transformFields();

    protected abstract List<? extends DRIVariable<?>> transformVariables();

    protected abstract List<? extends DRISort> transformSorts();

    protected abstract DRIDesignDataset getDataset();
}

