/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.design.base.DRDesignBand;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignPage;
import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.transformation.BandComponentsTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.definition.DRIBand;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRITemplateDesign;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.exception.DRException;

public class BandTransform {
    private DesignTransformAccessor accessor;
    private DRDesignBand titleBand;
    private DRDesignBand pageHeaderBand;
    private DRDesignBand pageFooterBand;
    private DRDesignBand columnHeaderBand;
    private DRDesignBand columnHeaderForGroupBand;
    private DRDesignBand columnFooterBand;
    private List<DRDesignBand> detailBands;
    private DRDesignBand detailBand;
    private DRDesignBand lastPageFooterBand;
    private DRDesignBand summaryBand;
    private DRDesignBand noDataBand;
    private DRDesignBand backgroundBand;

    public BandTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.detailBands = new ArrayList<DRDesignBand>();
    }

    public void transform() throws DRException {
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        DRIReport report = this.accessor.getReport();
        DRIBand band = report.getTitleBand();
        this.titleBand = this.band("title", band, templateTransform.getTitleSplitType(band), templateTransform.getTitleStyle(band), templateTransform.getTitleBackgroundComponent(band), ResetType.REPORT, null);
        band = report.getPageHeaderBand();
        this.pageHeaderBand = this.band("pageHeader", band, templateTransform.getPageHeaderSplitType(band), templateTransform.getPageHeaderStyle(band), templateTransform.getPageHeaderBackgroundComponent(band), ResetType.PAGE, null);
        band = report.getPageFooterBand();
        this.pageFooterBand = this.band("pageFooter", band, templateTransform.getPageFooterSplitType(band), templateTransform.getPageFooterStyle(band), templateTransform.getPageFooterBackgroundComponent(band), ResetType.PAGE, null);
        band = report.getColumnHeaderBand();
        this.columnHeaderBand = this.band("columnHeader", band, templateTransform.getColumnHeaderSplitType(band), templateTransform.getColumnHeaderStyle(band), templateTransform.getColumnHeaderBackgroundComponent(band), ResetType.COLUMN, null);
        for (DRIGroup dRIGroup : report.getGroups()) {
            if (!templateTransform.isGroupShowColumnHeaderAndFooter(dRIGroup)) continue;
            band = report.getColumnHeaderBand();
            this.columnHeaderForGroupBand = this.band("columnHeaderForGroup", band, templateTransform.getColumnHeaderSplitType(band), templateTransform.getColumnHeaderStyle(band), templateTransform.getColumnHeaderBackgroundComponent(band), ResetType.COLUMN, null);
            break;
        }
        band = report.getColumnFooterBand();
        this.columnFooterBand = this.band("columnFooter", band, templateTransform.getColumnFooterSplitType(band), templateTransform.getColumnFooterStyle(band), templateTransform.getColumnFooterBackgroundComponent(band), ResetType.COLUMN, null);
        band = report.getDetailHeaderBand();
        this.detailBands.add(this.band("detailHeader", band, templateTransform.getDetailHeaderSplitType(band), templateTransform.getDetailHeaderStyle(band), templateTransform.getDetailHeaderBackgroundComponent(band), ResetType.REPORT, null));
        band = report.getDetailBand();
        this.detailBand = this.band("detail", band, templateTransform.getDetailSplitType(band), templateTransform.getDetailStyle(band), templateTransform.getDetailBackgroundComponent(band), ResetType.REPORT, null);
        this.detailBands.add(this.detailBand);
        band = report.getDetailFooterBand();
        this.detailBands.add(this.band("detailFooter", band, templateTransform.getDetailFooterSplitType(band), templateTransform.getDetailFooterStyle(band), templateTransform.getDetailFooterBackgroundComponent(band), ResetType.REPORT, null));
        band = report.getLastPageFooterBand();
        this.lastPageFooterBand = this.band("lastPageFooter", band, templateTransform.getLastPageFooterSplitType(band), templateTransform.getLastPageFooterStyle(band), templateTransform.getLastPageFooterBackgroundComponent(band), ResetType.PAGE, null);
        band = report.getSummaryBand();
        this.summaryBand = this.band("summary", band, templateTransform.getSummarySplitType(band), templateTransform.getSummaryStyle(band), templateTransform.getSummaryBackgroundComponent(band), ResetType.REPORT, null);
        band = report.getNoDataBand();
        this.noDataBand = this.band("noData", band, templateTransform.getNoDataSplitType(band), templateTransform.getNoDataStyle(band), templateTransform.getNoDataBackgroundComponent(band), ResetType.NONE, null);
        band = report.getBackgroundBand();
        this.backgroundBand = this.band("background", band, templateTransform.getBackgroundSplitType(band), templateTransform.getBackgroundStyle(band), templateTransform.getBackgroundBackgroundComponent(band), ResetType.NONE, null);
    }

    public void prepareBands() throws DRException {
        BandComponentsTransform bandComponents = new BandComponentsTransform(this.accessor);
        DRITemplateDesign<?> templateDesign = this.accessor.getReport().getTemplateDesign();
        int maxWidth = this.accessor.getPageTransform().getMaxBandWidth();
        int maxColumnWidth = this.accessor.getPageTransform().getPage().getColumnWidth();
        this.titleBand = bandComponents.prepareBand(this.titleBand, maxWidth, templateDesign.getTitleComponentsCount());
        this.pageHeaderBand = bandComponents.prepareBand(this.pageHeaderBand, maxWidth, templateDesign.getPageHeaderComponentsCount());
        this.pageFooterBand = bandComponents.prepareBand(this.pageFooterBand, maxWidth, templateDesign.getPageFooterComponentsCount());
        this.columnHeaderBand = bandComponents.prepareBand(this.columnHeaderBand, maxColumnWidth, templateDesign.getColumnHeaderComponentsCount());
        this.columnFooterBand = bandComponents.prepareBand(this.columnFooterBand, maxColumnWidth, templateDesign.getColumnFooterComponentsCount());
        ArrayList<DRDesignBand> removeDetailBands = new ArrayList<DRDesignBand>();
        for (DRDesignBand detailBand : this.detailBands) {
            if (bandComponents.prepareBand(detailBand, maxColumnWidth, 0) != null) continue;
            removeDetailBands.add(detailBand);
        }
        this.detailBands.removeAll(removeDetailBands);
        this.lastPageFooterBand = bandComponents.prepareBand(this.lastPageFooterBand, maxWidth, templateDesign.getLastPageFooterComponentsCount());
        this.summaryBand = bandComponents.prepareBand(this.summaryBand, maxWidth, templateDesign.getSummaryComponentsCount());
        this.noDataBand = bandComponents.prepareBand(this.noDataBand, maxWidth, templateDesign.getNoDataComponentsCount());
        if (this.backgroundBand.getList() != null && this.backgroundBand.getList().isEmpty() && (this.backgroundBand.getList().getStyle() != null || this.backgroundBand.getList().getBackgroundComponent() != null)) {
            DRDesignFiller component = new DRDesignFiller();
            component.setWidth(1);
            component.setHeight(1);
            this.backgroundBand.getList().addComponent(component);
        }
        this.backgroundBand = bandComponents.prepareBand(this.backgroundBand, maxWidth, templateDesign.getBackgroundComponentsCount());
        if (this.backgroundBand != null && this.backgroundBand.getBandComponent() != null && this.backgroundBand.getList() != null && (this.backgroundBand.getList().getStyle() != null || this.backgroundBand.getList().getBackgroundComponent() != null)) {
            DRDesignPage page = this.accessor.getPage();
            int height = page.getHeight() - page.getMargin().getTop() - page.getMargin().getBottom();
            this.backgroundBand.getList().setHeight(height);
            if (this.backgroundBand.getList().getBackgroundComponent() != null) {
                this.backgroundBand.getList().getBackgroundComponent().setHeight(height);
            }
            this.backgroundBand.setHeight(height);
        }
        for (DRDesignGroup group : this.accessor.getGroupTransform().getGroups()) {
            DRDesignBand newBand;
            ArrayList<DRDesignBand> bands = new ArrayList<DRDesignBand>();
            for (DRDesignBand band : group.getHeaderBands()) {
                newBand = bandComponents.prepareBand(band, maxColumnWidth, 0);
                if (newBand == null) continue;
                bands.add(newBand);
            }
            group.setHeaderBands(bands);
            bands = new ArrayList();
            for (DRDesignBand band : group.getFooterBands()) {
                newBand = bandComponents.prepareBand(band, maxColumnWidth, 0);
                if (newBand == null) continue;
                bands.add(newBand);
            }
            group.setFooterBands(bands);
        }
    }

    protected DRDesignBand band(String bandName, DRIBand band, SplitType splitType, DRIReportStyle defaultStyle, DRIComponent defaultBackgroundComponent, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignBand designBand = new DRDesignBand(bandName);
        designBand.setSplitType(splitType);
        designBand.setList(this.accessor.getComponentTransform().list(band.getList(), DefaultStyleType.TEXT, resetType, resetGroup));
        if (designBand.getList().getStyle() == null && defaultStyle != null) {
            designBand.getList().setStyle(this.accessor.getStyleTransform().transformStyle(defaultStyle, false, DefaultStyleType.NONE));
        }
        if (designBand.getList().getBackgroundComponent() == null && defaultBackgroundComponent != null) {
            designBand.getList().setBackgroundComponent(this.accessor.getComponentTransform().listBackgroundComponent(defaultBackgroundComponent, DefaultStyleType.TEXT, resetType, resetGroup));
        }
        return designBand;
    }

    protected DRDesignBand band(String bandName, DRIBand band, SplitType splitType, DRIReportStyle defaultStyle, DRIComponent defaultBackgroundComponent) throws DRException {
        DRDesignBand designBand = new DRDesignBand(bandName);
        designBand.setSplitType(splitType);
        DRDesignList list = new DRDesignList();
        list.setType(band.getList().getType());
        list.setGap(this.accessor.getTemplateTransform().getListGap(band.getList()));
        list.setStretchType(this.accessor.getTemplateTransform().getStretchType(band.getList()));
        list.setPrintWhenExpression(this.accessor.getExpressionTransform().transformExpression(band.getList().getPrintWhenExpression()));
        list.setStyle(this.accessor.getStyleTransform().transformStyle(band.getList().getStyle(), false, DefaultStyleType.NONE));
        designBand.setList(list);
        if (list.getStyle() == null && defaultStyle != null) {
            list.setStyle(this.accessor.getStyleTransform().transformStyle(defaultStyle, false, DefaultStyleType.NONE));
        }
        if (designBand.getList().getBackgroundComponent() == null && defaultBackgroundComponent != null) {
            designBand.getList().setBackgroundComponent(this.accessor.getComponentTransform().listBackgroundComponent(defaultBackgroundComponent, DefaultStyleType.TEXT, ResetType.NONE, null));
        }
        return designBand;
    }

    public DRDesignBand getTitleBand() {
        return this.titleBand;
    }

    public DRDesignBand getPageHeaderBand() {
        return this.pageHeaderBand;
    }

    public DRDesignBand getPageFooterBand() {
        return this.pageFooterBand;
    }

    public DRDesignBand getColumnHeaderBand() {
        return this.columnHeaderBand;
    }

    public DRDesignBand getColumnHeaderForGroupBand() {
        return this.columnHeaderForGroupBand;
    }

    public DRDesignBand getColumnFooterBand() {
        return this.columnFooterBand;
    }

    public List<DRDesignBand> getDetailBands() {
        return this.detailBands;
    }

    public DRDesignBand getDetailBand() {
        return this.detailBand;
    }

    public DRDesignBand getLastPageFooterBand() {
        return this.lastPageFooterBand;
    }

    public DRDesignBand getSummaryBand() {
        return this.summaryBand;
    }

    public DRDesignBand getNoDataBand() {
        return this.noDataBand;
    }

    public DRDesignBand getBackgroundBand() {
        return this.backgroundBand;
    }
}

