/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import net.sf.dynamicreports.design.base.barcode.DRDesignBarbecue;
import net.sf.dynamicreports.design.base.barcode.DRDesignBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignChecksumBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignCodabarBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignCode128Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignCode39Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignDataMatrixBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignEan128Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignEan13Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignEan8Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignInterleaved2Of5Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignPdf417Barcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignPostnetBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignRoyalMailCustomerBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignUpcaBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignUpceBarcode;
import net.sf.dynamicreports.design.base.barcode.DRDesignUspsIntelligentMailBarcode;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.definition.barcode.DRIBarbecue;
import net.sf.dynamicreports.report.definition.barcode.DRIBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIChecksumBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRICodabarBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRICode128Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRICode39Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIDataMatrixBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIEan128Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIEan13Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIEan8Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIInterleaved2Of5Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIPdf417Barcode;
import net.sf.dynamicreports.report.definition.barcode.DRIPostnetBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIRoyalMailCustomerBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIUpcaBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIUpceBarcode;
import net.sf.dynamicreports.report.definition.barcode.DRIUspsIntelligentMailBarcode;
import net.sf.dynamicreports.report.exception.DRException;

public class BarcodeTransform {
    private DesignTransformAccessor accessor;

    public BarcodeTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    protected DRDesignBarcode transform(DRIBarcode barcode) throws DRException {
        if (barcode instanceof DRICodabarBarcode) {
            return this.codabar((DRICodabarBarcode)barcode);
        }
        if (barcode instanceof DRICode128Barcode) {
            return this.code128((DRICode128Barcode)barcode);
        }
        if (barcode instanceof DRIEan128Barcode) {
            return this.ean128((DRIEan128Barcode)barcode);
        }
        if (barcode instanceof DRIDataMatrixBarcode) {
            return this.dataMatrix((DRIDataMatrixBarcode)barcode);
        }
        if (barcode instanceof DRICode39Barcode) {
            return this.code39((DRICode39Barcode)barcode);
        }
        if (barcode instanceof DRIInterleaved2Of5Barcode) {
            return this.interleaved2Of5((DRIInterleaved2Of5Barcode)barcode);
        }
        if (barcode instanceof DRIUpcaBarcode) {
            return this.upca((DRIUpcaBarcode)barcode);
        }
        if (barcode instanceof DRIUpceBarcode) {
            return this.upce((DRIUpceBarcode)barcode);
        }
        if (barcode instanceof DRIEan13Barcode) {
            return this.ean13((DRIEan13Barcode)barcode);
        }
        if (barcode instanceof DRIEan8Barcode) {
            return this.ean8((DRIEan8Barcode)barcode);
        }
        if (barcode instanceof DRIUspsIntelligentMailBarcode) {
            return this.uspsIntelligentMail((DRIUspsIntelligentMailBarcode)barcode);
        }
        if (barcode instanceof DRIRoyalMailCustomerBarcode) {
            return this.royalMailCustomer((DRIRoyalMailCustomerBarcode)barcode);
        }
        if (barcode instanceof DRIPostnetBarcode) {
            return this.postnet((DRIPostnetBarcode)barcode);
        }
        if (barcode instanceof DRIPdf417Barcode) {
            return this.pdf417((DRIPdf417Barcode)barcode);
        }
        throw new DRDesignReportException("Barcode " + barcode.getClass().getName() + " not supported");
    }

    protected DRDesignBarbecue transform(DRIBarbecue barbecue) throws DRException {
        DRDesignBarbecue designBarbecue = new DRDesignBarbecue();
        designBarbecue.setWidth(this.accessor.getTemplateTransform().getBarbecueWidth(barbecue));
        designBarbecue.setHeight(this.accessor.getTemplateTransform().getBarbecueHeight(barbecue));
        designBarbecue.setType(barbecue.getType());
        designBarbecue.setCodeExpression(this.accessor.getExpressionTransform().transformExpression(barbecue.getCodeExpression()));
        designBarbecue.setApplicationIdentifierExpression(this.accessor.getExpressionTransform().transformExpression(barbecue.getApplicationIdentifierExpression()));
        designBarbecue.setDrawText(barbecue.getDrawText());
        designBarbecue.setChecksumRequired(barbecue.getChecksumRequired());
        designBarbecue.setBarWidth(barbecue.getBarWidth());
        designBarbecue.setBarHeight(barbecue.getBarHeight());
        designBarbecue.setOrientation(barbecue.getOrientation());
        return designBarbecue;
    }

    private void barcode(DRDesignBarcode designBarcode, DRIBarcode barcode) throws DRException {
        designBarcode.setWidth(this.accessor.getTemplateTransform().getBarcodeWidth(barcode));
        designBarcode.setHeight(this.accessor.getTemplateTransform().getBarcodeHeight(barcode));
        designBarcode.setCodeExpression(this.accessor.getExpressionTransform().transformExpression(barcode.getCodeExpression()));
        designBarcode.setPatternExpression(this.accessor.getExpressionTransform().transformExpression(barcode.getPatternExpression()));
        designBarcode.setModuleWidth(barcode.getModuleWidth());
        designBarcode.setOrientation(barcode.getOrientation());
        designBarcode.setTextPosition(barcode.getTextPosition());
        designBarcode.setQuietZone(barcode.getQuietZone());
        designBarcode.setVerticalQuietZone(barcode.getVerticalQuietZone());
    }

    private void checksumBarcode(DRDesignChecksumBarcode designBarcode, DRIChecksumBarcode barcode) throws DRException {
        this.barcode(designBarcode, barcode);
        designBarcode.setChecksumMode(barcode.getChecksumMode());
    }

    private DRDesignCodabarBarcode codabar(DRICodabarBarcode barcode) throws DRException {
        DRDesignCodabarBarcode designBarcode = new DRDesignCodabarBarcode();
        this.barcode(designBarcode, barcode);
        designBarcode.setWideFactor(barcode.getWideFactor());
        return designBarcode;
    }

    private DRDesignCode128Barcode code128(DRICode128Barcode barcode) throws DRException {
        DRDesignCode128Barcode designBarcode = new DRDesignCode128Barcode();
        this.barcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignEan128Barcode ean128(DRIEan128Barcode barcode) throws DRException {
        DRDesignEan128Barcode designBarcode = new DRDesignEan128Barcode();
        this.checksumBarcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignDataMatrixBarcode dataMatrix(DRIDataMatrixBarcode barcode) throws DRException {
        DRDesignDataMatrixBarcode designBarcode = new DRDesignDataMatrixBarcode();
        this.barcode(designBarcode, barcode);
        designBarcode.setShape(barcode.getShape());
        return designBarcode;
    }

    private DRDesignCode39Barcode code39(DRICode39Barcode barcode) throws DRException {
        DRDesignCode39Barcode designBarcode = new DRDesignCode39Barcode();
        this.checksumBarcode(designBarcode, barcode);
        designBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        designBarcode.setDisplayStartStop(barcode.getDisplayStartStop());
        designBarcode.setExtendedCharSetEnabled(barcode.getExtendedCharSetEnabled());
        designBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        designBarcode.setWideFactor(barcode.getWideFactor());
        return designBarcode;
    }

    private DRDesignInterleaved2Of5Barcode interleaved2Of5(DRIInterleaved2Of5Barcode barcode) throws DRException {
        DRDesignInterleaved2Of5Barcode designBarcode = new DRDesignInterleaved2Of5Barcode();
        this.checksumBarcode(designBarcode, barcode);
        designBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        designBarcode.setWideFactor(barcode.getWideFactor());
        return designBarcode;
    }

    private DRDesignUpcaBarcode upca(DRIUpcaBarcode barcode) throws DRException {
        DRDesignUpcaBarcode designBarcode = new DRDesignUpcaBarcode();
        this.checksumBarcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignUpceBarcode upce(DRIUpceBarcode barcode) throws DRException {
        DRDesignUpceBarcode designBarcode = new DRDesignUpceBarcode();
        this.checksumBarcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignEan13Barcode ean13(DRIEan13Barcode barcode) throws DRException {
        DRDesignEan13Barcode designBarcode = new DRDesignEan13Barcode();
        this.checksumBarcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignEan8Barcode ean8(DRIEan8Barcode barcode) throws DRException {
        DRDesignEan8Barcode designBarcode = new DRDesignEan8Barcode();
        this.checksumBarcode(designBarcode, barcode);
        return designBarcode;
    }

    private DRDesignUspsIntelligentMailBarcode uspsIntelligentMail(DRIUspsIntelligentMailBarcode barcode) throws DRException {
        DRDesignUspsIntelligentMailBarcode designBarcode = new DRDesignUspsIntelligentMailBarcode();
        this.checksumBarcode(designBarcode, barcode);
        designBarcode.setAscenderHeight(barcode.getAscenderHeight());
        designBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        designBarcode.setTrackHeight(barcode.getTrackHeight());
        return designBarcode;
    }

    private DRDesignRoyalMailCustomerBarcode royalMailCustomer(DRIRoyalMailCustomerBarcode barcode) throws DRException {
        DRDesignRoyalMailCustomerBarcode designBarcode = new DRDesignRoyalMailCustomerBarcode();
        this.checksumBarcode(designBarcode, barcode);
        designBarcode.setAscenderHeight(barcode.getAscenderHeight());
        designBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        designBarcode.setTrackHeight(barcode.getTrackHeight());
        return designBarcode;
    }

    private DRDesignPostnetBarcode postnet(DRIPostnetBarcode barcode) throws DRException {
        DRDesignPostnetBarcode designBarcode = new DRDesignPostnetBarcode();
        this.checksumBarcode(designBarcode, barcode);
        designBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        designBarcode.setShortBarHeight(barcode.getShortBarHeight());
        designBarcode.setBaselinePosition(barcode.getBaselinePosition());
        designBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        return designBarcode;
    }

    private DRDesignPdf417Barcode pdf417(DRIPdf417Barcode barcode) throws DRException {
        DRDesignPdf417Barcode designBarcode = new DRDesignPdf417Barcode();
        this.barcode(designBarcode, barcode);
        designBarcode.setMinColumns(barcode.getMinColumns());
        designBarcode.setMaxColumns(barcode.getMaxColumns());
        designBarcode.setMinRows(barcode.getMinRows());
        designBarcode.setMaxRows(barcode.getMaxRows());
        designBarcode.setWidthToHeightRatio(barcode.getWidthToHeightRatio());
        designBarcode.setErrorCorrectionLevel(barcode.getErrorCorrectionLevel());
        return designBarcode;
    }
}

