/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignListCell;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.base.style.DRDesignStyle;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.ColumnGrid;
import net.sf.dynamicreports.design.transformation.ConstantTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.base.grid.DRColumnGridList;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.column.DRIBooleanColumn;
import net.sf.dynamicreports.report.definition.column.DRIColumn;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.component.DRIDimensionComponent;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGrid;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGridComponent;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGridList;
import net.sf.dynamicreports.report.definition.grid.DRIColumnGridListCell;
import net.sf.dynamicreports.report.definition.grid.DRIColumnTitleGroup;
import net.sf.dynamicreports.report.exception.DRException;

public class ColumnGridTransform {
    private DesignTransformAccessor accessor;
    private DRIColumnGridList columnGridList;

    public ColumnGridTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() {
        DRIReport report = this.accessor.getReport();
        DRIColumnGrid columnGrid = report.getColumnGrid();
        if (columnGrid != null && !columnGrid.getList().getListCells().isEmpty()) {
            this.columnGridList = columnGrid.getList();
            return;
        }
        DRColumnGridList columnGridList = new DRColumnGridList();
        if (columnGrid != null) {
            columnGridList.setGap(columnGrid.getList().getGap());
            columnGridList.setType(columnGrid.getList().getType());
        }
        this.addColumnsToGridList(columnGridList);
        this.columnGridList = columnGridList;
    }

    private void addColumnsToGridList(DRColumnGridList columnGridList) {
        DRIReport report = this.accessor.getReport();
        for (DRIColumn<?> column : report.getColumns()) {
            if (this.accessor.getGroupTransform().getHideGroupColumns().contains(column)) continue;
            columnGridList.addComponent(column);
        }
    }

    protected ColumnGrid createColumnGrid() throws DRException {
        return this.createColumnGrid(this.columnGridList, null, false);
    }

    protected ColumnGrid createColumnTitleGrid(DRDesignStyle groupPaddingStyle) throws DRException {
        return this.createColumnGrid(this.columnGridList, groupPaddingStyle, true);
    }

    private ColumnGrid createColumnGrid(DRIColumnGridList columnGridList, DRDesignStyle groupPaddingStyle, boolean titleGroup) throws DRException {
        ColumnGrid columnGrid = new ColumnGrid();
        DRDesignList list = this.list(columnGridList, columnGrid, titleGroup).getList();
        int groupPadding = this.accessor.getGroupTransform().getGroupPadding();
        if (groupPadding > 0) {
            DRDesignFiller filler = new DRDesignFiller();
            filler.setStyle(groupPaddingStyle);
            filler.setWidth(groupPadding);
            filler.setHeight(0);
            list.addComponent(0, HorizontalCellComponentAlignment.CENTER, null, filler);
        }
        columnGrid.setList(list);
        return columnGrid;
    }

    private GridList list(DRIColumnGridComponent columnGridComponent, ColumnGrid columnGrid, boolean titleGroup) throws DRException {
        if (columnGridComponent instanceof DRIColumn) {
            DRDesignList list = new DRDesignList(ListType.VERTICAL);
            DRIColumn column = (DRIColumn)columnGridComponent;
            list.setWidth(this.accessor.getTemplateTransform().getColumnWidth(column, this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN)));
            columnGrid.addList(column, list);
            return new GridList(list, null);
        }
        if (columnGridComponent instanceof DRIColumnGridList) {
            return new GridList(this.columnGridList((DRIColumnGridList)columnGridComponent, columnGrid, titleGroup), null);
        }
        if (columnGridComponent instanceof DRIColumnTitleGroup) {
            return this.columnGridTitleGroup((DRIColumnTitleGroup)columnGridComponent, columnGrid, titleGroup);
        }
        throw new DRDesignReportException("Column grid component " + columnGridComponent.getClass().getName() + " not supported");
    }

    private DRDesignList columnGridList(DRIColumnGridList columnGridList, ColumnGrid columnGrid, boolean titleGroup) throws DRException {
        DRDesignList list = new DRDesignList();
        list.setType(columnGridList.getType());
        list.setGap(columnGridList.getGap());
        for (DRIColumnGridListCell dRIColumnGridListCell : columnGridList.getListCells()) {
            GridList gridList;
            DRIColumnGridComponent component = dRIColumnGridListCell.getComponent();
            HorizontalCellComponentAlignment horizontalAlignment = dRIColumnGridListCell.getHorizontalAlignment();
            VerticalCellComponentAlignment verticalAlignment = dRIColumnGridListCell.getVerticalAlignment();
            if (component instanceof DRIColumn) {
                DRIColumn column = (DRIColumn)component;
                if (column instanceof DRIBooleanColumn) {
                    if (horizontalAlignment == null) {
                        horizontalAlignment = ConstantTransform.toHorizontalCellComponentAlignment(((DRIBooleanField)((DRIBooleanColumn)column).getComponent()).getWidthType());
                    }
                    if (verticalAlignment == null) {
                        verticalAlignment = ConstantTransform.toVerticalCellComponentAlignment(((DRIBooleanField)((DRIBooleanColumn)column).getComponent()).getHeightType());
                    }
                } else {
                    DRIComponent columnComponent = this.accessor.getColumnTransform().getColumnComponent(column);
                    if (columnComponent instanceof DRIDimensionComponent) {
                        if (horizontalAlignment == null) {
                            horizontalAlignment = ConstantTransform.toHorizontalCellComponentAlignment(((DRIDimensionComponent)columnComponent).getWidthType());
                        }
                        if (verticalAlignment == null) {
                            verticalAlignment = ConstantTransform.toVerticalCellComponentAlignment(((DRIDimensionComponent)columnComponent).getHeightType());
                        }
                    }
                }
            }
            if ((gridList = this.list(component, columnGrid, titleGroup)).getHorizontalCellAlignment() != null) {
                list.addComponent(gridList.getHorizontalCellAlignment(), dRIColumnGridListCell.getVerticalAlignment(), gridList.getList());
                continue;
            }
            list.addComponent(horizontalAlignment, dRIColumnGridListCell.getVerticalAlignment(), gridList.getList());
        }
        return list;
    }

    private GridList columnGridTitleGroup(DRIColumnTitleGroup columnGridTitleGroup, ColumnGrid columnGrid, boolean titleGroup) throws DRException {
        DRDesignList list;
        DRDesignList columnList = this.list(columnGridTitleGroup.getList(), columnGrid, titleGroup).getList();
        DRTextField titleGroupField = new DRTextField();
        titleGroupField.setValueExpression(columnGridTitleGroup.getTitleExpression());
        titleGroupField.setStyle(columnGridTitleGroup.getTitleStyle());
        titleGroupField.setHeight(columnGridTitleGroup.getTitleHeight());
        titleGroupField.setHeightType(columnGridTitleGroup.getTitleHeightType());
        titleGroupField.setRows(columnGridTitleGroup.getTitleRows());
        titleGroupField.setStretchWithOverflow(columnGridTitleGroup.getTitleStretchWithOverflow());
        titleGroupField.setPropertyExpressions(columnGridTitleGroup.getTitlePropertyExpressions());
        HorizontalCellComponentAlignment hCellAlignment = null;
        if (columnGridTitleGroup.getTitleWidth() == null && columnGridTitleGroup.getTitleColumns() == null) {
            int totalWidth = 0;
            for (DRDesignListCell cell : columnList.getListCells()) {
                Integer width = cell.getComponent().getWidth();
                HorizontalCellComponentAlignment horizontalAlignment = cell.getHorizontalAlignment();
                if (horizontalAlignment == null || horizontalAlignment.equals((Object)HorizontalCellComponentAlignment.EXPAND) || horizontalAlignment.equals((Object)HorizontalCellComponentAlignment.FLOAT)) {
                    totalWidth = 0;
                    break;
                }
                if (width == null) continue;
                totalWidth += width.intValue();
            }
            if (totalWidth > 0) {
                titleGroupField.setWidth(totalWidth);
                hCellAlignment = HorizontalCellComponentAlignment.LEFT;
            }
        } else {
            if (columnGridTitleGroup.getTitleWidth() != null) {
                titleGroupField.setWidth(columnGridTitleGroup.getTitleWidth());
            }
            if (columnGridTitleGroup.getTitleColumns() != null) {
                titleGroupField.setColumns(columnGridTitleGroup.getTitleColumns());
            }
            hCellAlignment = ConstantTransform.toHorizontalCellComponentAlignment(columnGridTitleGroup.getTitleWidthType());
        }
        DRDesignTextField designTitleGroupField = this.accessor.getComponentTransform().textField(titleGroupField, DefaultStyleType.COLUMN_TITLE);
        designTitleGroupField.setUniqueName("columngroup.title");
        if (!titleGroup || columnGridTitleGroup.getTitleExpression() == null) {
            columnList.setRemovable(true);
            if (hCellAlignment != null) {
                list = new DRDesignList();
                list.setType(ListType.VERTICAL);
                list.addComponent(columnList);
                list.setWidth(designTitleGroupField.getWidth());
                return new GridList(list, hCellAlignment);
            }
            return new GridList(columnList, null);
        }
        list = new DRDesignList();
        list.setType(ListType.VERTICAL);
        if (hCellAlignment != null) {
            list.addComponent(hCellAlignment, null, designTitleGroupField);
            list.addComponent(columnList);
            list.setWidth(designTitleGroupField.getWidth());
            return new GridList(list, hCellAlignment);
        }
        list.addComponent(designTitleGroupField);
        list.addComponent(columnList);
        return new GridList(list, null);
    }

    private class GridList {
        private HorizontalCellComponentAlignment horizontalCellAlignment;
        private DRDesignList list;

        private GridList(DRDesignList list, HorizontalCellComponentAlignment horizontalCellAlignment) {
            this.list = list;
            this.horizontalCellAlignment = horizontalCellAlignment;
        }

        public HorizontalCellComponentAlignment getHorizontalCellAlignment() {
            return this.horizontalCellAlignment;
        }

        public DRDesignList getList() {
            return this.list;
        }
    }
}

