/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.base.style.DRDesignStyle;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.transformation.ColumnGrid;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.report.base.component.DRBooleanField;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.base.style.DRConditionalStyle;
import net.sf.dynamicreports.report.base.style.DRPadding;
import net.sf.dynamicreports.report.base.style.DRStyle;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.column.DRIBooleanColumn;
import net.sf.dynamicreports.report.definition.column.DRIColumn;
import net.sf.dynamicreports.report.definition.column.DRIValueColumn;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIConditionalStyle;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.definition.style.DRISimpleStyle;
import net.sf.dynamicreports.report.definition.style.DRIStyle;
import net.sf.dynamicreports.report.exception.DRException;

public class ColumnTransform {
    private DesignTransformAccessor accessor;
    private Map<DRIColumn<?>, DRIComponent> columnComponents;

    public ColumnTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() throws DRException {
        this.columnComponents = this.getColumnComponents();
        boolean showColumnTitle = this.accessor.getTemplateTransform().isShowColumnTitle();
        boolean showColumnValues = this.accessor.getTemplateTransform().isShowColumnValues();
        boolean showColumnTitleForGroup = this.accessor.getBandTransform().getColumnHeaderForGroupBand() != null;
        ColumnGrid columnTitle = null;
        if (showColumnTitle) {
            columnTitle = this.accessor.getColumnGridTransform().createColumnTitleGrid(this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN_TITLE));
        }
        ColumnGrid columnTitleForGroup = null;
        if (showColumnTitleForGroup) {
            columnTitleForGroup = this.accessor.getColumnGridTransform().createColumnTitleGrid(this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN_TITLE));
        }
        ColumnGrid detail = this.accessor.getColumnGridTransform().createColumnGrid();
        for (DRIColumn<?> column : this.accessor.getReport().getColumns()) {
            if (this.accessor.getGroupTransform().getHideGroupColumns().contains(column)) continue;
            if (column.getTitleExpression() != null) {
                if (showColumnTitle) {
                    columnTitle.addComponent(column, this.titleComponent(column));
                }
                if (showColumnTitleForGroup) {
                    columnTitleForGroup.addComponent(column, this.titleComponent(column));
                }
            }
            DRDesignComponent detailComponent = null;
            detailComponent = column instanceof DRIValueColumn ? this.detailValueComponent((DRIValueColumn)column) : (column instanceof DRIBooleanColumn ? this.detailBooleanComponent((DRIBooleanColumn)column) : this.detailComponent(column));
            detail.addComponent(column, detailComponent);
        }
        if (showColumnTitle && !columnTitle.isEmpty()) {
            this.accessor.getBandTransform().getColumnHeaderBand().addComponent(0, columnTitle.getList());
        }
        if (showColumnTitleForGroup && !columnTitleForGroup.isEmpty()) {
            this.accessor.getBandTransform().getColumnHeaderForGroupBand().addComponent(0, columnTitleForGroup.getList());
        }
        if (showColumnValues) {
            this.accessor.getBandTransform().getDetailBand().addComponent(detail.getList());
        }
    }

    private Map<DRIColumn<?>, DRIComponent> getColumnComponents() throws DRException {
        HashMap columnComponents = new HashMap();
        for (DRIColumn<?> column : this.accessor.getReport().getColumns()) {
            if (this.accessor.getGroupTransform().getHideGroupColumns().contains(column)) continue;
            Object component = column.getComponent();
            if (column instanceof DRIBooleanColumn) {
                component = this.createBooleanComponent((DRIBooleanColumn)column);
            }
            columnComponents.put(column, (DRIComponent)component);
        }
        return columnComponents;
    }

    private DRIComponent createBooleanComponent(DRIBooleanColumn column) throws DRException {
        DRIReportStyle booleanColumnStyle = this.accessor.getTemplateTransform().getBooleanColumnStyle(column);
        if (booleanColumnStyle == null) {
            return column.getComponent();
        }
        DRBooleanField booleanField = new DRBooleanField();
        booleanField.setComponentType(((DRIBooleanField)column.getComponent()).getComponentType());
        booleanField.setEmptyWhenNullValue(((DRIBooleanField)column.getComponent()).getEmptyWhenNullValue());
        booleanField.setValueExpression(((DRIBooleanField)column.getComponent()).getValueExpression());
        booleanField.setWidth(((DRIBooleanField)column.getComponent()).getWidth());
        booleanField.setWidthType(((DRIBooleanField)column.getComponent()).getWidthType());
        booleanField.setHeight(((DRIBooleanField)column.getComponent()).getHeight());
        booleanField.setHeightType(((DRIBooleanField)column.getComponent()).getHeightType());
        booleanField.setImageWidth(((DRIBooleanField)column.getComponent()).getImageWidth());
        booleanField.setImageHeight(((DRIBooleanField)column.getComponent()).getImageHeight());
        booleanField.setHorizontalAlignment(((DRIBooleanField)column.getComponent()).getHorizontalAlignment());
        booleanField.setStyle(booleanColumnStyle);
        booleanField.setPrintWhenExpression(((DRIBooleanField)column.getComponent()).getPrintWhenExpression());
        return booleanField;
    }

    private DRDesignComponent titleComponent(DRIColumn<?> column) throws DRException {
        DRTextField titleField = new DRTextField();
        titleField.setValueExpression(column.getTitleExpression());
        titleField.setStyle(column.getTitleStyle());
        titleField.setWidth(this.accessor.getTemplateTransform().getColumnWidth(column, this.accessor.getStyleTransform().getDefaultStyle(DefaultStyleType.COLUMN)));
        titleField.setHeight(column.getTitleHeight());
        titleField.setHeightType(column.getTitleHeightType());
        titleField.setRows(column.getTitleRows());
        titleField.setStretchWithOverflow(column.getTitleStretchWithOverflow());
        titleField.setPropertyExpressions(column.getTitlePropertyExpressions());
        DRDesignTextField designTitleField = this.accessor.getComponentTransform().textField(titleField, DefaultStyleType.COLUMN_TITLE);
        designTitleField.setUniqueName("column_" + column.getName() + ".title");
        return designTitleField;
    }

    private DRDesignComponent detailValueComponent(DRIValueColumn<?> column) throws DRException {
        DRDesignComponent detailComponent = this.detailComponent(column);
        ((DRDesignTextField)detailComponent).setPrintRepeatedValues(this.accessor.getTemplateTransform().isColumnPrintRepeatedDetailValues(column));
        return detailComponent;
    }

    private DRDesignComponent detailBooleanComponent(DRIBooleanColumn column) throws DRException {
        DRDesignComponent detailComponent = this.detailComponent(column);
        return detailComponent;
    }

    private DRDesignComponent detailComponent(DRIColumn<?> column) throws DRException {
        DRISimpleStyle detailEvenRowStyle;
        DRDesignComponent designComponent = this.accessor.getComponentTransform().component(this.getColumnComponent(column), DefaultStyleType.COLUMN, null, null);
        designComponent.setUniqueName("column_" + column.getName());
        ArrayList<? extends DRIConditionalStyle> rowHighlighters = new ArrayList<DRIConditionalStyle>();
        rowHighlighters.addAll(this.getDetailRowHighlighters());
        DRISimpleStyle detailOddRowStyle = this.accessor.getTemplateTransform().getDetailOddRowStyle();
        if (detailOddRowStyle != null) {
            rowHighlighters.add(this.detailRowConditionalStyle(detailOddRowStyle, Expressions.printInOddRow()));
        }
        if ((detailEvenRowStyle = this.accessor.getTemplateTransform().getDetailEvenRowStyle()) != null) {
            rowHighlighters.add(this.detailRowConditionalStyle(detailEvenRowStyle, Expressions.printInEvenRow()));
        }
        if (!rowHighlighters.isEmpty()) {
            DRIReportStyle style = this.getColumnComponent(column).getStyle();
            if (style == null) {
                style = this.accessor.getTemplateTransform().getColumnStyle(column instanceof DRIValueColumn);
            }
            DRStyle newStyle = new DRStyle();
            newStyle.setParentStyle(style);
            if (!(column instanceof DRIValueColumn)) {
                newStyle.setPadding(new DRPadding(0));
            }
            ArrayList<DRIConditionalStyle> conditionalStyles = new ArrayList<DRIConditionalStyle>();
            if (style != null) {
                DRIStyle dRIStyle = this.accessor.getStyleTransform().getStyle(style);
                for (DRIConditionalStyle dRIConditionalStyle : dRIStyle.getConditionalStyles()) {
                    conditionalStyles.add(dRIConditionalStyle);
                }
            }
            for (DRIConditionalStyle dRIConditionalStyle : rowHighlighters) {
                conditionalStyles.add(dRIConditionalStyle);
            }
            Color color = StyleResolver.getBackgroundColor(style, this.accessor.getStyleTransform());
            for (DRIConditionalStyle dRIConditionalStyle : conditionalStyles) {
                if (color != null) {
                    DRConditionalStyle newConditionalStyle = new DRConditionalStyle(dRIConditionalStyle.getConditionExpression());
                    this.accessor.getStyleTransform().copyStyle(newConditionalStyle, dRIConditionalStyle);
                    Color mergedColor = StyleResolver.mergeColors(color, dRIConditionalStyle.getBackgroundColor(), 0.25f);
                    newConditionalStyle.setBackgroundColor(mergedColor);
                    newStyle.addConditionalStyle(newConditionalStyle);
                    continue;
                }
                newStyle.addConditionalStyle((DRConditionalStyle)dRIConditionalStyle);
            }
            designComponent.setStyle(this.accessor.getStyleTransform().transformStyle(newStyle, true, DefaultStyleType.COLUMN));
        } else if (designComponent.getStyle() == null && !(column instanceof DRIValueColumn)) {
            DRIReportStyle columnStyle = this.accessor.getTemplateTransform().getColumnStyle(false);
            DRStyle newStyle = null;
            if (columnStyle != null) {
                newStyle = new DRStyle();
                newStyle.setParentStyle(columnStyle);
                newStyle.setPadding(new DRPadding(0));
            }
            DRDesignStyle designColumnStyle = this.accessor.getStyleTransform().transformStyle(newStyle, false, DefaultStyleType.NONE);
            designComponent.setStyle(designColumnStyle);
        }
        return designComponent;
    }

    private List<? extends DRIConditionalStyle> getDetailRowHighlighters() {
        return this.accessor.getReport().getDetailRowHighlighters();
    }

    private DRConditionalStyle detailRowConditionalStyle(DRISimpleStyle style, DRIExpression<Boolean> expression) {
        DRConditionalStyle conditionalStyle = new DRConditionalStyle(expression);
        this.accessor.getStyleTransform().copyStyle(conditionalStyle, style);
        return conditionalStyle;
    }

    public DRIComponent getColumnComponent(DRIColumn<?> column) {
        return this.columnComponents.get(column);
    }
}

