/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignHyperLink;
import net.sf.dynamicreports.design.base.DRDesignTableOfContentsHeading;
import net.sf.dynamicreports.design.base.DRDesignVariable;
import net.sf.dynamicreports.design.base.barcode.DRDesignBarbecue;
import net.sf.dynamicreports.design.base.barcode.DRDesignBarcode;
import net.sf.dynamicreports.design.base.chart.DRDesignChart;
import net.sf.dynamicreports.design.base.component.DRDesignBreak;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignEllipse;
import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignGenericElement;
import net.sf.dynamicreports.design.base.component.DRDesignHyperlinkComponent;
import net.sf.dynamicreports.design.base.component.DRDesignImage;
import net.sf.dynamicreports.design.base.component.DRDesignLine;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignMap;
import net.sf.dynamicreports.design.base.component.DRDesignRectangle;
import net.sf.dynamicreports.design.base.component.DRDesignSubreport;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstab;
import net.sf.dynamicreports.design.base.style.DRDesignStyle;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.constant.EvaluationTime;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.DRIDesignField;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignJasperExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSimpleExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSystemExpression;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.ConstantTransform;
import net.sf.dynamicreports.design.transformation.CustomBatikRenderer;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.base.DRBand;
import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.DRHyperLink;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRHyperLinkComponent;
import net.sf.dynamicreports.report.base.component.DRImage;
import net.sf.dynamicreports.report.base.component.DRList;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.base.style.DRPen;
import net.sf.dynamicreports.report.base.style.DRStyle;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.component.CustomComponentTransform;
import net.sf.dynamicreports.report.component.CustomComponents;
import net.sf.dynamicreports.report.component.DRICustomComponent;
import net.sf.dynamicreports.report.constant.BooleanComponentType;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.ImageScale;
import net.sf.dynamicreports.report.constant.VerticalCellComponentAlignment;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.barcode.DRIBarbecue;
import net.sf.dynamicreports.report.definition.barcode.DRIBarcode;
import net.sf.dynamicreports.report.definition.chart.DRIChart;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.definition.component.DRIBreak;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.component.DRICurrentDate;
import net.sf.dynamicreports.report.definition.component.DRIDimensionComponent;
import net.sf.dynamicreports.report.definition.component.DRIEllipse;
import net.sf.dynamicreports.report.definition.component.DRIFiller;
import net.sf.dynamicreports.report.definition.component.DRIFormatField;
import net.sf.dynamicreports.report.definition.component.DRIGenericElement;
import net.sf.dynamicreports.report.definition.component.DRIHyperLinkComponent;
import net.sf.dynamicreports.report.definition.component.DRIImage;
import net.sf.dynamicreports.report.definition.component.DRILine;
import net.sf.dynamicreports.report.definition.component.DRIList;
import net.sf.dynamicreports.report.definition.component.DRIListCell;
import net.sf.dynamicreports.report.definition.component.DRIMap;
import net.sf.dynamicreports.report.definition.component.DRIMultiPageList;
import net.sf.dynamicreports.report.definition.component.DRIPageNumber;
import net.sf.dynamicreports.report.definition.component.DRIPageXofY;
import net.sf.dynamicreports.report.definition.component.DRIRectangle;
import net.sf.dynamicreports.report.definition.component.DRISubreport;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.component.DRITotalPages;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstab;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIParameterExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.Renderable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ComponentTransform {
    private DesignTransformAccessor accessor;

    public ComponentTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
    }

    protected DRDesignComponent component(DRIComponent component, DefaultStyleType defaultStyleType, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        if (component instanceof DRITextField) {
            return this.textField((DRITextField)component, defaultStyleType);
        }
        if (component instanceof DRIList) {
            return this.list((DRIList)component, defaultStyleType, resetType, resetGroup);
        }
        if (component instanceof DRIMultiPageList) {
            return this.multiPageList((DRIMultiPageList)component);
        }
        if (component instanceof DRIFiller) {
            return this.filler((DRIFiller)component);
        }
        if (component instanceof DRIImage) {
            return this.image((DRIImage)component);
        }
        if (component instanceof DRIChart) {
            return this.chart((DRIChart)component, resetType, resetGroup);
        }
        if (component instanceof DRIBarcode) {
            return this.barcode((DRIBarcode)component, resetType, resetGroup);
        }
        if (component instanceof DRIBarbecue) {
            return this.barbecue((DRIBarbecue)component, resetType, resetGroup);
        }
        if (component instanceof DRISubreport) {
            return this.subreport((DRISubreport)component);
        }
        if (component instanceof DRIPageXofY) {
            return this.pageXofY((DRIPageXofY)component, defaultStyleType);
        }
        if (component instanceof DRITotalPages) {
            return this.totalPages((DRITotalPages)component, defaultStyleType);
        }
        if (component instanceof DRIPageNumber) {
            return this.pageNumber((DRIPageNumber)component, defaultStyleType);
        }
        if (component instanceof DRICurrentDate) {
            return this.currentDate((DRICurrentDate)component, defaultStyleType);
        }
        if (component instanceof DRILine) {
            return this.line((DRILine)component);
        }
        if (component instanceof DRIEllipse) {
            return this.ellipse((DRIEllipse)component);
        }
        if (component instanceof DRIRectangle) {
            return this.rectangle((DRIRectangle)component);
        }
        if (component instanceof DRIBooleanField) {
            return this.booleanField((DRIBooleanField)component, defaultStyleType, resetType, resetGroup);
        }
        if (component instanceof DRIBreak) {
            return this.breakComponent((DRIBreak)component);
        }
        if (component instanceof DRIGenericElement) {
            return this.genericElement((DRIGenericElement)component, resetType, resetGroup);
        }
        if (component instanceof DRICrosstab) {
            return this.crosstab((DRICrosstab)component, resetType, resetGroup);
        }
        if (component instanceof DRIMap) {
            return this.map((DRIMap)component, resetType, resetGroup);
        }
        if (component instanceof DRICustomComponent) {
            return this.customComponent((DRICustomComponent)component, resetType, resetGroup);
        }
        throw new DRDesignReportException("Component " + component.getClass().getName() + " not supported");
    }

    private void component(DRDesignComponent designComponent, DRIComponent component, DRIReportStyle style, boolean textStyle, DefaultStyleType defaultStyleType) throws DRException {
        designComponent.setStyle(this.accessor.getStyleTransform().transformStyle(style, textStyle, defaultStyleType));
        designComponent.setPrintWhenExpression(this.accessor.getExpressionTransform().transformExpression(component.getPrintWhenExpression()));
        designComponent.setRemoveLineWhenBlank(this.accessor.getTemplateTransform().getRemoveLineWhenBlank(component));
        designComponent.setPositionType(this.accessor.getTemplateTransform().getPositionType(component));
        designComponent.setStretchType(this.accessor.getTemplateTransform().getStretchType(component));
        designComponent.setPrintInFirstWholeBand(this.accessor.getTemplateTransform().getPrintInFirstWholeBand(component));
        designComponent.setPrintWhenDetailOverflows(this.accessor.getTemplateTransform().getPrintWhenDetailOverflows(component));
        designComponent.setPrintWhenGroupChanges(this.accessor.getTemplateTransform().getPrintWhenGroupChanges(component));
        for (DRIPropertyExpression propertyExpression : component.getPropertyExpressions()) {
            designComponent.getPropertyExpressions().add(this.accessor.getExpressionTransform().transformPropertyExpression(propertyExpression));
        }
        DRDesignTableOfContentsHeading designTocHeading = this.accessor.getTableOfContentsTransform().componentHeading(component);
        if (designTocHeading != null) {
            designComponent.setTableOfContentsHeading(designTocHeading);
            DRIDesignExpression anchorNameExpression = designTocHeading.getReferenceField().getAnchorNameExpression();
            Integer bookmarkLevel = designTocHeading.getReferenceField().getBookmarkLevel();
            DRDesignHyperLink designHyperLink = designTocHeading.getReferenceField().getHyperLink();
            if (designComponent instanceof DRDesignHyperlinkComponent) {
                ((DRDesignHyperlinkComponent)designComponent).setAnchorNameExpression(anchorNameExpression);
                ((DRDesignHyperlinkComponent)designComponent).setBookmarkLevel(bookmarkLevel);
                ((DRDesignHyperlinkComponent)designComponent).setHyperLink(designHyperLink);
            }
        }
    }

    private void hyperlink(DRDesignHyperlinkComponent designHyperlinkComponent, DRIHyperLinkComponent hyperlinkComponent, DRIReportStyle style, boolean textStyle, DefaultStyleType defaultStyleType) throws DRException {
        this.component(designHyperlinkComponent, hyperlinkComponent, style, textStyle, defaultStyleType);
        if (hyperlinkComponent.getAnchorNameExpression() != null) {
            designHyperlinkComponent.setAnchorNameExpression(this.accessor.getExpressionTransform().transformExpression(hyperlinkComponent.getAnchorNameExpression()));
        }
        if (hyperlinkComponent.getBookmarkLevel() != null) {
            designHyperlinkComponent.setBookmarkLevel(hyperlinkComponent.getBookmarkLevel());
        }
        DRIHyperLink hyperLink = hyperlinkComponent.getHyperLink();
        DRDesignHyperLink designHyperLink = this.accessor.getReportTransform().hyperlink(hyperLink);
        if (designHyperLink != null) {
            designHyperlinkComponent.setHyperLink(designHyperLink);
        }
    }

    protected DRDesignList list(DRIList list, DefaultStyleType defaultStyleType, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignList designList = new DRDesignList();
        this.component(designList, list, list.getStyle(), false, DefaultStyleType.NONE);
        designList.setType(list.getType());
        designList.setGap(this.accessor.getTemplateTransform().getListGap(list));
        designList.setWidth(this.accessor.getTemplateTransform().getListWidth(list));
        designList.setHeight(this.accessor.getTemplateTransform().getListHeight(list));
        designList.setCalculateComponents(designList.getWidth() == null && designList.getHeight() == null);
        for (DRIListCell dRIListCell : list.getListCells()) {
            DRIComponent component = dRIListCell.getComponent();
            HorizontalCellComponentAlignment horizontalAlignment = dRIListCell.getHorizontalAlignment();
            VerticalCellComponentAlignment verticalAlignment = dRIListCell.getVerticalAlignment();
            if (component instanceof DRIDimensionComponent) {
                DRIDimensionComponent dimComponent = (DRIDimensionComponent)component;
                if (horizontalAlignment == null) {
                    horizontalAlignment = ConstantTransform.toHorizontalCellComponentAlignment(dimComponent.getWidthType());
                }
                if (verticalAlignment == null) {
                    verticalAlignment = ConstantTransform.toVerticalCellComponentAlignment(dimComponent.getHeightType());
                }
            }
            designList.addComponent(horizontalAlignment, verticalAlignment, this.component(component, defaultStyleType, resetType, resetGroup));
        }
        designList.setBackgroundComponent(this.listBackgroundComponent(list.getBackgroundComponent(), defaultStyleType, resetType, resetGroup));
        return designList;
    }

    protected DRDesignComponent listBackgroundComponent(DRIComponent backgroundComponent, DefaultStyleType defaultStyleType, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        if (backgroundComponent != null) {
            if (backgroundComponent instanceof DRIRectangle || backgroundComponent instanceof DRIImage || backgroundComponent instanceof DRITextField) {
                return this.component(backgroundComponent, defaultStyleType, resetType, resetGroup);
            }
            throw new DRDesignReportException("List background component not supported. Only rectangle, image and textfield are supported");
        }
        return null;
    }

    private DRDesignSubreport multiPageList(DRIMultiPageList multiPageList) throws DRException {
        DRDesignSubreport designSubreport = new DRDesignSubreport();
        this.component(designSubreport, multiPageList, multiPageList.getStyle(), false, DefaultStyleType.NONE);
        designSubreport.setWidth(this.accessor.getTemplateTransform().getMultiPageListWidth(multiPageList));
        designSubreport.setHeight(this.accessor.getTemplateTransform().getMultiPageListHeight(multiPageList));
        JasperReportBuilder multiPageReport = DynamicReports.report();
        MultiPageListSubreportExpression subreportExpression = new MultiPageListSubreportExpression(multiPageList.getComponents());
        multiPageReport.detail(Components.subreport(subreportExpression));
        DRIDesignExpression reportExpression = this.accessor.getExpressionTransform().transformExpression(Expressions.value(multiPageReport));
        DRIDesignExpression dataSourceExpression = this.accessor.getExpressionTransform().transformExpression(Expressions.dataSource((JRDataSource)new JREmptyDataSource(multiPageList.getComponents().size())));
        designSubreport.setReportExpression(reportExpression);
        designSubreport.setDataSourceExpression(dataSourceExpression);
        return designSubreport;
    }

    protected DRDesignTextField textField(DRITextField<?> textField, DefaultStyleType defaultStyleType) throws DRException {
        DRDesignTextField designTextField = new DRDesignTextField();
        this.hyperlink(designTextField, textField, textField.getStyle(), true, defaultStyleType);
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        designTextField.setPrintRepeatedValues(Defaults.getDefaults().isTextFieldPrintRepeatedValues());
        designTextField.setStretchWithOverflow(templateTransform.getTextFieldStretchWithOverflow(textField));
        DRDesignStyle style = designTextField.getStyle();
        designTextField.setWidth(templateTransform.getTextFieldWidth(textField, style));
        designTextField.setHeight(templateTransform.getTextFieldHeight(textField, style));
        designTextField.setPattern(templateTransform.getTextFieldPattern(textField, style));
        designTextField.setPatternExpression(this.accessor.getExpressionTransform().transformExpression(textField.getPatternExpression()));
        designTextField.setHorizontalAlignment(templateTransform.getTextFieldHorizontalAlignment(textField, style));
        designTextField.setValueExpression(this.accessor.getExpressionTransform().transformExpression(textField.getValueExpression(), templateTransform.getTextFieldValueFormatter(textField), null));
        designTextField.setMarkup(textField.getMarkup());
        if (textField.getEvaluationTime() != null) {
            designTextField.setEvaluationTime(ConstantTransform.textFieldEvaluationTime(textField.getEvaluationTime(), textField.getEvaluationGroup(), this.accessor));
            designTextField.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(ConstantTransform.textFieldEvaluationGroup(textField.getEvaluationTime(), textField.getEvaluationGroup(), this.accessor)));
        } else {
            if (textField.getEvaluationGroup() != null) {
                throw new DRException("Evaluation group for textField is required only for evaluation time BEFORE_GROUP or GROUP");
            }
            EvaluationTime evaluationTime = this.detectEvaluationTime(designTextField.getValueExpression());
            designTextField.setEvaluationTime(evaluationTime);
            designTextField.setEvaluationGroup(this.detectEvaluationGroup(evaluationTime, designTextField.getValueExpression()));
        }
        return designTextField;
    }

    protected DRDesignFiller filler(DRIFiller filler) throws DRException {
        DRDesignFiller designFiller = new DRDesignFiller();
        this.component(designFiller, filler, filler.getStyle(), false, DefaultStyleType.NONE);
        designFiller.setWidth(this.accessor.getTemplateTransform().getFillerWidth(filler));
        designFiller.setHeight(this.accessor.getTemplateTransform().getFillerHeight(filler));
        return designFiller;
    }

    private DRDesignImage image(DRIImage image) throws DRException {
        return this.image(image, null, DefaultStyleType.IMAGE);
    }

    private DRDesignImage image(DRIImage image, Integer imageHeight, DefaultStyleType defaultStyleType) throws DRException {
        DRDesignImage designImage = new DRDesignImage();
        this.hyperlink(designImage, image, image.getStyle(), false, defaultStyleType);
        designImage.setImageScale(image.getImageScale());
        designImage.setImageExpression(this.accessor.getExpressionTransform().transformExpression(image.getImageExpression()));
        designImage.setUsingCache(image.getUsingCache());
        designImage.setLazy(image.getLazy());
        designImage.setHorizontalAlignment(image.getHorizontalAlignment());
        designImage.setWidth(this.accessor.getTemplateTransform().getImageWidth(image));
        DRDesignStyle style = designImage.getStyle();
        designImage.setHeight(this.accessor.getTemplateTransform().getImageHeight(image, imageHeight, style));
        return designImage;
    }

    private DRDesignChart chart(DRIChart chart, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignChart designChart = this.accessor.getChartTransform().transform(chart, resetType, resetGroup);
        this.hyperlink(designChart, chart, chart.getStyle(), false, DefaultStyleType.CHART);
        designChart.setEvaluationTime(this.evaluationTimeFromResetType(resetType));
        designChart.setEvaluationGroup(resetGroup);
        return designChart;
    }

    private DRDesignBarcode barcode(DRIBarcode barcode, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignBarcode designBarcode = this.accessor.getBarcodeTransform().transform(barcode);
        this.component(designBarcode, barcode, barcode.getStyle(), false, DefaultStyleType.BARCODE);
        designBarcode.setEvaluationTime(this.evaluationTimeFromResetType(resetType));
        designBarcode.setEvaluationGroup(resetGroup);
        return designBarcode;
    }

    private DRDesignBarbecue barbecue(DRIBarbecue barbecue, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignBarbecue designBarbecue = this.accessor.getBarcodeTransform().transform(barbecue);
        this.component(designBarbecue, barbecue, barbecue.getStyle(), false, DefaultStyleType.BARCODE);
        designBarbecue.setEvaluationTime(this.evaluationTimeFromResetType(resetType));
        designBarbecue.setEvaluationGroup(resetGroup);
        return designBarbecue;
    }

    private DRDesignSubreport subreport(DRISubreport subreport) throws DRException {
        DRDesignSubreport designSubreport = new DRDesignSubreport();
        this.component(designSubreport, subreport, subreport.getStyle(), false, DefaultStyleType.NONE);
        designSubreport.setWidth(this.accessor.getTemplateTransform().getSubreportWidth(subreport));
        designSubreport.setHeight(this.accessor.getTemplateTransform().getSubreportHeight(subreport));
        designSubreport.setReportExpression(this.accessor.getExpressionTransform().transformExpression(subreport.getReportExpression()));
        designSubreport.setParametersExpression(this.accessor.getExpressionTransform().transformExpression(subreport.getParametersExpression()));
        designSubreport.setConnectionExpression(this.accessor.getExpressionTransform().transformExpression(subreport.getConnectionExpression()));
        designSubreport.setDataSourceExpression(this.accessor.getExpressionTransform().transformExpression(subreport.getDataSourceExpression()));
        designSubreport.setRunToBottom(subreport.getRunToBottom());
        return designSubreport;
    }

    private DRDesignList pageXofY(DRIPageXofY pageXofY, DefaultStyleType defaultStyleType) throws DRException {
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        DRIReportStyle pageXofYStyle = pageXofY.getStyle();
        if (pageXofYStyle == null) {
            pageXofYStyle = this.accessor.getTemplateTransform().getTextStyle();
        }
        DRDesignStyle style = this.accessor.getStyleTransform().transformStyle(pageXofYStyle, true, defaultStyleType);
        Integer height = templateTransform.getPageXofYHeight(pageXofY, style);
        HorizontalAlignment horizontalAlignment = templateTransform.getPageXofYHorizontalAlignment(pageXofY, style);
        DRStyle newStylePageX = new DRStyle();
        newStylePageX.setParentStyle(pageXofYStyle);
        newStylePageX.getPadding().setRight(0);
        DRPen pen = new DRPen();
        pen.setLineWidth(Float.valueOf(0.0f));
        newStylePageX.getBorder().setRightPen(pen);
        DRStyle newStylePageY = new DRStyle();
        newStylePageY.setParentStyle(pageXofYStyle);
        newStylePageY.getPadding().setLeft(0);
        newStylePageY.getBorder().setLeftPen(pen);
        DRTextField<String> pageXField = new DRTextField<String>();
        pageXField.setAnchorNameExpression(pageXofY.getAnchorNameExpression());
        pageXField.setBookmarkLevel(pageXofY.getBookmarkLevel());
        pageXField.setHyperLink((DRHyperLink)pageXofY.getHyperLink());
        pageXField.setPrintWhenExpression(pageXofY.getPrintWhenExpression());
        pageXField.setStyle(newStylePageX);
        pageXField.setHeight(height);
        pageXField.setHeightType(pageXofY.getHeightType());
        pageXField.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        pageXField.setValueExpression(new PageXofYNumberExpression(pageXofY.getFormatExpression(), 0));
        DRTextField<String> pageYField = new DRTextField<String>();
        pageYField.setAnchorNameExpression(pageXofY.getAnchorNameExpression());
        pageYField.setBookmarkLevel(pageXofY.getBookmarkLevel());
        pageYField.setHyperLink((DRHyperLink)pageXofY.getHyperLink());
        pageYField.setPrintWhenExpression(pageXofY.getPrintWhenExpression());
        pageYField.setStyle(newStylePageY);
        pageYField.setHeight(height);
        pageYField.setHeightType(pageXofY.getHeightType());
        pageYField.setHorizontalAlignment(HorizontalAlignment.LEFT);
        pageYField.setValueExpression(new PageXofYNumberExpression(pageXofY.getFormatExpression(), 1));
        DRIGroup pageYEvaluationGroup = this.accessor.getGroupTransform().getFirstResetPageNumberGroup();
        if (pageYEvaluationGroup == null) {
            pageYField.setEvaluationTime(Evaluation.REPORT);
        } else {
            pageYField.setEvaluationTime(Evaluation.GROUP);
            pageYField.setEvaluationGroup((DRGroup)pageYEvaluationGroup);
        }
        int pageXofYWidth = templateTransform.getPageXofYWidth(pageXofY);
        switch (horizontalAlignment) {
            case LEFT: {
                int pageXWidth = StyleResolver.getFontWidth(style, 4);
                int pageYWidth = pageXofYWidth - pageXWidth;
                if (pageYWidth <= 0) {
                    pageYWidth = 10;
                }
                pageXField.setWidth(pageXWidth);
                pageXField.setWidthType(ComponentDimensionType.FIXED);
                pageYField.setWidth(pageYWidth);
                pageYField.setWidthType(pageXofY.getWidthType());
                break;
            }
            case RIGHT: {
                int pageYWidth = StyleResolver.getFontWidth(style, 6);
                int pageXWidth = pageXofYWidth - pageYWidth;
                if (pageXWidth <= 0) {
                    pageXWidth = 10;
                }
                pageXField.setWidth(pageXWidth);
                pageXField.setWidthType(pageXofY.getWidthType());
                pageYField.setWidth(pageYWidth);
                pageYField.setWidthType(ComponentDimensionType.FIXED);
                break;
            }
            default: {
                pageXField.setWidth(pageXofYWidth / 2);
                pageXField.setWidthType(pageXofY.getWidthType());
                pageYField.setWidth(pageXofYWidth / 2);
                pageYField.setWidthType(pageXofY.getWidthType());
            }
        }
        if (pageXofY.getPageXWidth() != null) {
            pageXField.setWidth(pageXofY.getPageXWidth());
        }
        if (pageXofY.getPageXWidthType() != null) {
            pageXField.setWidthType(pageXofY.getPageXWidthType());
        }
        if (pageXofY.getPageYWidth() != null) {
            pageYField.setWidth(pageXofY.getPageYWidth());
        }
        if (pageXofY.getPageYWidthType() != null) {
            pageYField.setWidthType(pageXofY.getPageYWidthType());
        }
        DRList listPageXofY = new DRList();
        listPageXofY.addComponent(pageXField);
        listPageXofY.addComponent(pageYField);
        return this.list(listPageXofY, DefaultStyleType.TEXT, null, null);
    }

    private DRDesignTextField totalPages(DRITotalPages totalPages, DefaultStyleType defaultStyleType) throws DRException {
        PageNumberExpression expression = new PageNumberExpression(totalPages.getFormatExpression());
        DRTextField<String> totalPagesField = this.formatField(totalPages, expression);
        DRIGroup pageEvaluationGroup = this.accessor.getGroupTransform().getFirstResetPageNumberGroup();
        if (pageEvaluationGroup == null) {
            totalPagesField.setEvaluationTime(Evaluation.REPORT);
        } else {
            totalPagesField.setEvaluationTime(Evaluation.GROUP);
            totalPagesField.setEvaluationGroup((DRGroup)pageEvaluationGroup);
        }
        return this.textField(totalPagesField, defaultStyleType);
    }

    private DRDesignTextField pageNumber(DRIPageNumber pageNumber, DefaultStyleType defaultStyleType) throws DRException {
        PageNumberExpression expression = new PageNumberExpression(pageNumber.getFormatExpression());
        return this.textField(this.formatField(pageNumber, expression), defaultStyleType);
    }

    private DRDesignTextField currentDate(DRICurrentDate currentDate, DefaultStyleType defaultStyleType) throws DRException {
        CurrentDateExpression expression = new CurrentDateExpression(currentDate.getFormatExpression(), currentDate.getPattern());
        return this.textField(this.formatField(currentDate, expression), defaultStyleType);
    }

    private DRTextField<String> formatField(DRIFormatField formatField, DRIExpression<String> expression) throws DRException {
        DRTextField<String> formatFieldTextField = new DRTextField<String>();
        formatFieldTextField.setAnchorNameExpression(formatField.getAnchorNameExpression());
        formatFieldTextField.setBookmarkLevel(formatField.getBookmarkLevel());
        formatFieldTextField.setHyperLink((DRHyperLink)formatField.getHyperLink());
        formatFieldTextField.setPrintWhenExpression(formatField.getPrintWhenExpression());
        formatFieldTextField.setStyle(formatField.getStyle());
        formatFieldTextField.setWidth(formatField.getWidth());
        formatFieldTextField.setWidthType(formatField.getWidthType());
        formatFieldTextField.setHeight(formatField.getHeight());
        formatFieldTextField.setHeightType(formatField.getHeightType());
        formatFieldTextField.setHorizontalAlignment(formatField.getHorizontalAlignment());
        formatFieldTextField.setValueExpression(expression);
        return formatFieldTextField;
    }

    protected DRDesignLine line(DRILine line) throws DRException {
        DRDesignLine designLine = new DRDesignLine();
        this.component(designLine, line, line.getStyle(), false, DefaultStyleType.NONE);
        designLine.setDirection(line.getDirection());
        designLine.setPen(this.accessor.getStyleTransform().pen(line.getPen()));
        designLine.setWidth(this.accessor.getTemplateTransform().getLineWidth(line));
        designLine.setHeight(this.accessor.getTemplateTransform().getLineHeight(line));
        return designLine;
    }

    protected DRDesignEllipse ellipse(DRIEllipse ellipse) throws DRException {
        DRDesignEllipse designEllipse = new DRDesignEllipse();
        this.component(designEllipse, ellipse, ellipse.getStyle(), false, DefaultStyleType.NONE);
        designEllipse.setPen(this.accessor.getStyleTransform().pen(ellipse.getPen()));
        designEllipse.setWidth(this.accessor.getTemplateTransform().getEllipseWidth(ellipse));
        designEllipse.setHeight(this.accessor.getTemplateTransform().getEllipseHeight(ellipse));
        return designEllipse;
    }

    protected DRDesignRectangle rectangle(DRIRectangle rectangle) throws DRException {
        DRDesignRectangle designRectangle = new DRDesignRectangle();
        this.component(designRectangle, rectangle, rectangle.getStyle(), false, DefaultStyleType.NONE);
        designRectangle.setRadius(this.accessor.getTemplateTransform().getRectangleRadius(rectangle));
        designRectangle.setPen(this.accessor.getStyleTransform().pen(rectangle.getPen()));
        designRectangle.setWidth(this.accessor.getTemplateTransform().getRectangleWidth(rectangle));
        designRectangle.setHeight(this.accessor.getTemplateTransform().getRectangleHeight(rectangle));
        return designRectangle;
    }

    protected DRDesignComponent booleanField(DRIBooleanField booleanField, DefaultStyleType defaultStyleType, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignComponent designComponent;
        BooleanComponentType componentType = this.accessor.getTemplateTransform().getBooleanComponentType(booleanField);
        boolean emptyWhenNullValue = this.accessor.getTemplateTransform().getBooleanEmptyWhenNullValue(booleanField);
        DRHyperLinkComponent component = null;
        switch (componentType) {
            case TEXT_TRUE_FALSE: 
            case TEXT_YES_NO: {
                String keyFalse;
                String keyTrue;
                if (componentType.equals((Object)BooleanComponentType.TEXT_TRUE_FALSE)) {
                    keyTrue = "true";
                    keyFalse = "false";
                } else {
                    keyTrue = "yes";
                    keyFalse = "no";
                }
                DRTextField<Boolean> textField = new DRTextField<Boolean>();
                textField.setValueExpression(booleanField.getValueExpression());
                textField.setDataType(DataTypes.booleanType());
                textField.setHorizontalAlignment(booleanField.getHorizontalAlignment());
                textField.setValueFormatter(new BooleanTextValueFormatter(keyTrue, keyFalse, emptyWhenNullValue));
                component = textField;
                break;
            }
            case IMAGE_STYLE_1: 
            case IMAGE_STYLE_2: 
            case IMAGE_STYLE_3: 
            case IMAGE_STYLE_4: 
            case IMAGE_BALL: 
            case IMAGE_CHECKBOX_1: 
            case IMAGE_CHECKBOX_2: {
                DRImage image = new DRImage();
                image.setImageScale(ImageScale.NO_RESIZE);
                image.setImageExpression(new BooleanImageExpression(booleanField, emptyWhenNullValue));
                component = image;
                break;
            }
            default: {
                throw new DRDesignReportException("Boolean component type " + componentType.name() + " not supported");
            }
        }
        component.setWidth(booleanField.getWidth());
        component.setWidthType(booleanField.getWidthType());
        component.setHeight(booleanField.getHeight());
        component.setHeightType(booleanField.getHeightType());
        component.setAnchorNameExpression(booleanField.getAnchorNameExpression());
        component.setBookmarkLevel(booleanField.getBookmarkLevel());
        component.setHyperLink((DRHyperLink)booleanField.getHyperLink());
        component.setStyle(booleanField.getStyle());
        component.setPrintWhenExpression(booleanField.getPrintWhenExpression());
        component.setPropertyExpressions(booleanField.getPropertyExpressions());
        if (component instanceof DRIImage) {
            int imageHeight = this.accessor.getTemplateTransform().getBooleanImageHeight(booleanField);
            designComponent = this.image((DRIImage)((Object)component), imageHeight, defaultStyleType);
            TemplateTransform templateTransform = this.accessor.getTemplateTransform();
            ((DRDesignImage)designComponent).setHorizontalAlignment(templateTransform.getBooleanHorizontalAlignment(booleanField, designComponent.getStyle()));
        } else {
            designComponent = this.component(component, defaultStyleType, resetType, resetGroup);
        }
        return designComponent;
    }

    protected DRDesignBreak breakComponent(DRIBreak breakComponent) throws DRException {
        DRDesignBreak designBreak = new DRDesignBreak();
        this.component(designBreak, breakComponent, null, false, DefaultStyleType.NONE);
        designBreak.setType(breakComponent.getType());
        designBreak.setWidth(this.accessor.getTemplateTransform().getBreakWidth(breakComponent));
        designBreak.setHeight(this.accessor.getTemplateTransform().getBreakHeight(breakComponent));
        return designBreak;
    }

    protected DRDesignGenericElement genericElement(DRIGenericElement genericElement, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignGenericElement designGenericElement = new DRDesignGenericElement();
        this.component(designGenericElement, genericElement, genericElement.getStyle(), false, DefaultStyleType.NONE);
        designGenericElement.setGenericElementNamespace(genericElement.getGenericElementNamespace());
        designGenericElement.setGenericElementName(genericElement.getGenericElementName());
        designGenericElement.setEvaluationTime(this.evaluationTimeFromResetType(resetType));
        designGenericElement.setEvaluationGroup(resetGroup);
        designGenericElement.setWidth(this.accessor.getTemplateTransform().getGenericElementWidth(genericElement));
        designGenericElement.setHeight(this.accessor.getTemplateTransform().getGenericElementHeight(genericElement));
        for (DRIParameterExpression parameterExpression : genericElement.getParameterExpressions()) {
            designGenericElement.getParameterExpressions().add(this.accessor.getExpressionTransform().transformParameterExpression(parameterExpression));
        }
        return designGenericElement;
    }

    private DRDesignCrosstab crosstab(DRICrosstab crosstab, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstab designCrosstab = this.accessor.getCrosstabTransform().transform(crosstab, resetType, resetGroup);
        this.component(designCrosstab, crosstab, crosstab.getStyle(), false, DefaultStyleType.NONE);
        return designCrosstab;
    }

    private DRDesignMap map(DRIMap map, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignMap designMap = new DRDesignMap();
        this.component(designMap, map, map.getStyle(), false, DefaultStyleType.NONE);
        designMap.setLatitudeExpression(this.accessor.getExpressionTransform().transformExpression(map.getLatitudeExpression()));
        designMap.setLongitudeExpression(this.accessor.getExpressionTransform().transformExpression(map.getLongitudeExpression()));
        designMap.setZoomExpression(this.accessor.getExpressionTransform().transformExpression(map.getZoomExpression()));
        designMap.setWidth(this.accessor.getTemplateTransform().getMapWidth(map));
        designMap.setHeight(this.accessor.getTemplateTransform().getMapHeight(map));
        designMap.setEvaluationTime(this.evaluationTimeFromResetType(resetType));
        designMap.setEvaluationGroup(resetGroup);
        return designMap;
    }

    private DRDesignComponent customComponent(DRICustomComponent component, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        CustomComponentTransform<?, ?> componentTransfom = CustomComponents.getComponentTransform(component);
        if (componentTransfom == null) {
            throw new DRDesignReportException("Component " + component.getClass().getName() + " not supported");
        }
        DRDesignComponent designComponent = (DRDesignComponent)componentTransfom.designComponent(this.accessor, component, resetType, resetGroup);
        this.component(designComponent, component, component.getStyle(), false, DefaultStyleType.NONE);
        DRICustomComponent dimensionComponent = component;
        if (designComponent.getWidth() == null) {
            designComponent.setWidth(this.accessor.getTemplateTransform().getCustomComponentWidth(dimensionComponent));
        }
        if (designComponent.getHeight() == null) {
            designComponent.setHeight(this.accessor.getTemplateTransform().getCustomComponentHeight(dimensionComponent));
        }
        return designComponent;
    }

    protected EvaluationTime detectEvaluationTime(DRIDesignExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof DRIDesignField || expression instanceof DRIDesignSystemExpression || expression instanceof DRIDesignSimpleExpression || expression instanceof DRIDesignJasperExpression) {
            return EvaluationTime.NOW;
        }
        if (expression instanceof DRIDesignVariable) {
            return this.evaluationTimeFromResetType(((DRIDesignVariable)expression).getResetType());
        }
        if (expression instanceof DRIDesignComplexExpression) {
            return this.detectComplexExpressionEvaluationTime((DRIDesignComplexExpression)expression);
        }
        throw new DRDesignReportException("Expression " + expression.getClass().getName() + " not supported");
    }

    public EvaluationTime evaluationTimeFromResetType(ResetType resetType) {
        if (resetType == null) {
            return null;
        }
        switch (resetType) {
            case NONE: {
                return EvaluationTime.NOW;
            }
            case REPORT: {
                return EvaluationTime.REPORT;
            }
            case PAGE: {
                return EvaluationTime.PAGE;
            }
            case COLUMN: {
                return EvaluationTime.COLUMN;
            }
            case GROUP: {
                return EvaluationTime.GROUP;
            }
        }
        throw new DRDesignReportException("Reset type " + resetType.name() + " not supported");
    }

    private EvaluationTime detectComplexExpressionEvaluationTime(DRIDesignComplexExpression complexExpression) {
        EvaluationTime evaluationTime = null;
        for (DRIDesignExpression expression : complexExpression.getExpressions()) {
            EvaluationTime evalTime = this.detectEvaluationTime(expression);
            if (evaluationTime == null) {
                evaluationTime = evalTime;
                continue;
            }
            if (evaluationTime == evalTime && (!evaluationTime.equals((Object)EvaluationTime.GROUP) || !evalTime.equals((Object)EvaluationTime.GROUP))) continue;
            return EvaluationTime.AUTO;
        }
        return evaluationTime;
    }

    private DRDesignGroup detectEvaluationGroup(EvaluationTime evaluationTime, DRIDesignExpression expression) {
        if (expression != null && evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP)) {
            DRDesignGroup evaluationGroup = this.detectEvaluationGroup(expression);
            if (evaluationGroup == null) {
                throw new DRDesignReportException("Can not detect evaluation group");
            }
            return evaluationGroup;
        }
        return null;
    }

    private DRDesignGroup detectEvaluationGroup(DRIDesignExpression expression) {
        if (expression instanceof DRIDesignField || expression instanceof DRIDesignSimpleExpression) {
            return null;
        }
        if (expression instanceof DRDesignVariable) {
            return ((DRDesignVariable)expression).getResetGroup();
        }
        if (expression instanceof DRIDesignComplexExpression) {
            return this.detectComplexExpressionEvaluationGroup((DRIDesignComplexExpression)expression);
        }
        throw new DRDesignReportException("Expression " + expression.getClass().getName() + " not supported");
    }

    private DRDesignGroup detectComplexExpressionEvaluationGroup(DRIDesignComplexExpression complexExpression) {
        DRDesignGroup evaluationGroup = null;
        for (DRIDesignExpression expression : complexExpression.getExpressions()) {
            DRDesignGroup group = this.detectEvaluationGroup(expression);
            if (evaluationGroup == null) {
                evaluationGroup = group;
                continue;
            }
            if (evaluationGroup == group) continue;
            throw new DRDesignReportException("Can not detect evaluation group");
        }
        return evaluationGroup;
    }

    private class BooleanImageExpression
    extends AbstractComplexExpression<Renderable> {
        private static final long serialVersionUID = 10000L;
        private Renderable imageTrue;
        private Renderable imageFalse;
        private boolean emptyWhenNullValue;

        private BooleanImageExpression(DRIBooleanField booleanField, boolean emptyWhenNullValue) throws DRException {
            String fileNameFalse;
            String fileNameTrue;
            this.emptyWhenNullValue = emptyWhenNullValue;
            this.addExpression(booleanField.getValueExpression());
            switch (booleanField.getComponentType()) {
                case IMAGE_STYLE_1: {
                    fileNameTrue = "boolean1_true";
                    fileNameFalse = "boolean1_false";
                    break;
                }
                case IMAGE_STYLE_2: {
                    fileNameTrue = "boolean2_true";
                    fileNameFalse = "boolean2_false";
                    break;
                }
                case IMAGE_STYLE_3: {
                    fileNameTrue = "boolean3_true";
                    fileNameFalse = "boolean3_false";
                    break;
                }
                case IMAGE_STYLE_4: {
                    fileNameTrue = "boolean1_true";
                    fileNameFalse = "boolean4_false";
                    break;
                }
                case IMAGE_CHECKBOX_1: {
                    fileNameTrue = "checkbox1_true";
                    fileNameFalse = "checkbox_false";
                    break;
                }
                case IMAGE_CHECKBOX_2: {
                    fileNameTrue = "checkbox2_true";
                    fileNameFalse = "checkbox_false";
                    break;
                }
                case IMAGE_BALL: {
                    fileNameTrue = "ball_green";
                    fileNameFalse = "ball_red";
                    break;
                }
                default: {
                    throw new DRDesignReportException("BooleanComponentType " + booleanField.getComponentType().name() + " not supported");
                }
            }
            try {
                int width = ComponentTransform.this.accessor.getTemplateTransform().getBooleanImageWidth(booleanField);
                int height = ComponentTransform.this.accessor.getTemplateTransform().getBooleanImageHeight(booleanField);
                this.imageTrue = new CustomBatikRenderer(ReportUtils.class.getResource("images/" + fileNameTrue + ".svg"), width, height);
                this.imageFalse = new CustomBatikRenderer(ReportUtils.class.getResource("images/" + fileNameFalse + ".svg"), width, height);
            }
            catch (JRException e) {
                throw new DRException(e);
            }
        }

        @Override
        public Renderable evaluate(List<?> values, ReportParameters reportParameters) {
            Boolean value = (Boolean)values.get(0);
            if (this.emptyWhenNullValue && value == null) {
                return null;
            }
            if (value != null && value.booleanValue()) {
                return this.imageTrue;
            }
            return this.imageFalse;
        }
    }

    private class BooleanTextValueFormatter
    extends AbstractValueFormatter<String, Boolean> {
        private static final long serialVersionUID = 10000L;
        private String keyTrue;
        private String keyFalse;
        private boolean emptyWhenNullValue;

        private BooleanTextValueFormatter(String keyTrue, String keyFalse, boolean emptyWhenNullValue) {
            this.keyTrue = keyTrue;
            this.keyFalse = keyFalse;
            this.emptyWhenNullValue = emptyWhenNullValue;
        }

        @Override
        public String format(Boolean value, ReportParameters reportParameters) {
            if (this.emptyWhenNullValue && value == null) {
                return "";
            }
            String key = value != null && value != false ? this.keyTrue : this.keyFalse;
            return ResourceBundle.getBundle("dynamicreports-messages", reportParameters.getLocale()).getString(key);
        }
    }

    private class CurrentDateExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;
        private String datePattern;

        public CurrentDateExpression(DRIExpression<String> currentDateExpression, String datePattern) {
            this.datePattern = datePattern;
            this.addExpression(currentDateExpression);
        }

        @Override
        public String evaluate(List<?> values, ReportParameters reportParameters) {
            String pattern = (String)values.get(0);
            Locale locale = reportParameters.getLocale();
            MessageFormat format = new MessageFormat(pattern, locale);
            String date = this.datePattern == null ? DataTypes.dateType().valueToString(new Date(), locale) : new SimpleDateFormat(this.datePattern, locale).format(new Date());
            String result = format.format(new Object[]{date});
            return result;
        }
    }

    private class MultiPageListSubreportExpression
    extends AbstractSimpleExpression<JasperReportBuilder> {
        private static final long serialVersionUID = 1L;
        private List<DRIComponent> detailComponents;

        public MultiPageListSubreportExpression(List<DRIComponent> detailComponents) {
            this.detailComponents = detailComponents;
        }

        @Override
        public JasperReportBuilder evaluate(ReportParameters reportParameters) {
            JasperReportBuilder report = DynamicReports.report();
            DRBand titleBand = report.getReport().getTitleBand();
            DRComponent detailComponent = (DRComponent)this.detailComponents.get(reportParameters.getReportRowNumber() - 1);
            titleBand.addComponent(detailComponent);
            return report;
        }
    }

    private class PageNumberExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;

        public PageNumberExpression(DRIExpression<String> pageNumberFormatExpression) {
            this.addExpression(pageNumberFormatExpression);
        }

        @Override
        public String evaluate(List<?> values, ReportParameters reportParameters) {
            String pattern = (String)values.get(0);
            MessageFormat format = new MessageFormat(pattern, reportParameters.getLocale());
            String result = format.format(new Object[]{reportParameters.getPageNumber()});
            return result;
        }
    }

    private class PageXofYNumberExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;
        private int index;

        public PageXofYNumberExpression(DRIExpression<String> pageNumberFormatExpression, int index) {
            this.addExpression(pageNumberFormatExpression);
            this.index = index;
        }

        @Override
        public String evaluate(List<?> values, ReportParameters reportParameters) {
            String pattern = (String)values.get(0);
            Validate.isTrue((boolean)StringUtils.contains((CharSequence)pattern, (CharSequence)"{0}"), (String)("Wrong format pattern \"" + pattern + "\", missing argument {0}"), (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.contains((CharSequence)pattern, (CharSequence)"{1}"), (String)("Wrong format pattern \"" + pattern + "\", missing argument {1}"), (Object[])new Object[0]);
            Validate.isTrue((pattern.indexOf("{0}") < pattern.indexOf("{1}") ? 1 : 0) != 0, (String)("Wrong format pattern \"" + pattern + "\", argument {0} must be before {1}"), (Object[])new Object[0]);
            int index1 = pattern.indexOf("{0}");
            pattern = this.index == 0 ? pattern.substring(0, index1 + 3) : pattern.substring(index1 + 3);
            MessageFormat format = new MessageFormat(pattern, reportParameters.getLocale());
            String result = format.format(new Object[]{reportParameters.getPageNumber(), reportParameters.getPageNumber()});
            return result;
        }
    }
}

