/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstab;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCell;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCellContent;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabColumnGroup;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabDataset;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabGroup;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabMeasure;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabRowGroup;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.report.base.DRHyperLink;
import net.sf.dynamicreports.report.base.component.DRFiller;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabCellContent;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabCellStyle;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.base.style.DRConditionalStyle;
import net.sf.dynamicreports.report.base.style.DRStyle;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.expression.SystemMessageExpression;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.CrosstabPercentageType;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstab;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabCellContent;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabCellStyle;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabColumnGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabDataset;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabMeasure;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabRowGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabVariable;
import net.sf.dynamicreports.report.definition.expression.DRIComplexExpression;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIJasperExpression;
import net.sf.dynamicreports.report.definition.expression.DRISimpleExpression;
import net.sf.dynamicreports.report.definition.style.DRIConditionalStyle;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.definition.style.DRISimpleStyle;
import net.sf.dynamicreports.report.definition.style.DRIStyle;
import net.sf.dynamicreports.report.exception.DRException;

public class CrosstabTransform {
    private DesignTransformAccessor accessor;
    private Map<DRDesignCrosstab, DRICrosstab> crosstabs;

    public CrosstabTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.init();
    }

    private void init() {
        this.crosstabs = new HashMap<DRDesignCrosstab, DRICrosstab>();
    }

    protected DRDesignCrosstab transform(DRICrosstab crosstab, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstab designCrosstab = new DRDesignCrosstab();
        designCrosstab.setDataset(this.dataset(crosstab.getDataset(), resetType, resetGroup));
        this.accessor.transformToDataset(crosstab.getDataset().getSubDataset());
        if (crosstab.getDataset() != null) {
            resetType = null;
            resetGroup = null;
        }
        DRDesignCrosstabCellContent whenNoDataCell = this.cellContent(crosstab.getWhenNoDataCell(), resetType, resetGroup);
        designCrosstab.setWidth(this.accessor.getTemplateTransform().getCrosstabWidth(crosstab));
        designCrosstab.setHeight(this.accessor.getTemplateTransform().getCrosstabHeight(crosstab, whenNoDataCell));
        designCrosstab.setRepeatColumnHeaders(crosstab.isRepeatColumnHeaders());
        designCrosstab.setRepeatRowHeaders(crosstab.isRepeatRowHeaders());
        designCrosstab.setColumnBreakOffset(crosstab.getColumnBreakOffset());
        designCrosstab.setIgnoreWidth(crosstab.getIgnoreWidth());
        designCrosstab.setRunDirection(crosstab.getRunDirection());
        designCrosstab.setWhenNoDataCell(whenNoDataCell);
        designCrosstab.setHeaderCell(this.cellContent(crosstab.getHeaderCell(), resetType, resetGroup));
        for (DRICrosstabColumnGroup<?> dRICrosstabColumnGroup : crosstab.getColumnGroups()) {
            this.addColumnGroup(crosstab, designCrosstab, dRICrosstabColumnGroup, resetType, resetGroup);
        }
        for (DRICrosstabRowGroup dRICrosstabRowGroup : crosstab.getRowGroups()) {
            this.addRowGroup(crosstab, designCrosstab, dRICrosstabRowGroup, resetType, resetGroup);
        }
        this.addCells(crosstab, designCrosstab, resetType, resetGroup);
        for (DRICrosstabVariable dRICrosstabVariable : crosstab.getVariables()) {
            this.addMeasure(designCrosstab, dRICrosstabVariable);
        }
        for (DRICrosstabMeasure dRICrosstabMeasure : crosstab.getMeasures()) {
            if (!(dRICrosstabMeasure.getExpression() instanceof DRICrosstabVariable)) continue;
            this.addMeasure(designCrosstab, (DRICrosstabVariable)dRICrosstabMeasure.getExpression());
        }
        this.accessor.getExpressionTransform().transformExpression(new CrosstabRowCounter());
        this.addRowCountExpression(designCrosstab);
        this.crosstabs.put(designCrosstab, crosstab);
        this.accessor.transformToMainDataset();
        return designCrosstab;
    }

    private DRDesignCrosstabDataset dataset(DRICrosstabDataset dataset, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstabDataset designDataset = new DRDesignCrosstabDataset();
        designDataset.setSubDataset(this.accessor.getDatasetTransform().transform(dataset.getSubDataset()));
        designDataset.setDataPreSorted(dataset.getDataPreSorted());
        designDataset.setResetType(resetType);
        designDataset.setResetGroup(resetGroup);
        return designDataset;
    }

    private void addRowCountExpression(DRDesignCrosstab designCrosstab) throws DRException {
        DRDesignCrosstabRowGroup lastRowGroup = this.getLastValue(designCrosstab.getRowGroups());
        DRFiller filler = new DRFiller();
        CrosstabRowCount rowCountExpression = new CrosstabRowCount();
        filler.setPrintWhenExpression(rowCountExpression);
        DRDesignFiller designTextField = this.accessor.getComponentTransform().filler(filler);
        lastRowGroup.getHeader().getList().addComponent(designTextField);
    }

    private DRDesignCrosstabCellContent cellContent(DRICrosstabCellContent cellContent, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstabCellContent designCellContents = new DRDesignCrosstabCellContent();
        designCellContents.setList(this.accessor.getComponentTransform().list(cellContent.getList(), DefaultStyleType.TEXT, resetType, resetGroup));
        designCellContents.setStyle(this.accessor.getStyleTransform().transformStyle(cellContent.getStyle(), false, DefaultStyleType.NONE));
        return designCellContents;
    }

    private void group(DRDesignCrosstabGroup designGroup, DRICrosstab crosstab, DRICrosstabGroup group, boolean showTotal, ResetType resetType, DRDesignGroup resetGroup, DRDesignComponent designTitleComponent, DRDesignComponent designTotalTitleComponent) throws DRException {
        DRIReportStyle groupStyle;
        designGroup.setName(group.getName());
        designGroup.setOrderType(group.getOrderType());
        designGroup.setExpression(this.accessor.getExpressionTransform().transformExpression(group.getExpression()));
        if (group.getOrderByExpression() != null) {
            DRIExpression<Comparable<?>> orderByExpression = this.getCrosstabExpression(crosstab, group.getOrderByExpression());
            designGroup.setOrderByExpression(this.accessor.getExpressionTransform().transformExpression(orderByExpression));
        }
        if (group.getComparatorExpression() != null) {
            DRIExpression<Comparator<?>> comparatorExpression = this.getCrosstabExpression(crosstab, group.getComparatorExpression());
            designGroup.setComparatorExpression(this.accessor.getExpressionTransform().transformExpression(comparatorExpression));
        }
        DRTextField textField = new DRTextField();
        textField.setValueExpression(group);
        textField.setPattern(group.getHeaderPattern());
        textField.setHorizontalAlignment(group.getHeaderHorizontalAlignment());
        textField.setValueFormatter(group.getHeaderValueFormatter());
        textField.setDataType(group.getDataType());
        textField.setStretchWithOverflow(group.getHeaderStretchWithOverflow());
        textField.setHyperLink((DRHyperLink)group.getHeaderHyperLink());
        boolean measureTitle = false;
        for (DRICrosstabMeasure<?> crosstabMeasure : crosstab.getMeasures()) {
            if (crosstabMeasure.getTitleExpression() == null) continue;
            measureTitle = true;
            break;
        }
        if (group instanceof DRICrosstabRowGroup || group instanceof DRICrosstabColumnGroup && !measureTitle) {
            textField.setStretchType(StretchType.RELATIVE_TO_BAND_HEIGHT);
        }
        if ((groupStyle = group.getHeaderStyle()) == null) {
            groupStyle = this.accessor.getTemplateTransform().getCrosstabGroupStyle(crosstab);
        }
        textField.setStyle(groupStyle);
        DRDesignCrosstabCellContent header = this.createCellContent(this.getCellStyle(groupStyle), resetType, resetGroup);
        DRDesignTextField designTextField = this.accessor.getComponentTransform().textField(textField, DefaultStyleType.TEXT);
        designTextField.setUniqueName("group_" + designGroup.getName() + ".header");
        header.getList().addComponent(designTextField);
        if (designTitleComponent != null) {
            header.getList().addComponent(designTitleComponent);
        }
        designGroup.setHeader(header);
        if (showTotal) {
            DRIReportStyle totalStyle = group.getTotalHeaderStyle();
            if (totalStyle == null) {
                DRICrosstabGroup firstGroup = null;
                firstGroup = group instanceof DRICrosstabRowGroup ? (DRICrosstabGroup)this.getFirstValue(crosstab.getRowGroups()) : (DRICrosstabGroup)this.getFirstValue(crosstab.getColumnGroups());
                totalStyle = firstGroup == group ? this.accessor.getTemplateTransform().getCrosstabGrandTotalStyle(crosstab) : this.accessor.getTemplateTransform().getCrosstabGroupTotalStyle(crosstab);
            }
            textField = new DRTextField();
            SystemMessageExpression totalHeaderExpression = group.getTotalHeaderExpression();
            if (totalHeaderExpression == null) {
                totalHeaderExpression = new SystemMessageExpression("total");
            }
            textField.setValueExpression(totalHeaderExpression);
            textField.setStyle(totalStyle);
            if (group instanceof DRICrosstabRowGroup || group instanceof DRICrosstabColumnGroup && !measureTitle) {
                textField.setStretchType(StretchType.RELATIVE_TO_BAND_HEIGHT);
            }
            DRDesignCrosstabCellContent totalHeader = this.createCellContent(this.getCellStyle(totalStyle), resetType, resetGroup);
            designTextField = this.accessor.getComponentTransform().textField(textField, DefaultStyleType.TEXT);
            designTextField.setUniqueName("group_" + designGroup.getName() + ".totalheader");
            totalHeader.getList().addComponent(designTextField);
            if (designTotalTitleComponent != null) {
                totalHeader.getList().addComponent(designTotalTitleComponent);
            }
            designGroup.setTotalHeader(totalHeader);
        }
    }

    private void addColumnGroup(DRICrosstab crosstab, DRDesignCrosstab designCrosstab, DRICrosstabColumnGroup<?> columnGroup, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        boolean lastColumn;
        DRDesignCrosstabColumnGroup designColumnGroup = new DRDesignCrosstabColumnGroup();
        boolean showTotal = this.accessor.getTemplateTransform().isCrosstabColumnGroupShowTotal(columnGroup);
        DRDesignComponent designTitleComponent = null;
        DRDesignComponent designTotalTitleComponent = null;
        boolean bl = lastColumn = columnGroup == this.getLastValue(crosstab.getColumnGroups());
        if (showTotal || lastColumn) {
            boolean showTitle = false;
            for (DRICrosstabMeasure<?> measure : crosstab.getMeasures()) {
                if (measure.getTitleExpression() == null) continue;
                showTitle = true;
                break;
            }
            if (showTitle) {
                String name;
                if (lastColumn) {
                    DRIReportStyle groupStyle = columnGroup.getHeaderStyle();
                    if (groupStyle == null) {
                        groupStyle = this.accessor.getTemplateTransform().getCrosstabGroupStyle(crosstab);
                    }
                    name = "group_" + columnGroup.getName() + ".titleheader";
                    designTitleComponent = this.getMeasureTitleComponent(name, crosstab, groupStyle);
                }
                if (showTotal) {
                    DRIReportStyle totalStyle = columnGroup.getTotalHeaderStyle();
                    if (totalStyle == null) {
                        DRICrosstabGroup firstGroup = this.getFirstValue(crosstab.getColumnGroups());
                        totalStyle = firstGroup == columnGroup ? this.accessor.getTemplateTransform().getCrosstabGrandTotalStyle(crosstab) : this.accessor.getTemplateTransform().getCrosstabGroupTotalStyle(crosstab);
                    }
                    name = "group_" + columnGroup.getName() + ".titletotalheader";
                    designTotalTitleComponent = this.getMeasureTitleComponent(name, crosstab, totalStyle);
                }
            }
        }
        this.group(designColumnGroup, crosstab, columnGroup, showTotal, resetType, resetGroup, designTitleComponent, designTotalTitleComponent);
        designColumnGroup.setTotalPosition(this.accessor.getTemplateTransform().getCrosstabColumnGroupTotalPosition(columnGroup));
        designCrosstab.getColumnGroups().add(designColumnGroup);
    }

    private DRDesignComponent getMeasureTitleComponent(String name, DRICrosstab crosstab, DRIReportStyle defaultStyle) throws DRException {
        DRDesignList titleComponent = new DRDesignList();
        for (DRICrosstabMeasure<?> measure : crosstab.getMeasures()) {
            DRIReportStyle titleStyle;
            DRTextField textField = new DRTextField();
            if (measure.getTitleExpression() != null) {
                textField.setValueExpression(measure.getTitleExpression());
            }
            if ((titleStyle = this.accessor.getTemplateTransform().getCrosstabMeasureTitleStyle(crosstab, measure)) == null) {
                titleStyle = defaultStyle;
            }
            textField.setStyle(titleStyle);
            DRDesignTextField designTextField = this.accessor.getComponentTransform().textField(textField, DefaultStyleType.TEXT);
            designTextField.setUniqueName(String.valueOf(name) + "." + measure.getName());
            titleComponent.addComponent(designTextField);
        }
        return titleComponent;
    }

    private void addRowGroup(DRICrosstab crosstab, DRDesignCrosstab designCrosstab, DRICrosstabRowGroup<?> rowGroup, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstabRowGroup designRowGroup = new DRDesignCrosstabRowGroup();
        boolean showTotal = this.accessor.getTemplateTransform().isCrosstabRowGroupShowTotal(rowGroup);
        this.group(designRowGroup, crosstab, rowGroup, showTotal, resetType, resetGroup, null, null);
        designRowGroup.setTotalPosition(this.accessor.getTemplateTransform().getCrosstabRowGroupTotalPosition(rowGroup));
        designCrosstab.getRowGroups().add(designRowGroup);
    }

    private void addCells(DRICrosstab crosstab, DRDesignCrosstab designCrosstab, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        MeasuresStyles measuresStyle = new MeasuresStyles(crosstab, designCrosstab);
        DRIReportStyle groupTotalStyle = this.accessor.getTemplateTransform().getCrosstabGroupTotalStyle(crosstab);
        groupTotalStyle = this.getCellStyle(groupTotalStyle);
        DRIReportStyle grandTotalStyle = this.accessor.getTemplateTransform().getCrosstabGrandTotalStyle(crosstab);
        grandTotalStyle = this.getCellStyle(grandTotalStyle);
        DRIReportStyle cellStyle = this.accessor.getTemplateTransform().getCrosstabCellStyle(crosstab);
        cellStyle = this.getCellStyle(cellStyle);
        DRICrosstabGroup firstColumnGroup = this.getFirstValue(crosstab.getColumnGroups());
        DRICrosstabGroup firstRowGroup = this.getFirstValue(crosstab.getRowGroups());
        DRDesignCrosstabCell designCell = this.cell(crosstab, cellStyle, measuresStyle, null, null, resetType, resetGroup);
        designCrosstab.getCells().add(designCell);
        DRIReportStyle style = null;
        for (DRICrosstabColumnGroup<?> dRICrosstabColumnGroup : crosstab.getColumnGroups()) {
            style = dRICrosstabColumnGroup == firstColumnGroup ? grandTotalStyle : groupTotalStyle;
            if (!this.accessor.getTemplateTransform().isCrosstabColumnGroupShowTotal(dRICrosstabColumnGroup)) continue;
            designCell = this.cell(crosstab, style, measuresStyle, null, dRICrosstabColumnGroup, resetType, resetGroup);
            designCrosstab.getCells().add(designCell);
        }
        for (DRICrosstabRowGroup dRICrosstabRowGroup : crosstab.getRowGroups()) {
            style = dRICrosstabRowGroup == firstRowGroup ? grandTotalStyle : groupTotalStyle;
            if (!this.accessor.getTemplateTransform().isCrosstabRowGroupShowTotal(dRICrosstabRowGroup)) continue;
            designCell = this.cell(crosstab, style, measuresStyle, dRICrosstabRowGroup, null, resetType, resetGroup);
            designCrosstab.getCells().add(designCell);
            for (DRICrosstabColumnGroup<?> columnGroup : crosstab.getColumnGroups()) {
                if (!this.accessor.getTemplateTransform().isCrosstabColumnGroupShowTotal(columnGroup)) continue;
                DRIReportStyle totalStyle = style;
                if (columnGroup == firstColumnGroup) {
                    totalStyle = grandTotalStyle;
                }
                designCell = this.cell(crosstab, totalStyle, measuresStyle, dRICrosstabRowGroup, columnGroup, resetType, resetGroup);
                designCrosstab.getCells().add(designCell);
            }
        }
    }

    private <T> T getFirstValue(List<T> values) {
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    private <T> T getLastValue(List<T> values) {
        if (!values.isEmpty()) {
            return values.get(values.size() - 1);
        }
        return null;
    }

    private DRIReportStyle getCellStyle(DRIReportStyle reportStyle) throws DRException {
        DRIStyle style = this.accessor.getStyleTransform().getStyle(reportStyle);
        if (style == null || style.getBackgroundColor() == null) {
            return null;
        }
        DRStyle cellStyle = new DRStyle();
        cellStyle.setBackgroundColor(style.getBackgroundColor());
        return cellStyle;
    }

    private DRIReportStyle cellStyle(DRICrosstab crosstab, List<DRIConditionalStyle> rowHighlighters, DRIReportStyle reportStyle) throws DRException {
        DRIStyle style = this.accessor.getStyleTransform().getStyle(reportStyle);
        if (rowHighlighters != null && !rowHighlighters.isEmpty() || !style.getConditionalStyles().isEmpty()) {
            DRConditionalStyle newConditionalStyle;
            DRStyle newStyle = new DRStyle();
            if (style != null) {
                newStyle.setParentStyle(style);
                for (DRIConditionalStyle dRIConditionalStyle : style.getConditionalStyles()) {
                    DRIExpression<Boolean> conditionalStyleExpression = this.getCrosstabExpression(crosstab, dRIConditionalStyle.getConditionExpression());
                    newConditionalStyle = new DRConditionalStyle(conditionalStyleExpression);
                    this.accessor.getStyleTransform().copyStyle(newConditionalStyle, dRIConditionalStyle);
                    newStyle.addConditionalStyle(newConditionalStyle);
                }
            }
            if (rowHighlighters != null && !rowHighlighters.isEmpty()) {
                Color color = StyleResolver.getBackgroundColor(style, this.accessor.getStyleTransform());
                for (DRIConditionalStyle conditionalStyle : rowHighlighters) {
                    if (color != null) {
                        newConditionalStyle = new DRConditionalStyle(conditionalStyle.getConditionExpression());
                        this.accessor.getStyleTransform().copyStyle(newConditionalStyle, conditionalStyle);
                        Color mergedColor = StyleResolver.mergeColors(color, conditionalStyle.getBackgroundColor(), 0.25f);
                        newConditionalStyle.setBackgroundColor(mergedColor);
                        newStyle.addConditionalStyle(newConditionalStyle);
                        continue;
                    }
                    newStyle.addConditionalStyle((DRConditionalStyle)conditionalStyle);
                }
            }
            return newStyle;
        }
        return style;
    }

    private DRDesignCrosstabCell cell(DRICrosstab crosstab, DRIReportStyle cellStyle, MeasuresStyles measuresStyle, DRICrosstabRowGroup<?> rowGroup, DRICrosstabColumnGroup<?> columnGroup, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRDesignCrosstabCell designCell = new DRDesignCrosstabCell();
        String rowTotalGroup = null;
        String columnTotalGroup = null;
        if (rowGroup != null) {
            rowTotalGroup = rowGroup.getName();
        }
        if (columnGroup != null) {
            columnTotalGroup = columnGroup.getName();
        }
        designCell.setRowTotalGroup(rowTotalGroup);
        designCell.setColumnTotalGroup(columnTotalGroup);
        DRDesignList designList = new DRDesignList();
        designList.setStretchType(StretchType.RELATIVE_TO_BAND_HEIGHT);
        for (DRICrosstabMeasure<?> measure : crosstab.getMeasures()) {
            DRTextField textField = new DRTextField();
            if (measure.getExpression() instanceof DRICrosstabVariable) {
                textField.setValueExpression(measure.getExpression());
            } else {
                DRIExpression<?> valueExpression = this.getCrosstabExpression(crosstab, measure.getExpression());
                textField.setValueExpression(valueExpression);
            }
            textField.setPattern(measure.getPattern());
            textField.setHorizontalAlignment(measure.getHorizontalAlignment());
            textField.setValueFormatter(measure.getValueFormatter());
            textField.setDataType(measure.getDataType());
            textField.setStretchWithOverflow(measure.getStretchWithOverflow());
            textField.setStretchType(StretchType.RELATIVE_TO_BAND_HEIGHT);
            textField.setHyperLink((DRHyperLink)measure.getHyperLink());
            textField.setStyle(measuresStyle.getStyle(measure, rowGroup, columnGroup));
            DRDesignTextField designTextField = this.accessor.getComponentTransform().textField(textField, DefaultStyleType.TEXT);
            String name = "cell_measure[" + measure.getName() + "]";
            if (rowTotalGroup != null) {
                name = String.valueOf(name) + "_rowgroup[" + rowTotalGroup + "]";
            }
            if (columnTotalGroup != null) {
                name = String.valueOf(name) + "_columngroup[" + columnTotalGroup + "]";
            }
            designTextField.setUniqueName(name);
            designList.addComponent(designTextField);
        }
        DRDesignCrosstabCellContent content = this.createCellContent(cellStyle, resetType, resetGroup);
        designCell.setContent(content);
        content.getList().addComponent(designList);
        return designCell;
    }

    private DRConditionalStyle detailRowConditionalStyle(DRISimpleStyle style, DRISimpleExpression<Boolean> expression) {
        DRConditionalStyle conditionalStyle = new DRConditionalStyle(expression);
        this.accessor.getStyleTransform().copyStyle(conditionalStyle, style);
        return conditionalStyle;
    }

    private boolean equalsGroup(DRICrosstabGroup<?> group1, DRICrosstabGroup<?> group2) {
        if (group1 == null && group2 == null) {
            return true;
        }
        if (group1 != null && group2 != null) {
            return group1.equals(group2);
        }
        return false;
    }

    private DRDesignCrosstabCellContent createCellContent(DRIReportStyle style, ResetType resetType, DRDesignGroup resetGroup) throws DRException {
        DRCrosstabCellContent cellContent = new DRCrosstabCellContent();
        cellContent.setStyle(style);
        return this.cellContent(cellContent, resetType, resetGroup);
    }

    private void addMeasure(DRDesignCrosstab designCrosstab, DRICrosstabVariable<?> variable) throws DRException {
        DRDesignCrosstabMeasure designMeasure = new DRDesignCrosstabMeasure();
        designMeasure.setName(variable.getName());
        CrosstabMeasureExpression expression = variable.getPercentageType() != null && variable.getPercentageType().equals((Object)CrosstabPercentageType.GRAND_TOTAL) && !variable.getCalculation().equals((Object)Calculation.COUNT) && !variable.getCalculation().equals((Object)Calculation.DISTINCT_COUNT) ? new CrosstabMeasureExpression(variable.getValueExpression()) : variable.getValueExpression();
        designMeasure.setValueExpression(this.accessor.getExpressionTransform().transformExpression(expression));
        designMeasure.setCalculation(variable.getCalculation());
        designMeasure.setPercentageType(this.accessor.getTemplateTransform().getCrosstabPercentageType(variable));
        designCrosstab.getMeasures().add(designMeasure);
    }

    protected DRICrosstab getCrosstab(DRDesignCrosstab designCrosstab) {
        return this.crosstabs.get(designCrosstab);
    }

    private <T> DRIExpression<T> getCrosstabExpression(DRICrosstab crosstab, DRIExpression<T> expression) throws DRException {
        if (expression instanceof DRIJasperExpression) {
            return expression;
        }
        return new CrosstabExpression<T>(crosstab, expression);
    }

    private class CrosstabExpression<T>
    extends AbstractComplexExpression<T> {
        private static final long serialVersionUID = 1L;
        private DRIExpression<T> expression;

        public CrosstabExpression(DRICrosstab crosstab, DRIExpression<T> expression) throws DRException {
            this.expression = expression;
            CrosstabTransform.this.accessor.getExpressionTransform().transformExpression(expression);
            if (expression instanceof DRIComplexExpression) {
                for (DRIExpression<?> dRIExpression : ((DRIComplexExpression)expression).getExpressions()) {
                    this.addExpression(dRIExpression);
                }
            }
            for (DRICrosstabVariable dRICrosstabVariable : crosstab.getVariables()) {
                this.addExpression(dRICrosstabVariable);
            }
            for (DRICrosstabMeasure dRICrosstabMeasure : crosstab.getMeasures()) {
                if (!(dRICrosstabMeasure.getExpression() instanceof DRICrosstabVariable)) continue;
                this.addExpression(dRICrosstabMeasure.getExpression());
            }
        }

        @Override
        public T evaluate(List<?> values, ReportParameters reportParameters) {
            DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
            int i = 0;
            while (i < this.getExpressions().size()) {
                customValues.setSystemValue(this.getExpressions().get(i).getName(), values.get(i));
                ++i;
            }
            if (this.expression instanceof DRIComplexExpression) {
                DRIComplexExpression express = (DRIComplexExpression)this.expression;
                return express.evaluate(values, reportParameters);
            }
            return reportParameters.getValue(this.expression.getName());
        }

        @Override
        public Class getValueClass() {
            return this.expression.getValueClass();
        }
    }

    private class CrosstabMeasureExpression
    extends AbstractComplexExpression<Double> {
        private static final long serialVersionUID = 1L;

        public CrosstabMeasureExpression(DRIExpression<?> expression) {
            this.addExpression(expression);
        }

        @Override
        public Double evaluate(List<?> values, ReportParameters reportParameters) {
            Number value = (Number)values.get(0);
            if (value != null) {
                return value.doubleValue();
            }
            return null;
        }
    }

    private class CrosstabPrintInEvenRow
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 1L;

        private CrosstabPrintInEvenRow() {
        }

        @Override
        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getCrosstabRowNumber() % 2 == 0) {
                return true;
            }
            return false;
        }
    }

    private class CrosstabPrintInOddRow
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 1L;

        private CrosstabPrintInOddRow() {
        }

        @Override
        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getCrosstabRowNumber() % 2 != 0) {
                return true;
            }
            return false;
        }
    }

    private class CrosstabRowCount
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 1L;

        private CrosstabRowCount() {
        }

        @Override
        public Boolean evaluate(ReportParameters reportParameters) {
            CrosstabRowCounter counter = (CrosstabRowCounter)reportParameters.getValue("CROSSTAB_ROW_NUMBER");
            counter.increment();
            return false;
        }
    }

    public class CrosstabRowCounter
    extends AbstractSimpleExpression<CrosstabRowCounter> {
        private static final long serialVersionUID = 1L;
        private int rowNumber = 1;

        @Override
        public CrosstabRowCounter evaluate(ReportParameters reportParameters) {
            return this;
        }

        private void increment() {
            ++this.rowNumber;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        @Override
        public String getName() {
            return "CROSSTAB_ROW_NUMBER";
        }
    }

    private class MeasuresStyles {
        private Map<DRICrosstabMeasure<?>, List<DRICrosstabCellStyle>> measuresStyle = new HashMap();
        private DRIReportStyle defaultCellStyle;
        private DRIReportStyle defaultGroupTotalStyle;
        private DRIReportStyle defaultGrandTotalStyle;
        private DRIReportStyle defaultRowGroupTotalStyle;
        private DRIReportStyle defaultRowGrandTotalStyle;
        private DRICrosstabGroup<?> firstColumnGroup;
        private DRICrosstabGroup<?> firstRowGroup;

        private MeasuresStyles(DRICrosstab crosstab, DRDesignCrosstab designCrosstab) throws DRException {
            this.init(crosstab, designCrosstab);
        }

        private void init(DRICrosstab crosstab, DRDesignCrosstab designCrosstab) throws DRException {
            ArrayList<DRConditionalStyle> rowHighlighters = new ArrayList<DRConditionalStyle>();
            DRISimpleStyle detailOddRowStyle = CrosstabTransform.this.accessor.getTemplateTransform().getCrosstabOddRowStyle(crosstab);
            DRISimpleStyle detailEvenRowStyle = CrosstabTransform.this.accessor.getTemplateTransform().getCrosstabEvenRowStyle(crosstab);
            if (detailOddRowStyle != null || detailEvenRowStyle != null) {
                if (detailOddRowStyle != null) {
                    rowHighlighters.add(CrosstabTransform.this.detailRowConditionalStyle(detailOddRowStyle, new CrosstabPrintInOddRow()));
                }
                if (detailEvenRowStyle != null) {
                    rowHighlighters.add(CrosstabTransform.this.detailRowConditionalStyle(detailEvenRowStyle, new CrosstabPrintInEvenRow()));
                }
            }
            for (DRICrosstabMeasure<?> measure : crosstab.getMeasures()) {
                ArrayList<DRCrosstabCellStyle> styles = new ArrayList<DRCrosstabCellStyle>();
                this.measuresStyle.put(measure, styles);
                for (DRICrosstabCellStyle cellStyle : measure.getStyles()) {
                    DRIReportStyle newStyle = CrosstabTransform.this.cellStyle(crosstab, rowHighlighters, cellStyle.getStyle());
                    styles.add(new DRCrosstabCellStyle(newStyle, cellStyle.getRowGroup(), cellStyle.getColumnGroup()));
                }
            }
            DRIReportStyle groupTotalStyle = CrosstabTransform.this.accessor.getTemplateTransform().getCrosstabGroupTotalStyle(crosstab);
            DRIReportStyle grandTotalStyle = CrosstabTransform.this.accessor.getTemplateTransform().getCrosstabGrandTotalStyle(crosstab);
            DRIReportStyle cellStyle = CrosstabTransform.this.accessor.getTemplateTransform().getCrosstabCellStyle(crosstab);
            if (groupTotalStyle == null) {
                groupTotalStyle = cellStyle;
            }
            if (grandTotalStyle == null) {
                grandTotalStyle = cellStyle;
            }
            this.defaultGroupTotalStyle = CrosstabTransform.this.cellStyle(crosstab, rowHighlighters, groupTotalStyle);
            this.defaultGrandTotalStyle = CrosstabTransform.this.cellStyle(crosstab, rowHighlighters, grandTotalStyle);
            if (StyleResolver.getBackgroundColor(groupTotalStyle, CrosstabTransform.this.accessor.getStyleTransform()) != null) {
                this.defaultRowGroupTotalStyle = CrosstabTransform.this.cellStyle(crosstab, null, groupTotalStyle);
            }
            if (StyleResolver.getBackgroundColor(grandTotalStyle, CrosstabTransform.this.accessor.getStyleTransform()) != null) {
                this.defaultRowGrandTotalStyle = CrosstabTransform.this.cellStyle(crosstab, null, grandTotalStyle);
            }
            this.defaultCellStyle = CrosstabTransform.this.cellStyle(crosstab, rowHighlighters, cellStyle);
            this.firstColumnGroup = (DRICrosstabGroup)CrosstabTransform.this.getFirstValue(crosstab.getColumnGroups());
            this.firstRowGroup = (DRICrosstabGroup)CrosstabTransform.this.getFirstValue(crosstab.getRowGroups());
        }

        public DRIReportStyle getStyle(DRICrosstabMeasure<?> measure, DRICrosstabRowGroup<?> rowGroup, DRICrosstabColumnGroup<?> columnGroup) {
            List<DRICrosstabCellStyle> styles = this.measuresStyle.get(measure);
            for (DRICrosstabCellStyle crosstabCellStyle : styles) {
                if (!CrosstabTransform.this.equalsGroup(rowGroup, crosstabCellStyle.getRowGroup()) || !CrosstabTransform.this.equalsGroup(columnGroup, crosstabCellStyle.getColumnGroup())) continue;
                return crosstabCellStyle.getStyle();
            }
            for (DRICrosstabCellStyle crosstabCellStyle : styles) {
                if (crosstabCellStyle.getRowGroup() != null || crosstabCellStyle.getColumnGroup() != null) continue;
                return crosstabCellStyle.getStyle();
            }
            if (rowGroup == null && columnGroup == null) {
                return this.defaultCellStyle;
            }
            if (rowGroup != null) {
                if ((columnGroup == this.firstColumnGroup || rowGroup == this.firstRowGroup) && this.defaultRowGrandTotalStyle != null) {
                    return this.defaultRowGrandTotalStyle;
                }
                if (this.defaultRowGroupTotalStyle != null) {
                    return this.defaultRowGroupTotalStyle;
                }
            }
            if (columnGroup == this.firstColumnGroup || rowGroup == this.firstRowGroup) {
                return this.defaultGrandTotalStyle;
            }
            return this.defaultGroupTotalStyle;
        }
    }
}

