/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignBand;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignTableOfContentsHeading;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.HorizontalCellComponentAlignment;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.definition.DRIBand;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.column.DRIValueColumn;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.exception.DRException;

public class GroupTransform {
    private DesignTransformAccessor accessor;
    private List<? extends DRIGroup> groups;
    private Map<DRIGroup, DRDesignGroup> designGroups;
    private List<DRIValueColumn<?>> hideGroupColumns;
    private DRIGroup firstResetPageNumberGroup;
    private int groupPadding;

    public GroupTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.init();
    }

    private void init() {
        DRIReport report = this.accessor.getReport();
        this.groups = report.getGroups();
        this.designGroups = new LinkedHashMap<DRIGroup, DRDesignGroup>();
        this.hideGroupColumns = new ArrayList();
        this.groupPadding = 0;
    }

    public void transform() throws DRException {
        for (DRIGroup dRIGroup : this.groups) {
            DRDesignGroup designGroup = this.group(dRIGroup);
            this.addGroup(dRIGroup, designGroup);
        }
    }

    private void addGroup(DRIGroup group, DRDesignGroup designGroup) {
        if (this.accessor.getTemplateTransform().isGroupHideColumn(group) && group.getValueField().getValueExpression() instanceof DRIValueColumn) {
            this.hideGroupColumns.add((DRIValueColumn)group.getValueField().getValueExpression());
        }
        this.designGroups.put(group, designGroup);
        if (this.firstResetPageNumberGroup == null && designGroup.isResetPageNumber()) {
            this.firstResetPageNumberGroup = group;
        }
        this.groupPadding += this.accessor.getTemplateTransform().getGroupPadding(group);
    }

    public void transformHeaderAndFooter() throws DRException {
        int groupPadding = 0;
        int level = 0;
        for (DRIGroup dRIGroup : this.groups) {
            this.headerAndFooter(dRIGroup, this.designGroups.get(dRIGroup), groupPadding, level++);
            groupPadding += this.accessor.getTemplateTransform().getGroupPadding(dRIGroup);
        }
    }

    private void headerAndFooter(DRIGroup group, DRDesignGroup designGroup, int groupPadding, int level) throws DRException {
        DRDesignList header = new DRDesignList();
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        DRDesignTableOfContentsHeading designTocHeading = this.accessor.getTableOfContentsTransform().groupHeading(group, level);
        if (designTocHeading != null) {
            header.addComponent(designTocHeading.getReferenceField());
        }
        switch (templateTransform.getGroupHeaderLayout(group)) {
            case EMPTY: {
                break;
            }
            case TITLE_AND_VALUE: {
                if (groupPadding > 0) {
                    DRDesignFiller filler = new DRDesignFiller();
                    filler.setWidth(groupPadding);
                    filler.setHeight(0);
                    header.addComponent(HorizontalCellComponentAlignment.CENTER, null, filler);
                }
                header.addComponent(HorizontalCellComponentAlignment.LEFT, null, this.titleComponent(group));
                DRDesignTextField valueComponent = this.valueComponent(group);
                header.addComponent(valueComponent);
                if (designTocHeading == null) break;
                valueComponent.setAnchorNameExpression(designTocHeading.getReferenceField().getAnchorNameExpression());
                valueComponent.setBookmarkLevel(designTocHeading.getReferenceField().getBookmarkLevel());
                valueComponent.setHyperLink(designTocHeading.getReferenceField().getHyperLink());
                break;
            }
            case VALUE: {
                if (groupPadding > 0) {
                    DRDesignFiller filler = new DRDesignFiller();
                    filler.setWidth(groupPadding);
                    filler.setHeight(0);
                    header.addComponent(HorizontalCellComponentAlignment.CENTER, null, filler);
                }
                DRDesignTextField valueComponent = this.valueComponent(group);
                header.addComponent(valueComponent);
                if (designTocHeading == null) break;
                valueComponent.setAnchorNameExpression(designTocHeading.getReferenceField().getAnchorNameExpression());
                valueComponent.setBookmarkLevel(designTocHeading.getReferenceField().getBookmarkLevel());
                valueComponent.setHyperLink(designTocHeading.getReferenceField().getHyperLink());
                break;
            }
            default: {
                throw new DRDesignReportException("Group header layout " + templateTransform.getGroupHeaderLayout(group).name() + " not supported");
            }
        }
        if (!header.isEmpty()) {
            DRIBand bnd = group.getHeaderBand();
            DRDesignBand band = this.accessor.getBandTransform().band("groupHeaderTitleAndValue", bnd, templateTransform.getGroupHeaderSplitType(bnd), templateTransform.getGroupHeaderStyle(bnd), templateTransform.getGroupHeaderBackgroundComponent(bnd));
            band.addComponent(header);
            designGroup.addHeaderBand(band);
        }
        DRIBand band = group.getHeaderBand();
        designGroup.addHeaderBand(this.groupBand("groupHeader", band, templateTransform.getGroupHeaderSplitType(band), templateTransform.getGroupHeaderStyle(band), templateTransform.getGroupHeaderBackgroundComponent(band), groupPadding, designGroup));
        band = group.getFooterBand();
        designGroup.addFooterBand(this.groupBand("groupFooter", band, templateTransform.getGroupFooterSplitType(band), templateTransform.getGroupFooterStyle(band), templateTransform.getGroupFooterBackgroundComponent(band), groupPadding, designGroup));
        if (templateTransform.isGroupShowColumnHeaderAndFooter(group)) {
            designGroup.addHeaderBand(this.accessor.getBandTransform().getColumnHeaderForGroupBand());
            designGroup.addFooterBand(this.accessor.getBandTransform().getColumnFooterBand());
        }
    }

    private DRDesignBand groupBand(String name, DRIBand band, SplitType splitType, DRIReportStyle defaultStyle, DRIComponent defaultBackgroundComponent, int groupPadding, DRDesignGroup resetGroup) throws DRException {
        DRDesignBand designBand = this.accessor.getBandTransform().band(name, band, splitType, defaultStyle, defaultBackgroundComponent, ResetType.GROUP, resetGroup);
        if (groupPadding > 0) {
            DRDesignFiller filler = new DRDesignFiller();
            filler.setWidth(groupPadding);
            filler.setHeight(0);
            DRDesignList list = new DRDesignList();
            list.addComponent(HorizontalCellComponentAlignment.CENTER, null, filler);
            list.addComponent(designBand.getList());
            designBand.setList(list);
        }
        return designBand;
    }

    private DRDesignComponent titleComponent(DRIGroup group) throws DRException {
        DRTextField titleField = new DRTextField();
        titleField.setValueExpression(group.getTitleExpression());
        titleField.setStyle(group.getTitleStyle());
        titleField.setWidth(group.getTitleWidth());
        DRDesignTextField designTitleField = this.accessor.getComponentTransform().textField(titleField, DefaultStyleType.GROUP_TITLE);
        designTitleField.setUniqueName("group_" + group.getName() + ".title");
        return designTitleField;
    }

    private DRDesignTextField valueComponent(DRIGroup group) throws DRException {
        DRDesignTextField designValueField = this.accessor.getComponentTransform().textField(group.getValueField(), DefaultStyleType.GROUP);
        designValueField.setUniqueName("group_" + group.getName());
        return designValueField;
    }

    private DRDesignGroup group(DRIGroup group) throws DRException {
        TemplateTransform templateTransform = this.accessor.getTemplateTransform();
        DRDesignGroup designGroup = new DRDesignGroup(group.getName());
        designGroup.setStartInNewPage(templateTransform.isGroupStartInNewPage(group));
        designGroup.setStartInNewColumn(templateTransform.isGroupStartInNewColumn(group));
        designGroup.setReprintHeaderOnEachPage(templateTransform.isGroupReprintHeaderOnEachPage(group));
        designGroup.setResetPageNumber(templateTransform.isGroupResetPageNumber(group));
        designGroup.setMinHeightToStartNewPage(templateTransform.getGroupMinHeightToStartNewPage(group));
        designGroup.setFooterPosition(templateTransform.getGroupFooterPosition(group));
        designGroup.setKeepTogether(templateTransform.isGroupKeepTogether(group));
        designGroup.setHeaderWithSubtotal(templateTransform.isGroupHeaderWithSubtotal(group));
        GroupByDataTypeExpression groupExpression = group.getValueField().getValueExpression();
        if (templateTransform.isGroupByDataType(group) && group.getValueField().getDataType() != null) {
            this.accessor.getExpressionTransform().transformExpression(groupExpression);
            DRIDataType<?, ?> dataType = group.getValueField().getDataType();
            groupExpression = new GroupByDataTypeExpression(groupExpression, dataType);
        }
        groupExpression = new DRVariable(groupExpression, Calculation.NOTHING);
        designGroup.setGroupExpression(this.accessor.getExpressionTransform().transformExpression(groupExpression));
        return designGroup;
    }

    protected DRDesignGroup getGroup(DRIGroup group) {
        return this.designGroups.get(group);
    }

    protected DRIGroup getFirstGroup() {
        if (!this.groups.isEmpty()) {
            return this.groups.get(0);
        }
        return null;
    }

    protected DRIGroup getBeforeGroup(DRIGroup group) {
        if (this.groups.size() > 1 && this.groups.indexOf(group) > 0) {
            return this.groups.get(this.groups.indexOf(group) - 1);
        }
        return null;
    }

    protected DRIGroup getLastGroup() {
        if (!this.groups.isEmpty()) {
            return this.groups.get(this.groups.size() - 1);
        }
        return null;
    }

    protected DRIGroup getFirstResetPageNumberGroup() {
        return this.firstResetPageNumberGroup;
    }

    protected int getGroupPadding() {
        return this.groupPadding;
    }

    protected List<DRIValueColumn<?>> getHideGroupColumns() {
        return this.hideGroupColumns;
    }

    public Collection<DRDesignGroup> getGroups() {
        return this.designGroups.values();
    }

    private class GroupByDataTypeExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 10000L;
        private DRIExpression<?> valueExpression;
        DRIDataType<?, ?> dataType;

        public GroupByDataTypeExpression(DRIExpression<?> valueExpression, DRIDataType<?, ?> dataType) {
            this.valueExpression = valueExpression;
            this.dataType = dataType;
        }

        @Override
        public String evaluate(ReportParameters reportParameters) {
            return this.dataType.valueToString(this.valueExpression.getName(), reportParameters);
        }
    }
}

