/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import net.sf.dynamicreports.design.base.style.DRDesignStyle;
import net.sf.dynamicreports.design.definition.style.DRIDesignStyle;
import net.sf.dynamicreports.design.transformation.StyleTransform;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.definition.style.DRIStyle;

public class StyleResolver {
    private static FontRenderContext context = new BufferedImage(1, 1, 1).createGraphics().getFontRenderContext();

    protected static int getFontWidth(DRDesignStyle style, int columns) {
        double width = StyleResolver.getFont(style).getStringBounds("m", context).getWidth();
        return (int)Math.ceil(width * (double)columns) + StyleResolver.getHorizontalPadding(style);
    }

    protected static int getFontHeight(DRDesignStyle style, int rows) {
        double height = StyleResolver.getFont(style).getMaxCharBounds(context).getHeight();
        return (int)Math.ceil(height * (double)rows) + StyleResolver.getVerticalPadding(style);
    }

    public static double getFontWidth(DRFont font) {
        Font fnt = StyleResolver.getFont(font.getFontName(), font.getBold(), font.getItalic(), font.getFontSize());
        return fnt.getStringBounds("m", context).getWidth();
    }

    public static double getFontHeight(DRFont font) {
        Font fnt = StyleResolver.getFont(font.getFontName(), font.getBold(), font.getItalic(), font.getFontSize());
        return fnt.getMaxCharBounds(context).getHeight();
    }

    private static Font getFont(DRDesignStyle style) {
        String fontName = StyleResolver.getFontName(style);
        Integer fontSize = StyleResolver.getFontSize(style);
        Boolean bold = StyleResolver.getFontBold(style);
        Boolean italic = StyleResolver.getFontItalic(style);
        return StyleResolver.getFont(fontName, bold, italic, fontSize);
    }

    private static Font getFont(String fontName, Boolean bold, Boolean italic, Integer fontSize) {
        if (bold == null) {
            bold = false;
        }
        if (italic == null) {
            italic = false;
        }
        int fontStyle = bold != false && italic != false ? 3 : (bold != false ? 1 : (italic != false ? 2 : 0));
        return new Font(fontName, fontStyle, fontSize);
    }

    protected static String getFontName(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getFontName() != null) {
            return style.getFont().getFontName();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontName(style.getParentStyle());
        }
        return null;
    }

    protected static Integer getFontSize(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getFontSize() != null) {
            return style.getFont().getFontSize();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontSize(style.getParentStyle());
        }
        return null;
    }

    protected static Boolean getFontBold(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getBold() != null) {
            return style.getFont().getBold();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontBold(style.getParentStyle());
        }
        return null;
    }

    protected static Boolean getFontItalic(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getItalic() != null) {
            return style.getFont().getItalic();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontItalic(style.getParentStyle());
        }
        return null;
    }

    protected static Boolean getFontUnderline(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getUnderline() != null) {
            return style.getFont().getUnderline();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontUnderline(style.getParentStyle());
        }
        return null;
    }

    protected static Boolean getFontStrikeThrough(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getStrikeThrough() != null) {
            return style.getFont().getStrikeThrough();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFontStrikeThrough(style.getParentStyle());
        }
        return null;
    }

    protected static String getPdfFontName(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getPdfFontName() != null) {
            return style.getFont().getPdfFontName();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getPdfFontName(style.getParentStyle());
        }
        return null;
    }

    protected static String getPdfEncoding(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getPdfEncoding() != null) {
            return style.getFont().getPdfEncoding();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getPdfEncoding(style.getParentStyle());
        }
        return null;
    }

    protected static Boolean getPdfEmbedded(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getFont().getPdfEmbedded() != null) {
            return style.getFont().getPdfEmbedded();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getPdfEmbedded(style.getParentStyle());
        }
        return null;
    }

    public static int getHorizontalPadding(DRIDesignStyle style) {
        return StyleResolver.getLeftPadding(style) + StyleResolver.getRightPadding(style) + StyleResolver.getLeftIndent(style) + StyleResolver.getRightIndent(style);
    }

    public static int getVerticalPadding(DRIDesignStyle style) {
        return StyleResolver.getTopPadding(style) + StyleResolver.getBottomPadding(style) + StyleResolver.getFirstLineIndent(style);
    }

    private static Integer getTopPadding(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getPadding() != null && style.getPadding().getTop() != null) {
            return style.getPadding().getTop();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getTopPadding(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getBottomPadding(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getPadding() != null && style.getPadding().getBottom() != null) {
            return style.getPadding().getBottom();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getBottomPadding(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getLeftPadding(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getPadding() != null && style.getPadding().getLeft() != null) {
            return style.getPadding().getLeft();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getLeftPadding(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getRightPadding(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getPadding() != null && style.getPadding().getRight() != null) {
            return style.getPadding().getRight();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getRightPadding(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getFirstLineIndent(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getParagraph() != null && style.getParagraph().getFirstLineIndent() != null) {
            return style.getParagraph().getFirstLineIndent();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getFirstLineIndent(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getLeftIndent(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getParagraph() != null && style.getParagraph().getLeftIndent() != null) {
            return style.getParagraph().getLeftIndent();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getLeftIndent(style.getParentStyle());
        }
        return 0;
    }

    private static Integer getRightIndent(DRIDesignStyle style) {
        if (style == null) {
            return 0;
        }
        if (style.getParagraph() != null && style.getParagraph().getRightIndent() != null) {
            return style.getParagraph().getRightIndent();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getRightIndent(style.getParentStyle());
        }
        return 0;
    }

    public static String getPattern(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getPattern() != null) {
            return style.getPattern();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getPattern(style.getParentStyle());
        }
        return null;
    }

    public static HorizontalAlignment getHorizontalAlignment(DRDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (style.getHorizontalAlignment() != null) {
            return style.getHorizontalAlignment();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getHorizontalAlignment(style.getParentStyle());
        }
        return null;
    }

    public static Color getBackgroundColor(DRIReportStyle reportStyle, StyleTransform transform) {
        if (reportStyle == null) {
            return null;
        }
        DRIStyle style = transform.getStyle(reportStyle);
        if (style.getBackgroundColor() != null) {
            return style.getBackgroundColor();
        }
        if (style.getParentStyle() != null) {
            return StyleResolver.getBackgroundColor(style.getParentStyle(), transform);
        }
        return null;
    }

    public static Color mergeColors(Color color1, Color color2, float percent) {
        float amount = 1.0f - percent;
        int r = (int)((float)color1.getRed() * amount + (float)color2.getRed() * percent);
        int g = (int)((float)color1.getGreen() * amount + (float)color2.getGreen() * percent);
        int b = (int)((float)color1.getBlue() * amount + (float)color2.getBlue() * percent);
        int a = (int)((float)color1.getAlpha() * amount + (float)color2.getAlpha() * percent);
        return new Color(r, g, b, a);
    }
}

