/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignTableOfContentsHeading;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.constant.DefaultStyleType;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.DRITableOfContentsHeading;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import net.sf.dynamicreports.report.definition.component.DRIHyperLinkComponent;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class TableOfContentsTransform {
    private DesignTransformAccessor accessor;
    private Map<DRITableOfContentsHeading, Integer> levels;

    public TableOfContentsTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.levels = new HashMap<DRITableOfContentsHeading, Integer>();
    }

    protected DRDesignTableOfContentsHeading componentHeading(DRIComponent component) throws DRException {
        DRITableOfContentsHeading tocHeading = component.getTableOfContentsHeading();
        boolean tableOfContents = this.accessor.isTableOfContents();
        if (tableOfContents && tocHeading != null) {
            DRTextField<String> referenceField = new DRTextField<String>();
            int level = this.getLevel(tocHeading);
            DRIExpression<String> labelExpression = tocHeading.getLabelExpression();
            if (labelExpression == null && component instanceof DRITextField) {
                labelExpression = ((DRITextField)component).getValueExpression();
            }
            if (labelExpression == null) {
                labelExpression = Expressions.text("");
            }
            String expressionName = labelExpression.getName();
            DRIExpression<String> anchorNameExpression = null;
            if (component instanceof DRIHyperLinkComponent) {
                anchorNameExpression = ((DRIHyperLinkComponent)component).getAnchorNameExpression();
            }
            referenceField.setValueExpression(new TocReferenceExpression(level, expressionName, labelExpression, anchorNameExpression));
            referenceField.setAnchorNameExpression(new TocReferenceLinkExpression(expressionName, anchorNameExpression));
            DRDesignTextField designReferenceField = this.accessor.getComponentTransform().textField(referenceField, DefaultStyleType.TEXT);
            designReferenceField.setWidth(1);
            designReferenceField.setHeight(1);
            designReferenceField.setUniqueName(String.valueOf(expressionName) + ".tocReference");
            DRDesignTableOfContentsHeading designTocHeading = new DRDesignTableOfContentsHeading();
            designTocHeading.setReferenceField(designReferenceField);
            return designTocHeading;
        }
        return null;
    }

    private int getLevel(DRITableOfContentsHeading tocHeading) {
        if (this.levels.containsKey(tocHeading)) {
            return this.levels.get(tocHeading);
        }
        int level = 0;
        if (tocHeading.getParentHeading() != null) {
            level = this.getLevel(tocHeading.getParentHeading()) + 1;
        }
        this.levels.put(tocHeading, level);
        return level;
    }

    protected DRDesignTableOfContentsHeading groupHeading(DRIGroup group, int level) throws DRException {
        boolean tableOfContents = this.accessor.isTableOfContents();
        boolean isAddGroupToTableOfContents = this.accessor.getTemplateTransform().isAddGroupToTableOfContents(group);
        if (tableOfContents && isAddGroupToTableOfContents) {
            DRTextField<String> referenceField = new DRTextField<String>();
            DRITextField<?> valueField = group.getValueField();
            referenceField.setValueExpression(new TocReferenceExpression(level, group.getName(), valueField.getValueExpression(), valueField.getAnchorNameExpression()));
            referenceField.setAnchorNameExpression(new TocReferenceLinkExpression(group.getName(), valueField.getAnchorNameExpression()));
            DRDesignTextField designReferenceField = this.accessor.getComponentTransform().textField(referenceField, DefaultStyleType.TEXT);
            designReferenceField.setWidth(0);
            designReferenceField.setHeight(0);
            designReferenceField.setUniqueName("group_" + group.getName() + ".tocReference");
            DRDesignTableOfContentsHeading designTocHeading = new DRDesignTableOfContentsHeading();
            designTocHeading.setReferenceField(designReferenceField);
            return designTocHeading;
        }
        return null;
    }

    private class TocReferenceExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;
        private int level;
        private String expressionName;
        private boolean customId;

        private TocReferenceExpression(int level, String expressionName, DRIExpression<?> labelExpression, DRIExpression<String> anchorNameExpression) {
            this.level = level;
            this.expressionName = expressionName;
            this.customId = anchorNameExpression != null;
            this.addExpression(labelExpression);
            if (anchorNameExpression != null) {
                this.addExpression(anchorNameExpression);
            }
        }

        @Override
        public String evaluate(List<?> values, ReportParameters reportParameters) {
            String id = this.customId ? (String)values.get(1) : String.valueOf(this.expressionName) + "_" + reportParameters.getReportRowNumber();
            DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
            String text = String.valueOf(values.get(0));
            customValues.addTocHeading(this.level, id, text);
            return null;
        }
    }

    private class TocReferenceLinkExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 10000L;
        private String expressionName;
        private boolean customId;

        private TocReferenceLinkExpression(String expressionName, DRIExpression<String> anchorNameExpression) {
            this.expressionName = expressionName;
            boolean bl = this.customId = anchorNameExpression != null;
            if (anchorNameExpression != null) {
                this.addExpression(anchorNameExpression);
            }
        }

        @Override
        public String evaluate(List<?> values, ReportParameters reportParameters) {
            String id = this.customId ? (String)values.get(0) : String.valueOf(this.expressionName) + "_" + reportParameters.getReportRowNumber();
            return id;
        }
    }
}

