/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Color;
import java.awt.Paint;
import java.util.LinkedHashSet;
import java.util.Map;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class SeriesColorsByNameCustomizer
implements DRIChartCustomizer {
    private Map<String, Color> seriesColorsByName;

    public SeriesColorsByNameCustomizer(Map<String, Color> seriesColorsByName) {
        this.seriesColorsByName = seriesColorsByName;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        block9: {
            block8: {
                if (!(chart.getPlot() instanceof CategoryPlot)) break block8;
                CategoryItemRenderer renderer = chart.getCategoryPlot().getRenderer();
                CategoryDataset dataset = chart.getCategoryPlot().getDataset();
                LinkedHashSet<String> legend = new LinkedHashSet<String>();
                int i = 0;
                while (i < dataset.getRowCount()) {
                    String key = (String)((Object)dataset.getRowKey(i));
                    if (renderer instanceof GroupedStackedBarRenderer) {
                        key = StringUtils.substringAfter((String)key, (String)"-{group-series}-");
                        legend.add(key);
                    }
                    renderer.setSeriesPaint(i, (Paint)this.seriesColorsByName.get(key));
                    ++i;
                }
                if (legend.isEmpty()) break block9;
                LegendItemCollection legendItems = new LegendItemCollection();
                for (String item : legend) {
                    legendItems.add(new LegendItem(item, (Paint)this.seriesColorsByName.get(item)));
                }
                chart.getCategoryPlot().setFixedLegendItems(legendItems);
                break block9;
            }
            if (chart.getPlot() instanceof PiePlot) {
                PiePlot plot = (PiePlot)chart.getPlot();
                PieDataset dataset = plot.getDataset();
                int i = 0;
                while (i < dataset.getItemCount()) {
                    String key = (String)((Object)dataset.getKey(i));
                    plot.setSectionPaint((Comparable)((Object)key), (Paint)this.seriesColorsByName.get(key));
                    ++i;
                }
            } else if (chart.getPlot() instanceof XYPlot) {
                XYItemRenderer renderer = chart.getXYPlot().getRenderer();
                XYDataset dataset = chart.getXYPlot().getDataset();
                int i = 0;
                while (i < dataset.getSeriesCount()) {
                    String key = (String)((Object)dataset.getSeriesKey(i));
                    renderer.setSeriesPaint(i, (Paint)this.seriesColorsByName.get(key));
                    ++i;
                }
            }
        }
    }
}

