/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.ui.TextAnchor;

public class ShowValuesCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private String valuePattern;

    public ShowValuesCustomizer(String valuePattern) {
        this.valuePattern = valuePattern;
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        if (chart.getPlot() instanceof CategoryPlot) {
            CategoryItemRenderer renderer = chart.getCategoryPlot().getRenderer();
            if (StringUtils.isBlank((CharSequence)this.valuePattern)) {
                renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            } else {
                renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat(this.valuePattern)));
            }
            renderer.setBaseItemLabelsVisible(Boolean.TRUE);
            chart.getCategoryPlot().getRangeAxis().zoomRange(0.0, 1.1);
            if (renderer.getClass().equals(BarRenderer3D.class)) {
                ((BarRenderer3D)renderer).setItemLabelAnchorOffset(10.0);
                renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT));
            }
        } else if (chart.getPlot() instanceof XYPlot) {
            XYItemRenderer renderer = chart.getXYPlot().getRenderer();
            if (StringUtils.isBlank((CharSequence)this.valuePattern)) {
                renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator());
            } else {
                renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator("{2}", NumberFormat.getNumberInstance(), (NumberFormat)new DecimalFormat(this.valuePattern)));
            }
            renderer.setBaseItemLabelsVisible(Boolean.TRUE);
            chart.getXYPlot().getRangeAxis().zoomRange(0.0, 1.1);
        }
    }
}

