/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.base;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.transformation.CrosstabTransform;
import net.sf.dynamicreports.jasper.base.CustomScriptlet;
import net.sf.dynamicreports.jasper.base.JasperScriptlet;
import net.sf.dynamicreports.jasper.constant.ValueType;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.exception.DRReportException;
import net.sf.jasperreports.engine.JRScriptletException;

public class JasperReportParameters
implements ReportParameters {
    public static final String MASTER_REPORT_PARAMETERS = "MASTER_REPORT_PARAMETERS";
    private JasperScriptlet jasperScriptlet;

    protected JasperReportParameters(JasperScriptlet jasperScriptlet) {
        this.jasperScriptlet = jasperScriptlet;
    }

    @Override
    public <T> T getValue(String name) {
        ValueType type = this.jasperScriptlet.getValueType(name);
        if (type != null) {
            switch (type) {
                case FIELD: {
                    return this.getFieldValue(name);
                }
                case VARIABLE: {
                    return this.getVariableValue(name);
                }
                case PARAMETER: {
                    return this.getParameterValue(name);
                }
                case SIMPLE_EXPRESSION: {
                    return (T)this.getSimpleExpressionValue(name);
                }
                case COMPLEX_EXPRESSION: {
                    return (T)this.getComplexExpressionValue(name);
                }
                case SYSTEM_EXPRESSION: {
                    return (T)this.getSystemExpressionValue(name);
                }
            }
        }
        throw new DRReportException("Value " + name + " not found");
    }

    @Override
    public <T> T getValue(DRIValue<T> value) {
        return this.getValue(value.getName());
    }

    @Override
    public <T> T getFieldValue(String name) {
        try {
            return (T)this.jasperScriptlet.getFieldValue(name);
        }
        catch (JRScriptletException e) {
            throw new DRReportException(e);
        }
    }

    @Override
    public <T> T getVariableValue(String name) {
        try {
            return (T)this.jasperScriptlet.getVariableValue(name);
        }
        catch (JRScriptletException e) {
            throw new DRReportException(e);
        }
    }

    @Override
    public Integer getPageNumber() {
        return (Integer)this.getVariableValue("PAGE_NUMBER");
    }

    @Override
    public Integer getColumnNumber() {
        return (Integer)this.getVariableValue("COLUMN_NUMBER");
    }

    @Override
    public Integer getReportRowNumber() {
        return (Integer)this.getVariableValue("REPORT_COUNT");
    }

    @Override
    public Integer getPageRowNumber() {
        return (Integer)this.getVariableValue("PAGE_COUNT");
    }

    @Override
    public Integer getColumnRowNumber() {
        return (Integer)this.getVariableValue("COLUMN_COUNT");
    }

    @Override
    public Integer getCrosstabRowNumber() {
        CrosstabTransform.CrosstabRowCounter counter = (CrosstabTransform.CrosstabRowCounter)this.getValue("CROSSTAB_ROW_NUMBER");
        if (counter != null) {
            return counter.getRowNumber();
        }
        return 0;
    }

    @Override
    public Integer getGroupCount(String groupName) {
        return (Integer)this.getVariableValue(String.valueOf(groupName) + "_COUNT");
    }

    @Override
    public <T> T getParameterValue(String name) {
        try {
            return (T)((Map)this.jasperScriptlet.getParameterValue("REPORT_PARAMETERS_MAP")).get(name);
        }
        catch (JRScriptletException e) {
            throw new DRReportException(e);
        }
    }

    @Override
    public Connection getConnection() {
        return (Connection)this.getParameterValue("REPORT_CONNECTION");
    }

    @Override
    public Locale getLocale() {
        return (Locale)this.getParameterValue("REPORT_LOCALE");
    }

    @Override
    public DRIScriptlet getScriptlet(String name) {
        return ((CustomScriptlet)((Object)this.getParameterValue(String.valueOf(name) + "_SCRIPTLET"))).getScriptlet();
    }

    @Override
    public String getMessage(String key) {
        return ((ResourceBundle)this.getParameterValue("REPORT_RESOURCE_BUNDLE")).getString(key);
    }

    @Override
    public String getMessage(String key, Object[] arguments) {
        String message = this.getMessage(key);
        if (arguments != null) {
            MessageFormat format = new MessageFormat(message, this.getLocale());
            message = format.format(arguments);
        }
        return message;
    }

    private Object getSimpleExpressionValue(String name) {
        return this.jasperScriptlet.getSimpleExpression(name).evaluate(this);
    }

    private Object getComplexExpressionValue(String name) {
        ArrayList values = new ArrayList();
        DRIDesignComplexExpression complexExpression = this.jasperScriptlet.getComplexExpression(name);
        for (DRIDesignExpression valueExpression : complexExpression.getExpressions()) {
            values.add(this.getValue(valueExpression.getName()));
        }
        return complexExpression.evaluate(values, this);
    }

    private Object getSystemExpressionValue(String name) {
        return this.jasperScriptlet.getSystemValue(name);
    }

    @Override
    public ReportParameters getMasterParameters() {
        return (ReportParameters)this.getParameterValue(MASTER_REPORT_PARAMETERS);
    }
}

