/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.builder;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import net.sf.dynamicreports.jasper.base.export.AbstractJasperExporter;
import net.sf.dynamicreports.jasper.base.reporthandler.JasperReportBuilderHandler;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.AbstractJasperExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.Exporters;
import net.sf.dynamicreports.jasper.builder.export.JasperCsvExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperDocxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperExcelApiXlsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperOdsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperOdtExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPdfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPptxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperRtfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperTextExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXhtmlExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXmlExporterBuilder;
import net.sf.dynamicreports.jasper.definition.JasperReportHandler;
import net.sf.dynamicreports.jasper.definition.export.JasperIExporter;
import net.sf.dynamicreports.jasper.transformation.ExporterTransform;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import org.apache.commons.lang3.Validate;

public class JasperConcatenatedReportBuilder
implements Serializable {
    private static final long serialVersionUID = 10000L;
    private JasperReportHandler jasperReportHandler;

    public JasperConcatenatedReportBuilder() {
        this(new JasperReportBuilderHandler());
    }

    public JasperConcatenatedReportBuilder(JasperReportHandler jasperReportHandler) {
        this.jasperReportHandler = jasperReportHandler;
    }

    public JasperConcatenatedReportBuilder concatenate(JasperReportBuilder ... jasperReportBuilders) {
        Validate.notNull((Object)jasperReportBuilders, (String)"jasperReportBuilders must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])jasperReportBuilders, (String)"jasperReportBuilders must not contains null jasperReportBuilder", (Object[])new Object[0]);
        this.jasperReportHandler.concatenate(jasperReportBuilders);
        return this;
    }

    public JasperConcatenatedReportBuilder toPng(OutputStream outputStream) throws DRException {
        return this.toPng(outputStream, 1.0f);
    }

    public JasperConcatenatedReportBuilder toPng(OutputStream outputStream, float zoom) throws DRException {
        Validate.notNull((Object)outputStream, (String)"outputStream must not be null", (Object[])new Object[0]);
        Validate.isTrue((zoom > 0.0f ? 1 : 0) != 0, (String)"zoom must be > 0", (Object[])new Object[0]);
        int maxWidth = 0;
        int maxHeight = 0;
        for (JasperPrint jasperPrint : this.jasperReportHandler.getPrintList()) {
            int pages = jasperPrint.getPages().size();
            int pageWidth = (int)((float)jasperPrint.getPageWidth() * zoom);
            maxWidth += pageWidth * pages + (pages - 1) + 2;
            int height = (int)((float)jasperPrint.getPageHeight() * zoom) + 2;
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        BufferedImage pageImage = new BufferedImage(maxWidth, maxHeight, 1);
        Graphics2D g2d = (Graphics2D)((Image)pageImage).getGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(new Rectangle2D.Float(1.0f, 1.0f, maxWidth - 1, maxHeight - 1));
        int offset = 1;
        for (JasperPrint jasperPrint : this.jasperReportHandler.getPrintList()) {
            int pageWidth = (int)((float)jasperPrint.getPageWidth() * zoom);
            int i = 0;
            while (i < jasperPrint.getPages().size()) {
                try {
                    JRGraphics2DExporter exporter = new JRGraphics2DExporter();
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                    exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)((Image)pageImage).getGraphics());
                    exporter.setParameter(JRGraphics2DExporterParameter.OFFSET_X, (Object)offset);
                    exporter.setParameter(JRGraphics2DExporterParameter.OFFSET_Y, (Object)1);
                    exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer(i));
                    exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)new Float(zoom));
                    exporter.exportReport();
                    offset += pageWidth + 1;
                }
                catch (JRException e) {
                    throw new DRException(e);
                }
                ++i;
            }
        }
        try {
            ImageIO.write((RenderedImage)pageImage, "png", outputStream);
        }
        catch (IOException e) {
            throw new DRException(e);
        }
        return this;
    }

    public JasperConcatenatedReportBuilder continuousPageNumbering() {
        return this.setContinuousPageNumbering(true);
    }

    public JasperConcatenatedReportBuilder setContinuousPageNumbering(boolean continuousPageNumbering) {
        this.jasperReportHandler.setContinuousPageNumbering(continuousPageNumbering);
        return this;
    }

    public JasperConcatenatedReportBuilder toCsv(OutputStream outputStream) throws DRException {
        return this.toCsv(Exporters.csvExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toCsv(JasperCsvExporterBuilder csvExporterBuilder) throws DRException {
        return this.export(csvExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toDocx(OutputStream outputStream) throws DRException {
        return this.toDocx(Exporters.docxExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toDocx(JasperDocxExporterBuilder docxExporterBuilder) throws DRException {
        return this.export(docxExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toHtml(OutputStream outputStream) throws DRException {
        return this.toHtml(Exporters.htmlExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toHtml(JasperHtmlExporterBuilder htmlExporterBuilder) throws DRException {
        return this.export(htmlExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toOds(OutputStream outputStream) throws DRException {
        return this.toOds(Exporters.odsExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toOds(JasperOdsExporterBuilder odsExporterBuilder) throws DRException {
        return this.export(odsExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toOdt(OutputStream outputStream) throws DRException {
        return this.toOdt(Exporters.odtExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toOdt(JasperOdtExporterBuilder odtExporterBuilder) throws DRException {
        return this.export(odtExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toPdf(OutputStream outputStream) throws DRException {
        return this.toPdf(Exporters.pdfExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toPdf(JasperPdfExporterBuilder pdfExporterBuilder) throws DRException {
        return this.export(pdfExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toRtf(OutputStream outputStream) throws DRException {
        return this.toRtf(Exporters.rtfExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toRtf(JasperRtfExporterBuilder rtfExporterBuilder) throws DRException {
        return this.export(rtfExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toText(OutputStream outputStream) throws DRException {
        return this.toText(Exporters.textExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toText(JasperTextExporterBuilder textExporterBuilder) throws DRException {
        return this.export(textExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toXhtml(OutputStream outputStream) throws DRException {
        return this.toXhtml(Exporters.xhtmlExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toXhtml(JasperXhtmlExporterBuilder xhtmlExporterBuilder) throws DRException {
        return this.export(xhtmlExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toExcelApiXls(OutputStream outputStream) throws DRException {
        return this.toExcelApiXls(Exporters.excelApiXlsExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toExcelApiXls(JasperExcelApiXlsExporterBuilder excelApiXlsExporterBuilder) throws DRException {
        return this.export(excelApiXlsExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toXls(OutputStream outputStream) throws DRException {
        return this.toXls(Exporters.xlsExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toXls(JasperXlsExporterBuilder xlsExporterBuilder) throws DRException {
        return this.export(xlsExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toXlsx(OutputStream outputStream) throws DRException {
        return this.toXlsx(Exporters.xlsxExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toXlsx(JasperXlsxExporterBuilder xlsxExporterBuilder) throws DRException {
        return this.export(xlsxExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toXml(OutputStream outputStream) throws DRException {
        return this.toXml(Exporters.xmlExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toXml(JasperXmlExporterBuilder xmlExporterBuilder) throws DRException {
        return this.export(xmlExporterBuilder);
    }

    public JasperConcatenatedReportBuilder toPptx(OutputStream outputStream) throws DRException {
        return this.toPptx(Exporters.pptxExporter(outputStream));
    }

    public JasperConcatenatedReportBuilder toPptx(JasperPptxExporterBuilder pptxExporterBuilder) throws DRException {
        return this.export(pptxExporterBuilder);
    }

    public JasperConcatenatedReportBuilder export(AbstractJasperExporterBuilder<?, ? extends AbstractJasperExporter> exporterBuilder) throws DRException {
        Validate.notNull(exporterBuilder, (String)"exporterBuilder must not be null", (Object[])new Object[0]);
        try {
            ExporterTransform exporterTransform = new ExporterTransform((JasperIExporter)exporterBuilder.build());
            JRExporter exporter = exporterTransform.transform();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, this.jasperReportHandler.getPrintList());
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        return this;
    }
}

