/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignReport;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignTextField;
import net.sf.dynamicreports.design.base.expression.AbstractDesignComplexExpression;
import net.sf.dynamicreports.design.constant.EvaluationTime;
import net.sf.dynamicreports.design.definition.DRIDesignHyperLink;
import net.sf.dynamicreports.design.definition.DRIDesignTableOfContentsHeading;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignBarbecue;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignBarcode;
import net.sf.dynamicreports.design.definition.chart.DRIDesignChart;
import net.sf.dynamicreports.design.definition.component.DRIDesignBreak;
import net.sf.dynamicreports.design.definition.component.DRIDesignComponent;
import net.sf.dynamicreports.design.definition.component.DRIDesignEllipse;
import net.sf.dynamicreports.design.definition.component.DRIDesignFiller;
import net.sf.dynamicreports.design.definition.component.DRIDesignGenericElement;
import net.sf.dynamicreports.design.definition.component.DRIDesignImage;
import net.sf.dynamicreports.design.definition.component.DRIDesignLine;
import net.sf.dynamicreports.design.definition.component.DRIDesignList;
import net.sf.dynamicreports.design.definition.component.DRIDesignMap;
import net.sf.dynamicreports.design.definition.component.DRIDesignRectangle;
import net.sf.dynamicreports.design.definition.component.DRIDesignSubreport;
import net.sf.dynamicreports.design.definition.component.DRIDesignTextField;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstab;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignParameterExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignPropertyExpression;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.jasper.base.JasperReportDesign;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.component.CustomComponentTransform;
import net.sf.dynamicreports.report.component.CustomComponents;
import net.sf.dynamicreports.report.component.DRIDesignCustomComponent;
import net.sf.dynamicreports.report.constant.ComponentPositionType;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentTransform {
    private static final Log log = LogFactory.getLog(SubreportExpression.class);
    private JasperTransformAccessor accessor;

    public ComponentTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    protected JRDesignElement[] component(DRIDesignComponent component, ListType listType) {
        JRDesignElement[] jrElements;
        if (component instanceof DRIDesignChart) {
            JRDesignElement jrElement = this.accessor.getChartTransform().transform((DRIDesignChart)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignBarcode) {
            JRDesignElement jrElement = this.accessor.getBarcodeTransform().transform((DRIDesignBarcode)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignBarbecue) {
            JRDesignElement jrElement = this.accessor.getBarcodeTransform().transform((DRIDesignBarbecue)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignList) {
            jrElements = this.list((DRIDesignList)component);
        } else if (component instanceof DRIDesignTextField) {
            JRDesignElement jrElement = this.textField((DRIDesignTextField)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignFiller) {
            JRDesignElement jrElement = this.filler((DRIDesignFiller)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignImage) {
            JRDesignElement jrElement = this.image((DRIDesignImage)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignSubreport) {
            JRDesignElement jrElement = this.subreport((DRIDesignSubreport)component, component.getWidth());
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignLine) {
            JRDesignElement jrElement = this.line((DRIDesignLine)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignEllipse) {
            JRDesignElement jrElement = this.ellipse((DRIDesignEllipse)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignRectangle) {
            JRDesignElement jrElement = this.rectangle((DRIDesignRectangle)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignBreak) {
            JRDesignElement jrElement = this.breakComponent((DRIDesignBreak)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignGenericElement) {
            JRDesignElement jrElement = this.genericElement((DRIDesignGenericElement)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignCrosstab) {
            JRDesignElement jrElement = this.accessor.getCrosstabTransform().transform((DRIDesignCrosstab)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignMap) {
            JRDesignElement jrElement = this.map((DRIDesignMap)component);
            jrElements = this.component(jrElement, component, listType);
        } else if (component instanceof DRIDesignCustomComponent) {
            JRDesignElement jrElement = this.customComponent(component);
            jrElements = this.component(jrElement, component, listType);
        } else {
            throw new JasperDesignException("Component " + component.getClass().getName() + " not supported");
        }
        return jrElements;
    }

    private JRDesignElement[] component(JRDesignElement jrElement, DRIDesignComponent component, ListType listType) {
        ComponentPositionType positionType;
        StretchType stretchType = component.getStretchType();
        if (stretchType == null) {
            stretchType = component instanceof DRIDesignSubreport || component instanceof DRIDesignLine || component instanceof DRIDesignBreak || component instanceof DRIDesignCrosstab || component instanceof DRIDesignList ? StretchType.NO_STRETCH : this.detectStretchType(listType);
        }
        if ((positionType = component.getPositionType()) == null) {
            positionType = ComponentPositionType.FLOAT;
        }
        jrElement.setPositionType(ConstantTransform.componentPositionType(positionType));
        jrElement.setStretchType(ConstantTransform.stretchType(stretchType));
        jrElement.setPrintInFirstWholeBand(component.isPrintInFirstWholeBand());
        jrElement.setPrintWhenDetailOverflows(component.isPrintWhenDetailOverflows());
        if (component.getPrintWhenGroupChanges() != null) {
            jrElement.setPrintWhenGroupChanges((JRGroup)this.accessor.getGroupTransform().getGroup(component.getPrintWhenGroupChanges()));
        }
        jrElement.setKey(component.getUniqueName());
        jrElement.setX(component.getX().intValue());
        jrElement.setY(component.getY().intValue());
        jrElement.setWidth(component.getWidth().intValue());
        jrElement.setHeight(component.getHeight().intValue());
        if (component.getStyle() != null) {
            jrElement.setStyle((JRStyle)this.accessor.getStyleTransform().getStyle(component.getStyle()));
        }
        jrElement.setPrintWhenExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(component.getPrintWhenExpression()));
        jrElement.setRemoveLineWhenBlank(component.isRemoveLineWhenBlank());
        for (DRIDesignPropertyExpression propertyExpression : component.getPropertyExpressions()) {
            jrElement.addPropertyExpression(this.accessor.getExpressionTransform().getPropertyExpression(propertyExpression));
        }
        DRIDesignTableOfContentsHeading tocHeading = component.getTableOfContentsHeading();
        if (tocHeading != null) {
            DRDesignTextField referenceField = (DRDesignTextField)tocHeading.getReferenceField();
            referenceField.setX(component.getX());
            referenceField.setY(component.getY());
            JRDesignElement jrReferenceElement = this.textField(referenceField);
            this.component(jrReferenceElement, referenceField, listType);
            return new JRDesignElement[]{jrReferenceElement, jrElement};
        }
        return new JRDesignElement[]{jrElement};
    }

    private StretchType detectStretchType(ListType listType) {
        if (listType.equals((Object)ListType.VERTICAL)) {
            return StretchType.NO_STRETCH;
        }
        return StretchType.RELATIVE_TO_TALLEST_OBJECT;
    }

    private JRDesignElement[] list(DRIDesignList list) {
        switch (list.getComponentGroupType()) {
            case FRAME: {
                JRDesignFrame frame = new JRDesignFrame();
                JRDesignElement[] jrElems = this.component((JRDesignElement)frame, list, list.getType());
                DRDesignComponent background = (DRDesignComponent)list.getBackgroundComponent();
                if (background != null) {
                    JRDesignElement jRDesignElement = this.component(background, list.getType())[0];
                    frame.addElement((JRElement)jRDesignElement);
                }
                for (DRIDesignComponent dRIDesignComponent : list.getComponents()) {
                    JRDesignElement[] jrElements;
                    JRDesignElement[] jRDesignElementArray = jrElements = this.component(dRIDesignComponent, list.getType());
                    int n = jrElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRDesignElement jrElement = jRDesignElementArray[n2];
                        frame.addElement((JRElement)jrElement);
                        ++n2;
                    }
                }
                return jrElems;
            }
            case NONE: {
                ArrayList<JRDesignElement> arrayList = new ArrayList<JRDesignElement>();
                for (DRIDesignComponent dRIDesignComponent : list.getComponents()) {
                    JRDesignElement[] jrElements;
                    JRDesignElement[] jRDesignElementArray = jrElements = this.component(dRIDesignComponent, list.getType());
                    int n = jrElements.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRDesignElement jrElement = jRDesignElementArray[n3];
                        arrayList.add(jrElement);
                        ++n3;
                    }
                }
                return arrayList.toArray(new JRDesignElement[arrayList.size()]);
            }
        }
        throw new JasperDesignException("ComponentGroupType " + ((Object)((Object)list.getComponentGroupType())).getClass().getName() + " not supported");
    }

    private JRDesignElement textField(DRIDesignTextField textField) {
        DRIDesignHyperLink hyperLink;
        JRDesignTextField jrTextField = new JRDesignTextField();
        jrTextField.setAnchorNameExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(textField.getAnchorNameExpression()));
        if (textField.getBookmarkLevel() != null) {
            jrTextField.setBookmarkLevel(textField.getBookmarkLevel().intValue());
        }
        if ((hyperLink = textField.getHyperLink()) != null) {
            jrTextField.setHyperlinkAnchorExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getAnchorExpression()));
            jrTextField.setHyperlinkPageExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getPageExpression()));
            jrTextField.setHyperlinkReferenceExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getReferenceExpression()));
            jrTextField.setHyperlinkTooltipExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getTooltipExpression()));
            if (hyperLink.getType() != null) {
                HyperlinkTypeEnum hyperLinkType = ConstantTransform.hyperLinkType(hyperLink.getType());
                if (hyperLinkType != null) {
                    jrTextField.setHyperlinkType(hyperLinkType);
                } else {
                    jrTextField.setLinkType(hyperLink.getType());
                }
            }
            if (hyperLink.getTarget() != null) {
                HyperlinkTargetEnum hyperLinkTarget = ConstantTransform.hyperLinkTarget(hyperLink.getTarget());
                if (hyperLinkTarget != null) {
                    jrTextField.setHyperlinkTarget(hyperLinkTarget);
                } else {
                    jrTextField.setLinkTarget(hyperLink.getTarget());
                }
            }
        }
        EvaluationTime evaluationTime = textField.getEvaluationTime();
        jrTextField.setEvaluationTime(ConstantTransform.evaluationTime(evaluationTime));
        if (evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP) && textField.getEvaluationGroup() != null) {
            jrTextField.setEvaluationGroup((JRGroup)this.accessor.getGroupTransform().getGroup(textField.getEvaluationGroup()));
        }
        jrTextField.setStretchWithOverflow(textField.isStretchWithOverflow());
        String pattern = textField.getPattern();
        if (!StringUtils.isBlank((CharSequence)pattern)) {
            jrTextField.setPattern(pattern);
        }
        jrTextField.setPatternExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(textField.getPatternExpression()));
        jrTextField.setHorizontalAlignment(ConstantTransform.horizontalAlignment(textField.getHorizontalAlignment()));
        jrTextField.setExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(textField.getValueExpression()));
        jrTextField.setPrintRepeatedValues(textField.isPrintRepeatedValues());
        jrTextField.setMarkup(ConstantTransform.markup(textField.getMarkup()));
        jrTextField.setBlankWhenNull(true);
        return jrTextField;
    }

    private JRDesignElement filler(DRIDesignFiller filler) {
        JRDesignStaticText jrDesignStaticText = new JRDesignStaticText();
        return jrDesignStaticText;
    }

    private JRDesignElement image(DRIDesignImage image) {
        DRIDesignHyperLink hyperLink;
        JRDesignImage jrImage = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
        jrImage.setAnchorNameExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(image.getAnchorNameExpression()));
        if (image.getBookmarkLevel() != null) {
            jrImage.setBookmarkLevel(image.getBookmarkLevel().intValue());
        }
        if ((hyperLink = image.getHyperLink()) != null) {
            jrImage.setHyperlinkAnchorExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getAnchorExpression()));
            jrImage.setHyperlinkPageExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getPageExpression()));
            jrImage.setHyperlinkReferenceExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getReferenceExpression()));
            jrImage.setHyperlinkTooltipExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getTooltipExpression()));
            if (hyperLink.getType() != null) {
                HyperlinkTypeEnum hyperLinkType = ConstantTransform.hyperLinkType(hyperLink.getType());
                if (hyperLinkType != null) {
                    jrImage.setHyperlinkType(hyperLinkType);
                } else {
                    jrImage.setLinkType(hyperLink.getType());
                }
            }
            if (hyperLink.getTarget() != null) {
                HyperlinkTargetEnum hyperLinkTarget = ConstantTransform.hyperLinkTarget(hyperLink.getTarget());
                if (hyperLinkTarget != null) {
                    jrImage.setHyperlinkTarget(hyperLinkTarget);
                } else {
                    jrImage.setLinkTarget(hyperLink.getTarget());
                }
            }
        }
        jrImage.setOnErrorType(OnErrorTypeEnum.BLANK);
        jrImage.setScaleImage(ConstantTransform.imageScale(image.getImageScale()));
        jrImage.setHorizontalAlignment(ConstantTransform.horizontalAlignment(image.getHorizontalAlignment()));
        jrImage.setExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(image.getImageExpression()));
        if (image.getUsingCache() != null) {
            jrImage.setUsingCache(image.getUsingCache());
        }
        if (image.getLazy() != null) {
            jrImage.setLazy(image.getLazy().booleanValue());
        }
        return jrImage;
    }

    private JRDesignElement subreport(DRIDesignSubreport subreport, Integer width) {
        JRDesignSubreport jrSubreport = new JRDesignSubreport(new JRDesignStyle().getDefaultStyleProvider());
        jrSubreport.setConnectionExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(subreport.getConnectionExpression()));
        jrSubreport.setDataSourceExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(subreport.getDataSourceExpression()));
        jrSubreport.setRunToBottom(subreport.getRunToBottom());
        if (ReportBuilder.class.isAssignableFrom(subreport.getReportExpression().getValueClass())) {
            SubreportExpression subreportExpression = new SubreportExpression(subreport.getReportExpression(), width);
            this.accessor.getExpressionTransform().addComplexExpression(subreportExpression);
            jrSubreport.setExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(subreportExpression));
            SubreportParametersExpression parametersExpression = new SubreportParametersExpression(subreportExpression, subreport.getParametersExpression());
            this.accessor.getExpressionTransform().addComplexExpression(parametersExpression);
            jrSubreport.setParametersMapExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(parametersExpression));
        } else {
            jrSubreport.setExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(subreport.getReportExpression()));
            JasperSubreportParametersExpression parametersExpression = new JasperSubreportParametersExpression(subreport.getParametersExpression());
            this.accessor.getExpressionTransform().addComplexExpression(parametersExpression);
            jrSubreport.setParametersMapExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(parametersExpression));
        }
        return jrSubreport;
    }

    private JRDesignElement line(DRIDesignLine line) {
        JRDesignLine jrDesignLine = new JRDesignLine();
        jrDesignLine.setDirection(ConstantTransform.lineDirection(line.getDirection()));
        this.accessor.getStyleTransform().pen(jrDesignLine.getLinePen(), line.getPen());
        return jrDesignLine;
    }

    private JRDesignElement ellipse(DRIDesignEllipse ellipse) {
        JRDesignEllipse jrDesignEllipse = new JRDesignEllipse(new JRDesignStyle().getDefaultStyleProvider());
        this.accessor.getStyleTransform().pen(jrDesignEllipse.getLinePen(), ellipse.getPen());
        return jrDesignEllipse;
    }

    private JRDesignElement rectangle(DRIDesignRectangle rectangle) {
        JRDesignRectangle jrDesignRectangle = new JRDesignRectangle();
        jrDesignRectangle.setRadius(rectangle.getRadius());
        this.accessor.getStyleTransform().pen(jrDesignRectangle.getLinePen(), rectangle.getPen());
        return jrDesignRectangle;
    }

    private JRDesignElement breakComponent(DRIDesignBreak breakComponent) {
        JRDesignBreak jrDesignBreak = new JRDesignBreak();
        jrDesignBreak.setType(ConstantTransform.breakType(breakComponent.getType()));
        return jrDesignBreak;
    }

    private JRDesignElement genericElement(DRIDesignGenericElement genericElement) {
        JRDesignGenericElement jrDesignGenericElement = new JRDesignGenericElement(new JRDesignStyle().getDefaultStyleProvider());
        JRGenericElementType genericType = new JRGenericElementType(genericElement.getGenericElementNamespace(), genericElement.getGenericElementName());
        jrDesignGenericElement.setGenericType(genericType);
        EvaluationTime evaluationTime = genericElement.getEvaluationTime();
        jrDesignGenericElement.setEvaluationTime(ConstantTransform.evaluationTime(evaluationTime));
        if (evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP) && genericElement.getEvaluationGroup() != null) {
            jrDesignGenericElement.setEvaluationGroupName(this.accessor.getGroupTransform().getGroup(genericElement.getEvaluationGroup()).getName());
        }
        for (DRIDesignParameterExpression parameterExpression : genericElement.getParameterExpressions()) {
            jrDesignGenericElement.addParameter(this.accessor.getExpressionTransform().getGenericElementParameterExpression(parameterExpression));
        }
        return jrDesignGenericElement;
    }

    private JRDesignElement map(DRIDesignMap map) {
        StandardMapComponent jrMap = new StandardMapComponent();
        EvaluationTime evaluationTime = map.getEvaluationTime();
        jrMap.setEvaluationTime(ConstantTransform.evaluationTime(evaluationTime));
        if (evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP) && map.getEvaluationGroup() != null) {
            jrMap.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(map.getEvaluationGroup()).getName());
        }
        jrMap.setLatitudeExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(map.getLatitudeExpression()));
        jrMap.setLongitudeExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(map.getLongitudeExpression()));
        jrMap.setZoomExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(map.getZoomExpression()));
        JRDesignComponentElement jrComponent = new JRDesignComponentElement();
        jrComponent.setComponent((Component)jrMap);
        jrComponent.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "map"));
        return jrComponent;
    }

    private JRDesignElement customComponent(DRIDesignComponent component) {
        CustomComponentTransform<?, ?> componentTransfom = CustomComponents.getComponentTransform(component);
        if (componentTransfom == null) {
            throw new DRDesignReportException("Component " + component.getClass().getName() + " not supported");
        }
        JRDesignComponentElement jrComponent = (JRDesignComponentElement)componentTransfom.jasperComponent(this.accessor, component);
        return jrComponent;
    }

    private class JasperSubreportParametersExpression
    extends AbstractDesignComplexExpression {
        public JasperSubreportParametersExpression(DRIDesignExpression parametersExpression) {
            super(ReportUtils.generateUniqueName("jasperSubreportParametersExpression"));
            if (parametersExpression != null) {
                this.addExpression(parametersExpression);
            }
        }

        @Override
        public Object evaluate(List<?> values, ReportParameters reportParameters) {
            Map parameters = null;
            parameters = !values.isEmpty() ? (Map)values.get(0) : new HashMap();
            parameters.put("MASTER_REPORT_PARAMETERS", reportParameters);
            return parameters;
        }

        @Override
        public Class<?> getValueClass() {
            return Map.class;
        }
    }

    private class SubreportExpression
    extends AbstractDesignComplexExpression {
        private String name;
        private Integer pageWidth;
        private ReportBuilder<?> reportBuilder;
        private Map<ReportBuilder<?>, JasperReportDesign> reportDesigns;
        private Map<ReportBuilder<?>, JasperReport> jasperReports;

        public SubreportExpression(DRIDesignExpression reportExpression, Integer pageWidth) {
            this.addExpression(reportExpression);
            this.pageWidth = pageWidth;
            this.name = ReportUtils.generateUniqueName("subreportExpression");
            this.reportDesigns = new HashMap();
            this.jasperReports = new HashMap();
        }

        @Override
        public Object evaluate(List<?> values, ReportParameters reportParameters) {
            block5: {
                this.reportBuilder = (ReportBuilder)values.get(0);
                if (this.jasperReports.containsKey(this.reportBuilder)) {
                    return this.jasperReports.get(this.reportBuilder);
                }
                try {
                    DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
                    DRDesignReport report = new DRDesignReport((DRIReport)this.reportBuilder.build(), this.pageWidth, customValues.getTocHeadings());
                    JasperReportDesign reportDesign = new JasperReportDesign(report, reportParameters, null);
                    JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)reportDesign.getDesign());
                    this.reportDesigns.put(this.reportBuilder, reportDesign);
                    this.jasperReports.put(this.reportBuilder, jasperReport);
                    return jasperReport;
                }
                catch (JRException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error encountered while creating subreport design", (Throwable)e);
                    }
                }
                catch (DRException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Error encountered while creating subreport design", (Throwable)e);
                }
            }
            return null;
        }

        public JasperReportDesign getReportDesign() {
            return this.reportDesigns.get(this.reportBuilder);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getValueClass() {
            return JasperReport.class;
        }
    }

    private class SubreportParametersExpression
    extends AbstractDesignComplexExpression {
        private SubreportExpression subreportExpression;

        public SubreportParametersExpression(SubreportExpression subreportExpression, DRIDesignExpression parametersExpression) {
            super(ReportUtils.generateUniqueName("subreportParametersExpression"));
            this.subreportExpression = subreportExpression;
            if (parametersExpression != null) {
                this.addExpression(parametersExpression);
            }
        }

        @Override
        public Object evaluate(List<?> values, ReportParameters reportParameters) {
            Map parameters = null;
            parameters = !values.isEmpty() ? (Map)values.get(0) : new HashMap();
            parameters.putAll(this.subreportExpression.getReportDesign().getParameters());
            if (this.subreportExpression.getReportDesign().getParameterValues() != null) {
                parameters.putAll(this.subreportExpression.getReportDesign().getParameterValues());
            }
            parameters.put("MASTER_REPORT_PARAMETERS", reportParameters);
            return parameters;
        }

        @Override
        public Class<?> getValueClass() {
            return Map.class;
        }
    }
}

