/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.jasper.definition.export.JasperICsvExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIDocxExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIExcelApiXlsExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIExcelExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIHtmlExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIImageExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIOdsExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIOdtExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIPdfExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIPptxExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIRtfExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperITextExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIXhtmlExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIXlsExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIXlsxExporter;
import net.sf.dynamicreports.jasper.definition.export.JasperIXmlExporter;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;

public class ExporterTransform {
    private JasperIExporter jasperExporter;

    public ExporterTransform(JasperIExporter jasperExporter) {
        this.jasperExporter = jasperExporter;
    }

    public JRExporter transform() throws DRException {
        JRExporter jrExporter;
        if (this.jasperExporter instanceof JasperICsvExporter) {
            jrExporter = this.csv((JasperICsvExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIDocxExporter) {
            jrExporter = this.docx((JasperIDocxExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIExcelApiXlsExporter) {
            jrExporter = this.excelApiXls((JasperIExcelApiXlsExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIXlsExporter) {
            jrExporter = this.xls((JasperIXlsExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIXlsxExporter) {
            jrExporter = this.xlsx((JasperIXlsxExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIHtmlExporter) {
            jrExporter = this.html((JasperIHtmlExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIOdsExporter) {
            jrExporter = this.ods((JasperIOdsExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIOdtExporter) {
            jrExporter = this.odt((JasperIOdtExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIPdfExporter) {
            jrExporter = this.pdf((JasperIPdfExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIRtfExporter) {
            jrExporter = this.rtf((JasperIRtfExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperITextExporter) {
            jrExporter = this.text((JasperITextExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIXhtmlExporter) {
            jrExporter = this.xhtml((JasperIXhtmlExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIXmlExporter) {
            jrExporter = this.xml((JasperIXmlExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIPptxExporter) {
            jrExporter = this.pptx((JasperIPptxExporter)this.jasperExporter);
        } else if (this.jasperExporter instanceof JasperIImageExporter) {
            jrExporter = this.image((JasperIImageExporter)this.jasperExporter);
        } else {
            throw new JasperDesignException("Exporter " + this.jasperExporter.getClass().getName() + " not supported");
        }
        return jrExporter;
    }

    private JRExporter exporter(JRExporter jrExporter, JasperIExporter jasperExporter) {
        if (jasperExporter.getOutputWriter() != null) {
            jrExporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)jasperExporter.getOutputWriter());
        }
        if (jasperExporter.getOutputStream() != null) {
            jrExporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)jasperExporter.getOutputStream());
        }
        if (jasperExporter.getOutputFile() != null) {
            jrExporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)jasperExporter.getOutputFile());
        }
        if (jasperExporter.getOutputFileName() != null) {
            jrExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)jasperExporter.getOutputFileName());
        }
        if (jasperExporter.getPageIndex() != null) {
            jrExporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)jasperExporter.getPageIndex());
        }
        if (jasperExporter.getStartPageIndex() != null) {
            jrExporter.setParameter(JRExporterParameter.START_PAGE_INDEX, (Object)jasperExporter.getStartPageIndex());
        }
        if (jasperExporter.getEndPageIndex() != null) {
            jrExporter.setParameter(JRExporterParameter.END_PAGE_INDEX, (Object)jasperExporter.getEndPageIndex());
        }
        if (jasperExporter.getCharacterEncoding() != null) {
            jrExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)jasperExporter.getCharacterEncoding());
        }
        if (jasperExporter.getOffsetX() != null) {
            jrExporter.setParameter(JRExporterParameter.OFFSET_X, (Object)jasperExporter.getOffsetX());
        }
        if (jasperExporter.getOffsetY() != null) {
            jrExporter.setParameter(JRExporterParameter.OFFSET_Y, (Object)jasperExporter.getOffsetY());
        }
        if (jasperExporter.getIgnorePageMargins() != null) {
            jrExporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)jasperExporter.getIgnorePageMargins());
        }
        return null;
    }

    private JRExporter xml(JasperIXmlExporter jasperExporter) {
        JRXmlExporter jrExporter = new JRXmlExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getEmbeddingImages() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXmlExporterParameter.IS_EMBEDDING_IMAGES, (Object)jasperExporter.getEmbeddingImages());
        }
        return jrExporter;
    }

    private JRExporter pptx(JasperIPptxExporter jasperExporter) {
        JRPptxExporter jrExporter = new JRPptxExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter xhtml(JasperIXhtmlExporter jasperExporter) {
        JRXhtmlExporter jrExporter = new JRXhtmlExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getOutputImagesToDir() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)jasperExporter.getOutputImagesToDir());
        }
        if (jasperExporter.getImagesDirName() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)jasperExporter.getImagesDirName());
        }
        if (jasperExporter.getImagesURI() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)jasperExporter.getImagesURI());
        }
        if (jasperExporter.getHtmlHeader() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)jasperExporter.getHtmlHeader());
        }
        if (jasperExporter.getBetweenPagesHtml() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)jasperExporter.getBetweenPagesHtml());
        }
        if (jasperExporter.getHtmlFooter() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)jasperExporter.getHtmlFooter());
        }
        if (jasperExporter.getWhitePageBackground() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)jasperExporter.getWhitePageBackground());
        }
        if (jasperExporter.getWrapBreakWord() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)jasperExporter.getWrapBreakWord());
        }
        if (jasperExporter.getSizeUnit() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.SIZE_UNIT, (Object)ConstantTransform.sizeUnit(jasperExporter.getSizeUnit()));
        }
        return jrExporter;
    }

    private JRExporter text(JasperITextExporter jasperExporter) {
        DRFont font;
        JRTextExporter jrExporter = new JRTextExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getCharacterWidth() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)jasperExporter.getCharacterWidth());
        } else {
            font = Defaults.getDefaults().getFont();
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Float(StyleResolver.getFontWidth(font)));
        }
        if (jasperExporter.getCharacterHeight() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)jasperExporter.getCharacterHeight());
        } else {
            font = Defaults.getDefaults().getFont();
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Float(StyleResolver.getFontHeight(font)));
        }
        if (jasperExporter.getPageWidth() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)jasperExporter.getPageWidth());
        }
        if (jasperExporter.getPageHeight() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)jasperExporter.getPageHeight());
        }
        if (jasperExporter.getBetweenPagesText() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)jasperExporter.getBetweenPagesText());
        }
        if (jasperExporter.getLineSeparator() != null) {
            jrExporter.setParameter((JRExporterParameter)JRTextExporterParameter.LINE_SEPARATOR, (Object)jasperExporter.getLineSeparator());
        }
        return jrExporter;
    }

    private JRExporter rtf(JasperIRtfExporter jasperExporter) {
        JRRtfExporter jrExporter = new JRRtfExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter pdf(JasperIPdfExporter jasperExporter) {
        JRPdfExporter jrExporter = new JRPdfExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getCreatingBatchModeBookmarks() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, (Object)jasperExporter.getCreatingBatchModeBookmarks());
        }
        if (jasperExporter.getCompressed() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_COMPRESSED, (Object)jasperExporter.getCompressed());
        }
        if (jasperExporter.getEncrypted() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)jasperExporter.getEncrypted());
        }
        if (jasperExporter.getBitKey128() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_128_BIT_KEY, (Object)jasperExporter.getBitKey128());
        }
        if (jasperExporter.getUserPassword() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)jasperExporter.getUserPassword());
        }
        if (jasperExporter.getOwnerPassword() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)jasperExporter.getOwnerPassword());
        }
        if (jasperExporter.getPermissions() != null && !jasperExporter.getPermissions().isEmpty()) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)ConstantTransform.pdfPermission(jasperExporter.getPermissions()));
        }
        if (jasperExporter.getPdfVersion() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_VERSION, (Object)ConstantTransform.pdfVersion(jasperExporter.getPdfVersion()));
        }
        if (jasperExporter.getMetadataTitle() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)jasperExporter.getMetadataTitle());
        }
        if (jasperExporter.getMetadataAuthor() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)jasperExporter.getMetadataAuthor());
        }
        if (jasperExporter.getMetadataSubject() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)jasperExporter.getMetadataSubject());
        }
        if (jasperExporter.getMetadataKeyWords() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)jasperExporter.getMetadataKeyWords());
        }
        if (jasperExporter.getMetadataCreator() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)jasperExporter.getMetadataCreator());
        }
        if (jasperExporter.getForceSvgShapes() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_SVG_SHAPES, (Object)jasperExporter.getForceSvgShapes());
        }
        if (jasperExporter.getPdfJavaScript() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_JAVASCRIPT, (Object)jasperExporter.getPdfJavaScript());
        }
        if (jasperExporter.getTagged() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_TAGGED, (Object)jasperExporter.getTagged());
        }
        if (jasperExporter.getTagLanguage() != null) {
            jrExporter.setParameter((JRExporterParameter)JRPdfExporterParameter.TAG_LANGUAGE, (Object)jasperExporter.getTagLanguage());
        }
        return jrExporter;
    }

    private JRExporter odt(JasperIOdtExporter jasperExporter) {
        JROdtExporter jrExporter = new JROdtExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter ods(JasperIOdsExporter jasperExporter) {
        JROdsExporter jrExporter = new JROdsExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter html(JasperIHtmlExporter jasperExporter) {
        JRHtmlExporter jrExporter = new JRHtmlExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getOutputImagesToDir() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)jasperExporter.getOutputImagesToDir());
        }
        if (jasperExporter.getImagesDirName() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)jasperExporter.getImagesDirName());
        }
        if (jasperExporter.getImagesURI() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)jasperExporter.getImagesURI());
        }
        if (jasperExporter.getHtmlHeader() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)jasperExporter.getHtmlHeader());
        }
        if (jasperExporter.getBetweenPagesHtml() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)jasperExporter.getBetweenPagesHtml());
        }
        if (jasperExporter.getHtmlFooter() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)jasperExporter.getHtmlFooter());
        }
        if (jasperExporter.getRemoveEmptySpaceBetweenRows() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)jasperExporter.getRemoveEmptySpaceBetweenRows());
        }
        if (jasperExporter.getWhitePageBackground() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)jasperExporter.getWhitePageBackground());
        }
        if (jasperExporter.getUsingImagesToAlign() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)jasperExporter.getUsingImagesToAlign());
        }
        if (jasperExporter.getWrapBreakWord() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)jasperExporter.getWrapBreakWord());
        }
        if (jasperExporter.getSizeUnit() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.SIZE_UNIT, (Object)ConstantTransform.sizeUnit(jasperExporter.getSizeUnit()));
        }
        if (jasperExporter.getFramesAsNestedTables() != null) {
            jrExporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.FRAMES_AS_NESTED_TABLES, (Object)jasperExporter.getFramesAsNestedTables());
        }
        return jrExporter;
    }

    private JRExporter excel(JRXlsAbstractExporter jrExporter, JasperIExcelExporter jasperExporter) {
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getOnePagePerSheet() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)jasperExporter.getOnePagePerSheet());
        }
        if (jasperExporter.getRemoveEmptySpaceBetweenRows() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)jasperExporter.getRemoveEmptySpaceBetweenRows());
        }
        if (jasperExporter.getRemoveEmptySpaceBetweenColumns() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)jasperExporter.getRemoveEmptySpaceBetweenColumns());
        }
        if (jasperExporter.getWhitePageBackground() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)jasperExporter.getWhitePageBackground());
        }
        if (jasperExporter.getDetectCellType() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, (Object)jasperExporter.getDetectCellType());
        }
        if (jasperExporter.getSheetNames() != null && !jasperExporter.getSheetNames().isEmpty()) {
            String[] sheetNames = jasperExporter.getSheetNames().toArray(new String[jasperExporter.getSheetNames().size()]);
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.SHEET_NAMES, (Object)sheetNames);
        }
        if (jasperExporter.getFontSizeFixEnabled() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)jasperExporter.getFontSizeFixEnabled());
        }
        if (jasperExporter.getImageBorderFixEnabled() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, (Object)jasperExporter.getImageBorderFixEnabled());
        }
        if (jasperExporter.getMaxRowsPerSheet() != null) {
            jrExporter.setParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)jasperExporter.getMaxRowsPerSheet());
        }
        if (jasperExporter.getIgnoreGraphics() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, (Object)jasperExporter.getIgnoreGraphics());
        }
        if (jasperExporter.getCollapseRowSpan() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)jasperExporter.getCollapseRowSpan());
        }
        if (jasperExporter.getIgnoreCellBorder() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, (Object)jasperExporter.getIgnoreCellBorder());
        }
        if (jasperExporter.getIgnoreCellBackground() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BACKGROUND, (Object)jasperExporter.getIgnoreCellBackground());
        }
        if (jasperExporter.getPassword() != null) {
            jrExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.PASSWORD, (Object)jasperExporter.getPassword());
        }
        return jrExporter;
    }

    private JRExporter xlsx(JasperIXlsxExporter jasperExporter) {
        JRXlsxExporter jrExporter = new JRXlsxExporter();
        this.excel((JRXlsAbstractExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter xls(JasperIXlsExporter jasperExporter) {
        JRXlsExporter jrExporter = new JRXlsExporter();
        this.excel((JRXlsAbstractExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter excelApiXls(JasperIExcelApiXlsExporter jasperExporter) {
        JExcelApiExporter jrExporter = new JExcelApiExporter();
        this.excel((JRXlsAbstractExporter)jrExporter, jasperExporter);
        return jrExporter;
    }

    private JRExporter docx(JasperIDocxExporter jasperExporter) {
        JRDocxExporter jrExporter = new JRDocxExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getFramesAsNestedTables() != null) {
            jrExporter.setParameter((JRExporterParameter)JRDocxExporterParameter.FRAMES_AS_NESTED_TABLES, (Object)jasperExporter.getFramesAsNestedTables());
        }
        if (jasperExporter.getFlexibleRowHeight() != null) {
            jrExporter.setParameter((JRExporterParameter)JRDocxExporterParameter.FLEXIBLE_ROW_HEIGHT, (Object)jasperExporter.getFlexibleRowHeight());
        }
        return jrExporter;
    }

    private JRExporter csv(JasperICsvExporter jasperExporter) {
        JRCsvExporter jrExporter = new JRCsvExporter();
        this.exporter((JRExporter)jrExporter, jasperExporter);
        if (jasperExporter.getFieldDelimiter() != null) {
            jrExporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)jasperExporter.getFieldDelimiter());
        }
        if (jasperExporter.getRecordDelimiter() != null) {
            jrExporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, (Object)jasperExporter.getRecordDelimiter());
        }
        return jrExporter;
    }

    public JRExporter image(JasperIImageExporter jasperExporter) throws DRException {
        try {
            JRGraphics2DExporter jrExporter = new JRGraphics2DExporter();
            if (jasperExporter.getCharacterEncoding() != null) {
                jrExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)jasperExporter.getCharacterEncoding());
            }
            if (jasperExporter.getOffsetY() != null) {
                jrExporter.setParameter(JRExporterParameter.OFFSET_Y, (Object)jasperExporter.getOffsetY());
            }
            if (jasperExporter.getIgnorePageMargins() != null) {
                jrExporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)jasperExporter.getIgnorePageMargins());
            }
            if (jasperExporter.getZoom() != null) {
                jrExporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)jasperExporter.getZoom());
            }
            return jrExporter;
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }
}

