/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report;

import java.lang.reflect.ParameterizedType;
import net.sf.dynamicreports.report.constant.Calculation;

public class ReportUtils {
    private static int counter = 0;

    public static String generateUniqueName(String name) {
        if (counter == Integer.MAX_VALUE) {
            counter = 0;
        }
        return String.valueOf(name) + "_" + counter++ + "_";
    }

    public static Class<?> getVariableValueClass(Calculation calculation, Class<?> valueClass) {
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            return Long.class;
        }
        if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            return Number.class;
        }
        return valueClass;
    }

    public static Class<?> getGenericClass(Object object, int index) {
        ParameterizedType genericSuperclass = ReportUtils.getParameterizedType(object.getClass());
        if (genericSuperclass == null) {
            return String.class;
        }
        Class<?> rawType = ReportUtils.getRawType(genericSuperclass.getActualTypeArguments()[index]);
        if (rawType == null) {
            return String.class;
        }
        return rawType;
    }

    private static ParameterizedType getParameterizedType(Class<?> classs) {
        if (classs == null) {
            return null;
        }
        if (classs.getGenericSuperclass() instanceof ParameterizedType) {
            return (ParameterizedType)classs.getGenericSuperclass();
        }
        return ReportUtils.getParameterizedType((Class)classs.getGenericSuperclass());
    }

    private static Class<?> getRawType(Object typeArgument) {
        if (typeArgument instanceof ParameterizedType) {
            return ReportUtils.getRawType(((ParameterizedType)typeArgument).getRawType());
        }
        if (typeArgument instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }
}

