/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.DRMargin;
import net.sf.dynamicreports.report.base.DRParameter;
import net.sf.dynamicreports.report.base.DRQuery;
import net.sf.dynamicreports.report.base.DRReport;
import net.sf.dynamicreports.report.base.DRReportTemplate;
import net.sf.dynamicreports.report.base.DRSort;
import net.sf.dynamicreports.report.base.DRSubtotal;
import net.sf.dynamicreports.report.base.column.DRColumn;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.grid.DRColumnGrid;
import net.sf.dynamicreports.report.base.style.DRConditionalStyle;
import net.sf.dynamicreports.report.base.style.DRSimpleStyle;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.MarginBuilder;
import net.sf.dynamicreports.report.builder.ParameterBuilder;
import net.sf.dynamicreports.report.builder.QueryBuilder;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.SortBuilder;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.group.Groups;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.SimpleStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.style.TemplateStyleListBuilder;
import net.sf.dynamicreports.report.builder.subtotal.PercentageSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsCustomizerBuilder;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.constant.RunDirection;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.constant.SubtotalPosition;
import net.sf.dynamicreports.report.constant.WhenNoDataType;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIFont;
import net.sf.dynamicreports.report.definition.style.DRIStyle;
import org.apache.commons.lang3.Validate;

public class ReportBuilder<T extends ReportBuilder<T>>
extends AbstractBuilder<T, DRReport> {
    private static final long serialVersionUID = 10000L;

    public ReportBuilder() {
        super(new DRReport());
    }

    public T setReportName(String reportName) {
        ((DRReport)this.getObject()).setReportName(reportName);
        return (T)this;
    }

    public T setLocale(Locale locale) {
        ((DRReport)this.getObject()).setLocale(locale);
        return (T)this;
    }

    public T setResourceBundle(ResourceBundle resourceBundle) {
        ((DRReport)this.getObject()).setResourceBundle(resourceBundle);
        return (T)this;
    }

    public T setResourceBundle(String resourceBundleName) {
        ((DRReport)this.getObject()).setResourceBundleName(resourceBundleName);
        return (T)this;
    }

    public T setShowColumnTitle(Boolean showColumnTitle) {
        ((DRReport)this.getObject()).setShowColumnTitle(showColumnTitle);
        return (T)this;
    }

    public T setShowColumnValues(Boolean showColumnValues) {
        ((DRReport)this.getObject()).setShowColumnValues(showColumnValues);
        return (T)this;
    }

    public T setPageFormat(PageType pageType) {
        return this.setPageFormat(pageType, PageOrientation.PORTRAIT);
    }

    public T setPageFormat(PageType pageType, PageOrientation orientation) {
        ((DRReport)this.getObject()).getPage().setPageFormat(pageType, orientation);
        return (T)this;
    }

    public T setPageFormat(Integer width, Integer height, PageOrientation orientation) {
        ((DRReport)this.getObject()).getPage().setPageFormat(width, height, orientation);
        return (T)this;
    }

    public T setPageMargin(MarginBuilder margin) {
        Validate.notNull((Object)margin, (String)"margin must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getPage().setMargin((DRMargin)margin.build());
        return (T)this;
    }

    public T setPageColumnsPerPage(Integer columnsPerPage) {
        ((DRReport)this.getObject()).getPage().setColumnsPerPage(columnsPerPage);
        return (T)this;
    }

    public T setPageColumnSpace(Integer columnSpace) {
        ((DRReport)this.getObject()).getPage().setColumnSpace(columnSpace);
        return (T)this;
    }

    public T ignorePageWidth() {
        return this.setIgnorePageWidth(true);
    }

    public T setIgnorePageWidth(Boolean ignorePageWidth) {
        ((DRReport)this.getObject()).getPage().setIgnorePageWidth(ignorePageWidth);
        return (T)this;
    }

    public T ignorePagination() {
        return this.setIgnorePagination(true);
    }

    public T setIgnorePagination(Boolean ignorePagination) {
        ((DRReport)this.getObject()).setIgnorePagination(ignorePagination);
        return (T)this;
    }

    public T setWhenNoDataType(WhenNoDataType whenNoDataType) {
        ((DRReport)this.getObject()).setWhenNoDataType(whenNoDataType);
        return (T)this;
    }

    public T titleOnANewPage() {
        return this.setTitleOnANewPage(true);
    }

    public T setTitleOnANewPage(Boolean titleOnANewPage) {
        ((DRReport)this.getObject()).setTitleOnANewPage(titleOnANewPage);
        return (T)this;
    }

    public T summaryOnANewPage() {
        return this.setSummaryOnANewPage(true);
    }

    public T setSummaryOnANewPage(Boolean summaryOnANewPage) {
        ((DRReport)this.getObject()).setSummaryOnANewPage(summaryOnANewPage);
        return (T)this;
    }

    public T summaryWithPageHeaderAndFooter() {
        return this.setSummaryWithPageHeaderAndFooter(true);
    }

    public T setSummaryWithPageHeaderAndFooter(Boolean summaryWithPageHeaderAndFooter) {
        ((DRReport)this.getObject()).setSummaryWithPageHeaderAndFooter(summaryWithPageHeaderAndFooter);
        return (T)this;
    }

    public T floatColumnFooter() {
        return this.setFloatColumnFooter(true);
    }

    public T setFloatColumnFooter(Boolean floatColumnFooter) {
        ((DRReport)this.getObject()).setFloatColumnFooter(floatColumnFooter);
        return (T)this;
    }

    public T setPrintOrder(Orientation printOrder) {
        ((DRReport)this.getObject()).setPrintOrder(printOrder);
        return (T)this;
    }

    public T setColumnDirection(RunDirection columnDirection) {
        ((DRReport)this.getObject()).setColumnDirection(columnDirection);
        return (T)this;
    }

    public T setLanguage(String language) {
        ((DRReport)this.getObject()).setLanguage(language);
        return (T)this;
    }

    public T setUseFieldNameAsDescription(Boolean useFieldNameAsDescription) {
        ((DRReport)this.getObject()).setUseFieldNameAsDescription(useFieldNameAsDescription);
        return (T)this;
    }

    public T scriptlets(DRIScriptlet ... scriptlets) {
        return this.addScriptlet(scriptlets);
    }

    public T addScriptlet(DRIScriptlet ... scriptlets) {
        Validate.notNull((Object)scriptlets, (String)"scriptlets must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])scriptlets, (String)"scriptlets must not contains null scriptlet", (Object[])new Object[0]);
        DRIScriptlet[] dRIScriptletArray = scriptlets;
        int n = scriptlets.length;
        int n2 = 0;
        while (n2 < n) {
            DRIScriptlet scriptlet = dRIScriptletArray[n2];
            ((DRReport)this.getObject()).addScriptlet(scriptlet);
            ++n2;
        }
        return (T)this;
    }

    public T setProperties(Properties properties) {
        ((DRReport)this.getObject()).setProperties(properties);
        return (T)this;
    }

    public T addProperty(String key, String value) {
        ((DRReport)this.getObject()).addProperty(key, value);
        return (T)this;
    }

    public T setQuery(String text, String language) {
        Validate.notNull((Object)text, (String)"text must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)language, (String)"language must not be null", (Object[])new Object[0]);
        return this.setQuery(DynamicReports.query(text, language));
    }

    public T setQuery(String sql) {
        Validate.notNull((Object)sql, (String)"sql must not be null", (Object[])new Object[0]);
        return this.setQuery(DynamicReports.query(sql, "sql"));
    }

    public T setQuery(QueryBuilder query) {
        Validate.notNull((Object)query, (String)"query must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).setQuery((DRQuery)query.build());
        return (T)this;
    }

    public T columnGrid(ListType type) {
        ((DRReport)this.getObject()).setColumnGrid(new DRColumnGrid(type));
        return (T)this;
    }

    public T columnGrid(ColumnGridComponentBuilder ... components) {
        return this.columnGrid(ListType.HORIZONTAL, components);
    }

    public T columnGrid(ListType type, ColumnGridComponentBuilder ... components) {
        Validate.notNull((Object)components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        DRColumnGrid columnGrid = new DRColumnGrid(type);
        ColumnGridComponentBuilder[] columnGridComponentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnGridComponentBuilder component = columnGridComponentBuilderArray[n2];
            columnGrid.addComponent(component.build());
            ++n2;
        }
        ((DRReport)this.getObject()).setColumnGrid(columnGrid);
        return (T)this;
    }

    public T setTemplate(ReportTemplateBuilder template) {
        Validate.notNull((Object)template, (String)"template must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).setTemplate((DRReportTemplate)template.build());
        return (T)this;
    }

    public T templateStyles(TemplateStyleListBuilder ... templateStyleLists) {
        return this.addTemplateStyle(templateStyleLists);
    }

    public T addTemplateStyle(TemplateStyleListBuilder ... templateStyleLists) {
        Validate.notNull((Object)templateStyleLists, (String)"templateStyleLists must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])templateStyleLists, (String)"templateStyleLists must not contains null templateStyleLists", (Object[])new Object[0]);
        TemplateStyleListBuilder[] templateStyleListBuilderArray = templateStyleLists;
        int n = templateStyleLists.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateStyleListBuilder templateStyle = templateStyleListBuilderArray[n2];
            DRIStyle[] dRIStyleArray = templateStyle.getStyles();
            int n3 = dRIStyleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                DRIStyle style = dRIStyleArray[n4];
                ((DRReport)this.getObject()).addTemplateStyle(style);
                ++n4;
            }
            ++n2;
        }
        return (T)this;
    }

    public T templateStyles(StyleBuilder ... templateStyles) {
        return this.addTemplateStyle(templateStyles);
    }

    public T addTemplateStyle(StyleBuilder ... templateStyles) {
        Validate.notNull((Object)templateStyles, (String)"templateStyles must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])templateStyles, (String)"templateStyles must not contains null templateStyle", (Object[])new Object[0]);
        StyleBuilder[] styleBuilderArray = templateStyles;
        int n = templateStyles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleBuilder templateStyle = styleBuilderArray[n2];
            ((DRReport)this.getObject()).addTemplateStyle((DRIStyle)templateStyle.build());
            ++n2;
        }
        return (T)this;
    }

    public T parameters(ParameterBuilder<?> ... parameters) {
        return this.addParameter(parameters);
    }

    public T addParameter(String name, Object value) {
        return this.addParameter(DynamicReports.parameter(name, value));
    }

    public T addParameter(String name, Class<?> valueClass) {
        return this.addParameter(DynamicReports.parameter(name, valueClass));
    }

    public T addParameter(ParameterBuilder<?> ... parameters) {
        Validate.notNull(parameters, (String)"parameters must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])parameters, (String)"parameters must not contains null parameter", (Object[])new Object[0]);
        ParameterBuilder<?>[] parameterBuilderArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterBuilder<?> parameter = parameterBuilderArray[n2];
            ((DRReport)this.getObject()).addParameter((DRParameter)parameter.build());
            ++n2;
        }
        return (T)this;
    }

    public T setParameter(String name, Object value) {
        ((DRReport)this.getObject()).addParameterValue(name, value);
        return (T)this;
    }

    public T setParameters(Map<String, Object> parameters) {
        ((DRReport)this.getObject()).setParameterValues(parameters);
        return (T)this;
    }

    public T fields(FieldBuilder<?> ... fields) {
        return this.addField(fields);
    }

    public T addField(String name, Class<?> valueClass) {
        return this.addField(DynamicReports.field(name, valueClass));
    }

    public <U> T addField(String name, DRIDataType<? super U, U> dataType) {
        return this.addField(DynamicReports.field(name, dataType));
    }

    public T addField(FieldBuilder<?> ... fields) {
        Validate.notNull(fields, (String)"fields must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])fields, (String)"fields must not contains null field", (Object[])new Object[0]);
        FieldBuilder<?>[] fieldBuilderArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldBuilder<?> field = fieldBuilderArray[n2];
            ((DRReport)this.getObject()).addField((DRField)field.build());
            ++n2;
        }
        return (T)this;
    }

    public T variables(VariableBuilder<?> ... variables) {
        return this.addVariable(variables);
    }

    public T addVariable(VariableBuilder<?> ... variables) {
        Validate.notNull(variables, (String)"variables must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])variables, (String)"variables must not contains null variable", (Object[])new Object[0]);
        VariableBuilder<?>[] variableBuilderArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            VariableBuilder<?> variable = variableBuilderArray[n2];
            ((DRReport)this.getObject()).addVariable(variable.getVariable());
            ++n2;
        }
        return (T)this;
    }

    public T sortBy(TextColumnBuilder<?> ... sortColumns) {
        Validate.notNull(sortColumns, (String)"sortColumns must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])sortColumns, (String)"sortColumns must not contains null sortColumn", (Object[])new Object[0]);
        TextColumnBuilder<?>[] textColumnBuilderArray = sortColumns;
        int n = sortColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TextColumnBuilder<?> sortColumn = textColumnBuilderArray[n2];
            this.sortBy(DynamicReports.asc(sortColumn));
            ++n2;
        }
        return (T)this;
    }

    public T sortBy(SortBuilder ... sorts) {
        return this.addSort(sorts);
    }

    public T addSort(SortBuilder ... sorts) {
        Validate.notNull((Object)sorts, (String)"sorts must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])sorts, (String)"sorts must not contains null sort", (Object[])new Object[0]);
        SortBuilder[] sortBuilderArray = sorts;
        int n = sorts.length;
        int n2 = 0;
        while (n2 < n) {
            SortBuilder sort = sortBuilderArray[n2];
            ((DRReport)this.getObject()).addSort((DRSort)sort.build());
            ++n2;
        }
        return (T)this;
    }

    public T columns(ColumnBuilder<?, ?> ... columns) {
        return this.addColumn(columns);
    }

    public T addColumn(ColumnBuilder<?, ?> ... columns) {
        Validate.notNull(columns, (String)"columns must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])columns, (String)"columns must not contains null column", (Object[])new Object[0]);
        ColumnBuilder<?, ?>[] columnBuilderArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnBuilder<?, ?> column = columnBuilderArray[n2];
            ((DRReport)this.getObject()).addColumn((DRColumn)column.build());
            ++n2;
        }
        return (T)this;
    }

    public T setDefaultFont(FontBuilder defaultFont) {
        if (defaultFont != null) {
            ((DRReport)this.getObject()).setDefaultFont((DRIFont)defaultFont.build());
        } else {
            ((DRReport)this.getObject()).setDefaultFont(null);
        }
        return (T)this;
    }

    public T setTextStyle(ReportStyleBuilder textStyle) {
        if (textStyle != null) {
            ((DRReport)this.getObject()).setTextStyle(textStyle.build());
        } else {
            ((DRReport)this.getObject()).setTextStyle(null);
        }
        return (T)this;
    }

    public T setColumnTitleStyle(ReportStyleBuilder columnTitleStyle) {
        if (columnTitleStyle != null) {
            ((DRReport)this.getObject()).setColumnTitleStyle(columnTitleStyle.build());
        } else {
            ((DRReport)this.getObject()).setColumnTitleStyle(null);
        }
        return (T)this;
    }

    public T setColumnStyle(ReportStyleBuilder columnStyle) {
        if (columnStyle != null) {
            ((DRReport)this.getObject()).setColumnStyle(columnStyle.build());
        } else {
            ((DRReport)this.getObject()).setColumnStyle(null);
        }
        return (T)this;
    }

    public T setGroupTitleStyle(ReportStyleBuilder groupTitleStyle) {
        if (groupTitleStyle != null) {
            ((DRReport)this.getObject()).setGroupTitleStyle(groupTitleStyle.build());
        } else {
            ((DRReport)this.getObject()).setGroupTitleStyle(null);
        }
        return (T)this;
    }

    public T setGroupStyle(ReportStyleBuilder groupStyle) {
        if (groupStyle != null) {
            ((DRReport)this.getObject()).setGroupStyle(groupStyle.build());
        } else {
            ((DRReport)this.getObject()).setGroupStyle(null);
        }
        return (T)this;
    }

    public T setSubtotalStyle(ReportStyleBuilder subtotalStyle) {
        if (subtotalStyle != null) {
            ((DRReport)this.getObject()).setSubtotalStyle(subtotalStyle.build());
        } else {
            ((DRReport)this.getObject()).setSubtotalStyle(null);
        }
        return (T)this;
    }

    public T setImageStyle(ReportStyleBuilder imageStyle) {
        if (imageStyle != null) {
            ((DRReport)this.getObject()).setImageStyle(imageStyle.build());
        } else {
            ((DRReport)this.getObject()).setImageStyle(null);
        }
        return (T)this;
    }

    public T setChartStyle(ReportStyleBuilder chartStyle) {
        if (chartStyle != null) {
            ((DRReport)this.getObject()).setChartStyle(chartStyle.build());
        } else {
            ((DRReport)this.getObject()).setChartStyle(null);
        }
        return (T)this;
    }

    public T setBarcodeStyle(ReportStyleBuilder barcodeStyle) {
        if (barcodeStyle != null) {
            ((DRReport)this.getObject()).setBarcodeStyle(barcodeStyle.build());
        } else {
            ((DRReport)this.getObject()).setBarcodeStyle(null);
        }
        return (T)this;
    }

    public T highlightDetailOddRows() {
        return this.setHighlightDetailOddRows(true);
    }

    public T setHighlightDetailOddRows(Boolean highlightDetailOddRows) {
        ((DRReport)this.getObject()).setHighlightDetailOddRows(highlightDetailOddRows);
        return (T)this;
    }

    public T setDetailOddRowStyle(SimpleStyleBuilder detailOddRowStyle) {
        if (detailOddRowStyle != null) {
            ((DRReport)this.getObject()).setDetailOddRowStyle((DRSimpleStyle)detailOddRowStyle.build());
        } else {
            ((DRReport)this.getObject()).setDetailOddRowStyle(null);
        }
        return (T)this;
    }

    public T highlightDetailEvenRows() {
        return this.setHighlightDetailEvenRows(true);
    }

    public T setHighlightDetailEvenRows(Boolean highlightDetailEvenRows) {
        ((DRReport)this.getObject()).setHighlightDetailEvenRows(highlightDetailEvenRows);
        return (T)this;
    }

    public T setDetailEvenRowStyle(SimpleStyleBuilder detailEvenRowStyle) {
        if (detailEvenRowStyle != null) {
            ((DRReport)this.getObject()).setDetailEvenRowStyle((DRSimpleStyle)detailEvenRowStyle.build());
        } else {
            ((DRReport)this.getObject()).setDetailEvenRowStyle(null);
        }
        return (T)this;
    }

    public T detailRowHighlighters(ConditionalStyleBuilder ... detailRowHighlighters) {
        return this.addDetailRowHighlighter(detailRowHighlighters);
    }

    public T addDetailRowHighlighter(ConditionalStyleBuilder ... detailRowHighlighters) {
        Validate.notNull((Object)detailRowHighlighters, (String)"detailRowHighlighters must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])detailRowHighlighters, (String)"detailRowHighlighters must not contains null detailRowHighlighter", (Object[])new Object[0]);
        ConditionalStyleBuilder[] conditionalStyleBuilderArray = detailRowHighlighters;
        int n = detailRowHighlighters.length;
        int n2 = 0;
        while (n2 < n) {
            ConditionalStyleBuilder conditionalStyleBuilder = conditionalStyleBuilderArray[n2];
            ((DRReport)this.getObject()).addDetailRowHighlighter((DRConditionalStyle)conditionalStyleBuilder.build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtTitle(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtTitle(subtotals);
    }

    public T addSubtotalAtTitle(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.TITLE)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtPageHeader(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtPageHeader(subtotals);
    }

    public T addSubtotalAtPageHeader(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.PAGE_HEADER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtPageFooter(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtPageFooter(subtotals);
    }

    public T addSubtotalAtPageFooter(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.PAGE_FOOTER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtColumnHeader(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtColumnHeader(subtotals);
    }

    public T addSubtotalAtColumnHeader(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.COLUMN_HEADER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtColumnFooter(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtColumnFooter(subtotals);
    }

    public T addSubtotalAtColumnFooter(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.COLUMN_FOOTER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtGroupHeader(GroupBuilder<?> group, SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtGroupHeader(group, subtotals);
    }

    public T addSubtotalAtGroupHeader(GroupBuilder<?> group, SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.GROUP_HEADER)).setGroup(group)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtGroupFooter(GroupBuilder<?> group, SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtGroupFooter(group, subtotals);
    }

    public T addSubtotalAtGroupFooter(GroupBuilder<?> group, SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.GROUP_FOOTER)).setGroup(group)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtFirstGroupHeader(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtFirstGroupHeader(subtotals);
    }

    public T addSubtotalAtFirstGroupHeader(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.FIRST_GROUP_HEADER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtFirstGroupFooter(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtFirstGroupFooter(subtotals);
    }

    public T addSubtotalAtFirstGroupFooter(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.FIRST_GROUP_FOOTER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtLastGroupHeader(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtLastGroupHeader(subtotals);
    }

    public T addSubtotalAtLastGroupHeader(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.LAST_GROUP_HEADER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtLastGroupFooter(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtLastGroupFooter(subtotals);
    }

    public T addSubtotalAtLastGroupFooter(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.LAST_GROUP_FOOTER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtLastPageFooter(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtLastPageFooter(subtotals);
    }

    public T addSubtotalAtLastPageFooter(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.LAST_PAGE_FOOTER)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsAtSummary(SubtotalBuilder<?, ?> ... subtotals) {
        return this.addSubtotalAtSummary(subtotals);
    }

    public T addSubtotalAtSummary(SubtotalBuilder<?, ?> ... subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        SubtotalBuilder<?, ?>[] subtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            SubtotalBuilder<?, ?> subtotal = subtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((SubtotalBuilder)subtotal.setPosition(SubtotalPosition.SUMMARY)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsOfPercentageAtGroupHeader(GroupBuilder<?> group, PercentageSubtotalBuilder ... subtotals) {
        return this.addSubtotalOfPercentageAtGroupHeader(group, subtotals);
    }

    public T addSubtotalOfPercentageAtGroupHeader(GroupBuilder<?> group, PercentageSubtotalBuilder ... subtotals) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        PercentageSubtotalBuilder[] percentageSubtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            PercentageSubtotalBuilder subtotal = percentageSubtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)subtotal.setPosition(SubtotalPosition.GROUP_HEADER)).setGroup(group)).build());
            ++n2;
        }
        return (T)this;
    }

    public T subtotalsOfPercentageAtGroupFooter(GroupBuilder<?> group, PercentageSubtotalBuilder ... subtotals) {
        return this.addSubtotalOfPercentageAtGroupFooter(group, subtotals);
    }

    public T addSubtotalOfPercentageAtGroupFooter(GroupBuilder<?> group, PercentageSubtotalBuilder ... subtotals) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        PercentageSubtotalBuilder[] percentageSubtotalBuilderArray = subtotals;
        int n = subtotals.length;
        int n2 = 0;
        while (n2 < n) {
            PercentageSubtotalBuilder subtotal = percentageSubtotalBuilderArray[n2];
            ((DRReport)this.getObject()).addSubtotal((DRSubtotal)((PercentageSubtotalBuilder)((PercentageSubtotalBuilder)subtotal.setPosition(SubtotalPosition.GROUP_FOOTER)).setGroup(group)).build());
            ++n2;
        }
        return (T)this;
    }

    public T groupBy(ValueColumnBuilder<?, ?> ... groupColumns) {
        Validate.notNull(groupColumns, (String)"groupColumns must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])groupColumns, (String)"groupColumns must not contains null groupColumn", (Object[])new Object[0]);
        ValueColumnBuilder<?, ?>[] valueColumnBuilderArray = groupColumns;
        int n = groupColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ValueColumnBuilder<?, ?> groupColumn = valueColumnBuilderArray[n2];
            this.addGroup(Groups.group(groupColumn));
            ++n2;
        }
        return (T)this;
    }

    public T groupBy(GroupBuilder<?> ... groups) {
        return this.addGroup(groups);
    }

    public T addGroup(GroupBuilder<?> ... groups) {
        Validate.notNull(groups, (String)"groups must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])groups, (String)"groups must not contains null group", (Object[])new Object[0]);
        GroupBuilder<?>[] groupBuilderArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            GroupBuilder<?> group = groupBuilderArray[n2];
            ((DRReport)this.getObject()).addGroup((DRGroup)group.build());
            ++n2;
        }
        return (T)this;
    }

    public T tableOfContents() {
        return this.setTableOfContents(true);
    }

    public T tableOfContents(TableOfContentsCustomizerBuilder tableOfContentsCustomizer) {
        return this.setTableOfContents(tableOfContentsCustomizer);
    }

    public T tableOfContents(DRITableOfContentsCustomizer tableOfContentsCustomizer) {
        return this.setTableOfContents(tableOfContentsCustomizer);
    }

    public T setTableOfContents(Boolean tableOfContents) {
        ((DRReport)this.getObject()).setTableOfContents(tableOfContents);
        return (T)this;
    }

    public T setTableOfContents(TableOfContentsCustomizerBuilder tableOfContentsCustomizer) {
        ((DRReport)this.getObject()).setTableOfContentsCustomizer((DRITableOfContentsCustomizer)tableOfContentsCustomizer.build());
        return this.setTableOfContents(true);
    }

    public T setTableOfContents(DRITableOfContentsCustomizer tableOfContentsCustomizer) {
        ((DRReport)this.getObject()).setTableOfContentsCustomizer(tableOfContentsCustomizer);
        return this.setTableOfContents(true);
    }

    public T setFilterExpression(DRIExpression<Boolean> filterExpression) {
        ((DRReport)this.getObject()).setFilterExpression(filterExpression);
        return (T)this;
    }

    public T setTitleSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getTitleBand().setSplitType(splitType);
        return (T)this;
    }

    public T setTitleStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getTitleBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getTitleBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setTitleBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getTitleBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T title(ComponentBuilder<?, ?> ... components) {
        return this.addTitle(components);
    }

    public T addTitle(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getTitleBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setPageHeaderSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getPageHeaderBand().setSplitType(splitType);
        return (T)this;
    }

    public T setPageHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getPageHeaderBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getPageHeaderBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setPageHeaderBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getPageHeaderBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T pageHeader(ComponentBuilder<?, ?> ... components) {
        return this.addPageHeader(components);
    }

    public T addPageHeader(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getPageHeaderBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setPageFooterSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getPageFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setPageFooterStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getPageFooterBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getPageFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setPageFooterBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getPageFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T pageFooter(ComponentBuilder<?, ?> ... components) {
        return this.addPageFooter(components);
    }

    public T addPageFooter(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getPageFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setColumnHeaderSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getColumnHeaderBand().setSplitType(splitType);
        return (T)this;
    }

    public T setColumnHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getColumnHeaderBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getColumnHeaderBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setColumnHeaderBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getColumnHeaderBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T columnHeader(ComponentBuilder<?, ?> ... components) {
        return this.addColumnHeader(components);
    }

    public T addColumnHeader(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getColumnHeaderBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setColumnFooterSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getColumnFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setColumnFooterStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getColumnFooterBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getColumnFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setColumnFooterBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getColumnFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T columnFooter(ComponentBuilder<?, ?> ... components) {
        return this.addColumnFooter(components);
    }

    public T addColumnFooter(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getColumnFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setGroupHeaderSplitType(GroupBuilder<?> group, SplitType splitType) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        drGroup.getHeaderBand().setSplitType(splitType);
        return (T)this;
    }

    public T setGroupHeaderStyle(GroupBuilder<?> group, ReportStyleBuilder style) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        if (style != null) {
            drGroup.getHeaderBand().getList().setStyle(style.build());
        } else {
            drGroup.getHeaderBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setGroupHeaderBackgroundComponent(GroupBuilder<?> group, ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        drGroup.getHeaderBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T groupHeader(GroupBuilder<?> group, ComponentBuilder<?, ?> ... components) {
        return this.addGroupHeader(group, components);
    }

    public T addGroupHeader(GroupBuilder<?> group, ComponentBuilder<?, ?> ... components) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            drGroup.getHeaderBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setGroupFooterSplitType(GroupBuilder<?> group, SplitType splitType) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        drGroup.getFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setGroupFooterStyle(GroupBuilder<?> group, ReportStyleBuilder style) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        if (style != null) {
            drGroup.getFooterBand().getList().setStyle(style.build());
        } else {
            drGroup.getFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setGroupFooterBackgroundComponent(GroupBuilder<?> group, ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        drGroup.getFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T groupFooter(GroupBuilder<?> group, ComponentBuilder<?, ?> ... components) {
        return this.addGroupFooter(group, components);
    }

    public T addGroupFooter(GroupBuilder<?> group, ComponentBuilder<?, ?> ... components) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        int index = ((DRReport)this.getObject()).getGroups().indexOf(group.getGroup());
        Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"group must be registered", (Object[])new Object[0]);
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        DRGroup drGroup = ((DRReport)this.getObject()).getGroups().get(index);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            drGroup.getFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setDetailSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getDetailBand().setSplitType(splitType);
        return (T)this;
    }

    public T setDetailStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getDetailBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getDetailBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setDetailBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getDetailBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T detail(ComponentBuilder<?, ?> ... components) {
        return this.addDetail(components);
    }

    public T addDetail(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getDetailBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setDetailHeaderSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getDetailHeaderBand().setSplitType(splitType);
        return (T)this;
    }

    public T setDetailHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getDetailHeaderBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getDetailHeaderBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setDetailHeaderBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getDetailHeaderBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T detailHeader(ComponentBuilder<?, ?> ... components) {
        return this.addDetailHeader(components);
    }

    public T addDetailHeader(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getDetailHeaderBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setDetailFooterSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getDetailFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setDetailFooterStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getDetailFooterBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getDetailFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setDetailFooterBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getDetailFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T detailFooter(ComponentBuilder<?, ?> ... components) {
        return this.addDetailFooter(components);
    }

    public T addDetailFooter(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getDetailFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setLastPageFooterSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getLastPageFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setLastPageFooterStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getLastPageFooterBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getLastPageFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setLastPageFooterBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getLastPageFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T lastPageFooter(ComponentBuilder<?, ?> ... components) {
        return this.addLastPageFooter(components);
    }

    public T addLastPageFooter(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getLastPageFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setSummarySplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getSummaryBand().setSplitType(splitType);
        return (T)this;
    }

    public T setSummaryStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getSummaryBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getSummaryBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setSummaryBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getSummaryBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T summary(ComponentBuilder<?, ?> ... components) {
        return this.addSummary(components);
    }

    public T addSummary(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getSummaryBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setNoDataSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getNoDataBand().setSplitType(splitType);
        return (T)this;
    }

    public T setNoDataStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getNoDataBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getNoDataBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setNoDataBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getNoDataBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T noData(ComponentBuilder<?, ?> ... components) {
        return this.addNoData(components);
    }

    public T addNoData(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getNoDataBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T setBackgroundSplitType(SplitType splitType) {
        ((DRReport)this.getObject()).getBackgroundBand().setSplitType(splitType);
        return (T)this;
    }

    public T setBackgroundStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRReport)this.getObject()).getBackgroundBand().getList().setStyle(style.build());
        } else {
            ((DRReport)this.getObject()).getBackgroundBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setBackgroundBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).getBackgroundBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T background(ComponentBuilder<?, ?> ... components) {
        return this.addBackground(components);
    }

    public T addBackground(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRReport)this.getObject()).getBackgroundBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public DRReport getReport() {
        return (DRReport)this.build();
    }
}

