/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import java.sql.Connection;
import net.sf.dynamicreports.report.base.DRDataset;
import net.sf.dynamicreports.report.base.chart.DRChart;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.builder.DatasetBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.HyperLinkComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.Position;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang3.Validate;

public abstract class AbstractChartBuilder<T extends AbstractChartBuilder<T>>
extends HyperLinkComponentBuilder<T, DRChart> {
    private static final long serialVersionUID = 10000L;

    protected AbstractChartBuilder(ChartType chartType) {
        super(new DRChart(chartType));
    }

    @Deprecated
    public T setCustomizer(DRIChartCustomizer customizer) {
        return this.customizers(customizer);
    }

    public T addCustomizer(DRIChartCustomizer ... customizers) {
        return this.customizers(customizers);
    }

    public T customizers(DRIChartCustomizer ... customizers) {
        Validate.notNull((Object)customizers, (String)"customizers must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])customizers, (String)"customizers must not contains null customizer", (Object[])new Object[0]);
        DRIChartCustomizer[] dRIChartCustomizerArray = customizers;
        int n = customizers.length;
        int n2 = 0;
        while (n2 < n) {
            DRIChartCustomizer customizer = dRIChartCustomizerArray[n2];
            ((DRChart)this.getObject()).addCustomizer(customizer);
            ++n2;
        }
        return (T)this;
    }

    public T setTitle(String title) {
        ((DRChart)this.getObject()).getTitle().setTitle(Expressions.text(title));
        return (T)this;
    }

    public T setTitle(DRIExpression<String> titleExpression) {
        ((DRChart)this.getObject()).getTitle().setTitle(titleExpression);
        return (T)this;
    }

    public T setTitleColor(Color titleColor) {
        ((DRChart)this.getObject()).getTitle().setColor(titleColor);
        return (T)this;
    }

    public T setTitleFont(FontBuilder titleFont) {
        Validate.notNull((Object)titleFont, (String)"titleFont must not be null", (Object[])new Object[0]);
        ((DRChart)this.getObject()).getTitle().setFont((DRFont)titleFont.build());
        return (T)this;
    }

    public T setTitlePosition(Position titlePosition) {
        ((DRChart)this.getObject()).getTitle().setPosition(titlePosition);
        return (T)this;
    }

    public T setSubtitle(String subtitle) {
        ((DRChart)this.getObject()).getSubtitle().setTitle(Expressions.text(subtitle));
        return (T)this;
    }

    public T setSubtitle(DRIExpression<String> subtitleExpression) {
        ((DRChart)this.getObject()).getSubtitle().setTitle(subtitleExpression);
        return (T)this;
    }

    public T setSubtitleColor(Color subtitleColor) {
        ((DRChart)this.getObject()).getSubtitle().setColor(subtitleColor);
        return (T)this;
    }

    public T setSubtitleFont(FontBuilder subtitleFont) {
        Validate.notNull((Object)subtitleFont, (String)"subtitleFont must not be null", (Object[])new Object[0]);
        ((DRChart)this.getObject()).getSubtitle().setFont((DRFont)subtitleFont.build());
        return (T)this;
    }

    public T setLegendColor(Color legendColor) {
        ((DRChart)this.getObject()).getLegend().setColor(legendColor);
        return (T)this;
    }

    public T setLegendBackgroundColor(Color legendBackgroundColor) {
        ((DRChart)this.getObject()).getLegend().setBackgroundColor(legendBackgroundColor);
        return (T)this;
    }

    public T setShowLegend(Boolean showLegend) {
        ((DRChart)this.getObject()).getLegend().setShowLegend(showLegend);
        return (T)this;
    }

    public T setLegendFont(FontBuilder legendFont) {
        Validate.notNull((Object)legendFont, (String)"legendFont must not be null", (Object[])new Object[0]);
        ((DRChart)this.getObject()).getLegend().setFont((DRFont)legendFont.build());
        return (T)this;
    }

    public T setLegendPosition(Position legendPosition) {
        ((DRChart)this.getObject()).getLegend().setPosition(legendPosition);
        return (T)this;
    }

    public T setSubDataset(DatasetBuilder subDataset) {
        Validate.notNull((Object)subDataset, (String)"subDataset must not be null", (Object[])new Object[0]);
        ((DRChart)this.getObject()).getDataset().setSubDataset((DRDataset)subDataset.build());
        return (T)this;
    }

    public T setDataSource(JRDataSource dataSource) {
        DatasetBuilder dataset = DynamicReports.dataset();
        dataset.setDataSource(dataSource);
        return this.setSubDataset(dataset);
    }

    public T setDataSource(DRIExpression<JRDataSource> dataSourceExpression) {
        DatasetBuilder dataset = DynamicReports.dataset();
        dataset.setDataSource(dataSourceExpression);
        return this.setSubDataset(dataset);
    }

    public T setDataSource(String sql, Connection connection) {
        DatasetBuilder dataset = DynamicReports.dataset();
        dataset.setDataSource(sql, connection);
        return this.setSubDataset(dataset);
    }

    public DRChart getChart() {
        return (DRChart)this.build();
    }
}

