/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import net.sf.dynamicreports.report.base.chart.dataset.DRChartDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRMultiAxisPlot;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.constant.AxisPosition;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.definition.chart.DRIChart;
import org.apache.commons.lang3.Validate;

public class MultiAxisChartBuilder
extends AbstractBaseChartBuilder<MultiAxisChartBuilder, DRMultiAxisPlot, DRChartDataset> {
    private static final long serialVersionUID = 10000L;

    protected MultiAxisChartBuilder() {
        super(ChartType.MULTI_AXIS);
    }

    public MultiAxisChartBuilder charts(AbstractBaseChartBuilder<?, ?, ?> ... charts) {
        return this.addChart(charts);
    }

    public MultiAxisChartBuilder addChart(AbstractBaseChartBuilder<?, ?, ?> ... charts) {
        Validate.notNull(charts, (String)"charts must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])charts, (String)"charts must not contains null chart", (Object[])new Object[0]);
        AbstractBaseChartBuilder<?, ?, ?>[] abstractBaseChartBuilderArray = charts;
        int n = charts.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBaseChartBuilder<?, ?, ?> chart = abstractBaseChartBuilderArray[n2];
            ((DRMultiAxisPlot)this.getPlot()).addChart((DRIChart)chart.build());
            ++n2;
        }
        return this;
    }

    public MultiAxisChartBuilder addChart(AbstractBaseChartBuilder<?, ?, ?> chart, AxisPosition position) {
        Validate.notNull(chart, (String)"chart must not be null", (Object[])new Object[0]);
        ((DRMultiAxisPlot)this.getPlot()).addChart((DRIChart)chart.build(), position);
        return this;
    }

    public MultiAxisChartBuilder setXAxisFormat(AxisFormatBuilder xAxisFormat) {
        Validate.notNull((Object)xAxisFormat, (String)"xAxisFormat must not be null", (Object[])new Object[0]);
        ((DRMultiAxisPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)xAxisFormat.build());
        return this;
    }

    public MultiAxisChartBuilder setYAxisFormat(AxisFormatBuilder yAxisFormat) {
        Validate.notNull((Object)yAxisFormat, (String)"yAxisFormat must not be null", (Object[])new Object[0]);
        ((DRMultiAxisPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)yAxisFormat.build());
        return this;
    }
}

