/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.BooleanColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ComponentColumnBuilder;
import net.sf.dynamicreports.report.builder.column.PercentageColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class Columns {
    public static <T> TextColumnBuilder<T> column(String fieldName, Class<T> valueClass) {
        return Columns.column(DynamicReports.field(fieldName, valueClass));
    }

    public static <T> TextColumnBuilder<T> column(String title, String fieldName, Class<T> valueClass) {
        return Columns.column(title, DynamicReports.field(fieldName, valueClass));
    }

    public static <T> TextColumnBuilder<T> column(String fieldName, DRIDataType<? super T, T> dataType) {
        Validate.notNull(dataType, (String)"dataType must not be null", (Object[])new Object[0]);
        TextColumnBuilder<T> textColumnBuilder = new TextColumnBuilder<T>(DynamicReports.field(fieldName, dataType.getValueClass()));
        textColumnBuilder.setDataType(dataType);
        return textColumnBuilder;
    }

    public static <T> TextColumnBuilder<T> column(String title, String fieldName, DRIDataType<? super T, T> dataType) {
        TextColumnBuilder<T> textColumnBuilder = Columns.column(fieldName, dataType);
        textColumnBuilder.setTitle(title);
        return textColumnBuilder;
    }

    public static <T> TextColumnBuilder<T> column(FieldBuilder<T> field) {
        TextColumnBuilder<T> textColumnBuilder = new TextColumnBuilder<T>(field);
        if (field.getField().getDataType() != null) {
            textColumnBuilder.setDataType(field.getField().getDataType());
        }
        return textColumnBuilder;
    }

    public static <T> TextColumnBuilder<T> column(String title, FieldBuilder<T> field) {
        return (TextColumnBuilder)Columns.column(field).setTitle(title);
    }

    public static <T> TextColumnBuilder<T> column(DRIExpression<T> expression) {
        TextColumnBuilder<T> textColumnBuilder = new TextColumnBuilder<T>(expression);
        if (expression instanceof DRIField && ((DRIField)expression).getDataType() != null) {
            textColumnBuilder.setDataType(((DRIField)expression).getDataType());
        }
        return textColumnBuilder;
    }

    public static <T> TextColumnBuilder<T> column(String title, DRIExpression<T> expression) {
        return (TextColumnBuilder)Columns.column(expression).setTitle(title);
    }

    public static PercentageColumnBuilder percentageColumn(ValueColumnBuilder<?, ? extends Number> column) {
        return new PercentageColumnBuilder(column);
    }

    public static PercentageColumnBuilder percentageColumn(String title, ValueColumnBuilder<?, ? extends Number> column) {
        return (PercentageColumnBuilder)Columns.percentageColumn(column).setTitle(title);
    }

    public static PercentageColumnBuilder percentageColumn(String fieldName, Class<? extends Number> valueClass) {
        return Columns.percentageColumn(DynamicReports.field(fieldName, valueClass));
    }

    public static PercentageColumnBuilder percentageColumn(String title, String fieldName, Class<? extends Number> valueClass) {
        return (PercentageColumnBuilder)Columns.percentageColumn(fieldName, valueClass).setTitle(title);
    }

    public static PercentageColumnBuilder percentageColumn(FieldBuilder<? extends Number> field) {
        return new PercentageColumnBuilder(field);
    }

    public static PercentageColumnBuilder percentageColumn(String title, FieldBuilder<? extends Number> field) {
        return (PercentageColumnBuilder)Columns.percentageColumn(field).setTitle(title);
    }

    public static TextColumnBuilder<Integer> columnRowNumberColumn() {
        return Columns.column(Expressions.columnRowNumber());
    }

    public static TextColumnBuilder<Integer> columnRowNumberColumn(String title) {
        return (TextColumnBuilder)Columns.columnRowNumberColumn().setTitle(title);
    }

    public static TextColumnBuilder<Integer> pageRowNumberColumn() {
        return Columns.column(Expressions.pageRowNumber());
    }

    public static TextColumnBuilder<Integer> pageRowNumberColumn(String title) {
        return (TextColumnBuilder)Columns.pageRowNumberColumn().setTitle(title);
    }

    public static TextColumnBuilder<Integer> reportRowNumberColumn() {
        return Columns.column(Expressions.reportRowNumber());
    }

    public static TextColumnBuilder<Integer> reportRowNumberColumn(String title) {
        return (TextColumnBuilder)Columns.reportRowNumberColumn().setTitle(title);
    }

    public static ComponentColumnBuilder componentColumn(ComponentBuilder<?, ?> component) {
        Validate.notNull(component, (String)"component must not be null", (Object[])new Object[0]);
        return new ComponentColumnBuilder(component);
    }

    public static ComponentColumnBuilder componentColumn(String title, ComponentBuilder<?, ?> component) {
        return (ComponentColumnBuilder)Columns.componentColumn(component).setTitle(title);
    }

    public static BooleanColumnBuilder booleanColumn(String fieldName) {
        return Columns.booleanColumn(DynamicReports.field(fieldName, Boolean.class));
    }

    public static BooleanColumnBuilder booleanColumn(String title, String fieldName) {
        return Columns.booleanColumn(title, DynamicReports.field(fieldName, Boolean.class));
    }

    public static BooleanColumnBuilder booleanColumn(FieldBuilder<Boolean> field) {
        return new BooleanColumnBuilder(field);
    }

    public static BooleanColumnBuilder booleanColumn(String title, FieldBuilder<Boolean> field) {
        return (BooleanColumnBuilder)Columns.booleanColumn(field).setTitle(title);
    }

    public static BooleanColumnBuilder booleanColumn(DRIExpression<Boolean> expression) {
        return new BooleanColumnBuilder(expression);
    }

    public static BooleanColumnBuilder booleanColumn(String title, DRIExpression<Boolean> expression) {
        return (BooleanColumnBuilder)Columns.booleanColumn(expression).setTitle(title);
    }
}

