/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import net.sf.dynamicreports.report.base.column.DRValueColumn;
import net.sf.dynamicreports.report.base.component.DRDimensionComponent;
import net.sf.dynamicreports.report.base.component.DRHyperLinkComponent;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;

public abstract class ValueColumnBuilder<T extends ValueColumnBuilder<T, U>, U>
extends ColumnBuilder<T, DRValueColumn<U>> {
    private static final long serialVersionUID = 10000L;

    protected ValueColumnBuilder() {
        super(new DRValueColumn(new DRTextField()));
    }

    protected void setValueExpression(DRIExpression<U> valueExpression) {
        ((DRTextField)this.getComponent()).setValueExpression(valueExpression);
    }

    public T setPrintRepeatedDetailValues(Boolean printRepeatedDetailValues) {
        ((DRValueColumn)this.getObject()).setPrintRepeatedDetailValues(printRepeatedDetailValues);
        return (T)this;
    }

    public T setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        ((DRTextField)this.getComponent()).setHorizontalAlignment(horizontalAlignment);
        return (T)this;
    }

    public T setPattern(String pattern) {
        ((DRTextField)this.getComponent()).setPattern(pattern);
        return (T)this;
    }

    public T setPattern(DRIExpression<String> patternExpression) {
        ((DRTextField)this.getComponent()).setPatternExpression(patternExpression);
        return (T)this;
    }

    public T setValueFormatter(DRIValueFormatter<?, ? super U> valueFormatter) {
        ((DRTextField)this.getComponent()).setValueFormatter(valueFormatter);
        return (T)this;
    }

    public T setDataType(DRIDataType<? super U, U> dataType) {
        ((DRTextField)this.getComponent()).setDataType(dataType);
        return (T)this;
    }

    public T setColumns(Integer columns) {
        ((DRTextField)this.getComponent()).setColumns(columns);
        return (T)this;
    }

    public T setFixedColumns(Integer columns) {
        ((DRTextField)this.getComponent()).setColumns(columns);
        ((DRDimensionComponent)this.getComponent()).setWidthType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinColumns(Integer columns) {
        ((DRTextField)this.getComponent()).setColumns(columns);
        ((DRDimensionComponent)this.getComponent()).setWidthType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setRows(Integer rows) {
        ((DRTextField)this.getComponent()).setRows(rows);
        return (T)this;
    }

    public T setFixedRows(Integer rows) {
        ((DRTextField)this.getComponent()).setRows(rows);
        ((DRDimensionComponent)this.getComponent()).setHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinRows(Integer rows) {
        ((DRTextField)this.getComponent()).setRows(rows);
        ((DRDimensionComponent)this.getComponent()).setHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setAnchorName(String anchorName) {
        ((DRHyperLinkComponent)this.getComponent()).setAnchorNameExpression(Expressions.text(anchorName));
        return (T)this;
    }

    public T setAnchorName(DRIExpression<String> anchorNameExpression) {
        ((DRHyperLinkComponent)this.getComponent()).setAnchorNameExpression(anchorNameExpression);
        return (T)this;
    }

    public T setBookmarkLevel(Integer bookmarkLevel) {
        ((DRHyperLinkComponent)this.getComponent()).setBookmarkLevel(bookmarkLevel);
        return (T)this;
    }

    public T setHyperLink(HyperLinkBuilder hyperLink) {
        if (hyperLink != null) {
            ((DRHyperLinkComponent)this.getComponent()).setHyperLink(hyperLink.getHyperLink());
        } else {
            ((DRHyperLinkComponent)this.getComponent()).setHyperLink(null);
        }
        return (T)this;
    }

    public T setWidth(Integer width) {
        ((DRDimensionComponent)this.getComponent()).setWidth(width);
        return (T)this;
    }

    public T setFixedWidth(Integer width) {
        ((DRDimensionComponent)this.getComponent()).setWidth(width);
        ((DRDimensionComponent)this.getComponent()).setWidthType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinWidth(Integer width) {
        ((DRDimensionComponent)this.getComponent()).setWidth(width);
        ((DRDimensionComponent)this.getComponent()).setWidthType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setHeight(Integer height) {
        ((DRDimensionComponent)this.getComponent()).setHeight(height);
        return (T)this;
    }

    public T setFixedHeight(Integer height) {
        ((DRDimensionComponent)this.getComponent()).setHeight(height);
        ((DRDimensionComponent)this.getComponent()).setHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setMinHeight(Integer height) {
        ((DRDimensionComponent)this.getComponent()).setHeight(height);
        ((DRDimensionComponent)this.getComponent()).setHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRTextField)this.getComponent()).setStretchWithOverflow(stretchWithOverflow);
        return (T)this;
    }

    public T printInFirstWholeBand() {
        return this.setPrintInFirstWholeBand(true);
    }

    public T setPrintInFirstWholeBand(Boolean printInFirstWholeBand) {
        ((DRDimensionComponent)this.getComponent()).setPrintInFirstWholeBand(printInFirstWholeBand);
        return (T)this;
    }

    public T printWhenDetailOverflows() {
        return this.setPrintWhenDetailOverflows(true);
    }

    public T setPrintWhenDetailOverflows(Boolean printWhenDetailOverflows) {
        ((DRDimensionComponent)this.getComponent()).setPrintWhenDetailOverflows(printWhenDetailOverflows);
        return (T)this;
    }

    public T addProperty(DRIPropertyExpression propertyExpression) {
        this.getComponent().addPropertyExpression(propertyExpression);
        return (T)this;
    }

    public T addProperty(String name, DRIExpression<String> valueExpression) {
        this.getComponent().addPropertyExpression(Expressions.property(name, valueExpression));
        return (T)this;
    }

    public T addProperty(String name, String value) {
        this.getComponent().addPropertyExpression(Expressions.property(name, value));
        return (T)this;
    }

    @Override
    protected DRTextField<U> getComponent() {
        return (DRTextField)((DRValueColumn)this.getObject()).getComponent();
    }
}

