/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.condition;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import org.apache.commons.lang3.Validate;

public abstract class AbstractBetweenValueExpression<T extends Number>
extends AbstractSimpleExpression<Boolean> {
    private static final long serialVersionUID = 10000L;
    private DRIValue<T> value;
    private Number min;
    private Number max;

    public AbstractBetweenValueExpression(DRIValue<T> value, Number min, Number max) {
        Validate.notNull(value, (String)"value must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)min, (String)"min must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)max, (String)"min must not be null", (Object[])new Object[0]);
        Validate.isTrue((min.doubleValue() < max.doubleValue() ? 1 : 0) != 0, (String)"min < max", (Object[])new Object[0]);
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @Override
    public Boolean evaluate(ReportParameters reportParameters) {
        Number actualValue = (Number)reportParameters.getValue(this.value);
        if (actualValue != null) {
            return this.compare(actualValue, this.min, this.max);
        }
        return false;
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    protected abstract Boolean compare(Number var1, Number var2, Number var3);
}

