/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.crosstab;

import java.util.Comparator;
import net.sf.dynamicreports.report.base.column.DRValueColumn;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabGroup;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.CrosstabTotalPosition;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import org.apache.commons.lang3.Validate;

public abstract class AbstractCrosstabGroupBuilder<T extends AbstractCrosstabGroupBuilder<T, U, V>, U extends DRCrosstabGroup<V>, V>
extends AbstractBuilder<T, U>
implements DRIValue<V> {
    private static final long serialVersionUID = 10000L;

    protected AbstractCrosstabGroupBuilder(ValueColumnBuilder<?, V> column, U crosstabGroup) {
        super(crosstabGroup);
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        DRValueColumn col = (DRValueColumn)column.getColumn();
        ((DRCrosstabGroup)this.getObject()).setExpression(col);
        ((DRCrosstabGroup)this.getObject()).setDataType(((DRITextField)col.getComponent()).getDataType());
        ((DRCrosstabGroup)this.getObject()).setHeaderPattern(((DRITextField)col.getComponent()).getPattern());
    }

    protected AbstractCrosstabGroupBuilder(FieldBuilder<V> field, U crosstabGroup) {
        super(crosstabGroup);
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRCrosstabGroup)this.getObject()).setExpression(field.getField());
        ((DRCrosstabGroup)this.getObject()).setDataType(field.getField().getDataType());
    }

    protected AbstractCrosstabGroupBuilder(DRIExpression<V> expression, U crosstabGroup) {
        super(crosstabGroup);
        ((DRCrosstabGroup)this.getObject()).setExpression(expression);
        if (expression instanceof DRIField) {
            ((DRCrosstabGroup)this.getObject()).setDataType(((DRIField)expression).getDataType());
        }
    }

    public T setHeaderPattern(String pattern) {
        ((DRCrosstabGroup)this.getObject()).setHeaderPattern(pattern);
        return (T)this;
    }

    public T setHeaderHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        ((DRCrosstabGroup)this.getObject()).setHeaderHorizontalAlignment(horizontalAlignment);
        return (T)this;
    }

    public T setHeaderValueFormatter(DRIValueFormatter<?, ? super V> valueFormatter) {
        ((DRCrosstabGroup)this.getObject()).setHeaderValueFormatter(valueFormatter);
        return (T)this;
    }

    public T setHeaderStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRCrosstabGroup)this.getObject()).setHeaderStretchWithOverflow(stretchWithOverflow);
        return (T)this;
    }

    public T setHeaderHyperLink(HyperLinkBuilder hyperLink) {
        if (hyperLink != null) {
            ((DRCrosstabGroup)this.getObject()).setHeaderHyperLink(hyperLink.getHyperLink());
        } else {
            ((DRCrosstabGroup)this.getObject()).setHeaderHyperLink(null);
        }
        return (T)this;
    }

    public T setHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRCrosstabGroup)this.getObject()).setHeaderStyle(style.getStyle());
        } else {
            ((DRCrosstabGroup)this.getObject()).setHeaderStyle(null);
        }
        return (T)this;
    }

    public T setShowTotal(Boolean showTotal) {
        ((DRCrosstabGroup)this.getObject()).setShowTotal(showTotal);
        return (T)this;
    }

    public T setTotalPosition(CrosstabTotalPosition totalPosition) {
        ((DRCrosstabGroup)this.getObject()).setTotalPosition(totalPosition);
        return (T)this;
    }

    public T setTotalHeader(DRIExpression<?> totalHeaderExpression) {
        ((DRCrosstabGroup)this.getObject()).setTotalHeaderExpression(totalHeaderExpression);
        return (T)this;
    }

    public T setTotalHeader(String totalHeader) {
        ((DRCrosstabGroup)this.getObject()).setTotalHeaderExpression(Expressions.text(totalHeader));
        return (T)this;
    }

    public T setTotalHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRCrosstabGroup)this.getObject()).setTotalHeaderStyle(style.getStyle());
        } else {
            ((DRCrosstabGroup)this.getObject()).setTotalHeaderStyle(null);
        }
        return (T)this;
    }

    public T setDataType(DRIDataType<? super V, V> dataType) {
        ((DRCrosstabGroup)this.getObject()).setDataType(dataType);
        return (T)this;
    }

    public T setOrderType(OrderType orderType) {
        ((DRCrosstabGroup)this.getObject()).setOrderType(orderType);
        return (T)this;
    }

    public T setOrderByExpression(DRIExpression<? extends Comparable<?>> orderByExpression) {
        return this.orderBy(orderByExpression);
    }

    public T orderBy(CrosstabMeasureBuilder<? extends Comparable<?>> measure) {
        return this.orderBy(Expressions.orderBy(measure));
    }

    public T orderBy(DRIExpression<? extends Comparable<?>> orderByExpression) {
        ((DRCrosstabGroup)this.getObject()).setOrderByExpression(orderByExpression);
        return (T)this;
    }

    public T setComparatorExpression(DRIExpression<? extends Comparator<?>> comparatorExpression) {
        ((DRCrosstabGroup)this.getObject()).setComparatorExpression(comparatorExpression);
        return (T)this;
    }

    @Override
    public String getName() {
        return ((DRCrosstabGroup)this.getObject()).getName();
    }
}

