/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.crosstab;

import net.sf.dynamicreports.report.base.column.DRValueColumn;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabCellStyle;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabMeasure;
import net.sf.dynamicreports.report.base.crosstab.DRCrosstabVariable;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.Crosstabs;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.CrosstabPercentageType;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.definition.DRICrosstabValue;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabColumnGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabRowGroup;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.exception.DRReportException;
import org.apache.commons.lang3.Validate;

public class CrosstabMeasureBuilder<T>
extends AbstractBuilder<CrosstabMeasureBuilder<T>, DRCrosstabMeasure<T>>
implements DRICrosstabValue<T> {
    private static final long serialVersionUID = 10000L;

    protected CrosstabMeasureBuilder(ValueColumnBuilder<?, ?> column, Calculation calculation) {
        super(new DRCrosstabMeasure((DRIExpression)Crosstabs.variable(column, calculation).build()));
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            this.setDataType(DataTypes.longType());
        } else if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            this.setDataType(DataTypes.doubleType());
        } else {
            DRITextField columnComponent = (DRITextField)((DRValueColumn)column.getColumn()).getComponent();
            this.setDataType(columnComponent.getDataType());
            this.setPattern(columnComponent.getPattern());
        }
    }

    protected CrosstabMeasureBuilder(FieldBuilder<?> field, Calculation calculation) {
        super(new DRCrosstabMeasure((DRIExpression)Crosstabs.variable(field, calculation).build()));
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            this.setDataType(DataTypes.longType());
        } else if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            this.setDataType(DataTypes.doubleType());
        } else {
            this.setDataType(field.getField().getDataType());
        }
    }

    protected CrosstabMeasureBuilder(DRIExpression<?> expression, Calculation calculation) {
        super(new DRCrosstabMeasure((DRIExpression)Crosstabs.variable(expression, calculation).build()));
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            this.setDataType(DataTypes.longType());
        } else if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            this.setDataType(DataTypes.doubleType());
        } else if (expression instanceof DRIField) {
            this.setDataType(((DRIField)expression).getDataType());
        }
    }

    protected CrosstabMeasureBuilder(DRIExpression<?> expression) {
        super(new DRCrosstabMeasure(expression));
    }

    public CrosstabMeasureBuilder<T> setDataType(DRIDataType dataType) {
        ((DRCrosstabMeasure)this.getObject()).setDataType(dataType);
        return this;
    }

    public CrosstabMeasureBuilder<T> setPercentageType(CrosstabPercentageType percentageType) {
        DRCrosstabVariable variable;
        if (((DRCrosstabMeasure)this.getObject()).getExpression() instanceof DRCrosstabVariable) {
            variable = (DRCrosstabVariable)((DRCrosstabMeasure)this.getObject()).getExpression();
            if (percentageType != null && percentageType.equals((Object)CrosstabPercentageType.GRAND_TOTAL) && !variable.getCalculation().equals((Object)Calculation.COUNT) && !variable.getCalculation().equals((Object)Calculation.DISTINCT_COUNT)) {
                this.setDataType(DataTypes.doubleType());
            }
        } else {
            throw new DRReportException("Percentage is not supported in this type of measure");
        }
        variable.setPercentageType(percentageType);
        return this;
    }

    public CrosstabMeasureBuilder<T> setPattern(String pattern) {
        ((DRCrosstabMeasure)this.getObject()).setPattern(pattern);
        return this;
    }

    public CrosstabMeasureBuilder<T> setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        ((DRCrosstabMeasure)this.getObject()).setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public CrosstabMeasureBuilder<T> setValueFormatter(DRIValueFormatter<?, ? super T> valueFormatter) {
        ((DRCrosstabMeasure)this.getObject()).setValueFormatter(valueFormatter);
        return this;
    }

    public CrosstabMeasureBuilder<T> setStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRCrosstabMeasure)this.getObject()).setStretchWithOverflow(stretchWithOverflow);
        return this;
    }

    public CrosstabMeasureBuilder<T> setHyperLink(HyperLinkBuilder hyperLink) {
        if (hyperLink != null) {
            ((DRCrosstabMeasure)this.getObject()).setHyperLink(hyperLink.getHyperLink());
        } else {
            ((DRCrosstabMeasure)this.getObject()).setHyperLink(null);
        }
        return this;
    }

    public CrosstabMeasureBuilder<T> setStyle(ReportStyleBuilder style) {
        Validate.notNull((Object)style, (String)"style must not be null", (Object[])new Object[0]);
        ((DRCrosstabMeasure)this.getObject()).getStyles().add(new DRCrosstabCellStyle(style.getStyle()));
        return this;
    }

    public CrosstabMeasureBuilder<T> setStyle(ReportStyleBuilder style, CrosstabRowGroupBuilder<?> rowGroup) {
        Validate.notNull((Object)style, (String)"style must not be null", (Object[])new Object[0]);
        Validate.notNull(rowGroup, (String)"rowGroup must not be null", (Object[])new Object[0]);
        ((DRCrosstabMeasure)this.getObject()).getStyles().add(new DRCrosstabCellStyle(style.getStyle(), (DRICrosstabRowGroup)rowGroup.build(), null));
        return this;
    }

    public CrosstabMeasureBuilder<T> setStyle(ReportStyleBuilder style, CrosstabColumnGroupBuilder<?> columnGroup) {
        Validate.notNull((Object)style, (String)"style must not be null", (Object[])new Object[0]);
        Validate.notNull(columnGroup, (String)"columnGroup must not be null", (Object[])new Object[0]);
        ((DRCrosstabMeasure)this.getObject()).getStyles().add(new DRCrosstabCellStyle(style.getStyle(), null, (DRICrosstabColumnGroup)columnGroup.build()));
        return this;
    }

    public CrosstabMeasureBuilder<T> setStyle(ReportStyleBuilder style, CrosstabRowGroupBuilder<?> rowGroup, CrosstabColumnGroupBuilder<?> columnGroup) {
        Validate.notNull((Object)style, (String)"style must not be null", (Object[])new Object[0]);
        Validate.notNull(rowGroup, (String)"rowGroup must not be null", (Object[])new Object[0]);
        Validate.notNull(columnGroup, (String)"columnGroup must not be null", (Object[])new Object[0]);
        ((DRCrosstabMeasure)this.getObject()).getStyles().add(new DRCrosstabCellStyle(style.getStyle(), (DRICrosstabRowGroup)rowGroup.build(), (DRICrosstabColumnGroup)columnGroup.build()));
        return this;
    }

    public CrosstabMeasureBuilder<T> setTitle(DRIExpression<?> titleExpression) {
        ((DRCrosstabMeasure)this.getObject()).setTitleExpression(titleExpression);
        return this;
    }

    public CrosstabMeasureBuilder<T> setTitle(String title) {
        ((DRCrosstabMeasure)this.getObject()).setTitleExpression(Expressions.text(title));
        return this;
    }

    public CrosstabMeasureBuilder<T> setTitleStyle(ReportStyleBuilder titleStyle) {
        if (titleStyle != null) {
            ((DRCrosstabMeasure)this.getObject()).setTitleStyle(titleStyle.getStyle());
        } else {
            ((DRCrosstabMeasure)this.getObject()).setTitleStyle(null);
        }
        return this;
    }

    @Override
    public String getName() {
        return ((DRCrosstabMeasure)this.build()).getExpression().getName();
    }
}

