/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.datatype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.dynamicreports.report.base.datatype.AbstractDataType;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.exception.DRException;

public class DateType
extends AbstractDataType<Date, Date> {
    private static final long serialVersionUID = 10000L;

    @Override
    public String getPattern() {
        return Defaults.getDefaults().getDateType().getPattern();
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return Defaults.getDefaults().getDateType().getHorizontalAlignment();
    }

    @Override
    public String valueToString(Date value, Locale locale) {
        if (value != null) {
            return new SimpleDateFormat(this.getPattern(), locale).format(value);
        }
        return null;
    }

    @Override
    public Date stringToValue(String value, Locale locale) throws DRException {
        if (value != null) {
            try {
                return new SimpleDateFormat(this.getPattern(), locale).parse(value);
            }
            catch (ParseException e) {
                throw new DRException("Unable to convert string value to date", e);
            }
        }
        return null;
    }
}

