/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.datatype;

import java.util.List;
import net.sf.dynamicreports.report.base.datatype.AbstractDataType;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.defaults.Defaults;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;

public class ListType
extends AbstractDataType<List, List> {
    private static final long serialVersionUID = 10000L;
    private static ListFormatter listFormatter = new ListFormatter();

    @Override
    public DRIValueFormatter<?, ? extends List> getValueFormatter() {
        return listFormatter;
    }

    @Override
    public String getPattern() {
        return Defaults.getDefaults().getStringType().getPattern();
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return Defaults.getDefaults().getStringType().getHorizontalAlignment();
    }

    private static class ListFormatter
    extends AbstractValueFormatter<String, List> {
        private static final long serialVersionUID = 10000L;

        private ListFormatter() {
        }

        @Override
        public String format(List values, ReportParameters reportParameters) {
            StringBuffer result = new StringBuffer();
            for (Object value : values) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                if (value == null) continue;
                result.append(value.toString());
            }
            return result.toString();
        }
    }
}

