/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.expression;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.crosstab.AbstractCrosstabGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIComplexExpression;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class AbstractComplexExpression<T>
implements DRIComplexExpression<T> {
    private static final long serialVersionUID = 10000L;
    private String name = ReportUtils.generateUniqueName("complexExpression");
    private List<DRIExpression<?>> expressions = new ArrayList();

    protected AbstractComplexExpression() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void addExpression(FieldBuilder<?> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.expressions.add(field.getField());
    }

    protected void addExpression(String fieldName, Class<?> valueClass) {
        DRField field = new DRField(fieldName, valueClass);
        this.expressions.add(field);
    }

    protected void addExpression(TextColumnBuilder<?> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.expressions.add((DRIExpression)column.build());
    }

    protected void addExpression(VariableBuilder<?> variable) {
        Validate.notNull(variable, (String)"variable must not be null", (Object[])new Object[0]);
        this.expressions.add(variable.getVariable());
    }

    protected void addExpression(DRIExpression<?> expression) {
        Validate.notNull(expression, (String)"expression must not be null", (Object[])new Object[0]);
        this.expressions.add(expression);
    }

    protected void addExpression(AbstractCrosstabGroupBuilder<?, ?, ?> crosstabGroup) {
        Validate.notNull(crosstabGroup, (String)"crosstabGroup must not be null", (Object[])new Object[0]);
        this.expressions.add(Expressions.crosstabValue(crosstabGroup));
    }

    protected void addExpression(CrosstabMeasureBuilder<?> crosstabMeasure) {
        Validate.notNull(crosstabMeasure, (String)"crosstabMeasure must not be null", (Object[])new Object[0]);
        this.expressions.add(Expressions.crosstabValue(crosstabMeasure));
    }

    @Override
    public List<DRIExpression<?>> getExpressions() {
        return this.expressions;
    }

    @Override
    public Class<? super T> getValueClass() {
        return ReportUtils.getGenericClass(this, 0);
    }

    @Override
    public abstract T evaluate(List<?> var1, ReportParameters var2);
}

