/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.expression;

import java.math.BigDecimal;
import java.util.List;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

abstract class CalculationExpression
extends AbstractComplexExpression<BigDecimal> {
    private static final long serialVersionUID = 10000L;

    protected CalculationExpression(DRIExpression<? extends Number> ... expressions) {
        Validate.notNull(expressions, (String)"expressions must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])expressions, (String)"expressions must not contains null expression", (Object[])new Object[0]);
        DRIExpression<? extends Number>[] dRIExpressionArray = expressions;
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            DRIExpression<? extends Number> expression = dRIExpressionArray[n2];
            this.addExpression(expression);
            ++n2;
        }
    }

    @Override
    public BigDecimal evaluate(List<?> values, ReportParameters reportParameters) {
        BigDecimal result = null;
        for (Object value : values) {
            BigDecimal bigDecimalValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(((Number)value).doubleValue());
            result = result == null ? bigDecimalValue : this.calculate(result, bigDecimalValue);
        }
        return result;
    }

    protected abstract BigDecimal calculate(BigDecimal var1, BigDecimal var2);
}

