/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.style;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.dynamicreports.report.builder.style.BorderBuilder;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.PaddingBuilder;
import net.sf.dynamicreports.report.builder.style.PenBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.SimpleStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.style.TemplateStyleBuilder;
import net.sf.dynamicreports.report.builder.style.TemplateStyleFileBuilder;
import net.sf.dynamicreports.report.constant.LineStyle;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang3.Validate;

public class Styles {
    public static FontBuilder font() {
        return new FontBuilder();
    }

    public static FontBuilder font(String fontName, boolean bold, boolean italic, int fontSize) {
        return new FontBuilder(fontName, bold, italic, fontSize);
    }

    public static FontBuilder fontArial() {
        return new FontBuilder("Arial", false, false, 10);
    }

    public static FontBuilder fontArialBold() {
        return new FontBuilder("Arial", true, false, 10);
    }

    public static FontBuilder fontTimesNewRoman() {
        return new FontBuilder("Times New Roman", false, false, 10);
    }

    public static FontBuilder fontTimesNewRomanBold() {
        return new FontBuilder("Times New Roman", true, false, 10);
    }

    public static FontBuilder fontCourierNew() {
        return new FontBuilder("Courier New", false, false, 10);
    }

    public static FontBuilder fontCourierNewBold() {
        return new FontBuilder("Courier New", true, false, 10);
    }

    public static PenBuilder pen() {
        return new PenBuilder();
    }

    public static PenBuilder pen(Float lineWidth, LineStyle lineStyle) {
        return new PenBuilder(lineWidth, lineStyle);
    }

    public static PenBuilder penThin() {
        return new PenBuilder(Float.valueOf(0.5f), LineStyle.SOLID);
    }

    public static PenBuilder pen1Point() {
        return new PenBuilder(Float.valueOf(1.0f), LineStyle.SOLID);
    }

    public static PenBuilder pen2Point() {
        return new PenBuilder(Float.valueOf(2.0f), LineStyle.SOLID);
    }

    public static PenBuilder penDotted() {
        return new PenBuilder(Float.valueOf(1.0f), LineStyle.DOTTED);
    }

    public static PenBuilder penDashed() {
        return new PenBuilder(Float.valueOf(1.0f), LineStyle.DASHED);
    }

    public static PenBuilder penDouble() {
        return new PenBuilder(Float.valueOf(1.0f), LineStyle.DOUBLE);
    }

    public static BorderBuilder border() {
        return new BorderBuilder();
    }

    public static BorderBuilder border(PenBuilder pen) {
        Validate.notNull((Object)pen, (String)"pen must not be null", (Object[])new Object[0]);
        return new BorderBuilder(pen);
    }

    public static PaddingBuilder padding() {
        return new PaddingBuilder();
    }

    public static PaddingBuilder padding(int padding) {
        return new PaddingBuilder(padding);
    }

    public static StyleBuilder style() {
        return new StyleBuilder();
    }

    public static StyleBuilder style(ReportStyleBuilder parentStyle) {
        return new StyleBuilder().setParentStyle(parentStyle);
    }

    public static StyleBuilder style(FontBuilder font) {
        return (StyleBuilder)new StyleBuilder().setFont(font);
    }

    public static StyleBuilder style(PenBuilder borderPen) {
        return (StyleBuilder)new StyleBuilder().setBorder(borderPen);
    }

    public static StyleBuilder style(Integer padding) {
        return (StyleBuilder)new StyleBuilder().setPadding(padding);
    }

    public static SimpleStyleBuilder simpleStyle() {
        return new SimpleStyleBuilder();
    }

    public static TemplateStyleBuilder templateStyle(String name) {
        return new TemplateStyleBuilder(name);
    }

    public static ConditionalStyleBuilder conditionalStyle(DRIExpression<Boolean> conditionExpression) {
        return new ConditionalStyleBuilder(conditionExpression);
    }

    public static TemplateStyleFileBuilder loadStyles(InputStream inputStream) {
        return new TemplateStyleFileBuilder(inputStream);
    }

    public static TemplateStyleFileBuilder loadStyles(File file) {
        return new TemplateStyleFileBuilder(file);
    }

    public static TemplateStyleFileBuilder loadStyles(String fileName) throws DRException {
        return new TemplateStyleFileBuilder(fileName);
    }

    public static TemplateStyleFileBuilder loadStyles(URL url) {
        return new TemplateStyleFileBuilder(url);
    }
}

