/**
 * DynamicReports - Free Java reporting library for creating reports dynamically
 *
 * Copyright (C) 2010 - 2013 Ricardo Mariaca
 * http://www.dynamicreports.org
 *
 * This file is part of DynamicReports.
 *
 * DynamicReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DynamicReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with DynamicReports. If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.dynamicreports.report.constant;

/**
 * @author Ricardo Mariaca (r.mariaca@dynamicreports.org)
 */
public enum BooleanComponentType {
	/**
	 * Shows a text value (true/false)
	 */
	TEXT_TRUE_FALSE,
	/**
	 * Shows a text value (yes/no)
	 */
	TEXT_YES_NO,
	/**
	 * Shows an image
	 */
	IMAGE_STYLE_1,
	/**
	 * Shows an image
	 */
	IMAGE_STYLE_2,
	/**
	 * Shows an image
	 */
	IMAGE_STYLE_3,
	/**
	 * Shows an image
	 */
	IMAGE_STYLE_4,
	/**
	 * Shows a ball image
	 */
	IMAGE_BALL,
	/**
	 * Shows a check box image
	 */
	IMAGE_CHECKBOX_1,
	/**
	 * Shows a check box image
	 */
	IMAGE_CHECKBOX_2
}
