/*
Copyright (c) 2009 eBay, Inc.

This program is licensed under the terms of the eBay Common Development and 
Distribution License (CDDL) Version 1.0 (the "License") and any subsequent 
version thereof released by eBay.  The then-current version of the License 
can be found at https://www.codebase.ebay.com/Licenses.html and in the 
eBaySDKLicense file that is under the eBay SDK install directory.
*/

package com.ebay.sdk.call;


import com.ebay.sdk.*;
import com.ebay.soap.eBLBaseComponents.*;
/**
 * Wrapper class of the AddMemberMessagesAAQToBidder call of eBay SOAP API.
 * <br>
 * <p>Title: SOAP API wrapper library.</p>
 * <p>Description: Contains wrapper classes for eBay SOAP APIs.</p>
 * <p>Copyright: Copyright (c) 2009</p>
 * <p>Company: eBay Inc.</p>
 * <br> <B>Input property:</B> <code>AddMemberMessagesAAQToBidderRequestContainer</code> - Allows a seller to send up to 10 messages to
 * bidders and users who have made offers (via Best
 * Offer) during an active listing.
 * <br> <B>Output property:</B> <code>ReturnedAddMemberMessagesAAQToBidderResponseContainer</code> - Container consisting of the <b>Ack</b> field (indicating the result of the send message
 * operation) and the <b>CorrelationID</b> field (used to track multiple send
 * message operations performed in one call).
 * 
 * @author Ron Murphy
 * @version 1.0
 */

public class AddMemberMessagesAAQToBidderCall extends com.ebay.sdk.ApiCall
{
  
  private AddMemberMessagesAAQToBidderRequestContainerType[] addMemberMessagesAAQToBidderRequestContainer = null;
  private AddMemberMessagesAAQToBidderResponseContainerType[] returnedAddMemberMessagesAAQToBidderResponseContainer=null;


  /**
   * Constructor.
   */
  public AddMemberMessagesAAQToBidderCall() {
  }

  /**
   * Constructor.
   * @param apiContext The ApiContext object to be used to make the call.
   */
  public AddMemberMessagesAAQToBidderCall(ApiContext apiContext) {
    super(apiContext);
    

  }

  /**
   * Enables a seller to send up to 10 messages to bidders, or to users who have
   * made offers via Best Offer, regarding an active item listing.
   * 
   * <br>
   * @throws ApiException
   * @throws SdkException
   * @throws Exception
   * @return The AddMemberMessagesAAQToBidderResponseContainerType[] object.
   */
  public AddMemberMessagesAAQToBidderResponseContainerType[] addMemberMessagesAAQToBidder()
      throws com.ebay.sdk.ApiException, com.ebay.sdk.SdkException, java.lang.Exception
  {
    AddMemberMessagesAAQToBidderRequestType req;
    req = new AddMemberMessagesAAQToBidderRequestType();
    if (this.addMemberMessagesAAQToBidderRequestContainer != null)
      req.setAddMemberMessagesAAQToBidderRequestContainer(this.addMemberMessagesAAQToBidderRequestContainer);

    AddMemberMessagesAAQToBidderResponseType resp = (AddMemberMessagesAAQToBidderResponseType) execute(req);

    this.returnedAddMemberMessagesAAQToBidderResponseContainer = resp.getAddMemberMessagesAAQToBidderResponseContainer();
    return this.getReturnedAddMemberMessagesAAQToBidderResponseContainer();
  }

  /**
   * Gets the AddMemberMessagesAAQToBidderRequestType.addMemberMessagesAAQToBidderRequestContainer.
   * @return AddMemberMessagesAAQToBidderRequestContainerType[]
   */
  public AddMemberMessagesAAQToBidderRequestContainerType[] getAddMemberMessagesAAQToBidderRequestContainer()
  {
    return this.addMemberMessagesAAQToBidderRequestContainer;
  }

  /**
   * Sets the AddMemberMessagesAAQToBidderRequestType.addMemberMessagesAAQToBidderRequestContainer.
   * @param addMemberMessagesAAQToBidderRequestContainer AddMemberMessagesAAQToBidderRequestContainerType[]
   */
  public void setAddMemberMessagesAAQToBidderRequestContainer(AddMemberMessagesAAQToBidderRequestContainerType[] addMemberMessagesAAQToBidderRequestContainer)
  {
    this.addMemberMessagesAAQToBidderRequestContainer = addMemberMessagesAAQToBidderRequestContainer;
  }

  /**
   * Valid after executing the API.
   * Gets the returned AddMemberMessagesAAQToBidderResponseType.returnedAddMemberMessagesAAQToBidderResponseContainer.
   * 
   * @return AddMemberMessagesAAQToBidderResponseContainerType[]
   */
  public AddMemberMessagesAAQToBidderResponseContainerType[] getReturnedAddMemberMessagesAAQToBidderResponseContainer()
  {
    return this.returnedAddMemberMessagesAAQToBidderResponseContainer;
  }

}

