/*
Copyright (c) 2009 eBay, Inc.

This program is licensed under the terms of the eBay Common Development and 
Distribution License (CDDL) Version 1.0 (the "License") and any subsequent 
version thereof released by eBay.  The then-current version of the License 
can be found at https://www.codebase.ebay.com/Licenses.html and in the 
eBaySDKLicense file that is under the eBay SDK install directory.
*/

package com.ebay.sdk.call;

import java.lang.Boolean;

import com.ebay.sdk.*;
import com.ebay.soap.eBLBaseComponents.*;
/**
 * Wrapper class of the GetUserPreferences call of eBay SOAP API.
 * <br>
 * <p>Title: SOAP API wrapper library.</p>
 * <p>Description: Contains wrapper classes for eBay SOAP APIs.</p>
 * <p>Copyright: Copyright (c) 2009</p>
 * <p>Company: eBay Inc.</p>
 * <br> <B>Input property:</B> <code>ShowBidderNoticePreferences</code> - If included and set to true, the seller's preference for receiving contact
 * information for unsuccessful bidders is returned in the response.
 * <br> <B>Input property:</B> <code>ShowCombinedPaymentPreferences</code> - If included and set to true, the seller's combined payment preferences are
 * returned in the response.
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * The CombinedPaymentPreferences.CombinedPaymentOption field is the only
 * preference that should be managed with the GetUserPreferences and
 * SetUserPreferences calls. All other Combined Payment preferences should be
 * managed with the SetDiscountProfiles and GetDiscountProfiles calls.
 * </span>
 * <br> <B>Input property:</B> <code>ShowCrossPromotionPreferences</code> - If included and set to true, the seller's cross-promotion preferences are
 * returned in the response. These preferences are only applicable for eBay
 * Store owners.
 * <br> <B>Input property:</B> <code>ShowSellerPaymentPreferences</code> - If included and set to true, the seller's payment preferences are returned
 * in the response.
 * <br> <B>Input property:</B> <code>ShowEndOfAuctionEmailPreferences</code> - If included and set to true, the seller's preferences for the end-of-auction
 * email sent to the winning bidder is returned in the response. These
 * preferences are only applicable for auction listings.
 * <br> <B>Input property:</B> <code>ShowSellerFavoriteItemPreferences</code> - If included and set to true, the seller's favorite item preferences are
 * returned in the response.
 * <br> <B>Input property:</B> <code>ShowProStoresPreferences</code> - If included and set to true, the seller's ProStores preferences are
 * returned in the response.
 * <br> <B>Input property:</B> <code>ShowEmailShipmentTrackingNumberPreference</code> - If included and set to true, the seller's preference for sending an email to
 * the buyer with the shipping tracking number is returned in the response.
 * <br> <B>Input property:</B> <code>ShowRequiredShipPhoneNumberPreference</code> - If included and set to true, the seller's preference for requiring that the
 * buyer supply a shipping phone number upon checkout is returned in the
 * response. Some shipping carriers require the receiver's phone number.
 * <br> <B>Input property:</B> <code>ShowSellerExcludeShipToLocationPreference</code> - If included and set to true, all of the seller's excluded shipping locations
 * are returned in the response. The returned list mirrors the seller's current
 * Exclude shipping locations list in My eBay's Shipping Preferences. An
 * excluded shipping location in My eBay can be an entire geographical region
 * (such as Middle East) or only an individual country (such as Iraq). Sellers
 * can override these default settings for an individual listing by using the
 * Item.ShippingDetails.ExcludeShipToLocation field in the AddItem family of
 * calls.
 * <br> <B>Input property:</B> <code>ShowUnpaidItemAssistancePreference</code> - If included and set to true, the seller's Unpaid Item Assistant preferences
 * are returned in the response. The Unpaid Item Assistant automatically opens
 * an Unpaid Item dispute on the behalf of the seller.
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * To return the list of buyers excluded from the Unpaid Item Assistant
 * mechanism, the ShowUnpaidItemAssistanceExclusionList field must also be
 * included and set to true in the request. Excluded buyers can be viewed in
 * the UnpaidItemAssistancePreferences.ExcludedUser field.
 * </span>
 * <br> <B>Input property:</B> <code>ShowPurchaseReminderEmailPreferences</code> - If included and set to true, the seller's preference for sending a purchase
 * reminder email to buyers is returned in the response.
 * <br> <B>Input property:</B> <code>ShowUnpaidItemAssistanceExclusionList</code> - If included and set to true, the list of eBay user IDs on the Unpaid Item
 * Assistant Excluded User list is returned through the
 * UnpaidItemAssistancePreferences.ExcludedUser field in the response. For
 * excluded users, an Unpaid Item dispute is not automatically filed through
 * the UPI Assistance mechanism. The Excluded User list is managed through the
 * SetUserPreferences call.
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * To return the list of buyers excluded from the Unpaid Item Assistant
 * mechanism, the ShowUnpaidItemAssistancePreference field must also be
 * included and set to true in the request.
 * </span>
 * <br> <B>Input property:</B> <code>ShowSellerProfilePreferences</code> - If this flag is included and set to true, the seller's Business Policies profile information is
 * returned in the response. This information includes a flag that indicates whether or
 * not the seller has opted into Business Policies, as well as Business Policies profiles
 * (payment, shipping, and return policy) active on the seller's account.
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * Business Policies are not yet available for use on the eBay platform.
 * </span>
 * <br> <B>Input property:</B> <code>ShowSellerReturnPreferences</code> - If this flag is included and set to true, the seller's eBay Return Center
 * preference information will be returned.
 * <br><br>
 * eBay managed returns are currently only available on the US site. The eBay
 * Return Center pilot launched on July 10, 2012. The eBay Return Center full
 * launch is scheduled for early August 2012.
 * <br> <B>Input property:</B> <code>ShowGlobalShippingProgramPreference</code> - If this flag is included and set to true, the seller's preference for offering the Global Shipping Program to international buyers will be returned in <strong>OfferGlobalShippingProgramPreference</strong>.
 * <br> <B>Output property:</B> <code>ReturnedBidderNoticePreferences</code> - Container consisting of the seller's preference for receiving contact
 * information for unsuccessful bidders. This container is returned when
 * <b>ShowBidderNoticePreferences</b> is included and set to 'true' in
 * the request. This preference is only applicable for auction listings.
 * <br> <B>Output property:</B> <code>ReturnedCombinedPaymentPreferences</code> - Container consisting of the seller's combined payment preferences. This
 * container is returned when <b>ShowCombinedPaymentPreferences</b>
 * is included and set to 'true' in the request.
 * <br>
 * <span class="tablenote"><strong>Note:</strong>
 * The <b>CombinedPaymentPreferences.CombinedPaymentOption</b> field is
 * the only combined payment preference that should be managed with the
 * <b>GetUserPreferences</b> and <b>SetUserPreferences</b> calls.
 * All other combined payment preferences should be managed with the
 * <b>SetDiscountProfiles</b> and <b>GetDiscountProfiles</b>
 * calls.
 * </span>
 * <br> <B>Output property:</B> <code>ReturnedCrossPromotionPreferences</code> - Container consisting of the seller's cross-promotion preferences. This
 * container is returned when <b>ShowCrossPromotionPreferences</b> is
 * included and set to 'true' in the request. These preferences are only applicable
 * for eBay Store owners.
 * <br> <B>Output property:</B> <code>ReturnedSellerPaymentPreferences</code> - Container consisting of the seller's payment preferences. This container is
 * returned when <b>ShowSellerPaymentPreferences</b> is included and
 * set to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedSellerFavoriteItemPreferences</code> - Container consisting of the seller's preferences for displaying items on a
 * buyer's Favorite Sellers' Items page or Favorite Sellers' Items digest. This
 * container is returned when <b>ShowSellerFavoriteItemPreferences</b>
 * is included and set to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedEndOfAuctionEmailPreferences</code> - Container consisting of the seller's preferences for the end-of-auction email
 * sent to the winning bidder. This container is returned when
 * <b>ShowEndOfAuctionEmailPreferences</b> is included and set to
 * 'true' in the request. These preferences are only applicable for auction
 * listings.
 * <br> <B>Output property:</B> <code>ReturnedEmailShipmentTrackingNumberPreference</code> - Container consisting of the seller's preference for sending an email to the
 * buyer with the shipping tracking number. This container is returned when
 * <b>ShowEmailShipmentTrackingNumberPreference</b> is included and set
 * to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedRequiredShipPhoneNumberPreference</code> - Container consisting of the seller's preference for requiring that the
 * buyer supply a shipping phone number upon checkout. Some shipping carriers
 * require the receiver's phone number. This container is returned when
 * <b>ShowRequiredShipPhoneNumberPreference</b> is included and set
 * to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedProStoresPreference</code> - Container consisting of the seller's ProStores preferences. This container
 * is returned when <b>ShowProStoresPreference</b> is included and
 * set to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedUnpaidItemAssistancePreferences</code> - Container consisting of a seller's Unpaid Item Assistant preferences. The
 * Unpaid Item Assistant automatically opens an Unpaid Item dispute on the
 * behalf of the seller. This container is returned if
 * <b>ShowUnpaidItemAssistancePreference</b> is included and set to
 * 'true' in the request.
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * To return the list of buyers excluded from the Unpaid Item Assistant
 * mechanism, the <b>ShowUnpaidItemAssistanceExclusionList</b> field
 * must also be included and set to 'true' in the request. Excluded buyers can be
 * viewed in the <b>UnpaidItemAssistancePreferences.ExcludedUser</b>
 * field.
 * </span>
 * <br> <B>Output property:</B> <code>ReturnedSellerExcludeShipToLocationPreferences</code> - Container consisting of a list of the seller's excluded shipping locations.
 * The returned list mirrors the seller's current Exclude shipping locations
 * list in My eBay's shipping preferences. An excluded shipping location in My
 * eBay can be an entire geographical region (such as Middle East) or only an
 * individual country (such as Iraq). Sellers can override these default
 * settings for an individual listing by using the
 * <b>Item.ShippingDetails.ExcludeShipToLocation</b> field in the
 * Add/Revise/Relist calls. This container is returned if the
 * <b>ShowSellerExcludeShipToLocationPreference</b> field is included
 * and set to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedPurchaseReminderEmailPreferences</code> - Container consisting of a seller's preference for sending a purchase reminder
 * email to buyers. This container is returned if the
 * <b>ShowPurchaseReminderEmailPreferences</b> field is included and
 * set to 'true' in the request.
 * <br> <B>Output property:</B> <code>ReturnedSellerThirdPartyCheckoutDisabled</code> - This flag is set with the
 * <b>SellerThirdPartyCheckoutDisabled</b> field of the
 * <b>SetUserPreferences</b> call, and is used to disable the
 * use of a third-party application to handle the checkout flow for a seller.
 * If true, Third-Party Checkout is disabled and any checkout flow initiated on
 * the seller's application is redirected to the eBay checkout flow. This field
 * is only returned if the <b>SellerThirdPartyCheckoutDisabled</b>
 * field has been set with the <b>SetUserPreferences</b> call.
 * <br> <B>Output property:</B> <code>ReturnedSellerProfilePreferences</code> - Parent response container consisting of high-level information for all
 * Business Policies profiles defined for the user's account. This container is
 * returned if <b>ShowSellerProfilePreferences</b> is included and
 * set to 'true' in the <b>GetUserPreferences</b> request (and one or
 * more Business Policies profiles are defined for the user's account).
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * Business Policies are not yet available for use on the eBay platform.
 * </span>
 * <br> <B>Output property:</B> <code>ReturnedSellerReturnPreferences</code> - Container consisting of a seller's eBay Return Center preferences. This
 * container is returned if <b>ShowSellerReturnPreferences</b> is
 * included and set to true in the request.
 * <br> <B>Output property:</B> <code>ReturnedOfferGlobalShippingProgramPreference</code> - This flag indicates whether the seller has opted in to the Global Shipping Program and is able to offer global shipping to international buyers. Returned when <strong>ShowGlobalShippingProgramPreference</strong> is included and set to true.
 * 
 * @author Ron Murphy
 * @version 1.0
 */

public class GetUserPreferencesCall extends com.ebay.sdk.ApiCall
{
  
  private Boolean showBidderNoticePreferences = null;
  private Boolean showCombinedPaymentPreferences = null;
  private Boolean showCrossPromotionPreferences = null;
  private Boolean showSellerPaymentPreferences = null;
  private Boolean showEndOfAuctionEmailPreferences = null;
  private Boolean showSellerFavoriteItemPreferences = null;
  private Boolean showProStoresPreferences = null;
  private Boolean showEmailShipmentTrackingNumberPreference = null;
  private Boolean showRequiredShipPhoneNumberPreference = null;
  private Boolean showSellerExcludeShipToLocationPreference = null;
  private Boolean showUnpaidItemAssistancePreference = null;
  private Boolean showPurchaseReminderEmailPreferences = null;
  private Boolean showUnpaidItemAssistanceExclusionList = null;
  private Boolean showSellerProfilePreferences = null;
  private Boolean showSellerReturnPreferences = null;
  private Boolean showGlobalShippingProgramPreference = null;
  private BidderNoticePreferencesType returnedBidderNoticePreferences=null;
  private CombinedPaymentPreferencesType returnedCombinedPaymentPreferences=null;
  private CrossPromotionPreferencesType returnedCrossPromotionPreferences=null;
  private SellerPaymentPreferencesType returnedSellerPaymentPreferences=null;
  private SellerFavoriteItemPreferencesType returnedSellerFavoriteItemPreferences=null;
  private EndOfAuctionEmailPreferencesType returnedEndOfAuctionEmailPreferences=null;
  private Boolean returnedEmailShipmentTrackingNumberPreference=null;
  private Boolean returnedRequiredShipPhoneNumberPreference=null;
  private ProStoresCheckoutPreferenceType returnedProStoresPreference=null;
  private UnpaidItemAssistancePreferencesType returnedUnpaidItemAssistancePreferences=null;
  private SellerExcludeShipToLocationPreferencesType returnedSellerExcludeShipToLocationPreferences=null;
  private PurchaseReminderEmailPreferencesType returnedPurchaseReminderEmailPreferences=null;
  private Boolean returnedSellerThirdPartyCheckoutDisabled=null;
  private SellerProfilePreferencesType returnedSellerProfilePreferences=null;
  private SellerReturnPreferencesType returnedSellerReturnPreferences=null;
  private Boolean returnedOfferGlobalShippingProgramPreference=null;


  /**
   * Constructor.
   */
  public GetUserPreferencesCall() {
  }

  /**
   * Constructor.
   * @param apiContext The ApiContext object to be used to make the call.
   */
  public GetUserPreferencesCall(ApiContext apiContext) {
    super(apiContext);
    

  }

  /**
   * Retrieves the specified user preferences for the authenticated caller.
   * 
   * <br>
   * @throws ApiException
   * @throws SdkException
   * @throws Exception
   * @return The void object.
   */
  public void getUserPreferences()
      throws com.ebay.sdk.ApiException, com.ebay.sdk.SdkException, java.lang.Exception
  {
    GetUserPreferencesRequestType req;
    req = new GetUserPreferencesRequestType();
    if (this.showBidderNoticePreferences != null)
      req.setShowBidderNoticePreferences(this.showBidderNoticePreferences.booleanValue());
    if (this.showCombinedPaymentPreferences != null)
      req.setShowCombinedPaymentPreferences(this.showCombinedPaymentPreferences.booleanValue());
    if (this.showCrossPromotionPreferences != null)
      req.setShowCrossPromotionPreferences(this.showCrossPromotionPreferences.booleanValue());
    if (this.showSellerPaymentPreferences != null)
      req.setShowSellerPaymentPreferences(this.showSellerPaymentPreferences.booleanValue());
    if (this.showEndOfAuctionEmailPreferences != null)
      req.setShowEndOfAuctionEmailPreferences(this.showEndOfAuctionEmailPreferences);
    if (this.showSellerFavoriteItemPreferences != null)
      req.setShowSellerFavoriteItemPreferences(this.showSellerFavoriteItemPreferences);
    if (this.showProStoresPreferences != null)
      req.setShowProStoresPreferences(this.showProStoresPreferences);
    if (this.showEmailShipmentTrackingNumberPreference != null)
      req.setShowEmailShipmentTrackingNumberPreference(this.showEmailShipmentTrackingNumberPreference);
    if (this.showRequiredShipPhoneNumberPreference != null)
      req.setShowRequiredShipPhoneNumberPreference(this.showRequiredShipPhoneNumberPreference);
    if (this.showSellerExcludeShipToLocationPreference != null)
      req.setShowSellerExcludeShipToLocationPreference(this.showSellerExcludeShipToLocationPreference);
    if (this.showUnpaidItemAssistancePreference != null)
      req.setShowUnpaidItemAssistancePreference(this.showUnpaidItemAssistancePreference);
    if (this.showPurchaseReminderEmailPreferences != null)
      req.setShowPurchaseReminderEmailPreferences(this.showPurchaseReminderEmailPreferences);
    if (this.showUnpaidItemAssistanceExclusionList != null)
      req.setShowUnpaidItemAssistanceExclusionList(this.showUnpaidItemAssistanceExclusionList);
    if (this.showSellerProfilePreferences != null)
      req.setShowSellerProfilePreferences(this.showSellerProfilePreferences);
    if (this.showSellerReturnPreferences != null)
      req.setShowSellerReturnPreferences(this.showSellerReturnPreferences);
    if (this.showGlobalShippingProgramPreference != null)
      req.setShowGlobalShippingProgramPreference(this.showGlobalShippingProgramPreference);

    GetUserPreferencesResponseType resp = (GetUserPreferencesResponseType) execute(req);

    this.returnedBidderNoticePreferences = resp.getBidderNoticePreferences();
    this.returnedCombinedPaymentPreferences = resp.getCombinedPaymentPreferences();
    this.returnedCrossPromotionPreferences = resp.getCrossPromotionPreferences();
    this.returnedSellerPaymentPreferences = resp.getSellerPaymentPreferences();
    this.returnedSellerFavoriteItemPreferences = resp.getSellerFavoriteItemPreferences();
    this.returnedEndOfAuctionEmailPreferences = resp.getEndOfAuctionEmailPreferences();
    this.returnedEmailShipmentTrackingNumberPreference = resp.isEmailShipmentTrackingNumberPreference();
    this.returnedRequiredShipPhoneNumberPreference = resp.isRequiredShipPhoneNumberPreference();
    this.returnedProStoresPreference = resp.getProStoresPreference();
    this.returnedUnpaidItemAssistancePreferences = resp.getUnpaidItemAssistancePreferences();
    this.returnedSellerExcludeShipToLocationPreferences = resp.getSellerExcludeShipToLocationPreferences();
    this.returnedPurchaseReminderEmailPreferences = resp.getPurchaseReminderEmailPreferences();
    this.returnedSellerThirdPartyCheckoutDisabled = resp.isSellerThirdPartyCheckoutDisabled();
    this.returnedSellerProfilePreferences = resp.getSellerProfilePreferences();
    this.returnedSellerReturnPreferences = resp.getSellerReturnPreferences();
    this.returnedOfferGlobalShippingProgramPreference = resp.isOfferGlobalShippingProgramPreference();

  }

  /**
   * Gets the GetUserPreferencesRequestType.showBidderNoticePreferences.
   * @return Boolean
   */
  public Boolean getShowBidderNoticePreferences()
  {
    return this.showBidderNoticePreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showBidderNoticePreferences.
   * @param showBidderNoticePreferences Boolean
   */
  public void setShowBidderNoticePreferences(Boolean showBidderNoticePreferences)
  {
    this.showBidderNoticePreferences = showBidderNoticePreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showCombinedPaymentPreferences.
   * @return Boolean
   */
  public Boolean getShowCombinedPaymentPreferences()
  {
    return this.showCombinedPaymentPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showCombinedPaymentPreferences.
   * @param showCombinedPaymentPreferences Boolean
   */
  public void setShowCombinedPaymentPreferences(Boolean showCombinedPaymentPreferences)
  {
    this.showCombinedPaymentPreferences = showCombinedPaymentPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showCrossPromotionPreferences.
   * @return Boolean
   */
  public Boolean getShowCrossPromotionPreferences()
  {
    return this.showCrossPromotionPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showCrossPromotionPreferences.
   * @param showCrossPromotionPreferences Boolean
   */
  public void setShowCrossPromotionPreferences(Boolean showCrossPromotionPreferences)
  {
    this.showCrossPromotionPreferences = showCrossPromotionPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showEmailShipmentTrackingNumberPreference.
   * @return Boolean
   */
  public Boolean getShowEmailShipmentTrackingNumberPreference()
  {
    return this.showEmailShipmentTrackingNumberPreference;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showEmailShipmentTrackingNumberPreference.
   * @param showEmailShipmentTrackingNumberPreference Boolean
   */
  public void setShowEmailShipmentTrackingNumberPreference(Boolean showEmailShipmentTrackingNumberPreference)
  {
    this.showEmailShipmentTrackingNumberPreference = showEmailShipmentTrackingNumberPreference;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showEndOfAuctionEmailPreferences.
   * @return Boolean
   */
  public Boolean getShowEndOfAuctionEmailPreferences()
  {
    return this.showEndOfAuctionEmailPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showEndOfAuctionEmailPreferences.
   * @param showEndOfAuctionEmailPreferences Boolean
   */
  public void setShowEndOfAuctionEmailPreferences(Boolean showEndOfAuctionEmailPreferences)
  {
    this.showEndOfAuctionEmailPreferences = showEndOfAuctionEmailPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showGlobalShippingProgramPreference.
   * @return Boolean
   */
  public Boolean getShowGlobalShippingProgramPreference()
  {
    return this.showGlobalShippingProgramPreference;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showGlobalShippingProgramPreference.
   * @param showGlobalShippingProgramPreference Boolean
   */
  public void setShowGlobalShippingProgramPreference(Boolean showGlobalShippingProgramPreference)
  {
    this.showGlobalShippingProgramPreference = showGlobalShippingProgramPreference;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showProStoresPreferences.
   * @return Boolean
   */
  public Boolean getShowProStoresPreferences()
  {
    return this.showProStoresPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showProStoresPreferences.
   * @param showProStoresPreferences Boolean
   */
  public void setShowProStoresPreferences(Boolean showProStoresPreferences)
  {
    this.showProStoresPreferences = showProStoresPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showPurchaseReminderEmailPreferences.
   * @return Boolean
   */
  public Boolean getShowPurchaseReminderEmailPreferences()
  {
    return this.showPurchaseReminderEmailPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showPurchaseReminderEmailPreferences.
   * @param showPurchaseReminderEmailPreferences Boolean
   */
  public void setShowPurchaseReminderEmailPreferences(Boolean showPurchaseReminderEmailPreferences)
  {
    this.showPurchaseReminderEmailPreferences = showPurchaseReminderEmailPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showRequiredShipPhoneNumberPreference.
   * @return Boolean
   */
  public Boolean getShowRequiredShipPhoneNumberPreference()
  {
    return this.showRequiredShipPhoneNumberPreference;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showRequiredShipPhoneNumberPreference.
   * @param showRequiredShipPhoneNumberPreference Boolean
   */
  public void setShowRequiredShipPhoneNumberPreference(Boolean showRequiredShipPhoneNumberPreference)
  {
    this.showRequiredShipPhoneNumberPreference = showRequiredShipPhoneNumberPreference;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showSellerExcludeShipToLocationPreference.
   * @return Boolean
   */
  public Boolean getShowSellerExcludeShipToLocationPreference()
  {
    return this.showSellerExcludeShipToLocationPreference;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showSellerExcludeShipToLocationPreference.
   * @param showSellerExcludeShipToLocationPreference Boolean
   */
  public void setShowSellerExcludeShipToLocationPreference(Boolean showSellerExcludeShipToLocationPreference)
  {
    this.showSellerExcludeShipToLocationPreference = showSellerExcludeShipToLocationPreference;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showSellerFavoriteItemPreferences.
   * @return Boolean
   */
  public Boolean getShowSellerFavoriteItemPreferences()
  {
    return this.showSellerFavoriteItemPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showSellerFavoriteItemPreferences.
   * @param showSellerFavoriteItemPreferences Boolean
   */
  public void setShowSellerFavoriteItemPreferences(Boolean showSellerFavoriteItemPreferences)
  {
    this.showSellerFavoriteItemPreferences = showSellerFavoriteItemPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showSellerPaymentPreferences.
   * @return Boolean
   */
  public Boolean getShowSellerPaymentPreferences()
  {
    return this.showSellerPaymentPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showSellerPaymentPreferences.
   * @param showSellerPaymentPreferences Boolean
   */
  public void setShowSellerPaymentPreferences(Boolean showSellerPaymentPreferences)
  {
    this.showSellerPaymentPreferences = showSellerPaymentPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showSellerProfilePreferences.
   * @return Boolean
   */
  public Boolean getShowSellerProfilePreferences()
  {
    return this.showSellerProfilePreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showSellerProfilePreferences.
   * @param showSellerProfilePreferences Boolean
   */
  public void setShowSellerProfilePreferences(Boolean showSellerProfilePreferences)
  {
    this.showSellerProfilePreferences = showSellerProfilePreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showSellerReturnPreferences.
   * @return Boolean
   */
  public Boolean getShowSellerReturnPreferences()
  {
    return this.showSellerReturnPreferences;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showSellerReturnPreferences.
   * @param showSellerReturnPreferences Boolean
   */
  public void setShowSellerReturnPreferences(Boolean showSellerReturnPreferences)
  {
    this.showSellerReturnPreferences = showSellerReturnPreferences;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showUnpaidItemAssistanceExclusionList.
   * @return Boolean
   */
  public Boolean getShowUnpaidItemAssistanceExclusionList()
  {
    return this.showUnpaidItemAssistanceExclusionList;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showUnpaidItemAssistanceExclusionList.
   * @param showUnpaidItemAssistanceExclusionList Boolean
   */
  public void setShowUnpaidItemAssistanceExclusionList(Boolean showUnpaidItemAssistanceExclusionList)
  {
    this.showUnpaidItemAssistanceExclusionList = showUnpaidItemAssistanceExclusionList;
  }

  /**
   * Gets the GetUserPreferencesRequestType.showUnpaidItemAssistancePreference.
   * @return Boolean
   */
  public Boolean getShowUnpaidItemAssistancePreference()
  {
    return this.showUnpaidItemAssistancePreference;
  }

  /**
   * Sets the GetUserPreferencesRequestType.showUnpaidItemAssistancePreference.
   * @param showUnpaidItemAssistancePreference Boolean
   */
  public void setShowUnpaidItemAssistancePreference(Boolean showUnpaidItemAssistancePreference)
  {
    this.showUnpaidItemAssistancePreference = showUnpaidItemAssistancePreference;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedBidderNoticePreferences.
   * 
   * @return BidderNoticePreferencesType
   */
  public BidderNoticePreferencesType getReturnedBidderNoticePreferences()
  {
    return this.returnedBidderNoticePreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedCombinedPaymentPreferences.
   * 
   * @return CombinedPaymentPreferencesType
   */
  public CombinedPaymentPreferencesType getReturnedCombinedPaymentPreferences()
  {
    return this.returnedCombinedPaymentPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedCrossPromotionPreferences.
   * 
   * @return CrossPromotionPreferencesType
   */
  public CrossPromotionPreferencesType getReturnedCrossPromotionPreferences()
  {
    return this.returnedCrossPromotionPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedEmailShipmentTrackingNumberPreference.
   * 
   * @return Boolean
   */
  public Boolean getReturnedEmailShipmentTrackingNumberPreference()
  {
    return this.returnedEmailShipmentTrackingNumberPreference;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedEndOfAuctionEmailPreferences.
   * 
   * @return EndOfAuctionEmailPreferencesType
   */
  public EndOfAuctionEmailPreferencesType getReturnedEndOfAuctionEmailPreferences()
  {
    return this.returnedEndOfAuctionEmailPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedOfferGlobalShippingProgramPreference.
   * 
   * @return Boolean
   */
  public Boolean getReturnedOfferGlobalShippingProgramPreference()
  {
    return this.returnedOfferGlobalShippingProgramPreference;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedProStoresPreference.
   * 
   * @return ProStoresCheckoutPreferenceType
   */
  public ProStoresCheckoutPreferenceType getReturnedProStoresPreference()
  {
    return this.returnedProStoresPreference;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedPurchaseReminderEmailPreferences.
   * 
   * @return PurchaseReminderEmailPreferencesType
   */
  public PurchaseReminderEmailPreferencesType getReturnedPurchaseReminderEmailPreferences()
  {
    return this.returnedPurchaseReminderEmailPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedRequiredShipPhoneNumberPreference.
   * 
   * @return Boolean
   */
  public Boolean getReturnedRequiredShipPhoneNumberPreference()
  {
    return this.returnedRequiredShipPhoneNumberPreference;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerExcludeShipToLocationPreferences.
   * 
   * @return SellerExcludeShipToLocationPreferencesType
   */
  public SellerExcludeShipToLocationPreferencesType getReturnedSellerExcludeShipToLocationPreferences()
  {
    return this.returnedSellerExcludeShipToLocationPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerFavoriteItemPreferences.
   * 
   * @return SellerFavoriteItemPreferencesType
   */
  public SellerFavoriteItemPreferencesType getReturnedSellerFavoriteItemPreferences()
  {
    return this.returnedSellerFavoriteItemPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerPaymentPreferences.
   * 
   * @return SellerPaymentPreferencesType
   */
  public SellerPaymentPreferencesType getReturnedSellerPaymentPreferences()
  {
    return this.returnedSellerPaymentPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerProfilePreferences.
   * 
   * @return SellerProfilePreferencesType
   */
  public SellerProfilePreferencesType getReturnedSellerProfilePreferences()
  {
    return this.returnedSellerProfilePreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerReturnPreferences.
   * 
   * @return SellerReturnPreferencesType
   */
  public SellerReturnPreferencesType getReturnedSellerReturnPreferences()
  {
    return this.returnedSellerReturnPreferences;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedSellerThirdPartyCheckoutDisabled.
   * 
   * @return Boolean
   */
  public Boolean getReturnedSellerThirdPartyCheckoutDisabled()
  {
    return this.returnedSellerThirdPartyCheckoutDisabled;
  }

  /**
   * Valid after executing the API.
   * Gets the returned GetUserPreferencesResponseType.returnedUnpaidItemAssistancePreferences.
   * 
   * @return UnpaidItemAssistancePreferencesType
   */
  public UnpaidItemAssistancePreferencesType getReturnedUnpaidItemAssistancePreferences()
  {
    return this.returnedUnpaidItemAssistancePreferences;
  }

}

