/*
Copyright (c) 2009 eBay, Inc.

This program is licensed under the terms of the eBay Common Development and 
Distribution License (CDDL) Version 1.0 (the "License") and any subsequent 
version thereof released by eBay.  The then-current version of the License 
can be found at https://www.codebase.ebay.com/Licenses.html and in the 
eBaySDKLicense file that is under the eBay SDK install directory.
*/

package com.ebay.sdk.call;

import java.lang.Boolean;

import com.ebay.sdk.*;
import com.ebay.soap.eBLBaseComponents.*;
/**
 * Wrapper class of the SetUserPreferences call of eBay SOAP API.
 * <br>
 * <p>Title: SOAP API wrapper library.</p>
 * <p>Description: Contains wrapper classes for eBay SOAP APIs.</p>
 * <p>Copyright: Copyright (c) 2009</p>
 * <p>Company: eBay Inc.</p>
 * <br> <B>Input property:</B> <code>BidderNoticePreferences</code> - Container consisting of the seller's preference for receiving contact
 * information for unsuccessful bidders. This preference is only applicable for
 * auction listings.
 * <br> <B>Input property:</B> <code>CombinedPaymentPreferences</code> - Container consisting of the seller's combined payment preferences.  
 * <br><br>
 * <span class="tablenote"><strong>Note:</strong>
 * This container's <b>CalculatedShippingPreferences</b> and 
 * <b>FlatShippingPreferences</b> child containers should no longer be
 * used. Instead, use the <b>SetShippingDiscountProfiles</b> call to
 * set the shipping rates for combined payment orders.
 * </span> 
 * <br>
 * <span class="tablenote"><strong>Note:</strong>
 * A seller's combined payment preferences can take up to 7 days to
 * have any logical or functional effect on eBay.
 * </span>
 * <br> <B>Input property:</B> <code>CrossPromotionPreferences</code> - Container consisting of the seller's cross-promotion preferences. These
 * preferences are only applicable for eBay Store owners. One or more
 * preferences may be set or modified under this field.
 * <br> <B>Input property:</B> <code>SellerPaymentPreferences</code> - Container consisting of the seller's payment preferences. One or more
 * preferences may be set or modified under this field. Payment preferences
 * specified in a <b>SetUserPreferences</b> call override the settings
 * in My eBay payment preferences.
 * <br> <B>Input property:</B> <code>SellerFavoriteItemPreferences</code> - Container consisting of the seller's preferences for displaying items on a
 * buyer's Favorite Sellers' Items page or Favorite Sellers' Items digest. One
 * or more preferences may be set or modified under this field. 
 * <br> <B>Input property:</B> <code>EndOfAuctionEmailPreferences</code> - Container consisting of the seller's preferences for the end-of-auction
 * email sent to the winning bidder. These preferences allow the seller to
 * customize the Email that is sent to buyer at the end of the auction. One or
 * more preferences may be set or modified under this field. These preferences
 * are only applicable for auction listings.
 * <br> <B>Input property:</B> <code>EmailShipmentTrackingNumberPreference</code> - Flag that controls whether the shipment's tracking number is sent by Email
 * from the seller to the buyer. 
 * <br> <B>Input property:</B> <code>RequiredShipPhoneNumberPreference</code> - Flag that controls whether the buyer is required to provide a shipping phone
 * number upon checkout. Some shipping carriers require the receiver's phone
 * number.
 * <br> <B>Input property:</B> <code>UnpaidItemAssistancePreferences</code> - Container consisting of a seller's Unpaid Item Assistant preferences. The
 * Unpaid Item Assistant automatically opens an Unpaid Item dispute on the
 * behalf of the seller. One or more preferences may be set or modified under
 * this field.
 * <br> <B>Input property:</B> <code>PurchaseReminderEmailPreferences</code> - Container consisting of a seller's preference for sending a purchase
 * reminder email to buyers. 
 * <br> <B>Input property:</B> <code>SellerThirdPartyCheckoutDisabled</code> - A flag used to disable the use of a third-party application to handle the
 * checkout flow for a seller. If set to true, Third-Party Checkout is disabled
 * and any checkout flow initiated on the seller's application is redirected to
 * the eBay checkout flow. 
 * 
 * @author Ron Murphy
 * @version 1.0
 */

public class SetUserPreferencesCall extends com.ebay.sdk.ApiCall
{
  
  private BidderNoticePreferencesType bidderNoticePreferences = null;
  private CombinedPaymentPreferencesType combinedPaymentPreferences = null;
  private CrossPromotionPreferencesType crossPromotionPreferences = null;
  private SellerPaymentPreferencesType sellerPaymentPreferences = null;
  private SellerFavoriteItemPreferencesType sellerFavoriteItemPreferences = null;
  private EndOfAuctionEmailPreferencesType endOfAuctionEmailPreferences = null;
  private Boolean emailShipmentTrackingNumberPreference = null;
  private Boolean requiredShipPhoneNumberPreference = null;
  private UnpaidItemAssistancePreferencesType unpaidItemAssistancePreferences = null;
  private PurchaseReminderEmailPreferencesType purchaseReminderEmailPreferences = null;
  private Boolean sellerThirdPartyCheckoutDisabled = null;


  /**
   * Constructor.
   */
  public SetUserPreferencesCall() {
  }

  /**
   * Constructor.
   * @param apiContext The ApiContext object to be used to make the call.
   */
  public SetUserPreferencesCall(ApiContext apiContext) {
    super(apiContext);
    

  }

  /**
   * Type defining the <b>SetUserPreferences</b> request container.
   * 
   * <br>
   * @throws ApiException
   * @throws SdkException
   * @throws Exception
   * @return The void object.
   */
  public void setUserPreferences()
      throws com.ebay.sdk.ApiException, com.ebay.sdk.SdkException, java.lang.Exception
  {
    SetUserPreferencesRequestType req;
    req = new SetUserPreferencesRequestType();
    if (this.bidderNoticePreferences != null)
      req.setBidderNoticePreferences(this.bidderNoticePreferences);
    if (this.combinedPaymentPreferences != null)
      req.setCombinedPaymentPreferences(this.combinedPaymentPreferences);
    if (this.crossPromotionPreferences != null)
      req.setCrossPromotionPreferences(this.crossPromotionPreferences);
    if (this.sellerPaymentPreferences != null)
      req.setSellerPaymentPreferences(this.sellerPaymentPreferences);
    if (this.sellerFavoriteItemPreferences != null)
      req.setSellerFavoriteItemPreferences(this.sellerFavoriteItemPreferences);
    if (this.endOfAuctionEmailPreferences != null)
      req.setEndOfAuctionEmailPreferences(this.endOfAuctionEmailPreferences);
    if (this.emailShipmentTrackingNumberPreference != null)
      req.setEmailShipmentTrackingNumberPreference(this.emailShipmentTrackingNumberPreference);
    if (this.requiredShipPhoneNumberPreference != null)
      req.setRequiredShipPhoneNumberPreference(this.requiredShipPhoneNumberPreference);
    if (this.unpaidItemAssistancePreferences != null)
      req.setUnpaidItemAssistancePreferences(this.unpaidItemAssistancePreferences);
    if (this.purchaseReminderEmailPreferences != null)
      req.setPurchaseReminderEmailPreferences(this.purchaseReminderEmailPreferences);
    if (this.sellerThirdPartyCheckoutDisabled != null)
      req.setSellerThirdPartyCheckoutDisabled(this.sellerThirdPartyCheckoutDisabled);

    SetUserPreferencesResponseType resp = (SetUserPreferencesResponseType) execute(req);


  }

  /**
   * Gets the SetUserPreferencesRequestType.bidderNoticePreferences.
   * @return BidderNoticePreferencesType
   */
  public BidderNoticePreferencesType getBidderNoticePreferences()
  {
    return this.bidderNoticePreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.bidderNoticePreferences.
   * @param bidderNoticePreferences BidderNoticePreferencesType
   */
  public void setBidderNoticePreferences(BidderNoticePreferencesType bidderNoticePreferences)
  {
    this.bidderNoticePreferences = bidderNoticePreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.combinedPaymentPreferences.
   * @return CombinedPaymentPreferencesType
   */
  public CombinedPaymentPreferencesType getCombinedPaymentPreferences()
  {
    return this.combinedPaymentPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.combinedPaymentPreferences.
   * @param combinedPaymentPreferences CombinedPaymentPreferencesType
   */
  public void setCombinedPaymentPreferences(CombinedPaymentPreferencesType combinedPaymentPreferences)
  {
    this.combinedPaymentPreferences = combinedPaymentPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.crossPromotionPreferences.
   * @return CrossPromotionPreferencesType
   */
  public CrossPromotionPreferencesType getCrossPromotionPreferences()
  {
    return this.crossPromotionPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.crossPromotionPreferences.
   * @param crossPromotionPreferences CrossPromotionPreferencesType
   */
  public void setCrossPromotionPreferences(CrossPromotionPreferencesType crossPromotionPreferences)
  {
    this.crossPromotionPreferences = crossPromotionPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.emailShipmentTrackingNumberPreference.
   * @return Boolean
   */
  public Boolean getEmailShipmentTrackingNumberPreference()
  {
    return this.emailShipmentTrackingNumberPreference;
  }

  /**
   * Sets the SetUserPreferencesRequestType.emailShipmentTrackingNumberPreference.
   * @param emailShipmentTrackingNumberPreference Boolean
   */
  public void setEmailShipmentTrackingNumberPreference(Boolean emailShipmentTrackingNumberPreference)
  {
    this.emailShipmentTrackingNumberPreference = emailShipmentTrackingNumberPreference;
  }

  /**
   * Gets the SetUserPreferencesRequestType.endOfAuctionEmailPreferences.
   * @return EndOfAuctionEmailPreferencesType
   */
  public EndOfAuctionEmailPreferencesType getEndOfAuctionEmailPreferences()
  {
    return this.endOfAuctionEmailPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.endOfAuctionEmailPreferences.
   * @param endOfAuctionEmailPreferences EndOfAuctionEmailPreferencesType
   */
  public void setEndOfAuctionEmailPreferences(EndOfAuctionEmailPreferencesType endOfAuctionEmailPreferences)
  {
    this.endOfAuctionEmailPreferences = endOfAuctionEmailPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.purchaseReminderEmailPreferences.
   * @return PurchaseReminderEmailPreferencesType
   */
  public PurchaseReminderEmailPreferencesType getPurchaseReminderEmailPreferences()
  {
    return this.purchaseReminderEmailPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.purchaseReminderEmailPreferences.
   * @param purchaseReminderEmailPreferences PurchaseReminderEmailPreferencesType
   */
  public void setPurchaseReminderEmailPreferences(PurchaseReminderEmailPreferencesType purchaseReminderEmailPreferences)
  {
    this.purchaseReminderEmailPreferences = purchaseReminderEmailPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.requiredShipPhoneNumberPreference.
   * @return Boolean
   */
  public Boolean getRequiredShipPhoneNumberPreference()
  {
    return this.requiredShipPhoneNumberPreference;
  }

  /**
   * Sets the SetUserPreferencesRequestType.requiredShipPhoneNumberPreference.
   * @param requiredShipPhoneNumberPreference Boolean
   */
  public void setRequiredShipPhoneNumberPreference(Boolean requiredShipPhoneNumberPreference)
  {
    this.requiredShipPhoneNumberPreference = requiredShipPhoneNumberPreference;
  }

  /**
   * Gets the SetUserPreferencesRequestType.sellerFavoriteItemPreferences.
   * @return SellerFavoriteItemPreferencesType
   */
  public SellerFavoriteItemPreferencesType getSellerFavoriteItemPreferences()
  {
    return this.sellerFavoriteItemPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.sellerFavoriteItemPreferences.
   * @param sellerFavoriteItemPreferences SellerFavoriteItemPreferencesType
   */
  public void setSellerFavoriteItemPreferences(SellerFavoriteItemPreferencesType sellerFavoriteItemPreferences)
  {
    this.sellerFavoriteItemPreferences = sellerFavoriteItemPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.sellerPaymentPreferences.
   * @return SellerPaymentPreferencesType
   */
  public SellerPaymentPreferencesType getSellerPaymentPreferences()
  {
    return this.sellerPaymentPreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.sellerPaymentPreferences.
   * @param sellerPaymentPreferences SellerPaymentPreferencesType
   */
  public void setSellerPaymentPreferences(SellerPaymentPreferencesType sellerPaymentPreferences)
  {
    this.sellerPaymentPreferences = sellerPaymentPreferences;
  }

  /**
   * Gets the SetUserPreferencesRequestType.sellerThirdPartyCheckoutDisabled.
   * @return Boolean
   */
  public Boolean getSellerThirdPartyCheckoutDisabled()
  {
    return this.sellerThirdPartyCheckoutDisabled;
  }

  /**
   * Sets the SetUserPreferencesRequestType.sellerThirdPartyCheckoutDisabled.
   * @param sellerThirdPartyCheckoutDisabled Boolean
   */
  public void setSellerThirdPartyCheckoutDisabled(Boolean sellerThirdPartyCheckoutDisabled)
  {
    this.sellerThirdPartyCheckoutDisabled = sellerThirdPartyCheckoutDisabled;
  }

  /**
   * Gets the SetUserPreferencesRequestType.unpaidItemAssistancePreferences.
   * @return UnpaidItemAssistancePreferencesType
   */
  public UnpaidItemAssistancePreferencesType getUnpaidItemAssistancePreferences()
  {
    return this.unpaidItemAssistancePreferences;
  }

  /**
   * Sets the SetUserPreferencesRequestType.unpaidItemAssistancePreferences.
   * @param unpaidItemAssistancePreferences UnpaidItemAssistancePreferencesType
   */
  public void setUnpaidItemAssistancePreferences(UnpaidItemAssistancePreferencesType unpaidItemAssistancePreferences)
  {
    this.unpaidItemAssistancePreferences = unpaidItemAssistancePreferences;
  }

}

