
package StampsSDK;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AccountType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="AccountType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Individual"/>
 *     &lt;enumeration value="HomeOffice"/>
 *     &lt;enumeration value="HomeBasedBusiness"/>
 *     &lt;enumeration value="OfficeBasedBusiness"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "AccountType")
@XmlEnum
public enum AccountType {

    @XmlEnumValue("Individual")
    INDIVIDUAL("Individual"),
    @XmlEnumValue("HomeOffice")
    HOME_OFFICE("HomeOffice"),
    @XmlEnumValue("HomeBasedBusiness")
    HOME_BASED_BUSINESS("HomeBasedBusiness"),
    @XmlEnumValue("OfficeBasedBusiness")
    OFFICE_BASED_BUSINESS("OfficeBasedBusiness");
    private final String value;

    AccountType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AccountType fromValue(String v) {
        for (AccountType c: AccountType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
