
package StampsSDK;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ContentType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ContentType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Commercial Sample"/>
 *     &lt;enumeration value="Gift"/>
 *     &lt;enumeration value="Document"/>
 *     &lt;enumeration value="Returned Goods"/>
 *     &lt;enumeration value="Other"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ContentType")
@XmlEnum
public enum ContentType {

    @XmlEnumValue("Commercial Sample")
    COMMERCIAL_SAMPLE("Commercial Sample"),
    @XmlEnumValue("Gift")
    GIFT("Gift"),
    @XmlEnumValue("Document")
    DOCUMENT("Document"),
    @XmlEnumValue("Returned Goods")
    RETURNED_GOODS("Returned Goods"),
    @XmlEnumValue("Other")
    OTHER("Other");
    private final String value;

    ContentType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ContentType fromValue(String v) {
        for (ContentType c: ContentType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
