
package StampsSDK;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ContentTypeV2.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ContentTypeV2">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Commercial Sample"/>
 *     &lt;enumeration value="Gift"/>
 *     &lt;enumeration value="Document"/>
 *     &lt;enumeration value="Returned Goods"/>
 *     &lt;enumeration value="Other"/>
 *     &lt;enumeration value="Merchandise"/>
 *     &lt;enumeration value="Humanitarian Donation"/>
 *     &lt;enumeration value="Dangerous Goods"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ContentTypeV2")
@XmlEnum
public enum ContentTypeV2 {

    @XmlEnumValue("Commercial Sample")
    COMMERCIAL_SAMPLE("Commercial Sample"),
    @XmlEnumValue("Gift")
    GIFT("Gift"),
    @XmlEnumValue("Document")
    DOCUMENT("Document"),
    @XmlEnumValue("Returned Goods")
    RETURNED_GOODS("Returned Goods"),
    @XmlEnumValue("Other")
    OTHER("Other"),
    @XmlEnumValue("Merchandise")
    MERCHANDISE("Merchandise"),
    @XmlEnumValue("Humanitarian Donation")
    HUMANITARIAN_DONATION("Humanitarian Donation"),
    @XmlEnumValue("Dangerous Goods")
    DANGEROUS_GOODS("Dangerous Goods");
    private final String value;

    ContentTypeV2(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ContentTypeV2 fromValue(String v) {
        for (ContentTypeV2 c: ContentTypeV2 .values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
