
package StampsSDK;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TrackingEventType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TrackingEventType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="None"/>
 *     &lt;enumeration value="ManifestAcknowledgement"/>
 *     &lt;enumeration value="ElectronicNotification"/>
 *     &lt;enumeration value="Delivered"/>
 *     &lt;enumeration value="AttemptedNoticeLeft"/>
 *     &lt;enumeration value="AcceptOrPickup"/>
 *     &lt;enumeration value="Refused"/>
 *     &lt;enumeration value="Undeliverable"/>
 *     &lt;enumeration value="Forwarded"/>
 *     &lt;enumeration value="ArrivalAtUnit"/>
 *     &lt;enumeration value="Missent"/>
 *     &lt;enumeration value="ReturnToSender"/>
 *     &lt;enumeration value="Enroute"/>
 *     &lt;enumeration value="DeadLetter"/>
 *     &lt;enumeration value="ArrivalAtPickupPoint"/>
 *     &lt;enumeration value="NoSuchNumber"/>
 *     &lt;enumeration value="InsufficientAddress"/>
 *     &lt;enumeration value="MovedNoForwarding"/>
 *     &lt;enumeration value="ForwardingExpired"/>
 *     &lt;enumeration value="AddresseeUnknown"/>
 *     &lt;enumeration value="Vacant"/>
 *     &lt;enumeration value="Unclaimed"/>
 *     &lt;enumeration value="Deceased"/>
 *     &lt;enumeration value="ReturnedOtherReason"/>
 *     &lt;enumeration value="PickedUpByShippingPartner"/>
 *     &lt;enumeration value="ArrivedAtShippingPartner"/>
 *     &lt;enumeration value="DepartedFromShippingPartner"/>
 *     &lt;enumeration value="UnrecognizedEvent"/>
 *     &lt;enumeration value="ErrorDateNotAvailable"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "TrackingEventType")
@XmlEnum
public enum TrackingEventType {

    @XmlEnumValue("None")
    NONE("None"),
    @XmlEnumValue("ManifestAcknowledgement")
    MANIFEST_ACKNOWLEDGEMENT("ManifestAcknowledgement"),
    @XmlEnumValue("ElectronicNotification")
    ELECTRONIC_NOTIFICATION("ElectronicNotification"),
    @XmlEnumValue("Delivered")
    DELIVERED("Delivered"),
    @XmlEnumValue("AttemptedNoticeLeft")
    ATTEMPTED_NOTICE_LEFT("AttemptedNoticeLeft"),
    @XmlEnumValue("AcceptOrPickup")
    ACCEPT_OR_PICKUP("AcceptOrPickup"),
    @XmlEnumValue("Refused")
    REFUSED("Refused"),
    @XmlEnumValue("Undeliverable")
    UNDELIVERABLE("Undeliverable"),
    @XmlEnumValue("Forwarded")
    FORWARDED("Forwarded"),
    @XmlEnumValue("ArrivalAtUnit")
    ARRIVAL_AT_UNIT("ArrivalAtUnit"),
    @XmlEnumValue("Missent")
    MISSENT("Missent"),
    @XmlEnumValue("ReturnToSender")
    RETURN_TO_SENDER("ReturnToSender"),
    @XmlEnumValue("Enroute")
    ENROUTE("Enroute"),
    @XmlEnumValue("DeadLetter")
    DEAD_LETTER("DeadLetter"),
    @XmlEnumValue("ArrivalAtPickupPoint")
    ARRIVAL_AT_PICKUP_POINT("ArrivalAtPickupPoint"),
    @XmlEnumValue("NoSuchNumber")
    NO_SUCH_NUMBER("NoSuchNumber"),
    @XmlEnumValue("InsufficientAddress")
    INSUFFICIENT_ADDRESS("InsufficientAddress"),
    @XmlEnumValue("MovedNoForwarding")
    MOVED_NO_FORWARDING("MovedNoForwarding"),
    @XmlEnumValue("ForwardingExpired")
    FORWARDING_EXPIRED("ForwardingExpired"),
    @XmlEnumValue("AddresseeUnknown")
    ADDRESSEE_UNKNOWN("AddresseeUnknown"),
    @XmlEnumValue("Vacant")
    VACANT("Vacant"),
    @XmlEnumValue("Unclaimed")
    UNCLAIMED("Unclaimed"),
    @XmlEnumValue("Deceased")
    DECEASED("Deceased"),
    @XmlEnumValue("ReturnedOtherReason")
    RETURNED_OTHER_REASON("ReturnedOtherReason"),
    @XmlEnumValue("PickedUpByShippingPartner")
    PICKED_UP_BY_SHIPPING_PARTNER("PickedUpByShippingPartner"),
    @XmlEnumValue("ArrivedAtShippingPartner")
    ARRIVED_AT_SHIPPING_PARTNER("ArrivedAtShippingPartner"),
    @XmlEnumValue("DepartedFromShippingPartner")
    DEPARTED_FROM_SHIPPING_PARTNER("DepartedFromShippingPartner"),
    @XmlEnumValue("UnrecognizedEvent")
    UNRECOGNIZED_EVENT("UnrecognizedEvent"),
    @XmlEnumValue("ErrorDateNotAvailable")
    ERROR_DATE_NOT_AVAILABLE("ErrorDateNotAvailable");
    private final String value;

    TrackingEventType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TrackingEventType fromValue(String v) {
        for (TrackingEventType c: TrackingEventType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
