
package com.ebay.soap.eBLBaseComponents;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Element;


/**
 * 
 * 				Contains an ISBN value, EAN value, UPC value, ticket keywords, or eBay
 * 				catalog product ID, plus other meta-data. For event tickets, this type
 * 				can contain a set of keywords that uniquely identify the product. Only
 * 				applicable to certain categories that support Pre-filled Item
 * 				Information.
 * 			
 * 
 * <p>Java class for ExternalProductIDType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ExternalProductIDType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Value" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="ReturnSearchResultOnDuplicates" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Type" type="{urn:ebay:apis:eBLBaseComponents}ExternalProductCodeType" minOccurs="0"/>
 *         &lt;element name="AlternateValue" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;any/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExternalProductIDType", propOrder = {
    "value",
    "returnSearchResultOnDuplicates",
    "type",
    "alternateValue",
    "any"
})
public class ExternalProductIDType
    implements Serializable
{

    private final static long serialVersionUID = 12343L;
    @XmlElement(name = "Value")
    protected String value;
    @XmlElement(name = "ReturnSearchResultOnDuplicates")
    protected Boolean returnSearchResultOnDuplicates;
    @XmlElement(name = "Type")
    protected ExternalProductCodeType type;
    @XmlElement(name = "AlternateValue")
    protected List<String> alternateValue;
    @XmlAnyElement(lax = true)
    protected List<Object> any;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the returnSearchResultOnDuplicates property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isReturnSearchResultOnDuplicates() {
        return returnSearchResultOnDuplicates;
    }

    /**
     * Sets the value of the returnSearchResultOnDuplicates property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReturnSearchResultOnDuplicates(Boolean value) {
        this.returnSearchResultOnDuplicates = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalProductCodeType }
     *     
     */
    public ExternalProductCodeType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalProductCodeType }
     *     
     */
    public void setType(ExternalProductCodeType value) {
        this.type = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link String }
     *     
     */
    public String[] getAlternateValue() {
        if (this.alternateValue == null) {
            return new String[ 0 ] ;
        }
        return ((String[]) this.alternateValue.toArray(new String[this.alternateValue.size()] ));
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link String }
     *     
     */
    public String getAlternateValue(int idx) {
        if (this.alternateValue == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.alternateValue.get(idx);
    }

    public int getAlternateValueLength() {
        if (this.alternateValue == null) {
            return  0;
        }
        return this.alternateValue.size();
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link String }
     *     
     */
    public void setAlternateValue(String[] values) {
        this._getAlternateValue().clear();
        int len = values.length;
        for (int i = 0; (i<len); i ++) {
            this.alternateValue.add(values[i]);
        }
    }

    protected List<String> _getAlternateValue() {
        if (alternateValue == null) {
            alternateValue = new ArrayList<String>();
        }
        return alternateValue;
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public String setAlternateValue(int idx, String value) {
        return this.alternateValue.set(idx, value);
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link Object }
     *     {@link Element }
     *     
     */
    public Object[] getAny() {
        if (this.any == null) {
            return new Object[ 0 ] ;
        }
        return ((Object[]) this.any.toArray(new Object[this.any.size()] ));
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link Object }
     *     {@link Element }
     *     
     */
    public Object getAny(int idx) {
        if (this.any == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.any.get(idx);
    }

    public int getAnyLength() {
        if (this.any == null) {
            return  0;
        }
        return this.any.size();
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link Object }
     *     {@link Element }
     *     
     */
    public void setAny(Object[] values) {
        this._getAny().clear();
        int len = values.length;
        for (int i = 0; (i<len); i ++) {
            this.any.add(values[i]);
        }
    }

    protected List<Object> _getAny() {
        if (any == null) {
            any = new ArrayList<Object>();
        }
        return any;
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     {@link Element }
     *     
     */
    public Object setAny(int idx, Object value) {
        return this.any.set(idx, value);
    }

}
