
package com.ebay.soap.eBLBaseComponents;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MinimumAdvertisedPriceExposureCodeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="MinimumAdvertisedPriceExposureCodeType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     &lt;enumeration value="PreCheckout"/>
 *     &lt;enumeration value="DuringCheckout"/>
 *     &lt;enumeration value="None"/>
 *     &lt;enumeration value="CustomCode"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 * Note: Per JAXB standards, underscores are added to separate words in enumerations (e.g., PayPal becomes PAY_PAL).
 */
@XmlType(name = "MinimumAdvertisedPriceExposureCodeType")
@XmlEnum
public enum MinimumAdvertisedPriceExposureCodeType {


    /**
     * 
     * 						PreCheckout specifies that the buyer must click a link (or a button) to navigate to a separate
     * 						page (or window) that displays the discount price. eBay displays the discounted item price in
     * 						a pop-up window.
     * 					
     * 
     */
    @XmlEnumValue("PreCheckout")
    PRE_CHECKOUT("PreCheckout"),

    /**
     * 
     * 						DuringCheckout specifies that the discounted price must be shown on the eBay checkout
     * 						flow page.
     * 					
     * 
     */
    @XmlEnumValue("DuringCheckout")
    DURING_CHECKOUT("DuringCheckout"),

    /**
     * 
     * 						None means the discount price is not shown via either PreCheckout nor DuringCheckout.
     * 					
     * 
     */
    @XmlEnumValue("None")
    NONE("None"),

    /**
     * 
     * 						Reserved for future use.
     * 					
     * 
     */
    @XmlEnumValue("CustomCode")
    CUSTOM_CODE("CustomCode");
    private final String value;

    MinimumAdvertisedPriceExposureCodeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MinimumAdvertisedPriceExposureCodeType fromValue(String v) {
        for (MinimumAdvertisedPriceExposureCodeType c: MinimumAdvertisedPriceExposureCodeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
