package urn.ebay.apis.eBLBaseComponents;

/**
 * ISO 4217 standard 3-letter currency code. 
 * 
 *  
 * The following currencies are supported by PayPal.
 * 
 *  Code
 *  CurrencyMaximum Transaction Amount
 *  
 *  AUD
 *  Australian Dollar 
 *  12,500 AUD
 *  
 *  
 *  CAD
 *  Canadian Dollar12,500 CAD
 *  
 *  
 *  EUR
 *  Euro
 *   8,000 EUR
 *  
 *  
 *  GBP
 *  Pound Sterling
 *    5,500 GBP
 *  
 *  
 *  JPY
 *  Japanese Yen
 *  1,000,000 JPY
 *  
 *  
 *  USD
 *   U.S. Dollar
 *  10,000 USD
 *  
 *  
 *  CHF
 *   Czech Koruna
 *  70,000 CHF
 *  
 *  
 *  SEK
 *   Swedish Krona
 *  3,50,000 SEK
 *  
 *  
 *  NOK
 *   Norwegian Krone
 *  4,00,000 NOK
 *  
 *  
 *  DKK
 *   Danish Krone
 *  3,00,000 DKK
 *  
 *  
 *  PLN
 *   Poland Zloty
 *  1,60,000 PLN
 *  
 *  
 *  HUF
 *   Hungary Forint
 *  110,00,000 HUF
 *  
 *  
 *  SGD
 *   Singapore Dollar
 *  80,000 SGD
 *  
 *  
 *  HKD
 *   HongKong Dollar
 *  3,80,000 HKD
 *  
 *  
 *  NZD
 *   New Zealand Dollar
 *  77,000 NZD
 *  
 *  
 *  CZK
 *   Czech Koruna
 *  1,20,000 CZK
 *  
 *  
 *  
 */
public enum  CurrencyCodeType {

	AFA("AFA"),

	ALL("ALL"),

	DZD("DZD"),

	ADP("ADP"),

	AOA("AOA"),

	ARS("ARS"),

	AMD("AMD"),

	AWG("AWG"),

	AZM("AZM"),

	BSD("BSD"),

	BHD("BHD"),

	BDT("BDT"),

	BBD("BBD"),

	BYR("BYR"),

	BZD("BZD"),

	BMD("BMD"),

	BTN("BTN"),

	INR("INR"),

	BOV("BOV"),

	BOB("BOB"),

	BAM("BAM"),

	BWP("BWP"),

	BRL("BRL"),

	BND("BND"),

	BGL("BGL"),

	BGN("BGN"),

	BIF("BIF"),

	KHR("KHR"),

	CAD("CAD"),

	CVE("CVE"),

	KYD("KYD"),

	XAF("XAF"),

	CLF("CLF"),

	CLP("CLP"),

	CNY("CNY"),

	COP("COP"),

	KMF("KMF"),

	CDF("CDF"),

	CRC("CRC"),

	HRK("HRK"),

	CUP("CUP"),

	CYP("CYP"),

	CZK("CZK"),

	DKK("DKK"),

	DJF("DJF"),

	DOP("DOP"),

	TPE("TPE"),

	ECV("ECV"),

	ECS("ECS"),

	EGP("EGP"),

	SVC("SVC"),

	ERN("ERN"),

	EEK("EEK"),

	ETB("ETB"),

	FKP("FKP"),

	FJD("FJD"),

	GMD("GMD"),

	GEL("GEL"),

	GHC("GHC"),

	GIP("GIP"),

	GTQ("GTQ"),

	GNF("GNF"),

	GWP("GWP"),

	GYD("GYD"),

	HTG("HTG"),

	HNL("HNL"),

	HKD("HKD"),

	HUF("HUF"),

	ISK("ISK"),

	IDR("IDR"),

	IRR("IRR"),

	IQD("IQD"),

	ILS("ILS"),

	JMD("JMD"),

	JPY("JPY"),

	JOD("JOD"),

	KZT("KZT"),

	KES("KES"),

	AUD("AUD"),

	KPW("KPW"),

	KRW("KRW"),

	KWD("KWD"),

	KGS("KGS"),

	LAK("LAK"),

	LVL("LVL"),

	LBP("LBP"),

	LSL("LSL"),

	LRD("LRD"),

	LYD("LYD"),

	CHF("CHF"),

	LTL("LTL"),

	MOP("MOP"),

	MKD("MKD"),

	MGF("MGF"),

	MWK("MWK"),

	MYR("MYR"),

	MVR("MVR"),

	MTL("MTL"),

	EUR("EUR"),

	MRO("MRO"),

	MUR("MUR"),

	MXN("MXN"),

	MXV("MXV"),

	MDL("MDL"),

	MNT("MNT"),

	XCD("XCD"),

	MZM("MZM"),

	MMK("MMK"),

	ZAR("ZAR"),

	NAD("NAD"),

	NPR("NPR"),

	ANG("ANG"),

	XPF("XPF"),

	NZD("NZD"),

	NIO("NIO"),

	NGN("NGN"),

	NOK("NOK"),

	OMR("OMR"),

	PKR("PKR"),

	PAB("PAB"),

	PGK("PGK"),

	PYG("PYG"),

	PEN("PEN"),

	PHP("PHP"),

	PLN("PLN"),

	USD("USD"),

	QAR("QAR"),

	ROL("ROL"),

	RUB("RUB"),

	RUR("RUR"),

	RWF("RWF"),

	SHP("SHP"),

	WST("WST"),

	STD("STD"),

	SAR("SAR"),

	SCR("SCR"),

	SLL("SLL"),

	SGD("SGD"),

	SKK("SKK"),

	SIT("SIT"),

	SBD("SBD"),

	SOS("SOS"),

	LKR("LKR"),

	SDD("SDD"),

	SRG("SRG"),

	SZL("SZL"),

	SEK("SEK"),

	SYP("SYP"),

	TWD("TWD"),

	TJS("TJS"),

	TZS("TZS"),

	THB("THB"),

	XOF("XOF"),

	TOP("TOP"),

	TTD("TTD"),

	TND("TND"),

	TRY("TRY"),

	TMM("TMM"),

	UGX("UGX"),

	UAH("UAH"),

	AED("AED"),

	GBP("GBP"),

	USS("USS"),

	USN("USN"),

	UYU("UYU"),

	UZS("UZS"),

	VUV("VUV"),

	VEB("VEB"),

	VND("VND"),

	MAD("MAD"),

	YER("YER"),

	YUM("YUM"),

	ZMK("ZMK"),

	ZWD("ZWD"),

	CUSTOMCODE("CustomCode");

	private String value;

	private CurrencyCodeType (String value) {
		this.value = value;
	}

	public String getValue(){
		return value;
	}
	
	public static CurrencyCodeType fromValue(String v) {
		for (CurrencyCodeType c : values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}

}