/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractGCEvent
implements Serializable {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private double timestamp;
    private Type type = Type.GC;
    private boolean tenuredDetail;
    protected List details;

    public Iterator details() {
        if (this.details == null) {
            return EMPTY_ITERATOR;
        }
        return this.details.iterator();
    }

    public void add(AbstractGCEvent detail) {
        if (this.details == null) {
            this.details = new ArrayList(2);
        }
        this.details.add(detail);
        if (detail.getType().getGeneration() == Generation.TENURED) {
            this.tenuredDetail = true;
        }
    }

    public boolean hasTenuredDetail() {
        return this.tenuredDetail;
    }

    public void setTimestamp(double timestamp) {
        this.timestamp = timestamp;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public abstract void toStringBuffer(StringBuffer var1);

    public boolean isTenuredDetail() {
        return this.tenuredDetail;
    }

    public void setTenuredDetail(boolean tenuredDetail) {
        this.tenuredDetail = tenuredDetail;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        this.toStringBuffer(sb);
        return sb.toString();
    }

    public static class Generation {
        private String name;
        public static final Generation YOUNG = new Generation("Young");
        public static final Generation TENURED = new Generation("Tenured");
        public static final Generation PERM = new Generation("Perm");
        public static final Generation ALL = new Generation("All");

        private Generation(String name) {
            this.name = name.intern();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Concurrency {
        private String name;
        public static final Concurrency CONCURRENT = new Concurrency("Concurrent");
        public static final Concurrency SERIAL = new Concurrency("Serial");

        private Concurrency(String name) {
            this.name = name.intern();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Type
    implements Serializable {
        private final String type;
        private final String rep;
        private Generation generation;
        private Concurrency concurrency;
        private static final Map TYPE_MAP = new HashMap();
        public static final Type JROCKIT_GC = new Type("jrockit.GC", Generation.TENURED);
        public static final Type JROCKIT_NURSERY_GC = new Type("jrockit.Nursery GC", Generation.YOUNG);
        public static final Type JROCKIT_PARALLEL_NURSERY_GC = new Type("jrockit.parallel nursery GC", Generation.YOUNG);
        public static final Type FULL_GC = new Type("Full GC", Generation.ALL);
        public static final Type GC = new Type("GC", Generation.YOUNG);
        public static final Type GC__ = new Type("GC--", Generation.YOUNG);
        public static final Type DEF_NEW = new Type("DefNew", "DefNew:", Generation.YOUNG);
        public static final Type PAR_NEW = new Type("ParNew", "ParNew:", Generation.YOUNG);
        public static final Type PAR_OLD_GEN = new Type("ParOldGen", "ParOldGen:", Generation.TENURED);
        public static final Type PS_YOUNG_GEN = new Type("PSYoungGen", "PSYoungGen:", Generation.YOUNG);
        public static final Type PS_OLD_GEN = new Type("PSOldGen", "PSOldGen:", Generation.TENURED);
        public static final Type PS_PERM_GEN = new Type("PSPermGen", "PSPermGen:", Generation.PERM);
        public static final Type TENURED = new Type("Tenured", "Tenured:", Generation.TENURED);
        public static final Type INC_GC = new Type("Inc GC", Generation.YOUNG);
        public static final Type TRAIN = new Type("Train", "Train:", Generation.TENURED);
        public static final Type TRAIN_MSC = new Type("Train MSC", "Train MSC:", Generation.TENURED);
        public static final Type PERM = new Type("Perm", "Perm:", Generation.PERM);
        public static final Type CMS = new Type("CMS", "CMS:", Generation.TENURED);
        public static final Type CMS_PERM = new Type("CMS Perm", "CMS Perm :", Generation.PERM);
        public static final Type CMS_CMF = new Type("CMS (concurrent mode failure)", "CMS (concurrent mode failure):", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_MARK_START = new Type("CMS-concurrent-mark-start", "CMS-concurrent-mark-start", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_MARK = new Type("CMS-concurrent-mark", "CMS-concurrent-mark:", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_PRECLEAN_START = new Type("CMS-concurrent-preclean-start", "CMS-concurrent-preclean-start", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_PRECLEAN = new Type("CMS-concurrent-preclean", "CMS-concurrent-preclean", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_SWEEP_START = new Type("CMS-concurrent-sweep-start", "CMS-concurrent-sweep-start", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_SWEEP = new Type("CMS-concurrent-sweep", "CMS-concurrent-sweep:", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_RESET_START = new Type("CMS-concurrent-reset-start", "CMS-concurrent-reset-start", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_RESET = new Type("CMS-concurrent-reset", "CMS-concurrent-reset:", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_ABORTABLE_PRECLEAN_START = new Type("CMS-concurrent-abortable-preclean-start", "CMS-concurrent-abortable-preclean-start", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_CONCURRENT_ABORTABLE_PRECLEAN = new Type("CMS-concurrent-abortable-preclean", "CMS-concurrent-abortable-preclean:", Generation.TENURED, Concurrency.CONCURRENT);
        public static final Type CMS_INITIAL_MARK = new Type("CMS-initial-mark", "CMS-initial-mark:", Generation.TENURED, Concurrency.SERIAL);
        public static final Type CMS_REMARK = new Type("CMS-remark", "CMS-remark:", Generation.TENURED, Concurrency.SERIAL);

        private Type(String type, Generation generation) {
            this(type, type, generation);
        }

        private Type(String type, String rep, Generation generation) {
            this(type, rep, generation, Concurrency.SERIAL);
        }

        private Type(String type, String rep, Generation generation, Concurrency concurrency) {
            this.type = type.intern();
            this.rep = rep;
            this.generation = generation;
            this.concurrency = concurrency;
            TYPE_MAP.put(this.type, this);
        }

        public static Type parse(String type) {
            Type gcType = (Type)TYPE_MAP.get(type = type.trim());
            if (gcType == null && type.endsWith(CMS_INITIAL_MARK.getType())) {
                gcType = CMS_INITIAL_MARK;
            }
            return gcType;
        }

        public static Type parse(int reason) {
            return reason == -1 ? GC : FULL_GC;
        }

        public static Type parse(int typeOfGC, float details) {
            Type type;
            switch (typeOfGC) {
                case 1: {
                    if (details == 0.0f) {
                        type = GC;
                        break;
                    }
                    type = PAR_NEW;
                    break;
                }
                case 2: {
                    type = FULL_GC;
                    break;
                }
                case 3: {
                    type = CMS;
                    break;
                }
                case 4: {
                    type = CMS;
                    break;
                }
                default: {
                    type = FULL_GC;
                }
            }
            return type;
        }

        public String getType() {
            return this.type;
        }

        public Generation getGeneration() {
            return this.generation;
        }

        public Concurrency getConcurrency() {
            return this.concurrency;
        }

        public String toString() {
            return this.rep;
        }
    }
}

