/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.DataReaderFactory;
import com.tagtraum.perf.gcviewer.GCDocument;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import com.tagtraum.perf.gcviewer.ModelPanel;
import com.tagtraum.perf.gcviewer.log.TextAreaLogHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;

public class ChartPanelView {
    private static final ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");
    private static final DataReaderFactory factory = new DataReaderFactory();
    private ModelChartImpl modelChart;
    private ModelPanel modelPanel;
    private GCModel model;
    private ViewBar viewBar;
    private boolean viewBarVisible;
    private boolean minimized;
    private SwingPropertyChangeSupport propertyChangeSupport;
    private GCDocument gcDocument;
    private TextAreaLogHandler textAreaLogHandler;
    private static final Logger IMP_LOGGER = Logger.getLogger("com.tagtraum.perf.gcviewer.imp");
    private static final Logger DATA_READER_FACTORY_LOGGER = Logger.getLogger("com.tagtraum.perf.gcviewer.DataReaderFactory");

    public ChartPanelView(GCDocument gcDocument, URL url) throws IOException {
        this.gcDocument = gcDocument;
        this.modelChart = new ModelChartImpl();
        this.modelPanel = new ModelPanel();
        this.viewBar = new ViewBar(this);
        this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        this.textAreaLogHandler = new TextAreaLogHandler();
        GCModel model = this.loadModel(url);
        this.setModel(model);
    }

    public boolean reloadModel() throws IOException {
        if (this.model.getURL() == null) {
            return false;
        }
        if (this.model.isDifferent(this.model.getURL())) {
            this.setModel(this.loadModel(this.model.getURL()));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCModel loadModel(final URL url) throws IOException {
        this.textAreaLogHandler = new TextAreaLogHandler();
        IMP_LOGGER.addHandler(this.textAreaLogHandler);
        DATA_READER_FACTORY_LOGGER.addHandler(this.textAreaLogHandler);
        try {
            InputStream in = url.openStream();
            DataReader reader = factory.getDataReader(in);
            GCModel model = reader.read();
            model.setURL(url);
            if (this.textAreaLogHandler.hasErrors()) {
                final JPanel panel = new JPanel(new BorderLayout());
                JLabel messageLabel = new JLabel(new MessageFormat(localStrings.getString("datareader_parseerror_dialog_message")).format(new Object[]{url}));
                messageLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
                panel.add((Component)messageLabel, "North");
                JScrollPane textAreaScrollPane = new JScrollPane(this.textAreaLogHandler.getTextArea());
                textAreaScrollPane.setPreferredSize(new Dimension(700, 500));
                panel.add((Component)textAreaScrollPane, "Center");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, panel, new MessageFormat(localStrings.getString("datareader_parseerror_dialog_title")).format(new Object[]{url}), 0);
                    }
                });
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            IMP_LOGGER.removeHandler(this.textAreaLogHandler);
            DATA_READER_FACTORY_LOGGER.removeHandler(this.textAreaLogHandler);
        }
    }

    public void invalidate() {
        this.modelChart.invalidate();
        this.modelPanel.invalidate();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public ViewBar getViewBar() {
        return this.viewBar;
    }

    public JTextArea getParseLog() {
        return this.textAreaLogHandler.getTextArea();
    }

    public boolean isViewBarVisible() {
        return this.viewBarVisible;
    }

    public void setViewBarVisible(boolean viewBarVisible) {
        this.viewBarVisible = viewBarVisible;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        boolean oldValue = this.minimized;
        if (minimized != this.minimized) {
            this.minimized = minimized;
            this.propertyChangeSupport.firePropertyChange("minimized", oldValue, minimized);
        }
    }

    public ModelChart getModelChart() {
        return this.modelChart;
    }

    public ModelPanel getModelPanel() {
        return this.modelPanel;
    }

    public GCModel getModel() {
        return this.model;
    }

    public void setModel(GCModel model) {
        this.model = model;
        this.modelPanel.setModel(model);
        this.modelChart.setModel(model);
        this.viewBar.setTitle(model.getURL().toString());
    }

    public void close() {
        this.gcDocument.removeChartPanelView(this);
    }

    private static class ViewBar
    extends JPanel {
        private JLabel title = new JLabel();
        private ViewBarButton closeButton = new ViewBarButton("images/close.png", "images/close_selected.png");
        private MinMaxButton minimizeButton = new MinMaxButton();
        private ChartPanelView chartPanelView;

        public ViewBar(ChartPanelView chartPanelView) {
            this.chartPanelView = chartPanelView;
            this.setLayout(new GridBagLayout());
            this.title.setOpaque(false);
            this.title.setHorizontalAlignment(2);
            this.title.setFont(this.title.getFont().deriveFont(this.title.getFont().getSize2D() * 0.8f));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.add((Component)this.title, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 3;
            this.add((Component)this.minimizeButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.closeButton, gridBagConstraints);
            this.minimizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ViewBar.this.chartPanelView.setMinimized(!ViewBar.this.chartPanelView.isMinimized());
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ViewBar.this.chartPanelView.close();
                }
            });
        }

        public void setTitle(String title) {
            this.title.setText(title);
        }

        protected void paintComponent(Graphics graphics) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.getBackground().darker(), 0.0f, (float)this.getHeight() / 2.0f, this.getBackground().brighter(), true);
            Color color = graphics.getColor();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(color);
        }

        private static class MinMaxButton
        extends JButton {
            private final ImageIcon min1 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/minimize.png")));
            private final ImageIcon min2 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/minimize_selected.png")));
            private final ImageIcon max1 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/maximize.png")));
            private final ImageIcon max2 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/maximize_selected.png")));
            private boolean minimize = true;

            public MinMaxButton() {
                this.setIcons(this.min1, this.min2);
                this.setMargin(new Insets(0, 2, 0, 2));
                this.setRolloverEnabled(true);
                this.setBorderPainted(false);
                this.setOpaque(false);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (MinMaxButton.this.minimize) {
                            MinMaxButton.this.setIcons(MinMaxButton.this.max1, MinMaxButton.this.max2);
                        } else {
                            MinMaxButton.this.setIcons(MinMaxButton.this.min1, MinMaxButton.this.min2);
                        }
                        MinMaxButton.this.minimize = !MinMaxButton.this.minimize;
                    }
                });
            }

            public void setIcons(ImageIcon imageIcon1, ImageIcon imageIcon2) {
                this.setIcon(imageIcon1);
                this.setRolloverIcon(imageIcon2);
                this.setSelectedIcon(imageIcon2);
            }
        }

        private static class ViewBarButton
        extends JButton {
            public ViewBarButton(String image1, String image2) {
                ImageIcon imageIcon1 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(image1)));
                ImageIcon imageIcon2 = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(image2)));
                this.setIcons(imageIcon1, imageIcon2);
                this.setMargin(new Insets(0, 2, 0, 2));
                this.setRolloverEnabled(true);
                this.setBorderPainted(false);
                this.setOpaque(false);
            }

            public void setIcons(ImageIcon imageIcon1, ImageIcon imageIcon2) {
                this.setIcon(imageIcon1);
                this.setRolloverIcon(imageIcon2);
                this.setSelectedIcon(imageIcon2);
            }
        }
    }
}

