/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.ModelChartImpl;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public abstract class ChartRenderer
extends JComponent {
    private ModelChartImpl modelChart;
    private boolean drawLine;
    private Paint linePaint;

    public ChartRenderer(ModelChartImpl modelChart) {
        this.modelChart = modelChart;
    }

    public void setLinePaint(Paint linePaint) {
        this.linePaint = linePaint;
    }

    public void setDrawLine(boolean drawLine) {
        this.drawLine = drawLine;
    }

    public ModelChartImpl getModelChart() {
        return this.modelChart;
    }

    public void setModelChart(ModelChartImpl modelChart) {
        this.modelChart = modelChart;
    }

    public boolean isDrawLine() {
        return this.drawLine;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        Object oldAAHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.modelChart.isAntiAlias()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintComponent(g2d);
        g2d.setPaint(oldPaint);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
    }

    public abstract void paintComponent(Graphics2D var1);
}

